using RimWorld;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// <para>Handles the human-to-animal bond.</para>
	/// <para>Zoophiles will tweak this into a bigger boost, as they treat it
	/// as an actual romantic relationship.</para>
	/// </summary>
	public sealed class R_BondedAnimal : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only for bestiality.
			if (!request.Category.IsBestiality()) return;
			// Psychopaths don't care about the nuances of animal relationships.
			if (xxx.is_psychopath(request.Pawn)) return;

			request.SetPreference(new R_BondedAnimal());
		}

		private R_BondedAnimal() : base(
			AttractionMode.Romantic,
			nameof(R_BondedAnimal),
			FactorOperation.Multiply,
			IsBondedAnimal,
			whenTrue: FixedValue(1.1f))
		{ }

		private static bool IsBondedAnimal(ref AttractionRequest request) =>
			request.Relations.Contains(PawnRelationDefOf.Bond);
	}
}