using Verse;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles vulnerability for rape.
	/// </summary>
	public sealed class P_Vulnerability : CurveAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only add for rape.
			if (!request.Purpose.IsForRape()) return;

			request.SetPreference(new P_Vulnerability());
		}

		/// <summary>
		/// Points of a curve that maps the difference between the victim's and
		/// rapists' vulnerability to a factor.
		/// </summary>
		private static readonly CurvePoint[] vulnerabilityCurve = new CurvePoint[]
		{
			new(-3f, 2f),
			new(-1.5f, 1.25f),
			new(0f, 1f),
			new(1.5f, 1f / 1.25f),
			new(3f, 0f)
		};

		private P_Vulnerability() : base(
			AttractionMode.Physical,
			nameof(P_Vulnerability),
			FactorOperation.Multiply,
			GetVulnerabilityDelta,
			vulnerabilityCurve)
		{ }

		private static float GetVulnerabilityDelta(ref AttractionRequest request)
		{
			// These values range from 0 to 3.
			var pVulnerability = xxx.get_vulnerability(request.Pawn);
			var tVulnerability = xxx.get_vulnerability(request.Target);
			// So this difference ranges between -3 and 3.  Negative values mean the
			// target is more vulnerable than the observer.
			return pVulnerability - tVulnerability;
		}
	}
}