using Sex = rjw.GenderHelper.Sex;

namespace rjw.Modules.Attraction.StandardPreferences
{
	public record struct BodyTypeData(
		Orientation PawnOri,
		Sex PawnSex,
		StandardizedBody TargetBody
	);

	/// <summary>
	/// Handles the body-type of a target.
	/// </summary>
	public sealed class P_HumanToBodyType : SelectAttractionPreference<BodyTypeData>
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Not applicable to animal observers.
			if (request.Category.AnimalObserver()) return;

			request.SetPreference(new P_HumanToBodyType());
		}

		private P_HumanToBodyType() : base(
			AttractionMode.Physical,
			nameof(P_HumanToBodyType),
			FactorOperation.Multiply,
			GetBodyData,
			SelectFromBody)
		{ }

		private static BodyTypeData GetBodyData(ref AttractionRequest request) => new(
			request.Pawn.GetCompRJW().orientation.Simplify(),
			GenderHelper.GetSex(request.Pawn),
			AttractionUtility.StandardizeBody(request.Target)
		);

		private static float SelectFromBody(BodyTypeData data, ref AttractionRequest request)
		{
			float result = 1f;

			// Don't do anything with unknown bodies.
			if (data.TargetBody == StandardizedBody.Unknown)
			{
				result = 1f;
			}
			// Depress strongly for animals (zoophiles will override this).
			else if (data.TargetBody == StandardizedBody.Animal || data.TargetBody == StandardizedBody.Insectoid)
			{
				if (!xxx.is_zoophile(request.Pawn))
				{
					result = 0.45f;
				}
				else
				{
					result = 1f;
				}
				
			}
			// Depress strongly for the abdomen bursting machines.
			else if (data.TargetBody == StandardizedBody.Mechanoid)
			{
				result = 0.45f;
			}
			// No boost in attraction for child-like bodies.
			else if (data.TargetBody == StandardizedBody.Baby || data.TargetBody == StandardizedBody.Child)
			{
				result = 1f;
			}
			// Sexualities that don't care about fat pawns.
			else if (data.PawnOri == Orientation.Asexual)
			{
				result = 1f;
			}
			else if (data.PawnOri == Orientation.Pansexual)
			{
				result = 1.25f;
			}
			// Fat pawns get no bonus (teratophiles will override this).
			else if (data.TargetBody == StandardizedBody.Fat)
			{
				result = 1f;
			}
			// Bisexuals are into both.
			else if (data.PawnOri == Orientation.Bisexual &&
					 (data.TargetBody == StandardizedBody.Male || data.TargetBody == StandardizedBody.Female))
			{
				result = 1.25f;
			}
			// Treat futa as effectively bisexual.
			else if (data.PawnSex == Sex.Futa &&
					 (data.TargetBody == StandardizedBody.Male || data.TargetBody == StandardizedBody.Female))
			{
				result = 1.25f;
			}
			// Males with a certain orientation.
			else if (data.PawnOri == Orientation.Heterosexual &&
					 (data.PawnSex == Sex.Male || data.PawnSex == Sex.Trap) &&
					 data.TargetBody == StandardizedBody.Female)
			{
				result = 1.25f;
			}
			else if (data.PawnOri == Orientation.Homosexual &&
					 (data.PawnSex == Sex.Male || data.PawnSex == Sex.Trap) &&
					 data.TargetBody == StandardizedBody.Male)
			{
				result = 1.25f;
			}
			// Females with a certain orientation.
			else if (data.PawnOri == Orientation.Heterosexual &&
					 data.PawnSex == Sex.Female &&
					 data.TargetBody == StandardizedBody.Male)
			{
				result = 1.25f;
			}
			else if (data.PawnOri == Orientation.Homosexual &&
					 data.PawnSex == Sex.Female &&
					 data.TargetBody == StandardizedBody.Female)
			{
				result = 1.25f;
			}

			// The default is already covered by the initial assignment (1f or 1.1f depending on your intention)
			return result;
		}
	}
}