using Verse;
using RimWorld;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles the beauty stat of a target.
	/// </summary>
	public sealed class P_HumanToBeauty : CurveAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Not applicable to animal observers.
			if (request.Category.AnimalObserver()) return;

			request.SetPreference(new P_HumanToBeauty());
		}

		/// <summary>
		/// Points of a curve that maps a pawn's beauty stat to a scalar to apply.
		/// </summary>
		private static readonly CurvePoint[] beautyPoints = new CurvePoint[]
		{
			new(-2f, 0.5f),
			new(-1f, 0.8f),
			new(0f, 1f),
			new(1f, 1.1f),
			new(2f, 1.25f)
		};

		private P_HumanToBeauty() : base(
			AttractionMode.Physical,
			nameof(P_HumanToBeauty),
			GetBeautyStat,
			beautyPoints)
		{ }

		private static float GetBeautyStat(ref AttractionRequest request) =>
			request.Target.GetStatValue(StatDefOf.PawnBeauty);
	}
}