namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// <para>Handles the penalty applied to dead pawns.</para>
	/// <para>The Necrophile quirk will tweak this preference to make it more
	/// favorable to the pawn.</para>
	/// </summary>
	public sealed class P_DeadOrAlive : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only applicable for sex.  A pawn can remember a dead pawn fondly,
			// but when it comes to fucking their corpse, THEN we care about
			// whether they're dead or alive.
			if (request.Purpose.IsNotForSex()) return;

			request.SetPreference(new P_DeadOrAlive());
		}

		private P_DeadOrAlive() : base(
			AttractionMode.Physical,
			nameof(P_DeadOrAlive),
			FactorOperation.Multiply,
			IsAlive,
			whenFalse: FixedValue(0.5f))
		{ }

		private static bool IsAlive(ref AttractionRequest request) => !request.Target.Dead;
	}
}