namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// <para>Handles two animals of different species, checking their
	/// sex-parts (and possibly other qualities) to see if they're likely
	/// similar species, such as a dog and wolf. If they differ, a penalty
	/// is applied.</para>
	/// <para>Humans are always considered compatible mates for animals,
	/// because fun!  So we don't check that here.</para>
	/// </summary>
	public sealed class P_AnimalToCompatibleSpecies : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Observer must be an animal.
			if (!request.Category.AnimalObserver()) return;

			request.SetPreference(new P_AnimalToCompatibleSpecies());
		}

		private P_AnimalToCompatibleSpecies() : base(
			AttractionMode.Physical,
			nameof(P_AnimalToCompatibleSpecies),
			FactorOperation.Multiply,
			IsCompatibleSpecies,
			whenFalse: FixedValue(0.4f))
		{ }

		private static bool IsCompatibleSpecies(ref AttractionRequest request) =>
			RaceGroupDef_Helper.IsCompatibleForMating(request.Pawn, request.Target);
	}
}