using System.Collections.Generic;
using Verse;
using rjw.Modules.Shared.Helpers;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles attractiveness-by-age for non-animal targets.
	/// </summary>
	public sealed class A_AgeForHuman : CurveAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Animal observers do not have an age that is comparable to humans.
			if (request.Category is not AttractionCategory.BetweenHumans) return;
			// Neither do robots.
			if (request.Pawn.IsUnsexyRobot()) return;

			// These curves are for the gender of the target.
			var sourceCurve = request.Target.gender switch
			{
				Gender.Male => AgeConfigDef.Instance.attractivenessByAgeMale,
				// Could be `Gender.None`, but whatever.
				_ => AgeConfigDef.Instance.attractivenessByAgeFemale
			};

			request.SetPreference(new A_AgeForHuman(sourceCurve));
		}

		private A_AgeForHuman(IEnumerable<CurvePoint> points) : base(
			AttractionMode.Age,
			nameof(A_AgeForHuman),
			GetScaledAge,
			points)
		{ }

		private static float GetScaledAge(ref AttractionRequest request) =>
			AgeHelper.ScaleToHumanAge(request.Target);
	}
}