namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles attractiveness-by-age for animal targets.
	/// </summary>
	public sealed class A_AgeForAnimal : AttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// The target must be an animal.
			if (!request.Category.AnimalTarget()) return;

			request.SetPreference(new A_AgeForAnimal());
		}

		private A_AgeForAnimal() : base(
			AttractionMode.Age,
			nameof(A_AgeForAnimal),
			FactorOperation.Multiply)
		{ }

		protected override float GetOperand(ref AttractionRequest request, float factor)
		{
			var target = request.Target;
			if (target.ageTracker.CurLifeStage.reproductive) return 1f;
			if (target.ageTracker.AgeBiologicalYears > 1) return 1f;
			// Very young animal; make some assumptions based on life expectancy.
			return target.RaceProps.lifeExpectancy > 8f ? 0.5f : 1f;
		}
	}
}