namespace rjw.Modules.Attraction
{
	/// <summary>
	/// What the purpose of an attraction request is.
	/// </summary>
	public enum AttractionPurpose
	{
		/// <summary>
		/// Seeing how much one pawn is into another pawn, generally.
		/// </summary>
		General,
		/// <summary>
		/// Seeing how much one pawn wants to bang another pawn.
		/// </summary>
		ForFucking,
		/// <summary>
		/// Seeing how much one pawn wants to rape another pawn.
		/// </summary>
		ForRape
	}

	public static class AttractionPurposeExtensions
	{
		/// <summary>
		/// Convenience extension for checking if the attraction purpose is not for sex.
		/// </summary>
		/// <param name="purpose">The purpose to inspect.</param>
		/// <returns>Whether it is not for sex.</returns>
		public static bool IsNotForSex(this AttractionPurpose purpose) =>
			purpose is AttractionPurpose.General;

		/// <summary>
		/// Convenience extension for checking if the attraction purpose is for any
		/// kind of sex, including rape.
		/// </summary>
		/// <param name="purpose">The purpose to inspect.</param>
		/// <returns>Whether it is for any kind of sex.</returns>
		public static bool IsForSex(this AttractionPurpose purpose) =>
			purpose is not AttractionPurpose.General;

		/// <summary>
		/// Convenience extension for checking if the attraction purpose is for rape.
		/// </summary>
		/// <param name="purpose">The purpose to inspect.</param>
		/// <returns>Whether it is for rape.</returns>
		public static bool IsForRape(this AttractionPurpose purpose) =>
			purpose is AttractionPurpose.ForRape;
	}
}