using RimWorld;
using Verse;
using Verse.AI;

namespace rjw
{
	/// <summary>
	/// Pawn tries to find animal to do loving/raping.
	/// </summary>
	public class JobGiver_Bestiality : ThinkNode_JobGiver
	{
		protected override Job TryGiveJob(Pawn pawn)
		{
			if (pawn.Drafted) return null;

			// Most checks are now done in ThinkNode_ConditionalBestiality

			if (!SexUtility.ReadyForLovin(pawn) || !xxx.is_hornyorfrustrated(pawn))
				return null;

			Pawn target = BreederHelper.FindAnimalToBreed(pawn);

			if (target == null) return null;

			Building_Bed petbed = target.ownership.OwnedBed;
			Building_Bed bed = pawn.ownership.OwnedBed;

			float animal_raped_chance = 0.5f;

			if (AfterSexUtility.AnimalParaphilia(target))
			{
				animal_raped_chance -= AfterSexUtility.AnimalParaphiliaStage(target) * 0.125f;
				//ModLog.Message("Animal raped chance: " + animal_raped_chance + " Animal Name:" + target.Name);
			}

			if (xxx.can_rape(pawn) && Rand.Chance(animal_raped_chance))
			{
				return JobMaker.MakeJob(xxx.bestiality, target);
			}
			else if (xxx.can_fuck(pawn) && !target.Downed)
			{
				if (bed != null && petbed != null && target.CanReach(bed, PathEndMode.OnCell, Danger.Some) && pawn.CanReach(petbed, PathEndMode.OnCell, Danger.Some)) //Both beds are available, lets try to select closest
				{
					if (pawn.Position.DistanceTo(petbed.Position) >= pawn.Position.DistanceTo(bed.Position))
						return JobMaker.MakeJob(xxx.bestialityForFemale, target, bed); //Own bed is closer, go there
					else if (pawn.Position.DistanceTo(petbed.Position) < pawn.Position.DistanceTo(bed.Position))
						return JobMaker.MakeJob(xxx.bestialityForFemale, target, petbed); //Petbed is closer, go there instead
				}
				else if (bed != null && target.CanReach(bed, PathEndMode.OnCell, Danger.Some)) //Only pawn bed is available
				{
					return JobMaker.MakeJob(xxx.bestialityForFemale, target, bed); //go to pawn bed
				}
				else if (petbed != null && pawn.CanReach(petbed, PathEndMode.OnCell, Danger.Some)) //Only animal bed is available
				{
					return JobMaker.MakeJob(xxx.bestialityForFemale, target, petbed); //go to animal bed
				}
				else
				{
					return JobMaker.MakeJob(xxx.bestiality, target); //fallback for sex if no bed
				}
			}
			else if (xxx.can_be_fucked(pawn) && !target.Downed)
			{
				if (bed != null && petbed != null && target.CanReach(bed, PathEndMode.OnCell, Danger.Some) && pawn.CanReach(petbed, PathEndMode.OnCell, Danger.Some)) //Both beds are available, lets try to select closest
				{
					if (pawn.Position.DistanceTo(petbed.Position) >= pawn.Position.DistanceTo(bed.Position))
						return JobMaker.MakeJob(xxx.bestialityForFemale, target, bed); //Own bed is closer, go there
					else if (pawn.Position.DistanceTo(petbed.Position) < pawn.Position.DistanceTo(bed.Position))
						return JobMaker.MakeJob(xxx.bestialityForFemale, target, petbed); //Petbed is closer, go there instead
				}
				else if (bed != null && target.CanReach(bed, PathEndMode.OnCell, Danger.Some)) //Only pawn bed is available
				{
					return JobMaker.MakeJob(xxx.bestialityForFemale, target, bed); //go to pawn bed
				}
				else if (petbed != null && pawn.CanReach(petbed, PathEndMode.OnCell, Danger.Some)) //Only animal bed is available
				{
					return JobMaker.MakeJob(xxx.bestialityForFemale, target, petbed); //go to animal bed
				}
			}
			return null;
		}
	}
}