using Verse;
using UnityEngine;
using rjw.Modules.Shared.Extensions;

namespace rjw
{
	// Would be nice to call this just 'ISexPart', but ILewdablePart already exists and represents something similar but different.
	public interface ISexPartHediff
	{
		HediffDef_SexPart Def { get; }

		T GetComp<T>() where T : HediffComp;

		HediffWithComps AsHediff { get; }
	}

	public static class ISexPartHediffExtensions
	{
		public static HediffComp_SexPart GetPartComp(this ISexPartHediff partHediff) => partHediff.GetComp<HediffComp_SexPart>();

		public static Pawn GetOwner(this ISexPartHediff part) => part.AsHediff.pawn;

		public static void DetectExternalSeverityChange(HediffWithComps hediff, float prevValue, float newValue)
		{
			if(Find.TickManager.Paused && prevValue != newValue)
			{
				if(hediff.TryGetComp<HediffComp_SexPart>(out var comp))
				{
					if (newValue != comp.GetSeverity())
					{
						ModLog.Message($"DetectExternalSeverityChange: {hediff.LabelBaseCap} ({hediff.pawn.GetName()}), {prevValue} -> {newValue}.");
						comp.SetSeverity(newValue, sync: false);
					}
				}
			}
		}
	}
}