using RimWorld;
using System.Collections.Generic;
using System.Linq;
using Verse;
using System;
using rjw.Modules.Attraction;

namespace rjw.RMB
{
	/// <summary>
	/// Generator of RMB categories for necrophilia
	/// </summary>
	static class RMB_Necro
	{
		/// <summary>
		/// Create necrophilia and reverse necrophilia options
		/// </summary>
		/// <param name="pawn">Selected pawn</param>
		/// <param name="target">Target of the right click</param>
		public static IEnumerable<FloatMenuOption> GetOptions(Pawn pawn, Corpse target)
		{
			AcceptanceReport canCreateEntries = DoBasicChecks(pawn, target);

			if (!canCreateEntries)
			{
				if (RJWSettings.DevMode && !canCreateEntries.Reason.NullOrEmpty())
					yield return new FloatMenuOption(canCreateEntries.Reason, null);

				yield break;
			}

			canCreateEntries = DoChecks(pawn, target);

			if (!canCreateEntries)
			{
				yield return new FloatMenuOption("RJW_RMB_RapeCorpse".Translate(target) + ": " + canCreateEntries.Reason, null);
				yield break;
			}

			FloatMenuOption opt = GenerateCategoryOption(pawn, target);
			if (opt != null)
				yield return opt;

			opt = GenerateCategoryOption(pawn, target, true);
			if (opt != null)
				yield return opt;
		}

		/// <summary>
		/// Check for the things that should be obvious to the player or does not change for particular pawns.
		/// </summary>
		/// <returns>
		/// AcceptanceReport. Reason is an untranslated string and should only be shown in the DevMode
		/// </returns>
		private static AcceptanceReport DoBasicChecks(Pawn pawn, Corpse target)
		{
			if (!RJWSettings.necrophilia_enabled)
			{
				return "No necro: Disabled by the mod settings";
			}

			if (target.InnerPawn == null || target.InnerPawn == pawn)
			{
				return false;
			}

			if (!xxx.can_rape(pawn, true))
			{
				return "No necro: Pawn can't rape";
			}

			return true;
		}

		/// <summary>
		/// Check for the things that can change for particular pawns.
		/// </summary>
		/// <returns>
		/// AcceptanceReport. Reason is a translated string and should not be null.
		/// </returns>
		private static AcceptanceReport DoChecks(Pawn pawn, Corpse target)
		{
			if (!pawn.IsDesignatedHero() && !pawn.IsHeroOwner())
			{
				if (AttractionUtility.Evaluate(pawn, target.InnerPawn) < 0.1f)
				{
					return "RJW_RMB_ReasonUnappealingTarget".Translate();
				}
			}

			return true;
		}

		/// <summary>
		/// Generate one FloatMenuOption
		/// </summary>
		/// <param name="pawn"></param>
		/// <param name="target"></param>
		/// <param name="reverse"></param>
		/// <returns>Category-level item that opens a sub-menu on click</returns>
		private static FloatMenuOption GenerateCategoryOption(Pawn pawn, Corpse target, bool reverse = false)
		{
			string text = null;
			if (reverse)
			{
				text = "RJW_RMB_RapeCorpse_Reverse".Translate(target);
			}
			else
			{
				text = "RJW_RMB_RapeCorpse".Translate(target);
			}

			Action action = delegate ()
			{
				var validinteractions = RMB_Menu.GenerateNonSoloSexRoleOptions(pawn, target, xxx.RapeCorpse, true, reverse);
				if (validinteractions.Any())
					FloatMenuUtility.MakeMenu(validinteractions, (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
				else
				{
					var messageText = "RJW_RMB_NoValidInteractions".Translate(text);
					Messages.Message(messageText, MessageTypeDefOf.RejectInput, false);
				}
			};

			return FloatMenuUtility.DecoratePrioritizedTask(new FloatMenuOption(text, action, MenuOptionPriority.High), pawn, target);
		}
	}
}
