﻿using RimWorld;
using System.Collections.Generic;
using Verse;
using rjw.Modules.Interactions;

namespace rjw.RMB
{
	/// <summary>
	/// Generator of RMB categories for masturbation.
	///
	/// Unlike the two-pawn options, masturbation menu is two has 3 levels:
	/// Masturbate -> Masturbate on bed
	///               Masturbate at (tile) -> Interaction 1
	///               Masturbate here         Interaction 2
	///                                       etc.
	/// </summary>
	static class RMB_Masturbate
	{
		/// <summary>
		/// Create masturbation option
		/// </summary>
		/// <param name="pawn">Selected pawn</param>
		public static IEnumerable<FloatMenuOption> GetOptions(Pawn pawn)
		{
			FloatMenuOption opt = GenerateCategoryOption(pawn);
			if (opt != null)
				yield return opt;
		}

		/// <summary>
		/// Generate one FloatMenuOption
		/// </summary>
		/// <returns>Category-level item that opens a sub-menu on click</returns>
		private static FloatMenuOption GenerateCategoryOption(Pawn pawn)
		{
			return FloatMenuUtility.DecoratePrioritizedTask(new FloatMenuOption("RJW_RMB_Masturbate".Translate(), delegate ()
			{
				FloatMenuUtility.MakeMenu(GenerateSoloSexRoleOptions(pawn), (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
			}, MenuOptionPriority.High), pawn, pawn);
		}

		/// <summary>
		/// Generates sub-menu options for a solo pawn
		/// </summary>
		/// <param name="pawn">Initiator pawn</param>
		/// <returns>A list of menu options, where each item represents a possible masturbation type</returns>
		private static IEnumerable<FloatMenuOption> GenerateSoloSexRoleOptions(Pawn pawn)
		{
			FloatMenuOption option = new("RJW_RMB_Masturbate_Bed".Translate(), delegate ()
			{
				Find.Targeter.BeginTargeting(TargetParemetersMasturbationChairOrBed(), (LocalTargetInfo targetThing) =>
				{
					FloatMenuUtility.MakeMenu(GenerateSoloSexPoseOptions(pawn, targetThing), (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
				});
			}, MenuOptionPriority.High);
			yield return FloatMenuUtility.DecoratePrioritizedTask(option, pawn, pawn);

			option = new FloatMenuOption("RJW_RMB_Masturbate_At".Translate(), delegate ()
			{
				Find.Targeter.BeginTargeting(TargetParemetersMasturbationLoc(), (LocalTargetInfo targetLoc) =>
				{
					FloatMenuUtility.MakeMenu(GenerateSoloSexPoseOptions(pawn, targetLoc), (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
				});
			}, MenuOptionPriority.High);
			yield return FloatMenuUtility.DecoratePrioritizedTask(option, pawn, pawn);

			option = new FloatMenuOption("RJW_RMB_Masturbate_Here".Translate(), delegate ()
			{
				FloatMenuUtility.MakeMenu(GenerateSoloSexPoseOptions(pawn, pawn.Position), (FloatMenuOption opt) => opt.Label, (FloatMenuOption opt) => opt.action);
			}, MenuOptionPriority.High);
			yield return FloatMenuUtility.DecoratePrioritizedTask(option, pawn, pawn);
		}

		private static TargetingParameters TargetParemetersMasturbationChairOrBed()
		{
			return new TargetingParameters()
			{
				canTargetBuildings = true,
				mapObjectTargetsMustBeAutoAttackable = false,
				validator = (TargetInfo target) =>
				{
					if (!target.HasThing)
						return false;
					if (target.Thing is not Building building)
						return false;
					if (building.def.building.isSittable)
						return true;
					if (building is Building_Bed)
						return true;
					return false;
				}
			};
		}

		public static TargetingParameters TargetParemetersMasturbationLoc()
		{
			return new TargetingParameters()
			{
				canTargetLocations = true,
				mapObjectTargetsMustBeAutoAttackable = false,
				validator = (TargetInfo target) =>
				{
					if (!target.HasThing)
						return true;
					return false;
				}
			};
		}

		/// <summary>
		/// Generates sub-sub-menu options for a solo pawn
		/// </summary>
		/// <param name="pawn">Initiator pawn</param>
		/// <param name="target">Place to masturbate</param>
		/// <returns>A list of menu options, where each item represents a possible masturbation interaction</returns>
		public static IEnumerable<FloatMenuOption> GenerateSoloSexPoseOptions(Pawn pawn, LocalTargetInfo target)
		{
			bool foundInteraction = false;

			foreach (InteractionDef d in SexUtility.SexInteractions)
			{
				var interaction = new SexInteraction(d);
				if (interaction.Extension.rjwSextype != xxx.rjwSextype.Masturbation.ToStringSafe())
					continue;

				var props = new SexProps { pawn = pawn, partner = pawn, interaction = interaction };
				var resolved = SexInteractionHelper.ResolveInteraction(props);
				if (resolved == null)
					continue;

				string label = interaction.Extension.RMBLabel.CapitalizeFirst();
				if (RJWSettings.DevMode)
					label += $" ( defName: {d.defName} )";

				FloatMenuOption option = new FloatMenuOption(label, delegate ()
				{
					RMB_Menu.HaveSex(pawn, xxx.Masturbate, target, d, resolved);
				}, MenuOptionPriority.High);
				yield return FloatMenuUtility.DecoratePrioritizedTask(option, pawn, target);
				foundInteraction = true;
			}

			if (RJWSettings.DevMode && !foundInteraction)
			{
				yield return new FloatMenuOption("No interactions found", null);
			}
		}
	}
}