using RimWorld;
using Verse;
using Verse.AI;

namespace rjw
{
	/// <summary>
	/// Called to determine if the animal is eligible for a mating with Bonded pawn
	/// </summary>
	public class ThinkNode_ConditionalCanMateBonded : ThinkNode_Conditional
	{
		protected override bool Satisfied(Pawn p)
		{
			if (!xxx.is_animal(p))
				return false;

			// Animal stuff disabled.
			if ((!RJWSettings.bestiality_enabled) || (!RJWSettings.animal_on_human_enabled))
				return false;

			if (xxx.HasBond(p))
				return true;

			else return false;
		}
	}
}