using RimWorld;
using Verse;
using Verse.AI;
using System.Linq;

namespace rjw
{
	public class ThinkNode_ChancePerHour_Fappin : ThinkNode_ChancePerHour
	{
		public static float get_fappin_mtb_hours(Pawn pawn)
		{
			float result = 1f;
			result /= 1f - pawn.health.hediffSet.PainTotal;
			
			float efficiency = pawn.health.capacities.GetLevel(PawnCapacityDefOf.Consciousness);
			if (efficiency < 0.5f)
			{
				result /= efficiency * 2f;
			}

			if (!pawn.RaceProps.Humanlike)
			{
				return result * 4f;
			}
			if (RimWorld.LovePartnerRelationUtility.ExistingLovePartner(pawn) != null)
			{
				result *= 2f; //This is a factor which makes pawns with love partners less likely to do fappin/random raping/rapingCP/bestiality/necro.
			}
			else if (pawn.gender == Gender.Male)
			{
				result /= 1.25f; //This accounts for single men
			}

			result /= GenMath.FlatHill(0.0001f, 8f, 13f, 28f, 50f, 0.15f, pawn.ageTracker.AgeBiologicalYearsFloat);//this needs to be changed

			if (xxx.is_nympho(pawn))
			{
				result /= 2f;
			}

			return result;
		}

		protected override float MtbHours(Pawn p)
		{
			// No fapping for animals... for now, at least.
			// Maybe enable this for monsters girls and such in future, but that'll need code changes to avoid errors.
			if (xxx.is_animal(p))
				return -1.0f;

			bool is_horny = xxx.is_hornyorfrustrated(p);
			if (is_horny)
			{
				bool isAlone = !p.Map.mapPawns.AllPawnsSpawned.Any(x => p.CanSee(x) && xxx.is_human(x));
				// More likely to fap if alone.
				float aloneFactor = isAlone ? 0.6f : 1.2f;
				if (xxx.has_quirk(p, "Exhibitionist"))
					aloneFactor = isAlone ? 1.0f : 0.6f;

				// More likely to fap if nude.
				float clothingFactor = p.apparel.PsychologicallyNude ? 0.8f : 1.0f;

				float SexNeedFactor = (4 - xxx.need_some_sex(p)) / 2f;
				return get_fappin_mtb_hours(p) * SexNeedFactor * aloneFactor * clothingFactor;
			}

			return -1.0f;
		}
	}
}