﻿using System;
using Verse;

namespace rjw.Modules.Shared.Extensions
{
	public static class BodyPartRecordExtension
	{
		/// <summary>
		/// Check if body part is missing. Unlike vanilla <see cref="HediffSet.PartIsMissing"/>,
		/// this method takes into account artificial replacements.
		/// </summary>
		/// <exception cref="ArgumentNullException"></exception>
		public static bool IsMissingForPawn(this BodyPartRecord self, Pawn pawn)
		{
			if (pawn == null)
			{
				throw new ArgumentNullException(nameof(pawn));
			}
			if (self == null)
			{
				throw new ArgumentNullException(nameof(self));
			}

			HediffSet hediffSet = pawn.health.hediffSet;

			if (hediffSet.PartIsMissing(self))
			{
				// Part can be missing because it has been replaced by an artificial part.
				// In vanilla an artificial part can replace more than one natural part.
				// For example, the bionic arm is actually a shoulder, while arm, hand and fingers are missing
				return !hediffSet.PartOrAnyAncestorHasDirectlyAddedParts(self);
			}

			return false;
		}
	}
}
