﻿using rjw.Modules.Interactions.Enums;
using System.Collections.Generic;
using Verse;

namespace rjw.Modules.Interactions.Objects.Parts
{
	public class RJWLewdablePart : ILewdablePart
	{
		public ISexPartHediff Part { get; private set; }

		public LewdablePartKind PartKind { get; private set; }

		public float Size => Part.AsHediff.Severity;

		private readonly IList<string> _props;
		public IList<string> Props => _props;

		public RJWLewdablePart(ISexPartHediff hediff, LewdablePartKind partKind)
		{
			Part = hediff;
			PartKind = partKind;
			_props = hediff.Def.partTags ?? new();
		}
	}
}
