﻿using LudeonTK;
using RimWorld;
using rjw.Modules.Interactions.Objects;
using rjw.Modules.Shared.Extensions;
using System.Collections.Generic;
using System.Linq;
using Verse;

namespace rjw.Modules.Interactions.Extensions
{
	public static class PawnExtensions
	{
		public static SexablePawnParts GetSexablePawnParts(this Pawn self)
		{
			if (self == null)
			{
				return null;
			}

			//We get the genital parts once so we don't parse ALL the hediff all the time
			IList<ISexPartHediff> hediffWithGenitalParts = self.health.hediffSet.hediffs
				.OfType<ISexPartHediff>()
				.ToList();

			return new SexablePawnParts
			{
				Mouths = self.Mouths().WithoutMissing(self),
				Beaks = self.Beaks().WithoutMissing(self),
				Tongues = self.Tongues().WithoutMissing(self),
				Hands = self.Hands().WithoutMissing(self),
				Feet = self.Feet().WithoutMissing(self),
				Tails = self.Tails().WithoutMissing(self),

				AllParts = hediffWithGenitalParts,

				Penises = hediffWithGenitalParts.Penises(),
				Vaginas = hediffWithGenitalParts.Vaginas(),
				Breasts = hediffWithGenitalParts.Breasts(),
				Udders = hediffWithGenitalParts.Udders(),
				Anuses = hediffWithGenitalParts.Anuses(),

				FemaleOvipositors = hediffWithGenitalParts.FemaleOvipositors(),
				MaleOvipositors = hediffWithGenitalParts.MaleOvipositors()
			};
		}

		private static IList<BodyPartRecord> Mouths(this Pawn self)
		{
			//EatingSource = mouth
			return self.RaceProps.body.GetPartsWithTag(RimWorld.BodyPartTagDefOf.EatingSource)
				.Where(part => part.def.defName?.ToLower().Contains("beak") == false)
				.ToList();
		}

		private static IList<BodyPartRecord> Beaks(this Pawn self)
		{
			//EatingSource = mouth
			return self.RaceProps.body.GetPartsWithTag(RimWorld.BodyPartTagDefOf.EatingSource)
				.Where(part => part.def.defName?.ToLower().Contains("beak") == true)
				.ToList();
		}

		private static IList<BodyPartRecord> Tongues(this Pawn self)
		{
			BodyDef body = self.RaceProps.body;
			List<BodyPartRecord> possibleParts = body.GetPartsWithTag(RimWorld.BodyPartTagDefOf.Tongue);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Vanilla animals don't have tongues
			possibleParts = body.GetPartsWithDef(RJWBodyPartDefOf.AnimalJaw);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Fallback for races with custom tongue def
			return body.GetPartsWhereDefNameContains("tongue").ToList();
		}

		private static IList<BodyPartRecord> Tails(this Pawn self)
		{
			BodyDef body = self.RaceProps.body;
			List<BodyPartRecord> possibleParts = body.GetPartsWithDef(RJWBodyPartDefOf.Tail);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Found at least one race with a custom tail def
			return body.GetPartsWhereDefNameContains("tail").ToList();
		}

		private static IList<BodyPartRecord> Hands(this Pawn self)
		{
			BodyDef body = self.RaceProps.body;
			List<BodyPartRecord> possibleParts = body.GetPartsWithDef(BodyPartDefOf.Hand);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Some races just don't model hands
			possibleParts = body.GetPartsWithDef(BodyPartDefOf.Arm);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// At least one race only modelled shoulders
			possibleParts = body.GetPartsWithDef(BodyPartDefOf.Shoulder);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Fallback for races with custom hand def
			return body.GetPartsWhereDefNameContains("hand").ToList();
		}

		private static IList<BodyPartRecord> Feet(this Pawn self)
		{
			BodyDef body = self.RaceProps.body;
			List<BodyPartRecord> possibleParts = body.GetPartsWithDef(RJWBodyPartDefOf.Foot);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Animals have paws instead of feet
			possibleParts = body.GetPartsWithDef(RJWBodyPartDefOf.Paw);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Don't know if there are races that don't model feet, but I'll add this
			possibleParts = body.GetPartsWithDef(RJWBodyPartDefOf.Leg);
			if (possibleParts.Count > 0)
			{
				return possibleParts;
			}

			// Fallback for races with custom foot def
			return body.GetPartsWhereDefNameContains("foot", "paw").ToList();
		}

		/// <summary>
		/// Find all BodyPartRecords where def name contains one of the strings.
		/// <br/>
		/// This method is slower than GetPartsWithTag and much slower than GetPartsWithDef.
		/// </summary>
		/// <param name="name">Strings to search in the def names. Lower case only</param>
		private static IEnumerable<BodyPartRecord> GetPartsWhereDefNameContains(this BodyDef body, params string[] name)
		{
			for (int i = 0; i < body.AllParts.Count; i++)
			{
				if (body.AllParts[i].def.defName?.ToLower().ContainsAny(name) == true)
				{
					yield return body.AllParts[i];
				}
			}
		}

		/// <summary>
		/// Create new list without the missing body parts
		/// </summary>
		/// <param name="self">List of body parts</param>
		/// <param name="owner">Pawn to check against</param>
		/// <returns>New list with filtered values from <paramref name="self"/></returns>
		private static IList<BodyPartRecord> WithoutMissing(this IList<BodyPartRecord> self, Pawn owner)
		{
			// body.GetPartsWithDef returns a ref to the cached list. Bad things will happen if we change it
			List<BodyPartRecord> result = new List<BodyPartRecord>();

			for (int i = 0; i < self.Count; i++)
			{
				if (!self[i].IsMissingForPawn(owner))
				{
					result.Add(self[i]);
				}
			}

			return result;
		}

		[DebugAction("RimJobWorld", "Dump SexablePawnParts", actionType = DebugActionType.ToolMapForPawns, allowedGameStates = AllowedGameStates.PlayingOnMap)]
		public static void DumpSexablePawnParts(Pawn pawn)
		{
			SexablePawnParts parts = pawn.GetSexablePawnParts();

			ModLog.Message($"Dumping SexablePawnParts for {pawn}");
			ModLog.Message($"Mouths ({parts.Mouths.Count()}):");
			foreach (var part in parts.Mouths)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Beaks ({parts.Beaks.Count()}):");
			foreach (var part in parts.Beaks)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Tongues ({parts.Tongues.Count()}):");
			foreach (var part in parts.Tongues)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Hands ({parts.Hands.Count()}):");
			foreach (var part in parts.Hands)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Feet ({parts.Feet.Count()}):");
			foreach (var part in parts.Feet)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Tails ({parts.Tails.Count()}):");
			foreach (var part in parts.Tails)
			{
				ModLog.Message($"    {part}");
			}

			ModLog.Message($"Penises ({parts.Penises.Count()}):");
			foreach (var part in parts.Penises)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Vaginas ({parts.Vaginas.Count()}):");
			foreach (var part in parts.Vaginas)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Breasts ({parts.Breasts.Count()}):");
			foreach (var part in parts.Breasts)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Udders ({parts.Udders.Count()}):");
			foreach (var part in parts.Udders)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"Anuses ({parts.Anuses.Count()}):");
			foreach (var part in parts.Anuses)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"FemaleOvipositors ({parts.FemaleOvipositors.Count()}):");
			foreach (var part in parts.FemaleOvipositors)
			{
				ModLog.Message($"    {part}");
			}
			ModLog.Message($"MaleOvipositors ({parts.MaleOvipositors.Count()}):");
			foreach (var part in parts.MaleOvipositors)
			{
				ModLog.Message($"    {part}");
			}

			ModLog.Message($"AllParts ({parts.AllParts.Count()}):");
			foreach (var part in parts.AllParts)
			{
				ModLog.Message($"    {part}");
			}
		}
	}
}
