﻿using rjw.Modules.Interactions.Enums;
using rjw.Modules.Interactions.Objects;
using rjw.Modules.Interactions.Objects.Parts;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

namespace rjw.Modules.Interactions.Extensions
{
	public static class EnumerableExtensions
	{
		public static IEnumerable<ILewdablePart> FilterSeverity(this IEnumerable<ILewdablePart> self, Nullable<float> severity)
		{
			IEnumerable<ILewdablePart> result = self;

			if (severity.HasValue == true)
			{
				result = Enumerable.Union(
					result.Where(e => e is VanillaLewdablePart),
					result.Where(e => e is RJWLewdablePart)
						.Where(e => (e as RJWLewdablePart).Part.AsHediff.Severity >= severity.Value)
					);
			}

			foreach (ILewdablePart part in result)
			{
				yield return part;
			}
		}

		public static IEnumerable<ILewdablePart> WithPartKind(this IEnumerable<ILewdablePart> self, LewdablePartKind partKind)
		{
			return self
				.Where(e => e.PartKind == partKind);
		}
		public static IEnumerable<ILewdablePart> WithPartTag(this IEnumerable<ILewdablePart> self, GenitalTag tag)
		{
			return self
				.OfType<RJWLewdablePart>()
				.Where(e => e.Part.Def.genitalTags.Contains(tag));
		}
		public static IEnumerable<ILewdablePart> WithPartKindAndTag(this IEnumerable<ILewdablePart> self, LewdablePartKind partKind, GenitalTag tag)
		{
			return self
				.WithPartKind(partKind)
				.WithPartTag(tag);
		}

		public static bool HasPartKind(this IEnumerable<ILewdablePart> self, LewdablePartKind partKind)
		{
			return self
				.WithPartKind(partKind)
				.Any();
		}
		public static bool HasPartTag(this IEnumerable<ILewdablePart> self, GenitalTag tag)
		{
			return self
				.WithPartTag(tag)
				.Any();
		}
		public static bool HasPartKindAndTag(this IEnumerable<ILewdablePart> self, LewdablePartKind partKind, GenitalTag tag)
		{
			return self
				.WithPartKindAndTag(partKind, tag)
				.Any();
		}
		
		public static IEnumerable<ISexPartHediff> BigBreasts(this IEnumerable<ISexPartHediff> self)
		{
			if (self == null)
			{
				return null;
			}

			return self
				.Where(e => e.Def.genitalFamily == GenitalFamily.Breasts)
				.Where(e => e.AsHediff.CurStageIndex >= 1);
		}
		
		public static bool HasBigBreasts(this IEnumerable<ISexPartHediff> self)
		{
			if (self == null)
			{
				return false;
			}

			return self
				.BigBreasts()
				.Any();
		}

		public static ISexPartHediff Largest(this IEnumerable<ISexPartHediff> self)
		{
			if (self == null)
			{
				return null;
			}

			return self
				.OrderByDescending(e => e.AsHediff.Severity)
				.FirstOrDefault();
		}
		public static ISexPartHediff Smallest(this IEnumerable<ISexPartHediff> self)
		{
			if (self == null)
			{
				return null;
			}

			return self
				.OrderBy(e => e.AsHediff.Severity)
				.FirstOrDefault();
		}

		public static ISexPartHediff GetBestSizeAppropriate(this IEnumerable<ISexPartHediff> self, ISexPartHediff toFit)
		{
			if (self == null)
			{
				return null;
			}

			return self
				.OrderBy(e => Mathf.Abs(e.AsHediff.Severity - toFit.AsHediff.Severity))
				.FirstOrDefault();
		}
	}
}
