﻿using rjw.Modules.Interactions.Enums;
using rjw.Modules.Interactions.Objects.Parts;
using rjw.Modules.Shared.Logs;
using System.Collections.Generic;
using System.Text;
using Verse;

namespace rjw.Modules.Interactions.Exposable
{
	public class RJWLewdablePartExposable : IExposable
	{
		private static ILog _log = LogManager.GetLogger<RJWLewdablePartExposable>();

		public HediffWithExtensionExposable hediff;

		public LewdablePartKind partKind;

		public float Size => hediff.hediff.Severity;

		public IList<string> Props => (hediff.hediff.def as HediffDef_SexPart)?.partTags ?? new();

		public void ExposeData()
		{
			Scribe_Deep.Look(ref hediff, nameof(hediff));
			Scribe_Values.Look(ref partKind, nameof(partKind));
		}

		/// <summary>
		/// Dummy method to not break build pending removal of unused submodule
		/// </summary>
		/// <param name="toCast"></param>
		/// <returns></returns>
		public static RJWLewdablePart Convert(RJWLewdablePartExposable toCast)
		{
			return new RJWLewdablePart(
				toCast.hediff.hediff as ISexPartHediff, 
				toCast.partKind
				);
		}
		public static RJWLewdablePartExposable Convert(RJWLewdablePart toCast)
		{
			return new RJWLewdablePartExposable()
			{
				hediff = HediffWithExtensionExposable.Convert(toCast.Part),
				partKind = toCast.PartKind
			};
		}

		public override string ToString()
		{
			StringBuilder stringBuilder = new StringBuilder();

			stringBuilder.AppendLine($"{nameof(partKind)} = {partKind}");

			return stringBuilder.ToString();
		}
	}
}
