# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtOpenGLFunctions, except for defaults which are replaced by "...".
"""

# Module PySide2.QtOpenGLFunctions
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtGui
import PySide2.QtOpenGLFunctions


class QOpenGLFunctions_1_0(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glInitNames(self) -> None: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_1(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_2(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_3(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_4(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_5(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_2_0(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_2_1(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_0(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_1(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_2_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_2_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_3_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_3_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_0_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_0_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_1_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_1_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_2_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_2_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_3_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glInvalidateBufferData(self, buffer:int) -> None: ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateTexImage(self, texture:int, level:int) -> None: ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_3_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, mode:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInvalidateBufferData(self, buffer:int) -> None: ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateTexImage(self, texture:int, level:int) -> None: ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, index:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_4_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence) -> None: ...
    def glBindBuffersRange(self, target:int, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, sizes:typing.Sequence) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBindVertexBuffers(self, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, strides:typing.Sequence) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int) -> None: ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:int) -> None: ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, buf:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetColorTable(self, target:int, format:int, type:int, table:int) -> None: ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int) -> None: ...
    def glGetConvolutionFilter(self, target:int, format:int, type:int, image:int) -> None: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetHistogram(self, target:int, reset:int, format:int, type:int, values:int) -> None: ...
    def glGetMinmax(self, target:int, reset:int, format:int, type:int, values:int) -> None: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetSeparableFilter(self, target:int, format:int, type:int, row:int, column:int, span:int) -> None: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int) -> None: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glInvalidateBufferData(self, buffer:int) -> None: ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateTexImage(self, texture:int, level:int) -> None: ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes) -> None: ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, src:int) -> None: ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, maskNumber:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_4_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence) -> None: ...
    def glBindBuffersRange(self, target:int, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, sizes:typing.Sequence) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBindVertexBuffers(self, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, strides:typing.Sequence) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int) -> None: ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:int) -> None: ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, buf:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int) -> None: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int) -> None: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glInvalidateBufferData(self, buffer:int) -> None: ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateTexImage(self, texture:int, level:int) -> None: ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int) -> None: ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes) -> None: ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glReadBuffer(self, src:int) -> None: ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, maskNumber:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_5_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glAccum(self, op:int, value:float) -> None: ...
    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAlphaFunc(self, func:int, ref:float) -> None: ...
    def glArrayElement(self, i:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBegin(self, mode:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence) -> None: ...
    def glBindBuffersRange(self, target:int, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, sizes:typing.Sequence) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTextureUnit(self, unit:int, texture:int) -> None: ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBindVertexBuffers(self, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, strides:typing.Sequence) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glBlitNamedFramebuffer(self, readFramebuffer:int, drawFramebuffer:int, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCallList(self, list:int) -> None: ...
    def glCallLists(self, n:int, type:int, lists:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glCheckNamedFramebufferStatus(self, framebuffer:int, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearIndex(self, c:float) -> None: ...
    def glClearNamedBufferData(self, buffer:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearNamedFramebufferfi(self, framebuffer:int, buffer:int, depth:float, stencil:int) -> None: ...
    def glClearNamedFramebufferfv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearNamedFramebufferiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearNamedFramebufferuiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int) -> None: ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int) -> None: ...
    def glClientActiveTexture(self, texture:int) -> None: ...
    def glClipControl(self, origin:int, depth:int) -> None: ...
    def glClipPlane(self, plane:int, equation:typing.Sequence) -> None: ...
    def glColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glColor3bv(self, v:bytes) -> None: ...
    def glColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glColor3dv(self, v:typing.Sequence) -> None: ...
    def glColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glColor3fv(self, v:typing.Sequence) -> None: ...
    def glColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glColor3iv(self, v:typing.Sequence) -> None: ...
    def glColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glColor3sv(self, v:typing.Sequence) -> None: ...
    def glColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glColor3ubv(self, v:bytes) -> None: ...
    def glColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glColor3uiv(self, v:typing.Sequence) -> None: ...
    def glColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glColor3usv(self, v:typing.Sequence) -> None: ...
    def glColor4b(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4bv(self, v:bytes) -> None: ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4dv(self, v:typing.Sequence) -> None: ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glColor4fv(self, v:typing.Sequence) -> None: ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4iv(self, v:typing.Sequence) -> None: ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4sv(self, v:typing.Sequence) -> None: ...
    def glColor4ub(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4ubv(self, v:bytes) -> None: ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4uiv(self, v:typing.Sequence) -> None: ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColor4usv(self, v:typing.Sequence) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glColorMaterial(self, face:int, mode:int) -> None: ...
    def glColorP3ui(self, type:int, color:int) -> None: ...
    def glColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorP4ui(self, type:int, color:int) -> None: ...
    def glColorP4uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int) -> None: ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int) -> None: ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int) -> None: ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float) -> None: ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int) -> None: ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int) -> None: ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int) -> None: ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int) -> None: ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTextureSubImage1D(self, texture:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:int) -> None: ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteLists(self, list:int, range:int) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableClientState(self, array:int) -> None: ...
    def glDisableVertexArrayAttrib(self, vaobj:int, index:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, buf:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEdgeFlag(self, flag:int) -> None: ...
    def glEdgeFlagPointer(self, stride:int, pointer:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableClientState(self, array:int) -> None: ...
    def glEnableVertexArrayAttrib(self, vaobj:int, index:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEnd(self) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndList(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glEvalCoord1d(self, u:float) -> None: ...
    def glEvalCoord1dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord1f(self, u:float) -> None: ...
    def glEvalCoord1fv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2d(self, u:float, v:float) -> None: ...
    def glEvalCoord2dv(self, u:typing.Sequence) -> None: ...
    def glEvalCoord2f(self, u:float, v:float) -> None: ...
    def glEvalCoord2fv(self, u:typing.Sequence) -> None: ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int) -> None: ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int) -> None: ...
    def glEvalPoint1(self, i:int) -> None: ...
    def glEvalPoint2(self, i:int, j:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glFogCoordd(self, coord:float) -> None: ...
    def glFogCoorddv(self, coord:typing.Sequence) -> None: ...
    def glFogCoordf(self, coord:float) -> None: ...
    def glFogCoordfv(self, coord:typing.Sequence) -> None: ...
    def glFogf(self, pname:int, param:float) -> None: ...
    def glFogfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFogi(self, pname:int, param:int) -> None: ...
    def glFogiv(self, pname:int, params:typing.Sequence) -> None: ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGenerateTextureMipmap(self, texture:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetColorTable(self, target:int, format:int, type:int, table:int) -> None: ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int) -> None: ...
    def glGetCompressedTextureImage(self, texture:int, level:int, bufSize:int, pixels:int) -> None: ...
    def glGetCompressedTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, bufSize:int, pixels:int) -> None: ...
    def glGetConvolutionFilter(self, target:int, format:int, type:int, image:int) -> None: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    def glGetHistogram(self, target:int, reset:int, format:int, type:int, values:int) -> None: ...
    def glGetMinmax(self, target:int, reset:int, format:int, type:int, values:int) -> None: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetSeparableFilter(self, target:int, format:int, type:int, row:int, column:int, span:int) -> None: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int) -> None: ...
    def glGetTextureImage(self, texture:int, level:int, format:int, type:int, bufSize:int, pixels:int) -> None: ...
    def glGetTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, bufSize:int, pixels:int) -> None: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glGetnColorTable(self, target:int, format:int, type:int, bufSize:int, table:int) -> None: ...
    def glGetnCompressedTexImage(self, target:int, lod:int, bufSize:int, pixels:int) -> None: ...
    def glGetnConvolutionFilter(self, target:int, format:int, type:int, bufSize:int, image:int) -> None: ...
    def glGetnHistogram(self, target:int, reset:int, format:int, type:int, bufSize:int, values:int) -> None: ...
    def glGetnMinmax(self, target:int, reset:int, format:int, type:int, bufSize:int, values:int) -> None: ...
    def glGetnSeparableFilter(self, target:int, format:int, type:int, rowBufSize:int, row:int, columnBufSize:int, column:int, span:int) -> None: ...
    def glGetnTexImage(self, target:int, level:int, format:int, type:int, bufSize:int, pixels:int) -> None: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:int) -> None: ...
    def glIndexMask(self, mask:int) -> None: ...
    def glIndexPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glIndexd(self, c:float) -> None: ...
    def glIndexdv(self, c:typing.Sequence) -> None: ...
    def glIndexf(self, c:float) -> None: ...
    def glIndexfv(self, c:typing.Sequence) -> None: ...
    def glIndexi(self, c:int) -> None: ...
    def glIndexiv(self, c:typing.Sequence) -> None: ...
    def glIndexs(self, c:int) -> None: ...
    def glIndexsv(self, c:typing.Sequence) -> None: ...
    def glIndexub(self, c:int) -> None: ...
    def glIndexubv(self, c:bytes) -> None: ...
    def glInitNames(self) -> None: ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int) -> None: ...
    def glInvalidateBufferData(self, buffer:int) -> None: ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateNamedFramebufferData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateNamedFramebufferSubData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateTexImage(self, texture:int, level:int) -> None: ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsList(self, list:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLightModelf(self, pname:int, param:float) -> None: ...
    def glLightModelfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightModeli(self, pname:int, param:int) -> None: ...
    def glLightModeliv(self, pname:int, params:typing.Sequence) -> None: ...
    def glLightf(self, light:int, pname:int, param:float) -> None: ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLighti(self, light:int, pname:int, param:int) -> None: ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence) -> None: ...
    def glLineStipple(self, factor:int, pattern:int) -> None: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glListBase(self, base:int) -> None: ...
    def glLoadIdentity(self) -> None: ...
    def glLoadMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadMatrixf(self, m:typing.Sequence) -> None: ...
    def glLoadName(self, name:int) -> None: ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence) -> None: ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid1f(self, un:int, u1:float, u2:float) -> None: ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float) -> None: ...
    def glMapNamedBuffer(self, buffer:int, access:int) -> int: ...
    def glMaterialf(self, face:int, pname:int, param:float) -> None: ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMateriali(self, face:int, pname:int, param:int) -> None: ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence) -> None: ...
    def glMatrixMode(self, mode:int) -> None: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMemoryBarrierByRegion(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMinmax(self, target:int, internalformat:int, sink:int) -> None: ...
    def glMultMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixd(self, m:typing.Sequence) -> None: ...
    def glMultTransposeMatrixf(self, m:typing.Sequence) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int) -> None: ...
    def glMultiTexCoord1d(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1f(self, target:int, s:float) -> None: ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1i(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord1s(self, target:int, s:int) -> None: ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float) -> None: ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int) -> None: ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float) -> None: ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int) -> None: ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float) -> None: ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int) -> None: ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence) -> None: ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int) -> None: ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence) -> None: ...
    def glNamedBufferData(self, buffer:int, size:int, data:int, usage:int) -> None: ...
    def glNamedBufferStorage(self, buffer:int, size:int, data:int, flags:int) -> None: ...
    def glNamedFramebufferDrawBuffer(self, framebuffer:int, buf:int) -> None: ...
    def glNamedFramebufferDrawBuffers(self, framebuffer:int, n:int, bufs:typing.Sequence) -> None: ...
    def glNamedFramebufferParameteri(self, framebuffer:int, pname:int, param:int) -> None: ...
    def glNamedFramebufferReadBuffer(self, framebuffer:int, src:int) -> None: ...
    def glNamedFramebufferRenderbuffer(self, framebuffer:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glNamedFramebufferTexture(self, framebuffer:int, attachment:int, texture:int, level:int) -> None: ...
    def glNamedFramebufferTextureLayer(self, framebuffer:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glNamedRenderbufferStorage(self, renderbuffer:int, internalformat:int, width:int, height:int) -> None: ...
    def glNamedRenderbufferStorageMultisample(self, renderbuffer:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glNewList(self, list:int, mode:int) -> None: ...
    def glNormal3b(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3bv(self, v:bytes) -> None: ...
    def glNormal3d(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3dv(self, v:typing.Sequence) -> None: ...
    def glNormal3f(self, nx:float, ny:float, nz:float) -> None: ...
    def glNormal3fv(self, v:typing.Sequence) -> None: ...
    def glNormal3i(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3iv(self, v:typing.Sequence) -> None: ...
    def glNormal3s(self, nx:int, ny:int, nz:int) -> None: ...
    def glNormal3sv(self, v:typing.Sequence) -> None: ...
    def glNormalP3ui(self, type:int, coords:int) -> None: ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glNormalPointer(self, type:int, stride:int, pointer:int) -> None: ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes) -> None: ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes) -> None: ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float) -> None: ...
    def glPassThrough(self, token:float) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPixelTransferf(self, pname:int, param:float) -> None: ...
    def glPixelTransferi(self, pname:int, param:int) -> None: ...
    def glPixelZoom(self, xfactor:float, yfactor:float) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopAttrib(self) -> None: ...
    def glPopClientAttrib(self) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPopMatrix(self) -> None: ...
    def glPopName(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushAttrib(self, mask:int) -> None: ...
    def glPushClientAttrib(self, mask:int) -> None: ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes) -> None: ...
    def glPushMatrix(self) -> None: ...
    def glPushName(self, name:int) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glRasterPos2d(self, x:float, y:float) -> None: ...
    def glRasterPos2dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2f(self, x:float, y:float) -> None: ...
    def glRasterPos2fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2i(self, x:int, y:int) -> None: ...
    def glRasterPos2iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos2s(self, x:int, y:int) -> None: ...
    def glRasterPos2sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3d(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3f(self, x:float, y:float, z:float) -> None: ...
    def glRasterPos3fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3i(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos3s(self, x:int, y:int, z:int) -> None: ...
    def glRasterPos3sv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4dv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glRasterPos4fv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4iv(self, v:typing.Sequence) -> None: ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glRasterPos4sv(self, v:typing.Sequence) -> None: ...
    def glReadBuffer(self, src:int) -> None: ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glReadnPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, bufSize:int, data:int) -> None: ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResetHistogram(self, target:int) -> None: ...
    def glResetMinmax(self, target:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glRotated(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glRotatef(self, angle:float, x:float, y:float, z:float) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, maskNumber:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScaled(self, x:float, y:float, z:float) -> None: ...
    def glScalef(self, x:float, y:float, z:float) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glSecondaryColor3b(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3bv(self, v:bytes) -> None: ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3dv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float) -> None: ...
    def glSecondaryColor3fv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3iv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3sv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3ub(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3ubv(self, v:bytes) -> None: ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3uiv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int) -> None: ...
    def glSecondaryColor3usv(self, v:typing.Sequence) -> None: ...
    def glSecondaryColorP3ui(self, type:int, color:int) -> None: ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence) -> None: ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int) -> None: ...
    def glShadeModel(self, mode:int) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexCoord1d(self, s:float) -> None: ...
    def glTexCoord1dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1f(self, s:float) -> None: ...
    def glTexCoord1fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1i(self, s:int) -> None: ...
    def glTexCoord1iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord1s(self, s:int) -> None: ...
    def glTexCoord1sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2d(self, s:float, t:float) -> None: ...
    def glTexCoord2dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2f(self, s:float, t:float) -> None: ...
    def glTexCoord2fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2i(self, s:int, t:int) -> None: ...
    def glTexCoord2iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord2s(self, s:int, t:int) -> None: ...
    def glTexCoord2sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3d(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3f(self, s:float, t:float, r:float) -> None: ...
    def glTexCoord3fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3i(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord3s(self, s:int, t:int, r:int) -> None: ...
    def glTexCoord3sv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4dv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float) -> None: ...
    def glTexCoord4fv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4iv(self, v:typing.Sequence) -> None: ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int) -> None: ...
    def glTexCoord4sv(self, v:typing.Sequence) -> None: ...
    def glTexCoordP1ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP2ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP3ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordP4ui(self, type:int, coords:int) -> None: ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence) -> None: ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glTexEnvf(self, target:int, pname:int, param:float) -> None: ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexEnvi(self, target:int, pname:int, param:int) -> None: ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGend(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGenf(self, coord:int, pname:int, param:float) -> None: ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexGeni(self, coord:int, pname:int, param:int) -> None: ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureBarrier(self) -> None: ...
    def glTextureBuffer(self, texture:int, internalformat:int, buffer:int) -> None: ...
    def glTextureParameterIiv(self, texture:int, pname:int, params:typing.Sequence) -> None: ...
    def glTextureParameterIuiv(self, texture:int, pname:int, params:typing.Sequence) -> None: ...
    def glTextureParameterf(self, texture:int, pname:int, param:float) -> None: ...
    def glTextureParameterfv(self, texture:int, pname:int, param:typing.Sequence) -> None: ...
    def glTextureParameteri(self, texture:int, pname:int, param:int) -> None: ...
    def glTextureParameteriv(self, texture:int, pname:int, param:typing.Sequence) -> None: ...
    def glTextureStorage1D(self, texture:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTextureStorage2D(self, texture:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTextureStorage2DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTextureStorage3D(self, texture:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTextureStorage3DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int) -> None: ...
    def glTransformFeedbackBufferBase(self, xfb:int, index:int, buffer:int) -> None: ...
    def glTranslated(self, x:float, y:float, z:float) -> None: ...
    def glTranslatef(self, x:float, y:float, z:float) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUnmapNamedBuffer(self, buffer:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertex2d(self, x:float, y:float) -> None: ...
    def glVertex2dv(self, v:typing.Sequence) -> None: ...
    def glVertex2f(self, x:float, y:float) -> None: ...
    def glVertex2fv(self, v:typing.Sequence) -> None: ...
    def glVertex2i(self, x:int, y:int) -> None: ...
    def glVertex2iv(self, v:typing.Sequence) -> None: ...
    def glVertex2s(self, x:int, y:int) -> None: ...
    def glVertex2sv(self, v:typing.Sequence) -> None: ...
    def glVertex3d(self, x:float, y:float, z:float) -> None: ...
    def glVertex3dv(self, v:typing.Sequence) -> None: ...
    def glVertex3f(self, x:float, y:float, z:float) -> None: ...
    def glVertex3fv(self, v:typing.Sequence) -> None: ...
    def glVertex3i(self, x:int, y:int, z:int) -> None: ...
    def glVertex3iv(self, v:typing.Sequence) -> None: ...
    def glVertex3s(self, x:int, y:int, z:int) -> None: ...
    def glVertex3sv(self, v:typing.Sequence) -> None: ...
    def glVertex4d(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4dv(self, v:typing.Sequence) -> None: ...
    def glVertex4f(self, x:float, y:float, z:float, w:float) -> None: ...
    def glVertex4fv(self, v:typing.Sequence) -> None: ...
    def glVertex4i(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4iv(self, v:typing.Sequence) -> None: ...
    def glVertex4s(self, x:int, y:int, z:int, w:int) -> None: ...
    def glVertex4sv(self, v:typing.Sequence) -> None: ...
    def glVertexArrayAttribBinding(self, vaobj:int, attribindex:int, bindingindex:int) -> None: ...
    def glVertexArrayAttribFormat(self, vaobj:int, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexArrayAttribIFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexArrayAttribLFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexArrayBindingDivisor(self, vaobj:int, bindingindex:int, divisor:int) -> None: ...
    def glVertexArrayElementBuffer(self, vaobj:int, buffer:int) -> None: ...
    def glVertexArrayVertexBuffers(self, vaobj:int, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, strides:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int) -> None: ...
    def glVertexP2ui(self, type:int, value:int) -> None: ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP3ui(self, type:int, value:int) -> None: ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexP4ui(self, type:int, value:int) -> None: ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence) -> None: ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def glWindowPos2d(self, x:float, y:float) -> None: ...
    def glWindowPos2dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2f(self, x:float, y:float) -> None: ...
    def glWindowPos2fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2i(self, x:int, y:int) -> None: ...
    def glWindowPos2iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos2s(self, x:int, y:int) -> None: ...
    def glWindowPos2sv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3d(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3dv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3f(self, x:float, y:float, z:float) -> None: ...
    def glWindowPos3fv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3i(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3iv(self, v:typing.Sequence) -> None: ...
    def glWindowPos3s(self, x:int, y:int, z:int) -> None: ...
    def glWindowPos3sv(self, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_5_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBeginConditionalRender(self, id:int, mode:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence) -> None: ...
    def glBindBuffersRange(self, target:int, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, sizes:typing.Sequence) -> None: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes) -> None: ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBindTextureUnit(self, unit:int, texture:int) -> None: ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBindVertexBuffers(self, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, strides:typing.Sequence) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glBlitNamedFramebuffer(self, readFramebuffer:int, drawFramebuffer:int, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glCheckNamedFramebufferStatus(self, framebuffer:int, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int) -> None: ...
    def glClear(self, mask:int) -> None: ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepth(self, depth:float) -> None: ...
    def glClearDepthf(self, dd:float) -> None: ...
    def glClearNamedBufferData(self, buffer:int, internalformat:int, format:int, type:int, data:int) -> None: ...
    def glClearNamedFramebufferfi(self, framebuffer:int, buffer:int, depth:float, stencil:int) -> None: ...
    def glClearNamedFramebufferfv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearNamedFramebufferiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearNamedFramebufferuiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int) -> None: ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int) -> None: ...
    def glClipControl(self, origin:int, depth:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCompressedTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int) -> None: ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTextureSubImage1D(self, texture:int, level:int, xoffset:int, x:int, y:int, width:int) -> None: ...
    def glCopyTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCopyTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:int) -> None: ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRange(self, nearVal:float, farVal:float) -> None: ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float) -> None: ...
    def glDepthRangef(self, n:float, f:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexArrayAttrib(self, vaobj:int, index:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawBuffer(self, buf:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawTransformFeedback(self, mode:int, id:int) -> None: ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int) -> None: ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int) -> None: ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexArrayAttrib(self, vaobj:int, index:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndConditionalRender(self) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glEndQueryIndexed(self, target:int, index:int) -> None: ...
    def glEndTransformFeedback(self) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGenerateTextureMipmap(self, texture:int) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int) -> None: ...
    def glGetCompressedTextureImage(self, texture:int, level:int, bufSize:int, pixels:int) -> None: ...
    def glGetCompressedTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, bufSize:int, pixels:int) -> None: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int) -> None: ...
    def glGetTextureImage(self, texture:int, level:int, format:int, type:int, bufSize:int, pixels:int) -> None: ...
    def glGetTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, bufSize:int, pixels:int) -> None: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glGetnCompressedTexImage(self, target:int, lod:int, bufSize:int, pixels:int) -> None: ...
    def glGetnTexImage(self, target:int, level:int, format:int, type:int, bufSize:int, pixels:int) -> None: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glInvalidateBufferData(self, buffer:int) -> None: ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateNamedFramebufferData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateNamedFramebufferSubData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glInvalidateTexImage(self, texture:int, level:int) -> None: ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glLogicOp(self, opcode:int) -> None: ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapNamedBuffer(self, buffer:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMemoryBarrierByRegion(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int) -> None: ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int) -> None: ...
    def glNamedBufferData(self, buffer:int, size:int, data:int, usage:int) -> None: ...
    def glNamedBufferStorage(self, buffer:int, size:int, data:int, flags:int) -> None: ...
    def glNamedFramebufferDrawBuffer(self, framebuffer:int, buf:int) -> None: ...
    def glNamedFramebufferDrawBuffers(self, framebuffer:int, n:int, bufs:typing.Sequence) -> None: ...
    def glNamedFramebufferParameteri(self, framebuffer:int, pname:int, param:int) -> None: ...
    def glNamedFramebufferReadBuffer(self, framebuffer:int, src:int) -> None: ...
    def glNamedFramebufferRenderbuffer(self, framebuffer:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glNamedFramebufferTexture(self, framebuffer:int, attachment:int, texture:int, level:int) -> None: ...
    def glNamedFramebufferTextureLayer(self, framebuffer:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glNamedRenderbufferStorage(self, renderbuffer:int, internalformat:int, width:int, height:int) -> None: ...
    def glNamedRenderbufferStorageMultisample(self, renderbuffer:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes) -> None: ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes) -> None: ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPauseTransformFeedback(self) -> None: ...
    def glPixelStoref(self, pname:int, param:float) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPointParameterf(self, pname:int, param:float) -> None: ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointParameteri(self, pname:int, param:int) -> None: ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence) -> None: ...
    def glPointSize(self, size:float) -> None: ...
    def glPolygonMode(self, face:int, mode:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPrimitiveRestartIndex(self, index:int) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1d(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProvokingVertex(self, mode:int) -> None: ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes) -> None: ...
    def glQueryCounter(self, id:int, target:int) -> None: ...
    def glReadBuffer(self, src:int) -> None: ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glReadnPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, bufSize:int, data:int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glResumeTransformFeedback(self) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glSampleMaski(self, maskNumber:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int) -> None: ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence) -> None: ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureBarrier(self) -> None: ...
    def glTextureBuffer(self, texture:int, internalformat:int, buffer:int) -> None: ...
    def glTextureParameterIiv(self, texture:int, pname:int, params:typing.Sequence) -> None: ...
    def glTextureParameterIuiv(self, texture:int, pname:int, params:typing.Sequence) -> None: ...
    def glTextureParameterf(self, texture:int, pname:int, param:float) -> None: ...
    def glTextureParameterfv(self, texture:int, pname:int, param:typing.Sequence) -> None: ...
    def glTextureParameteri(self, texture:int, pname:int, param:int) -> None: ...
    def glTextureParameteriv(self, texture:int, pname:int, param:typing.Sequence) -> None: ...
    def glTextureStorage1D(self, texture:int, levels:int, internalformat:int, width:int) -> None: ...
    def glTextureStorage2D(self, texture:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTextureStorage2DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTextureStorage3D(self, texture:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTextureStorage3DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int) -> None: ...
    def glTransformFeedbackBufferBase(self, xfb:int, index:int, buffer:int) -> None: ...
    def glUniform1d(self, location:int, x:float) -> None: ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1f(self, location:int, v0:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, v0:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2d(self, location:int, x:float, y:float) -> None: ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, v0:float, v1:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3d(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUnmapNamedBuffer(self, buffer:int) -> int: ...
    def glUseProgram(self, program:int) -> None: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertexArrayAttribBinding(self, vaobj:int, attribindex:int, bindingindex:int) -> None: ...
    def glVertexArrayAttribFormat(self, vaobj:int, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexArrayAttribIFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexArrayAttribLFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexArrayBindingDivisor(self, vaobj:int, bindingindex:int, divisor:int) -> None: ...
    def glVertexArrayElementBuffer(self, vaobj:int, buffer:int) -> None: ...
    def glVertexArrayVertexBuffers(self, vaobj:int, first:int, count:int, buffers:typing.Sequence, offsets:typing.Sequence, strides:typing.Sequence) -> None: ...
    def glVertexAttrib1d(self, index:int, x:float) -> None: ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1f(self, index:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib1s(self, index:int, x:int) -> None: ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib2s(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nub(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexAttribI1i(self, index:int, x:int) -> None: ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI1ui(self, index:int, x:int) -> None: ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2i(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int) -> None: ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int) -> None: ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4bv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ubv(self, index:int, v:bytes) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribL1d(self, index:int, x:float) -> None: ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL2d(self, index:int, x:float, y:float) -> None: ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:int, value:int) -> None: ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:int, value:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:int, stride:int, pointer:int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence) -> None: ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float) -> None: ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...

# eof
