# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtGui, except for defaults which are replaced by "...".
"""

# Module PySide2.QtGui
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtCore
import PySide2.QtGui


class QAbstractOpenGLFunctions(Shiboken.Object):

    def __init__(self) -> None: ...

    def initializeOpenGLFunctions(self) -> bool: ...
    def isInitialized(self) -> bool: ...
    def owningContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def setOwningContext(self, context:PySide2.QtGui.QOpenGLContext) -> None: ...


class QAbstractTextDocumentLayout(PySide2.QtCore.QObject):

    class PaintContext(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, PaintContext:PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Selection(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Selection:PySide2.QtGui.QAbstractTextDocumentLayout.Selection) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    def __init__(self, doc:PySide2.QtGui.QTextDocument) -> None: ...

    def anchorAt(self, pos:PySide2.QtCore.QPointF) -> str: ...
    def blockBoundingRect(self, block:PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockWithMarkerAt(self, pos:PySide2.QtCore.QPointF) -> PySide2.QtGui.QTextBlock: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentChanged(self, from_:int, charsRemoved:int, charsAdded:int) -> None: ...
    def documentSize(self) -> PySide2.QtCore.QSizeF: ...
    def draw(self, painter:PySide2.QtGui.QPainter, context:PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...
    def drawInlineObject(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF, object:PySide2.QtGui.QTextInlineObject, posInDocument:int, format:PySide2.QtGui.QTextFormat) -> None: ...
    def format(self, pos:int) -> PySide2.QtGui.QTextCharFormat: ...
    def formatAt(self, pos:PySide2.QtCore.QPointF) -> PySide2.QtGui.QTextFormat: ...
    def formatIndex(self, pos:int) -> int: ...
    def frameBoundingRect(self, frame:PySide2.QtGui.QTextFrame) -> PySide2.QtCore.QRectF: ...
    def handlerForObject(self, objectType:int) -> PySide2.QtGui.QTextObjectInterface: ...
    def hitTest(self, point:PySide2.QtCore.QPointF, accuracy:PySide2.QtCore.Qt.HitTestAccuracy) -> int: ...
    def imageAt(self, pos:PySide2.QtCore.QPointF) -> str: ...
    def pageCount(self) -> int: ...
    def paintDevice(self) -> PySide2.QtGui.QPaintDevice: ...
    def positionInlineObject(self, item:PySide2.QtGui.QTextInlineObject, posInDocument:int, format:PySide2.QtGui.QTextFormat) -> None: ...
    def registerHandler(self, objectType:int, component:PySide2.QtCore.QObject) -> None: ...
    def resizeInlineObject(self, item:PySide2.QtGui.QTextInlineObject, posInDocument:int, format:PySide2.QtGui.QTextFormat) -> None: ...
    def setPaintDevice(self, device:PySide2.QtGui.QPaintDevice) -> None: ...
    def unregisterHandler(self, objectType:int, component:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...


class QAccessible(Shiboken.Object):
    CharBoundary             : QAccessible = ... # 0x0
    Name                     : QAccessible = ... # 0x0
    NoRole                   : QAccessible = ... # 0x0
    TextInterface            : QAccessible = ... # 0x0
    Description              : QAccessible = ... # 0x1
    EditableTextInterface    : QAccessible = ... # 0x1
    Label                    : QAccessible = ... # 0x1
    SoundPlayed              : QAccessible = ... # 0x1
    TitleBar                 : QAccessible = ... # 0x1
    WordBoundary             : QAccessible = ... # 0x1
    Alert                    : QAccessible = ... # 0x2
    Labelled                 : QAccessible = ... # 0x2
    MenuBar                  : QAccessible = ... # 0x2
    SentenceBoundary         : QAccessible = ... # 0x2
    Value                    : QAccessible = ... # 0x2
    ValueInterface           : QAccessible = ... # 0x2
    ActionInterface          : QAccessible = ... # 0x3
    ForegroundChanged        : QAccessible = ... # 0x3
    Help                     : QAccessible = ... # 0x3
    ParagraphBoundary        : QAccessible = ... # 0x3
    ScrollBar                : QAccessible = ... # 0x3
    Accelerator              : QAccessible = ... # 0x4
    Controller               : QAccessible = ... # 0x4
    Grip                     : QAccessible = ... # 0x4
    ImageInterface           : QAccessible = ... # 0x4
    LineBoundary             : QAccessible = ... # 0x4
    MenuStart                : QAccessible = ... # 0x4
    DebugDescription         : QAccessible = ... # 0x5
    MenuEnd                  : QAccessible = ... # 0x5
    NoBoundary               : QAccessible = ... # 0x5
    Sound                    : QAccessible = ... # 0x5
    TableInterface           : QAccessible = ... # 0x5
    Cursor                   : QAccessible = ... # 0x6
    PopupMenuStart           : QAccessible = ... # 0x6
    TableCellInterface       : QAccessible = ... # 0x6
    Caret                    : QAccessible = ... # 0x7
    PopupMenuEnd             : QAccessible = ... # 0x7
    AlertMessage             : QAccessible = ... # 0x8
    Controlled               : QAccessible = ... # 0x8
    Window                   : QAccessible = ... # 0x9
    Client                   : QAccessible = ... # 0xa
    PopupMenu                : QAccessible = ... # 0xb
    ContextHelpStart         : QAccessible = ... # 0xc
    MenuItem                 : QAccessible = ... # 0xc
    ContextHelpEnd           : QAccessible = ... # 0xd
    ToolTip                  : QAccessible = ... # 0xd
    Application              : QAccessible = ... # 0xe
    DragDropStart            : QAccessible = ... # 0xe
    Document                 : QAccessible = ... # 0xf
    DragDropEnd              : QAccessible = ... # 0xf
    DialogStart              : QAccessible = ... # 0x10
    Pane                     : QAccessible = ... # 0x10
    Chart                    : QAccessible = ... # 0x11
    DialogEnd                : QAccessible = ... # 0x11
    Dialog                   : QAccessible = ... # 0x12
    ScrollingStart           : QAccessible = ... # 0x12
    Border                   : QAccessible = ... # 0x13
    ScrollingEnd             : QAccessible = ... # 0x13
    Grouping                 : QAccessible = ... # 0x14
    Separator                : QAccessible = ... # 0x15
    ToolBar                  : QAccessible = ... # 0x16
    StatusBar                : QAccessible = ... # 0x17
    MenuCommand              : QAccessible = ... # 0x18
    Table                    : QAccessible = ... # 0x18
    ColumnHeader             : QAccessible = ... # 0x19
    RowHeader                : QAccessible = ... # 0x1a
    Column                   : QAccessible = ... # 0x1b
    Row                      : QAccessible = ... # 0x1c
    Cell                     : QAccessible = ... # 0x1d
    Link                     : QAccessible = ... # 0x1e
    HelpBalloon              : QAccessible = ... # 0x1f
    Assistant                : QAccessible = ... # 0x20
    List                     : QAccessible = ... # 0x21
    ListItem                 : QAccessible = ... # 0x22
    Tree                     : QAccessible = ... # 0x23
    TreeItem                 : QAccessible = ... # 0x24
    PageTab                  : QAccessible = ... # 0x25
    PropertyPage             : QAccessible = ... # 0x26
    Indicator                : QAccessible = ... # 0x27
    Graphic                  : QAccessible = ... # 0x28
    StaticText               : QAccessible = ... # 0x29
    EditableText             : QAccessible = ... # 0x2a
    Button                   : QAccessible = ... # 0x2b
    PushButton               : QAccessible = ... # 0x2b
    CheckBox                 : QAccessible = ... # 0x2c
    RadioButton              : QAccessible = ... # 0x2d
    ComboBox                 : QAccessible = ... # 0x2e
    ProgressBar              : QAccessible = ... # 0x30
    Dial                     : QAccessible = ... # 0x31
    HotkeyField              : QAccessible = ... # 0x32
    Slider                   : QAccessible = ... # 0x33
    SpinBox                  : QAccessible = ... # 0x34
    Canvas                   : QAccessible = ... # 0x35
    Animation                : QAccessible = ... # 0x36
    Equation                 : QAccessible = ... # 0x37
    ButtonDropDown           : QAccessible = ... # 0x38
    ButtonMenu               : QAccessible = ... # 0x39
    ButtonDropGrid           : QAccessible = ... # 0x3a
    Whitespace               : QAccessible = ... # 0x3b
    PageTabList              : QAccessible = ... # 0x3c
    Clock                    : QAccessible = ... # 0x3d
    Splitter                 : QAccessible = ... # 0x3e
    LayeredPane              : QAccessible = ... # 0x80
    Terminal                 : QAccessible = ... # 0x81
    Desktop                  : QAccessible = ... # 0x82
    Paragraph                : QAccessible = ... # 0x83
    WebDocument              : QAccessible = ... # 0x84
    Section                  : QAccessible = ... # 0x85
    Notification             : QAccessible = ... # 0x86
    ActionChanged            : QAccessible = ... # 0x101
    ActiveDescendantChanged  : QAccessible = ... # 0x102
    AttributeChanged         : QAccessible = ... # 0x103
    DocumentContentChanged   : QAccessible = ... # 0x104
    DocumentLoadComplete     : QAccessible = ... # 0x105
    DocumentLoadStopped      : QAccessible = ... # 0x106
    DocumentReload           : QAccessible = ... # 0x107
    HyperlinkEndIndexChanged : QAccessible = ... # 0x108
    HyperlinkNumberOfAnchorsChanged: QAccessible = ... # 0x109
    HyperlinkSelectedLinkChanged: QAccessible = ... # 0x10a
    HypertextLinkActivated   : QAccessible = ... # 0x10b
    HypertextLinkSelected    : QAccessible = ... # 0x10c
    HyperlinkStartIndexChanged: QAccessible = ... # 0x10d
    HypertextChanged         : QAccessible = ... # 0x10e
    HypertextNLinksChanged   : QAccessible = ... # 0x10f
    ObjectAttributeChanged   : QAccessible = ... # 0x110
    PageChanged              : QAccessible = ... # 0x111
    SectionChanged           : QAccessible = ... # 0x112
    TableCaptionChanged      : QAccessible = ... # 0x113
    TableColumnDescriptionChanged: QAccessible = ... # 0x114
    TableColumnHeaderChanged : QAccessible = ... # 0x115
    TableModelChanged        : QAccessible = ... # 0x116
    TableRowDescriptionChanged: QAccessible = ... # 0x117
    TableRowHeaderChanged    : QAccessible = ... # 0x118
    TableSummaryChanged      : QAccessible = ... # 0x119
    TextAttributeChanged     : QAccessible = ... # 0x11a
    TextCaretMoved           : QAccessible = ... # 0x11b
    TextColumnChanged        : QAccessible = ... # 0x11d
    TextInserted             : QAccessible = ... # 0x11e
    TextRemoved              : QAccessible = ... # 0x11f
    TextUpdated              : QAccessible = ... # 0x120
    TextSelectionChanged     : QAccessible = ... # 0x121
    VisibleDataChanged       : QAccessible = ... # 0x122
    ColorChooser             : QAccessible = ... # 0x404
    Footer                   : QAccessible = ... # 0x40e
    Form                     : QAccessible = ... # 0x410
    Heading                  : QAccessible = ... # 0x414
    Note                     : QAccessible = ... # 0x41b
    ComplementaryContent     : QAccessible = ... # 0x42c
    ObjectCreated            : QAccessible = ... # 0x8000
    ObjectDestroyed          : QAccessible = ... # 0x8001
    ObjectShow               : QAccessible = ... # 0x8002
    ObjectHide               : QAccessible = ... # 0x8003
    ObjectReorder            : QAccessible = ... # 0x8004
    Focus                    : QAccessible = ... # 0x8005
    Selection                : QAccessible = ... # 0x8006
    SelectionAdd             : QAccessible = ... # 0x8007
    SelectionRemove          : QAccessible = ... # 0x8008
    SelectionWithin          : QAccessible = ... # 0x8009
    StateChanged             : QAccessible = ... # 0x800a
    LocationChanged          : QAccessible = ... # 0x800b
    NameChanged              : QAccessible = ... # 0x800c
    DescriptionChanged       : QAccessible = ... # 0x800d
    ValueChanged             : QAccessible = ... # 0x800e
    ParentChanged            : QAccessible = ... # 0x800f
    HelpChanged              : QAccessible = ... # 0x80a0
    DefaultActionChanged     : QAccessible = ... # 0x80b0
    AcceleratorChanged       : QAccessible = ... # 0x80c0
    InvalidEvent             : QAccessible = ... # 0x80c1
    UserRole                 : QAccessible = ... # 0xffff
    UserText                 : QAccessible = ... # 0xffff
    AllRelations             : QAccessible = ... # -0x1

    class Event(object):
        SoundPlayed              : QAccessible.Event = ... # 0x1
        Alert                    : QAccessible.Event = ... # 0x2
        ForegroundChanged        : QAccessible.Event = ... # 0x3
        MenuStart                : QAccessible.Event = ... # 0x4
        MenuEnd                  : QAccessible.Event = ... # 0x5
        PopupMenuStart           : QAccessible.Event = ... # 0x6
        PopupMenuEnd             : QAccessible.Event = ... # 0x7
        ContextHelpStart         : QAccessible.Event = ... # 0xc
        ContextHelpEnd           : QAccessible.Event = ... # 0xd
        DragDropStart            : QAccessible.Event = ... # 0xe
        DragDropEnd              : QAccessible.Event = ... # 0xf
        DialogStart              : QAccessible.Event = ... # 0x10
        DialogEnd                : QAccessible.Event = ... # 0x11
        ScrollingStart           : QAccessible.Event = ... # 0x12
        ScrollingEnd             : QAccessible.Event = ... # 0x13
        MenuCommand              : QAccessible.Event = ... # 0x18
        ActionChanged            : QAccessible.Event = ... # 0x101
        ActiveDescendantChanged  : QAccessible.Event = ... # 0x102
        AttributeChanged         : QAccessible.Event = ... # 0x103
        DocumentContentChanged   : QAccessible.Event = ... # 0x104
        DocumentLoadComplete     : QAccessible.Event = ... # 0x105
        DocumentLoadStopped      : QAccessible.Event = ... # 0x106
        DocumentReload           : QAccessible.Event = ... # 0x107
        HyperlinkEndIndexChanged : QAccessible.Event = ... # 0x108
        HyperlinkNumberOfAnchorsChanged: QAccessible.Event = ... # 0x109
        HyperlinkSelectedLinkChanged: QAccessible.Event = ... # 0x10a
        HypertextLinkActivated   : QAccessible.Event = ... # 0x10b
        HypertextLinkSelected    : QAccessible.Event = ... # 0x10c
        HyperlinkStartIndexChanged: QAccessible.Event = ... # 0x10d
        HypertextChanged         : QAccessible.Event = ... # 0x10e
        HypertextNLinksChanged   : QAccessible.Event = ... # 0x10f
        ObjectAttributeChanged   : QAccessible.Event = ... # 0x110
        PageChanged              : QAccessible.Event = ... # 0x111
        SectionChanged           : QAccessible.Event = ... # 0x112
        TableCaptionChanged      : QAccessible.Event = ... # 0x113
        TableColumnDescriptionChanged: QAccessible.Event = ... # 0x114
        TableColumnHeaderChanged : QAccessible.Event = ... # 0x115
        TableModelChanged        : QAccessible.Event = ... # 0x116
        TableRowDescriptionChanged: QAccessible.Event = ... # 0x117
        TableRowHeaderChanged    : QAccessible.Event = ... # 0x118
        TableSummaryChanged      : QAccessible.Event = ... # 0x119
        TextAttributeChanged     : QAccessible.Event = ... # 0x11a
        TextCaretMoved           : QAccessible.Event = ... # 0x11b
        TextColumnChanged        : QAccessible.Event = ... # 0x11d
        TextInserted             : QAccessible.Event = ... # 0x11e
        TextRemoved              : QAccessible.Event = ... # 0x11f
        TextUpdated              : QAccessible.Event = ... # 0x120
        TextSelectionChanged     : QAccessible.Event = ... # 0x121
        VisibleDataChanged       : QAccessible.Event = ... # 0x122
        ObjectCreated            : QAccessible.Event = ... # 0x8000
        ObjectDestroyed          : QAccessible.Event = ... # 0x8001
        ObjectShow               : QAccessible.Event = ... # 0x8002
        ObjectHide               : QAccessible.Event = ... # 0x8003
        ObjectReorder            : QAccessible.Event = ... # 0x8004
        Focus                    : QAccessible.Event = ... # 0x8005
        Selection                : QAccessible.Event = ... # 0x8006
        SelectionAdd             : QAccessible.Event = ... # 0x8007
        SelectionRemove          : QAccessible.Event = ... # 0x8008
        SelectionWithin          : QAccessible.Event = ... # 0x8009
        StateChanged             : QAccessible.Event = ... # 0x800a
        LocationChanged          : QAccessible.Event = ... # 0x800b
        NameChanged              : QAccessible.Event = ... # 0x800c
        DescriptionChanged       : QAccessible.Event = ... # 0x800d
        ValueChanged             : QAccessible.Event = ... # 0x800e
        ParentChanged            : QAccessible.Event = ... # 0x800f
        HelpChanged              : QAccessible.Event = ... # 0x80a0
        DefaultActionChanged     : QAccessible.Event = ... # 0x80b0
        AcceleratorChanged       : QAccessible.Event = ... # 0x80c0
        InvalidEvent             : QAccessible.Event = ... # 0x80c1

    class InterfaceType(object):
        TextInterface            : QAccessible.InterfaceType = ... # 0x0
        EditableTextInterface    : QAccessible.InterfaceType = ... # 0x1
        ValueInterface           : QAccessible.InterfaceType = ... # 0x2
        ActionInterface          : QAccessible.InterfaceType = ... # 0x3
        ImageInterface           : QAccessible.InterfaceType = ... # 0x4
        TableInterface           : QAccessible.InterfaceType = ... # 0x5
        TableCellInterface       : QAccessible.InterfaceType = ... # 0x6

    class Relation(object): ...

    class RelationFlag(object):
        Label                    : QAccessible.RelationFlag = ... # 0x1
        Labelled                 : QAccessible.RelationFlag = ... # 0x2
        Controller               : QAccessible.RelationFlag = ... # 0x4
        Controlled               : QAccessible.RelationFlag = ... # 0x8
        AllRelations             : QAccessible.RelationFlag = ... # -0x1

    class Role(object):
        NoRole                   : QAccessible.Role = ... # 0x0
        TitleBar                 : QAccessible.Role = ... # 0x1
        MenuBar                  : QAccessible.Role = ... # 0x2
        ScrollBar                : QAccessible.Role = ... # 0x3
        Grip                     : QAccessible.Role = ... # 0x4
        Sound                    : QAccessible.Role = ... # 0x5
        Cursor                   : QAccessible.Role = ... # 0x6
        Caret                    : QAccessible.Role = ... # 0x7
        AlertMessage             : QAccessible.Role = ... # 0x8
        Window                   : QAccessible.Role = ... # 0x9
        Client                   : QAccessible.Role = ... # 0xa
        PopupMenu                : QAccessible.Role = ... # 0xb
        MenuItem                 : QAccessible.Role = ... # 0xc
        ToolTip                  : QAccessible.Role = ... # 0xd
        Application              : QAccessible.Role = ... # 0xe
        Document                 : QAccessible.Role = ... # 0xf
        Pane                     : QAccessible.Role = ... # 0x10
        Chart                    : QAccessible.Role = ... # 0x11
        Dialog                   : QAccessible.Role = ... # 0x12
        Border                   : QAccessible.Role = ... # 0x13
        Grouping                 : QAccessible.Role = ... # 0x14
        Separator                : QAccessible.Role = ... # 0x15
        ToolBar                  : QAccessible.Role = ... # 0x16
        StatusBar                : QAccessible.Role = ... # 0x17
        Table                    : QAccessible.Role = ... # 0x18
        ColumnHeader             : QAccessible.Role = ... # 0x19
        RowHeader                : QAccessible.Role = ... # 0x1a
        Column                   : QAccessible.Role = ... # 0x1b
        Row                      : QAccessible.Role = ... # 0x1c
        Cell                     : QAccessible.Role = ... # 0x1d
        Link                     : QAccessible.Role = ... # 0x1e
        HelpBalloon              : QAccessible.Role = ... # 0x1f
        Assistant                : QAccessible.Role = ... # 0x20
        List                     : QAccessible.Role = ... # 0x21
        ListItem                 : QAccessible.Role = ... # 0x22
        Tree                     : QAccessible.Role = ... # 0x23
        TreeItem                 : QAccessible.Role = ... # 0x24
        PageTab                  : QAccessible.Role = ... # 0x25
        PropertyPage             : QAccessible.Role = ... # 0x26
        Indicator                : QAccessible.Role = ... # 0x27
        Graphic                  : QAccessible.Role = ... # 0x28
        StaticText               : QAccessible.Role = ... # 0x29
        EditableText             : QAccessible.Role = ... # 0x2a
        Button                   : QAccessible.Role = ... # 0x2b
        PushButton               : QAccessible.Role = ... # 0x2b
        CheckBox                 : QAccessible.Role = ... # 0x2c
        RadioButton              : QAccessible.Role = ... # 0x2d
        ComboBox                 : QAccessible.Role = ... # 0x2e
        ProgressBar              : QAccessible.Role = ... # 0x30
        Dial                     : QAccessible.Role = ... # 0x31
        HotkeyField              : QAccessible.Role = ... # 0x32
        Slider                   : QAccessible.Role = ... # 0x33
        SpinBox                  : QAccessible.Role = ... # 0x34
        Canvas                   : QAccessible.Role = ... # 0x35
        Animation                : QAccessible.Role = ... # 0x36
        Equation                 : QAccessible.Role = ... # 0x37
        ButtonDropDown           : QAccessible.Role = ... # 0x38
        ButtonMenu               : QAccessible.Role = ... # 0x39
        ButtonDropGrid           : QAccessible.Role = ... # 0x3a
        Whitespace               : QAccessible.Role = ... # 0x3b
        PageTabList              : QAccessible.Role = ... # 0x3c
        Clock                    : QAccessible.Role = ... # 0x3d
        Splitter                 : QAccessible.Role = ... # 0x3e
        LayeredPane              : QAccessible.Role = ... # 0x80
        Terminal                 : QAccessible.Role = ... # 0x81
        Desktop                  : QAccessible.Role = ... # 0x82
        Paragraph                : QAccessible.Role = ... # 0x83
        WebDocument              : QAccessible.Role = ... # 0x84
        Section                  : QAccessible.Role = ... # 0x85
        Notification             : QAccessible.Role = ... # 0x86
        ColorChooser             : QAccessible.Role = ... # 0x404
        Footer                   : QAccessible.Role = ... # 0x40e
        Form                     : QAccessible.Role = ... # 0x410
        Heading                  : QAccessible.Role = ... # 0x414
        Note                     : QAccessible.Role = ... # 0x41b
        ComplementaryContent     : QAccessible.Role = ... # 0x42c
        UserRole                 : QAccessible.Role = ... # 0xffff

    class State(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, State:PySide2.QtGui.QAccessible.State) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class Text(object):
        Name                     : QAccessible.Text = ... # 0x0
        Description              : QAccessible.Text = ... # 0x1
        Value                    : QAccessible.Text = ... # 0x2
        Help                     : QAccessible.Text = ... # 0x3
        Accelerator              : QAccessible.Text = ... # 0x4
        DebugDescription         : QAccessible.Text = ... # 0x5
        UserText                 : QAccessible.Text = ... # 0xffff

    class TextBoundaryType(object):
        CharBoundary             : QAccessible.TextBoundaryType = ... # 0x0
        WordBoundary             : QAccessible.TextBoundaryType = ... # 0x1
        SentenceBoundary         : QAccessible.TextBoundaryType = ... # 0x2
        ParagraphBoundary        : QAccessible.TextBoundaryType = ... # 0x3
        LineBoundary             : QAccessible.TextBoundaryType = ... # 0x4
        NoBoundary               : QAccessible.TextBoundaryType = ... # 0x5
    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def accessibleInterface(uniqueId:int) -> PySide2.QtGui.QAccessibleInterface: ...
    @staticmethod
    def cleanup() -> None: ...
    @staticmethod
    def deleteAccessibleInterface(uniqueId:int) -> None: ...
    @staticmethod
    def isActive() -> bool: ...
    @staticmethod
    def qAccessibleTextBoundaryHelper(cursor:PySide2.QtGui.QTextCursor, boundaryType:PySide2.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple: ...
    @staticmethod
    def queryAccessibleInterface(arg__1:PySide2.QtCore.QObject) -> PySide2.QtGui.QAccessibleInterface: ...
    @staticmethod
    def registerAccessibleInterface(iface:PySide2.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def setActive(active:bool) -> None: ...
    @staticmethod
    def setRootObject(object:PySide2.QtCore.QObject) -> None: ...
    @staticmethod
    def uniqueId(iface:PySide2.QtGui.QAccessibleInterface) -> int: ...
    @staticmethod
    def updateAccessibility(event:PySide2.QtGui.QAccessibleEvent) -> None: ...


class QAccessibleEditableTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def deleteText(self, startOffset:int, endOffset:int) -> None: ...
    def insertText(self, offset:int, text:str) -> None: ...
    def replaceText(self, startOffset:int, endOffset:int, text:str) -> None: ...


class QAccessibleEvent(Shiboken.Object):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, typ:PySide2.QtGui.QAccessible.Event) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, typ:PySide2.QtGui.QAccessible.Event) -> None: ...

    def accessibleInterface(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def child(self) -> int: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def setChild(self, chld:int) -> None: ...
    def type(self) -> PySide2.QtGui.QAccessible.Event: ...
    def uniqueId(self) -> int: ...


class QAccessibleInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def child(self, index:int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childAt(self, x:int, y:int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def editableTextInterface(self) -> PySide2.QtGui.QAccessibleEditableTextInterface: ...
    def focusChild(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide2.QtGui.QColor: ...
    def indexOfChild(self, arg__1:PySide2.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, arg__1:PySide2.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def parent(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def relations(self, match:PySide2.QtGui.QAccessible.Relation=...) -> typing.List: ...
    def role(self) -> PySide2.QtGui.QAccessible.Role: ...
    def setText(self, t:PySide2.QtGui.QAccessible.Text, text:str) -> None: ...
    def state(self) -> PySide2.QtGui.QAccessible.State: ...
    def tableCellInterface(self) -> PySide2.QtGui.QAccessibleTableCellInterface: ...
    def text(self, t:PySide2.QtGui.QAccessible.Text) -> str: ...
    def textInterface(self) -> PySide2.QtGui.QAccessibleTextInterface: ...
    def valueInterface(self) -> PySide2.QtGui.QAccessibleValueInterface: ...
    def virtual_hook(self, id:int, data:int) -> None: ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QAccessibleObject(PySide2.QtGui.QAccessibleInterface):

    def __init__(self, object:PySide2.QtCore.QObject) -> None: ...

    def childAt(self, x:int, y:int) -> PySide2.QtGui.QAccessibleInterface: ...
    def isValid(self) -> bool: ...
    def object(self) -> PySide2.QtCore.QObject: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def setText(self, t:PySide2.QtGui.QAccessible.Text, text:str) -> None: ...


class QAccessibleStateChangeEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, state:PySide2.QtGui.QAccessible.State) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, state:PySide2.QtGui.QAccessible.State) -> None: ...

    def changedStates(self) -> PySide2.QtGui.QAccessible.State: ...


class QAccessibleTableCellInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def columnExtent(self) -> int: ...
    def columnHeaderCells(self) -> typing.List: ...
    def columnIndex(self) -> int: ...
    def isSelected(self) -> bool: ...
    def rowExtent(self) -> int: ...
    def rowHeaderCells(self) -> typing.List: ...
    def rowIndex(self) -> int: ...
    def table(self) -> PySide2.QtGui.QAccessibleInterface: ...


class QAccessibleTableModelChangeEvent(PySide2.QtGui.QAccessibleEvent):
    ModelReset               : QAccessibleTableModelChangeEvent = ... # 0x0
    DataChanged              : QAccessibleTableModelChangeEvent = ... # 0x1
    RowsInserted             : QAccessibleTableModelChangeEvent = ... # 0x2
    ColumnsInserted          : QAccessibleTableModelChangeEvent = ... # 0x3
    RowsRemoved              : QAccessibleTableModelChangeEvent = ... # 0x4
    ColumnsRemoved           : QAccessibleTableModelChangeEvent = ... # 0x5

    class ModelChangeType(object):
        ModelReset               : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x0
        DataChanged              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x1
        RowsInserted             : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x2
        ColumnsInserted          : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x3
        RowsRemoved              : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x4
        ColumnsRemoved           : QAccessibleTableModelChangeEvent.ModelChangeType = ... # 0x5

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, changeType:PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, changeType:PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...

    def firstColumn(self) -> int: ...
    def firstRow(self) -> int: ...
    def lastColumn(self) -> int: ...
    def lastRow(self) -> int: ...
    def modelChangeType(self) -> PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType: ...
    def setFirstColumn(self, col:int) -> None: ...
    def setFirstRow(self, row:int) -> None: ...
    def setLastColumn(self, col:int) -> None: ...
    def setLastRow(self, row:int) -> None: ...
    def setModelChangeType(self, changeType:PySide2.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType) -> None: ...


class QAccessibleTextCursorEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, cursorPos:int) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, cursorPos:int) -> None: ...

    def cursorPosition(self) -> int: ...
    def setCursorPosition(self, position:int) -> None: ...


class QAccessibleTextInsertEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, position:int, text:str) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, position:int, text:str) -> None: ...

    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...


class QAccessibleTextInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def addSelection(self, startOffset:int, endOffset:int) -> None: ...
    def attributes(self, offset:int) -> typing.Tuple: ...
    def characterCount(self) -> int: ...
    def characterRect(self, offset:int) -> PySide2.QtCore.QRect: ...
    def cursorPosition(self) -> int: ...
    def offsetAtPoint(self, point:PySide2.QtCore.QPoint) -> int: ...
    def removeSelection(self, selectionIndex:int) -> None: ...
    def scrollToSubstring(self, startIndex:int, endIndex:int) -> None: ...
    def selection(self, selectionIndex:int) -> typing.Tuple: ...
    def selectionCount(self) -> int: ...
    def setCursorPosition(self, position:int) -> None: ...
    def setSelection(self, selectionIndex:int, startOffset:int, endOffset:int) -> None: ...
    def text(self, startOffset:int, endOffset:int) -> str: ...
    def textAfterOffset(self, offset:int, boundaryType:PySide2.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple: ...
    def textAtOffset(self, offset:int, boundaryType:PySide2.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple: ...
    def textBeforeOffset(self, offset:int, boundaryType:PySide2.QtGui.QAccessible.TextBoundaryType) -> typing.Tuple: ...


class QAccessibleTextRemoveEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, position:int, text:str) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, position:int, text:str) -> None: ...

    def changePosition(self) -> int: ...
    def textRemoved(self) -> str: ...


class QAccessibleTextSelectionEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, start:int, end:int) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, start:int, end:int) -> None: ...

    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setSelection(self, start:int, end:int) -> None: ...


class QAccessibleTextUpdateEvent(PySide2.QtGui.QAccessibleTextCursorEvent):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, position:int, oldText:str, text:str) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, position:int, oldText:str, text:str) -> None: ...

    def changePosition(self) -> int: ...
    def textInserted(self) -> str: ...
    def textRemoved(self) -> str: ...


class QAccessibleValueChangeEvent(PySide2.QtGui.QAccessibleEvent):

    @typing.overload
    def __init__(self, iface:PySide2.QtGui.QAccessibleInterface, val:typing.Any) -> None: ...
    @typing.overload
    def __init__(self, obj:PySide2.QtCore.QObject, val:typing.Any) -> None: ...

    def setValue(self, val:typing.Any) -> None: ...
    def value(self) -> typing.Any: ...


class QAccessibleValueInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def currentValue(self) -> typing.Any: ...
    def maximumValue(self) -> typing.Any: ...
    def minimumStepSize(self) -> typing.Any: ...
    def minimumValue(self) -> typing.Any: ...
    def setCurrentValue(self, value:typing.Any) -> None: ...


class QActionEvent(PySide2.QtCore.QEvent): ...


class QBackingStore(Shiboken.Object):

    def __init__(self, window:PySide2.QtGui.QWindow) -> None: ...

    def beginPaint(self, arg__1:PySide2.QtGui.QRegion) -> None: ...
    def endPaint(self) -> None: ...
    def flush(self, region:PySide2.QtGui.QRegion, window:typing.Optional[PySide2.QtGui.QWindow]=..., offset:PySide2.QtCore.QPoint=...) -> None: ...
    def hasStaticContents(self) -> bool: ...
    def paintDevice(self) -> PySide2.QtGui.QPaintDevice: ...
    def resize(self, size:PySide2.QtCore.QSize) -> None: ...
    def scroll(self, area:PySide2.QtGui.QRegion, dx:int, dy:int) -> bool: ...
    def setStaticContents(self, region:PySide2.QtGui.QRegion) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def staticContents(self) -> PySide2.QtGui.QRegion: ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QBitmap(PySide2.QtGui.QPixmap):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:typing.Optional[bytes]=...) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QBitmap) -> None: ...
    @typing.overload
    def __init__(self, w:int, h:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    @staticmethod
    def fromData(size:PySide2.QtCore.QSize, bits:bytes, monoFormat:PySide2.QtGui.QImage.Format=...) -> PySide2.QtGui.QBitmap: ...
    @typing.overload
    @staticmethod
    def fromImage(image:PySide2.QtGui.QImage, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QBitmap: ...
    @typing.overload
    @staticmethod
    def fromImage(image:PySide2.QtGui.QImage, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def swap(self, other:PySide2.QtGui.QBitmap) -> None: ...
    @typing.overload
    def swap(self, other:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def transformed(self, arg__1:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QBitmap: ...
    @typing.overload
    def transformed(self, arg__1:PySide2.QtGui.QMatrix, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def transformed(self, matrix:PySide2.QtGui.QTransform) -> PySide2.QtGui.QBitmap: ...


class QBrush(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, brush:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def __init__(self, bs:PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def __init__(self, color:PySide2.QtCore.Qt.GlobalColor, bs:PySide2.QtCore.Qt.BrushStyle=...) -> None: ...
    @typing.overload
    def __init__(self, color:PySide2.QtCore.Qt.GlobalColor, pixmap:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, color:PySide2.QtGui.QColor, bs:PySide2.QtCore.Qt.BrushStyle=...) -> None: ...
    @typing.overload
    def __init__(self, color:PySide2.QtGui.QColor, pixmap:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, gradient:PySide2.QtGui.QGradient) -> None: ...
    @typing.overload
    def __init__(self, image:PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, pixmap:PySide2.QtGui.QPixmap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def gradient(self) -> PySide2.QtGui.QGradient: ...
    def isOpaque(self) -> bool: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    def setColor(self, color:PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def setColor(self, color:PySide2.QtGui.QColor) -> None: ...
    def setMatrix(self, mat:PySide2.QtGui.QMatrix) -> None: ...
    def setStyle(self, arg__1:PySide2.QtCore.Qt.BrushStyle) -> None: ...
    def setTexture(self, pixmap:PySide2.QtGui.QPixmap) -> None: ...
    def setTextureImage(self, image:PySide2.QtGui.QImage) -> None: ...
    def setTransform(self, arg__1:PySide2.QtGui.QTransform) -> None: ...
    def style(self) -> PySide2.QtCore.Qt.BrushStyle: ...
    def swap(self, other:PySide2.QtGui.QBrush) -> None: ...
    def texture(self) -> PySide2.QtGui.QPixmap: ...
    def textureImage(self) -> PySide2.QtGui.QImage: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...


class QClipboard(PySide2.QtCore.QObject):
    Clipboard                : QClipboard = ... # 0x0
    Selection                : QClipboard = ... # 0x1
    FindBuffer               : QClipboard = ... # 0x2
    LastMode                 : QClipboard = ... # 0x2

    class Mode(object):
        Clipboard                : QClipboard.Mode = ... # 0x0
        Selection                : QClipboard.Mode = ... # 0x1
        FindBuffer               : QClipboard.Mode = ... # 0x2
        LastMode                 : QClipboard.Mode = ... # 0x2
    def clear(self, mode:PySide2.QtGui.QClipboard.Mode=...) -> None: ...
    def image(self, mode:PySide2.QtGui.QClipboard.Mode=...) -> PySide2.QtGui.QImage: ...
    def mimeData(self, mode:PySide2.QtGui.QClipboard.Mode=...) -> PySide2.QtCore.QMimeData: ...
    def ownsClipboard(self) -> bool: ...
    def ownsFindBuffer(self) -> bool: ...
    def ownsSelection(self) -> bool: ...
    def pixmap(self, mode:PySide2.QtGui.QClipboard.Mode=...) -> PySide2.QtGui.QPixmap: ...
    def setImage(self, arg__1:PySide2.QtGui.QImage, mode:PySide2.QtGui.QClipboard.Mode=...) -> None: ...
    def setMimeData(self, data:PySide2.QtCore.QMimeData, mode:PySide2.QtGui.QClipboard.Mode=...) -> None: ...
    def setPixmap(self, arg__1:PySide2.QtGui.QPixmap, mode:PySide2.QtGui.QClipboard.Mode=...) -> None: ...
    def setText(self, arg__1:str, mode:PySide2.QtGui.QClipboard.Mode=...) -> None: ...
    def supportsFindBuffer(self) -> bool: ...
    def supportsSelection(self) -> bool: ...
    @typing.overload
    def text(self, mode:PySide2.QtGui.QClipboard.Mode=...) -> str: ...
    @typing.overload
    def text(self, subtype:str, mode:PySide2.QtGui.QClipboard.Mode=...) -> str: ...


class QCloseEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QColor(Shiboken.Object):
    HexRgb                   : QColor = ... # 0x0
    Invalid                  : QColor = ... # 0x0
    HexArgb                  : QColor = ... # 0x1
    Rgb                      : QColor = ... # 0x1
    Hsv                      : QColor = ... # 0x2
    Cmyk                     : QColor = ... # 0x3
    Hsl                      : QColor = ... # 0x4
    ExtendedRgb              : QColor = ... # 0x5

    class NameFormat(object):
        HexRgb                   : QColor.NameFormat = ... # 0x0
        HexArgb                  : QColor.NameFormat = ... # 0x1

    class Spec(object):
        Invalid                  : QColor.Spec = ... # 0x0
        Rgb                      : QColor.Spec = ... # 0x1
        Hsv                      : QColor.Spec = ... # 0x2
        Cmyk                     : QColor.Spec = ... # 0x3
        Hsl                      : QColor.Spec = ... # 0x4
        ExtendedRgb              : QColor.Spec = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Any) -> None: ...
    @typing.overload
    def __init__(self, color:PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, name:str) -> None: ...
    @typing.overload
    def __init__(self, r:int, g:int, b:int, a:int=...) -> None: ...
    @typing.overload
    def __init__(self, rgb:int) -> None: ...
    @typing.overload
    def __init__(self, spec:PySide2.QtGui.QColor.Spec, a1:int, a2:int, a3:int, a4:int, a5:int=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __setstate__(self, arg__1:object) -> object: ...
    def __str__(self) -> object: ...
    def alpha(self) -> int: ...
    def alphaF(self) -> float: ...
    def black(self) -> int: ...
    def blackF(self) -> float: ...
    def blue(self) -> int: ...
    def blueF(self) -> float: ...
    @staticmethod
    def colorNames() -> typing.List: ...
    def convertTo(self, colorSpec:PySide2.QtGui.QColor.Spec) -> PySide2.QtGui.QColor: ...
    def cyan(self) -> int: ...
    def cyanF(self) -> float: ...
    def dark(self, f:int=...) -> PySide2.QtGui.QColor: ...
    def darker(self, f:int=...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromCmyk(c:int, m:int, y:int, k:int, a:int=...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromCmykF(c:float, m:float, y:float, k:float, a:float=...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHsl(h:int, s:int, l:int, a:int=...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHslF(h:float, s:float, l:float, a:float=...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHsv(h:int, s:int, v:int, a:int=...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromHsvF(h:float, s:float, v:float, a:float=...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgb(r:int, g:int, b:int, a:int=...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def fromRgb(rgb:int) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromRgbF(r:float, g:float, b:float, a:float=...) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromRgba(rgba:int) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def fromRgba64(r:int, g:int, b:int, a:int=...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def getCmyk(self) -> typing.Tuple: ...
    @typing.overload
    def getCmyk(self) -> typing.Tuple: ...
    @typing.overload
    def getCmykF(self) -> typing.Tuple: ...
    @typing.overload
    def getCmykF(self) -> typing.Tuple: ...
    def getHsl(self) -> typing.Tuple: ...
    def getHslF(self) -> typing.Tuple: ...
    def getHsv(self) -> typing.Tuple: ...
    def getHsvF(self) -> typing.Tuple: ...
    def getRgb(self) -> typing.Tuple: ...
    def getRgbF(self) -> typing.Tuple: ...
    def green(self) -> int: ...
    def greenF(self) -> float: ...
    def hslHue(self) -> int: ...
    def hslHueF(self) -> float: ...
    def hslSaturation(self) -> int: ...
    def hslSaturationF(self) -> float: ...
    def hsvHue(self) -> int: ...
    def hsvHueF(self) -> float: ...
    def hsvSaturation(self) -> int: ...
    def hsvSaturationF(self) -> float: ...
    def hue(self) -> int: ...
    def hueF(self) -> float: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def isValidColor(name:str) -> bool: ...
    def light(self, f:int=...) -> PySide2.QtGui.QColor: ...
    def lighter(self, f:int=...) -> PySide2.QtGui.QColor: ...
    def lightness(self) -> int: ...
    def lightnessF(self) -> float: ...
    def magenta(self) -> int: ...
    def magentaF(self) -> float: ...
    @typing.overload
    def name(self) -> str: ...
    @typing.overload
    def name(self, format:PySide2.QtGui.QColor.NameFormat) -> str: ...
    def red(self) -> int: ...
    def redF(self) -> float: ...
    def rgb(self) -> int: ...
    def rgba(self) -> int: ...
    def saturation(self) -> int: ...
    def saturationF(self) -> float: ...
    def setAlpha(self, alpha:int) -> None: ...
    def setAlphaF(self, alpha:float) -> None: ...
    def setBlue(self, blue:int) -> None: ...
    def setBlueF(self, blue:float) -> None: ...
    def setCmyk(self, c:int, m:int, y:int, k:int, a:int=...) -> None: ...
    def setCmykF(self, c:float, m:float, y:float, k:float, a:float=...) -> None: ...
    def setGreen(self, green:int) -> None: ...
    def setGreenF(self, green:float) -> None: ...
    def setHsl(self, h:int, s:int, l:int, a:int=...) -> None: ...
    def setHslF(self, h:float, s:float, l:float, a:float=...) -> None: ...
    def setHsv(self, h:int, s:int, v:int, a:int=...) -> None: ...
    def setHsvF(self, h:float, s:float, v:float, a:float=...) -> None: ...
    def setNamedColor(self, name:str) -> None: ...
    def setRed(self, red:int) -> None: ...
    def setRedF(self, red:float) -> None: ...
    @typing.overload
    def setRgb(self, r:int, g:int, b:int, a:int=...) -> None: ...
    @typing.overload
    def setRgb(self, rgb:int) -> None: ...
    def setRgbF(self, r:float, g:float, b:float, a:float=...) -> None: ...
    def setRgba(self, rgba:int) -> None: ...
    def spec(self) -> PySide2.QtGui.QColor.Spec: ...
    def toCmyk(self) -> PySide2.QtGui.QColor: ...
    def toExtendedRgb(self) -> PySide2.QtGui.QColor: ...
    def toHsl(self) -> PySide2.QtGui.QColor: ...
    def toHsv(self) -> PySide2.QtGui.QColor: ...
    def toRgb(self) -> PySide2.QtGui.QColor: ...
    def toTuple(self) -> object: ...
    def value(self) -> int: ...
    def valueF(self) -> float: ...
    def yellow(self) -> int: ...
    def yellowF(self) -> float: ...


class QColorConstants(Shiboken.Object):

    class Svg(Shiboken.Object): ...


class QColorSpace(Shiboken.Object):
    SRgb                     : QColorSpace = ... # 0x1
    SRgbLinear               : QColorSpace = ... # 0x2
    AdobeRgb                 : QColorSpace = ... # 0x3
    DisplayP3                : QColorSpace = ... # 0x4
    ProPhotoRgb              : QColorSpace = ... # 0x5

    class NamedColorSpace(object):
        SRgb                     : QColorSpace.NamedColorSpace = ... # 0x1
        SRgbLinear               : QColorSpace.NamedColorSpace = ... # 0x2
        AdobeRgb                 : QColorSpace.NamedColorSpace = ... # 0x3
        DisplayP3                : QColorSpace.NamedColorSpace = ... # 0x4
        ProPhotoRgb              : QColorSpace.NamedColorSpace = ... # 0x5

    class Primaries(object):
        Custom                   : QColorSpace.Primaries = ... # 0x0
        SRgb                     : QColorSpace.Primaries = ... # 0x1
        AdobeRgb                 : QColorSpace.Primaries = ... # 0x2
        DciP3D65                 : QColorSpace.Primaries = ... # 0x3
        ProPhotoRgb              : QColorSpace.Primaries = ... # 0x4

    class TransferFunction(object):
        Custom                   : QColorSpace.TransferFunction = ... # 0x0
        Linear                   : QColorSpace.TransferFunction = ... # 0x1
        Gamma                    : QColorSpace.TransferFunction = ... # 0x2
        SRgb                     : QColorSpace.TransferFunction = ... # 0x3
        ProPhotoRgb              : QColorSpace.TransferFunction = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, colorSpace:PySide2.QtGui.QColorSpace) -> None: ...
    @typing.overload
    def __init__(self, namedColorSpace:PySide2.QtGui.QColorSpace.NamedColorSpace) -> None: ...
    @typing.overload
    def __init__(self, primaries:PySide2.QtGui.QColorSpace.Primaries, fun:PySide2.QtGui.QColorSpace.TransferFunction, gamma:float=...) -> None: ...
    @typing.overload
    def __init__(self, primaries:PySide2.QtGui.QColorSpace.Primaries, gamma:float) -> None: ...
    @typing.overload
    def __init__(self, whitePoint:PySide2.QtCore.QPointF, redPoint:PySide2.QtCore.QPointF, greenPoint:PySide2.QtCore.QPointF, bluePoint:PySide2.QtCore.QPointF, fun:PySide2.QtGui.QColorSpace.TransferFunction, gamma:float=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @staticmethod
    def fromIccProfile(iccProfile:PySide2.QtCore.QByteArray) -> PySide2.QtGui.QColorSpace: ...
    def gamma(self) -> float: ...
    def iccProfile(self) -> PySide2.QtCore.QByteArray: ...
    def isValid(self) -> bool: ...
    def primaries(self) -> PySide2.QtGui.QColorSpace.Primaries: ...
    @typing.overload
    def setPrimaries(self, primariesId:PySide2.QtGui.QColorSpace.Primaries) -> None: ...
    @typing.overload
    def setPrimaries(self, whitePoint:PySide2.QtCore.QPointF, redPoint:PySide2.QtCore.QPointF, greenPoint:PySide2.QtCore.QPointF, bluePoint:PySide2.QtCore.QPointF) -> None: ...
    def setTransferFunction(self, transferFunction:PySide2.QtGui.QColorSpace.TransferFunction, gamma:float=...) -> None: ...
    def swap(self, colorSpace:PySide2.QtGui.QColorSpace) -> None: ...
    def transferFunction(self) -> PySide2.QtGui.QColorSpace.TransferFunction: ...
    def withTransferFunction(self, transferFunction:PySide2.QtGui.QColorSpace.TransferFunction, gamma:float=...) -> PySide2.QtGui.QColorSpace: ...


class QConicalGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QConicalGradient:PySide2.QtGui.QConicalGradient) -> None: ...
    @typing.overload
    def __init__(self, center:PySide2.QtCore.QPointF, startAngle:float) -> None: ...
    @typing.overload
    def __init__(self, cx:float, cy:float, startAngle:float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def angle(self) -> float: ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    def setAngle(self, angle:float) -> None: ...
    @typing.overload
    def setCenter(self, center:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setCenter(self, x:float, y:float) -> None: ...


class QContextMenuEvent(PySide2.QtGui.QInputEvent):
    Mouse                    : QContextMenuEvent = ... # 0x0
    Keyboard                 : QContextMenuEvent = ... # 0x1
    Other                    : QContextMenuEvent = ... # 0x2

    class Reason(object):
        Mouse                    : QContextMenuEvent.Reason = ... # 0x0
        Keyboard                 : QContextMenuEvent.Reason = ... # 0x1
        Other                    : QContextMenuEvent.Reason = ... # 0x2

    @typing.overload
    def __init__(self, reason:PySide2.QtGui.QContextMenuEvent.Reason, pos:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, reason:PySide2.QtGui.QContextMenuEvent.Reason, pos:PySide2.QtCore.QPoint, globalPos:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, reason:PySide2.QtGui.QContextMenuEvent.Reason, pos:PySide2.QtCore.QPoint, globalPos:PySide2.QtCore.QPoint, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...

    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def reason(self) -> PySide2.QtGui.QContextMenuEvent.Reason: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QCursor(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bitmap:PySide2.QtGui.QBitmap, mask:PySide2.QtGui.QBitmap, hotX:int=..., hotY:int=...) -> None: ...
    @typing.overload
    def __init__(self, cursor:PySide2.QtGui.QCursor) -> None: ...
    @typing.overload
    def __init__(self, pixmap:PySide2.QtGui.QPixmap, hotX:int=..., hotY:int=...) -> None: ...
    @typing.overload
    def __init__(self, shape:PySide2.QtCore.Qt.CursorShape) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, outS:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, inS:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def bitmap(self) -> PySide2.QtGui.QBitmap: ...
    def hotSpot(self) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> PySide2.QtGui.QBitmap: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def pos() -> PySide2.QtCore.QPoint: ...
    @typing.overload
    @staticmethod
    def pos(screen:PySide2.QtGui.QScreen) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    @staticmethod
    def setPos(p:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    @staticmethod
    def setPos(screen:PySide2.QtGui.QScreen, p:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    @staticmethod
    def setPos(screen:PySide2.QtGui.QScreen, x:int, y:int) -> None: ...
    @typing.overload
    @staticmethod
    def setPos(x:int, y:int) -> None: ...
    def setShape(self, newShape:PySide2.QtCore.Qt.CursorShape) -> None: ...
    def shape(self) -> PySide2.QtCore.Qt.CursorShape: ...
    def swap(self, other:PySide2.QtGui.QCursor) -> None: ...


class QDesktopServices(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def openUrl(url:PySide2.QtCore.QUrl) -> bool: ...
    @staticmethod
    def setUrlHandler(scheme:str, receiver:PySide2.QtCore.QObject, method:bytes) -> None: ...
    @staticmethod
    def unsetUrlHandler(scheme:str) -> None: ...


class QDoubleValidator(PySide2.QtGui.QValidator):
    StandardNotation         : QDoubleValidator = ... # 0x0
    ScientificNotation       : QDoubleValidator = ... # 0x1

    class Notation(object):
        StandardNotation         : QDoubleValidator.Notation = ... # 0x0
        ScientificNotation       : QDoubleValidator.Notation = ... # 0x1

    @typing.overload
    def __init__(self, bottom:float, top:float, decimals:int, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def bottom(self) -> float: ...
    def decimals(self) -> int: ...
    def notation(self) -> PySide2.QtGui.QDoubleValidator.Notation: ...
    def setBottom(self, arg__1:float) -> None: ...
    def setDecimals(self, arg__1:int) -> None: ...
    def setNotation(self, arg__1:PySide2.QtGui.QDoubleValidator.Notation) -> None: ...
    def setRange(self, bottom:float, top:float, decimals:int=...) -> None: ...
    def setTop(self, arg__1:float) -> None: ...
    def top(self) -> float: ...
    def validate(self, arg__1:str, arg__2:int) -> PySide2.QtGui.QValidator.State: ...


class QDrag(PySide2.QtCore.QObject):

    def __init__(self, dragSource:PySide2.QtCore.QObject) -> None: ...

    @staticmethod
    def cancel() -> None: ...
    def defaultAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def dragCursor(self, action:PySide2.QtCore.Qt.DropAction) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def exec_(self, supportedActions:PySide2.QtCore.Qt.DropActions, defaultAction:PySide2.QtCore.Qt.DropAction) -> PySide2.QtCore.Qt.DropAction: ...
    @typing.overload
    def exec_(self, supportedActions:PySide2.QtCore.Qt.DropActions=...) -> PySide2.QtCore.Qt.DropAction: ...
    def hotSpot(self) -> PySide2.QtCore.QPoint: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def setDragCursor(self, cursor:PySide2.QtGui.QPixmap, action:PySide2.QtCore.Qt.DropAction) -> None: ...
    def setHotSpot(self, hotspot:PySide2.QtCore.QPoint) -> None: ...
    def setMimeData(self, data:PySide2.QtCore.QMimeData) -> None: ...
    def setPixmap(self, arg__1:PySide2.QtGui.QPixmap) -> None: ...
    def source(self) -> PySide2.QtCore.QObject: ...
    def start(self, supportedActions:PySide2.QtCore.Qt.DropActions=...) -> PySide2.QtCore.Qt.DropAction: ...
    def supportedActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def target(self) -> PySide2.QtCore.QObject: ...


class QDragEnterEvent(PySide2.QtGui.QDragMoveEvent):

    def __init__(self, pos:PySide2.QtCore.QPoint, actions:PySide2.QtCore.Qt.DropActions, data:PySide2.QtCore.QMimeData, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...


class QDragLeaveEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QDragMoveEvent(PySide2.QtGui.QDropEvent):

    def __init__(self, pos:PySide2.QtCore.QPoint, actions:PySide2.QtCore.Qt.DropActions, data:PySide2.QtCore.QMimeData, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, type:PySide2.QtCore.QEvent.Type=...) -> None: ...

    @typing.overload
    def accept(self) -> None: ...
    @typing.overload
    def accept(self, r:PySide2.QtCore.QRect) -> None: ...
    def answerRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def ignore(self) -> None: ...
    @typing.overload
    def ignore(self, r:PySide2.QtCore.QRect) -> None: ...


class QDropEvent(PySide2.QtCore.QEvent):

    def __init__(self, pos:PySide2.QtCore.QPointF, actions:PySide2.QtCore.Qt.DropActions, data:PySide2.QtCore.QMimeData, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, type:PySide2.QtCore.QEvent.Type=...) -> None: ...

    def acceptProposedAction(self) -> None: ...
    def dropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def keyboardModifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def mouseButtons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def possibleActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def proposedAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def setDropAction(self, action:PySide2.QtCore.Qt.DropAction) -> None: ...
    def source(self) -> PySide2.QtCore.QObject: ...


class QEnterEvent(PySide2.QtCore.QEvent):

    def __init__(self, localPos:PySide2.QtCore.QPointF, windowPos:PySide2.QtCore.QPointF, screenPos:PySide2.QtCore.QPointF) -> None: ...

    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QExposeEvent(PySide2.QtCore.QEvent):

    def __init__(self, rgn:PySide2.QtGui.QRegion) -> None: ...

    def region(self) -> PySide2.QtGui.QRegion: ...


class QFileOpenEvent(PySide2.QtCore.QEvent):

    @typing.overload
    def __init__(self, file:str) -> None: ...
    @typing.overload
    def __init__(self, url:PySide2.QtCore.QUrl) -> None: ...

    def file(self) -> str: ...
    def openFile(self, file:PySide2.QtCore.QFile, flags:PySide2.QtCore.QIODevice.OpenMode) -> bool: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QFocusEvent(PySide2.QtCore.QEvent):

    def __init__(self, type:PySide2.QtCore.QEvent.Type, reason:PySide2.QtCore.Qt.FocusReason=...) -> None: ...

    def gotFocus(self) -> bool: ...
    def lostFocus(self) -> bool: ...
    def reason(self) -> PySide2.QtCore.Qt.FocusReason: ...


class QFont(Shiboken.Object):
    AnyStretch               : QFont = ... # 0x0
    Helvetica                : QFont = ... # 0x0
    MixedCase                : QFont = ... # 0x0
    PercentageSpacing        : QFont = ... # 0x0
    PreferDefaultHinting     : QFont = ... # 0x0
    SansSerif                : QFont = ... # 0x0
    StyleNormal              : QFont = ... # 0x0
    Thin                     : QFont = ... # 0x0
    AbsoluteSpacing          : QFont = ... # 0x1
    AllUppercase             : QFont = ... # 0x1
    PreferDefault            : QFont = ... # 0x1
    PreferNoHinting          : QFont = ... # 0x1
    Serif                    : QFont = ... # 0x1
    StyleItalic              : QFont = ... # 0x1
    Times                    : QFont = ... # 0x1
    AllLowercase             : QFont = ... # 0x2
    Courier                  : QFont = ... # 0x2
    PreferBitmap             : QFont = ... # 0x2
    PreferVerticalHinting    : QFont = ... # 0x2
    StyleOblique             : QFont = ... # 0x2
    TypeWriter               : QFont = ... # 0x2
    Decorative               : QFont = ... # 0x3
    OldEnglish               : QFont = ... # 0x3
    PreferFullHinting        : QFont = ... # 0x3
    SmallCaps                : QFont = ... # 0x3
    Capitalize               : QFont = ... # 0x4
    PreferDevice             : QFont = ... # 0x4
    System                   : QFont = ... # 0x4
    AnyStyle                 : QFont = ... # 0x5
    Cursive                  : QFont = ... # 0x6
    Monospace                : QFont = ... # 0x7
    Fantasy                  : QFont = ... # 0x8
    PreferOutline            : QFont = ... # 0x8
    ExtraLight               : QFont = ... # 0xc
    ForceOutline             : QFont = ... # 0x10
    Light                    : QFont = ... # 0x19
    PreferMatch              : QFont = ... # 0x20
    Normal                   : QFont = ... # 0x32
    UltraCondensed           : QFont = ... # 0x32
    Medium                   : QFont = ... # 0x39
    ExtraCondensed           : QFont = ... # 0x3e
    DemiBold                 : QFont = ... # 0x3f
    PreferQuality            : QFont = ... # 0x40
    Bold                     : QFont = ... # 0x4b
    Condensed                : QFont = ... # 0x4b
    ExtraBold                : QFont = ... # 0x51
    Black                    : QFont = ... # 0x57
    SemiCondensed            : QFont = ... # 0x57
    Unstretched              : QFont = ... # 0x64
    SemiExpanded             : QFont = ... # 0x70
    Expanded                 : QFont = ... # 0x7d
    PreferAntialias          : QFont = ... # 0x80
    ExtraExpanded            : QFont = ... # 0x96
    UltraExpanded            : QFont = ... # 0xc8
    NoAntialias              : QFont = ... # 0x100
    OpenGLCompatible         : QFont = ... # 0x200
    ForceIntegerMetrics      : QFont = ... # 0x400
    NoSubpixelAntialias      : QFont = ... # 0x800
    PreferNoShaping          : QFont = ... # 0x1000
    NoFontMerging            : QFont = ... # 0x8000

    class Capitalization(object):
        MixedCase                : QFont.Capitalization = ... # 0x0
        AllUppercase             : QFont.Capitalization = ... # 0x1
        AllLowercase             : QFont.Capitalization = ... # 0x2
        SmallCaps                : QFont.Capitalization = ... # 0x3
        Capitalize               : QFont.Capitalization = ... # 0x4

    class HintingPreference(object):
        PreferDefaultHinting     : QFont.HintingPreference = ... # 0x0
        PreferNoHinting          : QFont.HintingPreference = ... # 0x1
        PreferVerticalHinting    : QFont.HintingPreference = ... # 0x2
        PreferFullHinting        : QFont.HintingPreference = ... # 0x3

    class SpacingType(object):
        PercentageSpacing        : QFont.SpacingType = ... # 0x0
        AbsoluteSpacing          : QFont.SpacingType = ... # 0x1

    class Stretch(object):
        AnyStretch               : QFont.Stretch = ... # 0x0
        UltraCondensed           : QFont.Stretch = ... # 0x32
        ExtraCondensed           : QFont.Stretch = ... # 0x3e
        Condensed                : QFont.Stretch = ... # 0x4b
        SemiCondensed            : QFont.Stretch = ... # 0x57
        Unstretched              : QFont.Stretch = ... # 0x64
        SemiExpanded             : QFont.Stretch = ... # 0x70
        Expanded                 : QFont.Stretch = ... # 0x7d
        ExtraExpanded            : QFont.Stretch = ... # 0x96
        UltraExpanded            : QFont.Stretch = ... # 0xc8

    class Style(object):
        StyleNormal              : QFont.Style = ... # 0x0
        StyleItalic              : QFont.Style = ... # 0x1
        StyleOblique             : QFont.Style = ... # 0x2

    class StyleHint(object):
        Helvetica                : QFont.StyleHint = ... # 0x0
        SansSerif                : QFont.StyleHint = ... # 0x0
        Serif                    : QFont.StyleHint = ... # 0x1
        Times                    : QFont.StyleHint = ... # 0x1
        Courier                  : QFont.StyleHint = ... # 0x2
        TypeWriter               : QFont.StyleHint = ... # 0x2
        Decorative               : QFont.StyleHint = ... # 0x3
        OldEnglish               : QFont.StyleHint = ... # 0x3
        System                   : QFont.StyleHint = ... # 0x4
        AnyStyle                 : QFont.StyleHint = ... # 0x5
        Cursive                  : QFont.StyleHint = ... # 0x6
        Monospace                : QFont.StyleHint = ... # 0x7
        Fantasy                  : QFont.StyleHint = ... # 0x8

    class StyleStrategy(object):
        PreferDefault            : QFont.StyleStrategy = ... # 0x1
        PreferBitmap             : QFont.StyleStrategy = ... # 0x2
        PreferDevice             : QFont.StyleStrategy = ... # 0x4
        PreferOutline            : QFont.StyleStrategy = ... # 0x8
        ForceOutline             : QFont.StyleStrategy = ... # 0x10
        PreferMatch              : QFont.StyleStrategy = ... # 0x20
        PreferQuality            : QFont.StyleStrategy = ... # 0x40
        PreferAntialias          : QFont.StyleStrategy = ... # 0x80
        NoAntialias              : QFont.StyleStrategy = ... # 0x100
        OpenGLCompatible         : QFont.StyleStrategy = ... # 0x200
        ForceIntegerMetrics      : QFont.StyleStrategy = ... # 0x400
        NoSubpixelAntialias      : QFont.StyleStrategy = ... # 0x800
        PreferNoShaping          : QFont.StyleStrategy = ... # 0x1000
        NoFontMerging            : QFont.StyleStrategy = ... # 0x8000

    class Weight(object):
        Thin                     : QFont.Weight = ... # 0x0
        ExtraLight               : QFont.Weight = ... # 0xc
        Light                    : QFont.Weight = ... # 0x19
        Normal                   : QFont.Weight = ... # 0x32
        Medium                   : QFont.Weight = ... # 0x39
        DemiBold                 : QFont.Weight = ... # 0x3f
        Bold                     : QFont.Weight = ... # 0x4b
        ExtraBold                : QFont.Weight = ... # 0x51
        Black                    : QFont.Weight = ... # 0x57

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, family:str, pointSize:int=..., weight:int=..., italic:bool=...) -> None: ...
    @typing.overload
    def __init__(self, font:PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, font:PySide2.QtGui.QFont, pd:PySide2.QtGui.QPaintDevice) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def bold(self) -> bool: ...
    @staticmethod
    def cacheStatistics() -> None: ...
    def capitalization(self) -> PySide2.QtGui.QFont.Capitalization: ...
    @staticmethod
    def cleanup() -> None: ...
    def defaultFamily(self) -> str: ...
    def exactMatch(self) -> bool: ...
    def families(self) -> typing.List: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def fromString(self, arg__1:str) -> bool: ...
    def hintingPreference(self) -> PySide2.QtGui.QFont.HintingPreference: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def insertSubstitution(arg__1:str, arg__2:str) -> None: ...
    @staticmethod
    def insertSubstitutions(arg__1:str, arg__2:typing.Sequence) -> None: ...
    def isCopyOf(self, arg__1:PySide2.QtGui.QFont) -> bool: ...
    def italic(self) -> bool: ...
    def kerning(self) -> bool: ...
    def key(self) -> str: ...
    def lastResortFamily(self) -> str: ...
    def lastResortFont(self) -> str: ...
    def letterSpacing(self) -> float: ...
    def letterSpacingType(self) -> PySide2.QtGui.QFont.SpacingType: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def rawMode(self) -> bool: ...
    def rawName(self) -> str: ...
    @staticmethod
    def removeSubstitutions(arg__1:str) -> None: ...
    @typing.overload
    def resolve(self) -> int: ...
    @typing.overload
    def resolve(self, arg__1:PySide2.QtGui.QFont) -> PySide2.QtGui.QFont: ...
    @typing.overload
    def resolve(self, mask:int) -> None: ...
    def setBold(self, arg__1:bool) -> None: ...
    def setCapitalization(self, arg__1:PySide2.QtGui.QFont.Capitalization) -> None: ...
    def setFamilies(self, arg__1:typing.Sequence) -> None: ...
    def setFamily(self, arg__1:str) -> None: ...
    def setFixedPitch(self, arg__1:bool) -> None: ...
    def setHintingPreference(self, hintingPreference:PySide2.QtGui.QFont.HintingPreference) -> None: ...
    def setItalic(self, b:bool) -> None: ...
    def setKerning(self, arg__1:bool) -> None: ...
    def setLetterSpacing(self, type:PySide2.QtGui.QFont.SpacingType, spacing:float) -> None: ...
    def setOverline(self, arg__1:bool) -> None: ...
    def setPixelSize(self, arg__1:int) -> None: ...
    def setPointSize(self, arg__1:int) -> None: ...
    def setPointSizeF(self, arg__1:float) -> None: ...
    def setRawMode(self, arg__1:bool) -> None: ...
    def setRawName(self, arg__1:str) -> None: ...
    def setStretch(self, arg__1:int) -> None: ...
    def setStrikeOut(self, arg__1:bool) -> None: ...
    def setStyle(self, style:PySide2.QtGui.QFont.Style) -> None: ...
    def setStyleHint(self, arg__1:PySide2.QtGui.QFont.StyleHint, strategy:PySide2.QtGui.QFont.StyleStrategy=...) -> None: ...
    def setStyleName(self, arg__1:str) -> None: ...
    def setStyleStrategy(self, s:PySide2.QtGui.QFont.StyleStrategy) -> None: ...
    def setUnderline(self, arg__1:bool) -> None: ...
    def setWeight(self, arg__1:int) -> None: ...
    def setWordSpacing(self, spacing:float) -> None: ...
    def stretch(self) -> int: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide2.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide2.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def styleStrategy(self) -> PySide2.QtGui.QFont.StyleStrategy: ...
    @staticmethod
    def substitute(arg__1:str) -> str: ...
    @staticmethod
    def substitutes(arg__1:str) -> typing.List: ...
    @staticmethod
    def substitutions() -> typing.List: ...
    def swap(self, other:PySide2.QtGui.QFont) -> None: ...
    def toString(self) -> str: ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...
    def wordSpacing(self) -> float: ...


class QFontDatabase(Shiboken.Object):
    Any                      : QFontDatabase = ... # 0x0
    GeneralFont              : QFontDatabase = ... # 0x0
    FixedFont                : QFontDatabase = ... # 0x1
    Latin                    : QFontDatabase = ... # 0x1
    Greek                    : QFontDatabase = ... # 0x2
    TitleFont                : QFontDatabase = ... # 0x2
    Cyrillic                 : QFontDatabase = ... # 0x3
    SmallestReadableFont     : QFontDatabase = ... # 0x3
    Armenian                 : QFontDatabase = ... # 0x4
    Hebrew                   : QFontDatabase = ... # 0x5
    Arabic                   : QFontDatabase = ... # 0x6
    Syriac                   : QFontDatabase = ... # 0x7
    Thaana                   : QFontDatabase = ... # 0x8
    Devanagari               : QFontDatabase = ... # 0x9
    Bengali                  : QFontDatabase = ... # 0xa
    Gurmukhi                 : QFontDatabase = ... # 0xb
    Gujarati                 : QFontDatabase = ... # 0xc
    Oriya                    : QFontDatabase = ... # 0xd
    Tamil                    : QFontDatabase = ... # 0xe
    Telugu                   : QFontDatabase = ... # 0xf
    Kannada                  : QFontDatabase = ... # 0x10
    Malayalam                : QFontDatabase = ... # 0x11
    Sinhala                  : QFontDatabase = ... # 0x12
    Thai                     : QFontDatabase = ... # 0x13
    Lao                      : QFontDatabase = ... # 0x14
    Tibetan                  : QFontDatabase = ... # 0x15
    Myanmar                  : QFontDatabase = ... # 0x16
    Georgian                 : QFontDatabase = ... # 0x17
    Khmer                    : QFontDatabase = ... # 0x18
    SimplifiedChinese        : QFontDatabase = ... # 0x19
    TraditionalChinese       : QFontDatabase = ... # 0x1a
    Japanese                 : QFontDatabase = ... # 0x1b
    Korean                   : QFontDatabase = ... # 0x1c
    Vietnamese               : QFontDatabase = ... # 0x1d
    Other                    : QFontDatabase = ... # 0x1e
    Symbol                   : QFontDatabase = ... # 0x1e
    Ogham                    : QFontDatabase = ... # 0x1f
    Runic                    : QFontDatabase = ... # 0x20
    Nko                      : QFontDatabase = ... # 0x21
    WritingSystemsCount      : QFontDatabase = ... # 0x22

    class SystemFont(object):
        GeneralFont              : QFontDatabase.SystemFont = ... # 0x0
        FixedFont                : QFontDatabase.SystemFont = ... # 0x1
        TitleFont                : QFontDatabase.SystemFont = ... # 0x2
        SmallestReadableFont     : QFontDatabase.SystemFont = ... # 0x3

    class WritingSystem(object):
        Any                      : QFontDatabase.WritingSystem = ... # 0x0
        Latin                    : QFontDatabase.WritingSystem = ... # 0x1
        Greek                    : QFontDatabase.WritingSystem = ... # 0x2
        Cyrillic                 : QFontDatabase.WritingSystem = ... # 0x3
        Armenian                 : QFontDatabase.WritingSystem = ... # 0x4
        Hebrew                   : QFontDatabase.WritingSystem = ... # 0x5
        Arabic                   : QFontDatabase.WritingSystem = ... # 0x6
        Syriac                   : QFontDatabase.WritingSystem = ... # 0x7
        Thaana                   : QFontDatabase.WritingSystem = ... # 0x8
        Devanagari               : QFontDatabase.WritingSystem = ... # 0x9
        Bengali                  : QFontDatabase.WritingSystem = ... # 0xa
        Gurmukhi                 : QFontDatabase.WritingSystem = ... # 0xb
        Gujarati                 : QFontDatabase.WritingSystem = ... # 0xc
        Oriya                    : QFontDatabase.WritingSystem = ... # 0xd
        Tamil                    : QFontDatabase.WritingSystem = ... # 0xe
        Telugu                   : QFontDatabase.WritingSystem = ... # 0xf
        Kannada                  : QFontDatabase.WritingSystem = ... # 0x10
        Malayalam                : QFontDatabase.WritingSystem = ... # 0x11
        Sinhala                  : QFontDatabase.WritingSystem = ... # 0x12
        Thai                     : QFontDatabase.WritingSystem = ... # 0x13
        Lao                      : QFontDatabase.WritingSystem = ... # 0x14
        Tibetan                  : QFontDatabase.WritingSystem = ... # 0x15
        Myanmar                  : QFontDatabase.WritingSystem = ... # 0x16
        Georgian                 : QFontDatabase.WritingSystem = ... # 0x17
        Khmer                    : QFontDatabase.WritingSystem = ... # 0x18
        SimplifiedChinese        : QFontDatabase.WritingSystem = ... # 0x19
        TraditionalChinese       : QFontDatabase.WritingSystem = ... # 0x1a
        Japanese                 : QFontDatabase.WritingSystem = ... # 0x1b
        Korean                   : QFontDatabase.WritingSystem = ... # 0x1c
        Vietnamese               : QFontDatabase.WritingSystem = ... # 0x1d
        Other                    : QFontDatabase.WritingSystem = ... # 0x1e
        Symbol                   : QFontDatabase.WritingSystem = ... # 0x1e
        Ogham                    : QFontDatabase.WritingSystem = ... # 0x1f
        Runic                    : QFontDatabase.WritingSystem = ... # 0x20
        Nko                      : QFontDatabase.WritingSystem = ... # 0x21
        WritingSystemsCount      : QFontDatabase.WritingSystem = ... # 0x22

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QFontDatabase:PySide2.QtGui.QFontDatabase) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def addApplicationFont(fileName:str) -> int: ...
    @staticmethod
    def addApplicationFontFromData(fontData:PySide2.QtCore.QByteArray) -> int: ...
    @staticmethod
    def applicationFontFamilies(id:int) -> typing.List: ...
    def bold(self, family:str, style:str) -> bool: ...
    def families(self, writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem=...) -> typing.List: ...
    def font(self, family:str, style:str, pointSize:int) -> PySide2.QtGui.QFont: ...
    def hasFamily(self, family:str) -> bool: ...
    def isBitmapScalable(self, family:str, style:str=...) -> bool: ...
    def isFixedPitch(self, family:str, style:str=...) -> bool: ...
    def isPrivateFamily(self, family:str) -> bool: ...
    def isScalable(self, family:str, style:str=...) -> bool: ...
    def isSmoothlyScalable(self, family:str, style:str=...) -> bool: ...
    def italic(self, family:str, style:str) -> bool: ...
    def pointSizes(self, family:str, style:str=...) -> typing.List: ...
    @staticmethod
    def removeAllApplicationFonts() -> bool: ...
    @staticmethod
    def removeApplicationFont(id:int) -> bool: ...
    def smoothSizes(self, family:str, style:str) -> typing.List: ...
    @staticmethod
    def standardSizes() -> typing.List: ...
    @typing.overload
    def styleString(self, font:PySide2.QtGui.QFont) -> str: ...
    @typing.overload
    def styleString(self, fontInfo:PySide2.QtGui.QFontInfo) -> str: ...
    def styles(self, family:str) -> typing.List: ...
    @staticmethod
    def supportsThreadedFontRendering() -> bool: ...
    @staticmethod
    def systemFont(type:PySide2.QtGui.QFontDatabase.SystemFont) -> PySide2.QtGui.QFont: ...
    def weight(self, family:str, style:str) -> int: ...
    @staticmethod
    def writingSystemName(writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @staticmethod
    def writingSystemSample(writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem) -> str: ...
    @typing.overload
    def writingSystems(self) -> typing.List: ...
    @typing.overload
    def writingSystems(self, family:str) -> typing.List: ...


class QFontInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QFontInfo) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bold(self) -> bool: ...
    def exactMatch(self) -> bool: ...
    def family(self) -> str: ...
    def fixedPitch(self) -> bool: ...
    def italic(self) -> bool: ...
    def overline(self) -> bool: ...
    def pixelSize(self) -> int: ...
    def pointSize(self) -> int: ...
    def pointSizeF(self) -> float: ...
    def rawMode(self) -> bool: ...
    def strikeOut(self) -> bool: ...
    def style(self) -> PySide2.QtGui.QFont.Style: ...
    def styleHint(self) -> PySide2.QtGui.QFont.StyleHint: ...
    def styleName(self) -> str: ...
    def swap(self, other:PySide2.QtGui.QFontInfo) -> None: ...
    def underline(self) -> bool: ...
    def weight(self) -> int: ...


class QFontMetrics(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def __init__(self, font:PySide2.QtGui.QFont, pd:PySide2.QtGui.QPaintDevice) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> int: ...
    def averageCharWidth(self) -> int: ...
    @typing.overload
    def boundingRect(self, r:PySide2.QtCore.QRect, flags:int, text:str, tabstops:int=..., tabarray:typing.Optional[typing.Sequence[int]]=...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, text:str) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, x:int, y:int, w:int, h:int, flags:int, text:str, tabstops:int=..., tabarray:typing.Optional[typing.Sequence[int]]=...) -> PySide2.QtCore.QRect: ...
    def boundingRectChar(self, arg__1:str) -> PySide2.QtCore.QRect: ...
    def capHeight(self) -> int: ...
    def charWidth(self, str:str, pos:int) -> int: ...
    def descent(self) -> int: ...
    def elidedText(self, text:str, mode:PySide2.QtCore.Qt.TextElideMode, width:int, flags:int=...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> int: ...
    @typing.overload
    def horizontalAdvance(self, arg__1:str) -> int: ...
    @typing.overload
    def horizontalAdvance(self, arg__1:str, len:int=...) -> int: ...
    def inFont(self, arg__1:str) -> bool: ...
    def inFontUcs4(self, ucs4:int) -> bool: ...
    def leading(self) -> int: ...
    def leftBearing(self, arg__1:str) -> int: ...
    def lineSpacing(self) -> int: ...
    def lineWidth(self) -> int: ...
    def maxWidth(self) -> int: ...
    def minLeftBearing(self) -> int: ...
    def minRightBearing(self) -> int: ...
    def overlinePos(self) -> int: ...
    def rightBearing(self, arg__1:str) -> int: ...
    def size(self, flags:int, str:str, tabstops:int=..., tabarray:typing.Optional[typing.Sequence[int]]=...) -> PySide2.QtCore.QSize: ...
    def strikeOutPos(self) -> int: ...
    def swap(self, other:PySide2.QtGui.QFontMetrics) -> None: ...
    def tightBoundingRect(self, text:str) -> PySide2.QtCore.QRect: ...
    def underlinePos(self) -> int: ...
    @typing.overload
    def width(self, arg__1:str, len:int, flags:int) -> int: ...
    @typing.overload
    def width(self, arg__1:str, len:int=...) -> int: ...
    def widthChar(self, arg__1:str) -> int: ...
    def xHeight(self) -> int: ...


class QFontMetricsF(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QFontMetrics) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QFontMetricsF) -> None: ...
    @typing.overload
    def __init__(self, font:PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def __init__(self, font:PySide2.QtGui.QFont, pd:PySide2.QtGui.QPaintDevice) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    @typing.overload
    def boundingRect(self, r:PySide2.QtCore.QRectF, flags:int, string:str, tabstops:int=..., tabarray:typing.Optional[typing.Sequence[int]]=...) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, string:str) -> PySide2.QtCore.QRectF: ...
    def boundingRectChar(self, arg__1:str) -> PySide2.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def elidedText(self, text:str, mode:PySide2.QtCore.Qt.TextElideMode, width:float, flags:int=...) -> str: ...
    def fontDpi(self) -> float: ...
    def height(self) -> float: ...
    @typing.overload
    def horizontalAdvance(self, arg__1:str) -> float: ...
    @typing.overload
    def horizontalAdvance(self, string:str, length:int=...) -> float: ...
    def inFont(self, arg__1:str) -> bool: ...
    def inFontUcs4(self, ucs4:int) -> bool: ...
    def leading(self) -> float: ...
    def leftBearing(self, arg__1:str) -> float: ...
    def lineSpacing(self) -> float: ...
    def lineWidth(self) -> float: ...
    def maxWidth(self) -> float: ...
    def minLeftBearing(self) -> float: ...
    def minRightBearing(self) -> float: ...
    def overlinePos(self) -> float: ...
    def rightBearing(self, arg__1:str) -> float: ...
    def size(self, flags:int, str:str, tabstops:int=..., tabarray:typing.Optional[typing.Sequence[int]]=...) -> PySide2.QtCore.QSizeF: ...
    def strikeOutPos(self) -> float: ...
    def swap(self, other:PySide2.QtGui.QFontMetricsF) -> None: ...
    def tightBoundingRect(self, text:str) -> PySide2.QtCore.QRectF: ...
    def underlinePos(self) -> float: ...
    def width(self, string:str) -> float: ...
    def widthChar(self, arg__1:str) -> float: ...
    def xHeight(self) -> float: ...


class QGradient(Shiboken.Object):
    ColorInterpolation       : QGradient = ... # 0x0
    LinearGradient           : QGradient = ... # 0x0
    LogicalMode              : QGradient = ... # 0x0
    PadSpread                : QGradient = ... # 0x0
    ComponentInterpolation   : QGradient = ... # 0x1
    RadialGradient           : QGradient = ... # 0x1
    ReflectSpread            : QGradient = ... # 0x1
    StretchToDeviceMode      : QGradient = ... # 0x1
    WarmFlame                : QGradient = ... # 0x1
    ConicalGradient          : QGradient = ... # 0x2
    NightFade                : QGradient = ... # 0x2
    ObjectBoundingMode       : QGradient = ... # 0x2
    RepeatSpread             : QGradient = ... # 0x2
    NoGradient               : QGradient = ... # 0x3
    ObjectMode               : QGradient = ... # 0x3
    SpringWarmth             : QGradient = ... # 0x3
    JuicyPeach               : QGradient = ... # 0x4
    YoungPassion             : QGradient = ... # 0x5
    LadyLips                 : QGradient = ... # 0x6
    SunnyMorning             : QGradient = ... # 0x7
    RainyAshville            : QGradient = ... # 0x8
    FrozenDreams             : QGradient = ... # 0x9
    WinterNeva               : QGradient = ... # 0xa
    DustyGrass               : QGradient = ... # 0xb
    TemptingAzure            : QGradient = ... # 0xc
    HeavyRain                : QGradient = ... # 0xd
    AmyCrisp                 : QGradient = ... # 0xe
    MeanFruit                : QGradient = ... # 0xf
    DeepBlue                 : QGradient = ... # 0x10
    RipeMalinka              : QGradient = ... # 0x11
    CloudyKnoxville          : QGradient = ... # 0x12
    MalibuBeach              : QGradient = ... # 0x13
    NewLife                  : QGradient = ... # 0x14
    TrueSunset               : QGradient = ... # 0x15
    MorpheusDen              : QGradient = ... # 0x16
    RareWind                 : QGradient = ... # 0x17
    NearMoon                 : QGradient = ... # 0x18
    WildApple                : QGradient = ... # 0x19
    SaintPetersburg          : QGradient = ... # 0x1a
    PlumPlate                : QGradient = ... # 0x1c
    EverlastingSky           : QGradient = ... # 0x1d
    HappyFisher              : QGradient = ... # 0x1e
    Blessing                 : QGradient = ... # 0x1f
    SharpeyeEagle            : QGradient = ... # 0x20
    LadogaBottom             : QGradient = ... # 0x21
    LemonGate                : QGradient = ... # 0x22
    ItmeoBranding            : QGradient = ... # 0x23
    ZeusMiracle              : QGradient = ... # 0x24
    OldHat                   : QGradient = ... # 0x25
    StarWine                 : QGradient = ... # 0x26
    HappyAcid                : QGradient = ... # 0x29
    AwesomePine              : QGradient = ... # 0x2a
    NewYork                  : QGradient = ... # 0x2b
    ShyRainbow               : QGradient = ... # 0x2c
    MixedHopes               : QGradient = ... # 0x2e
    FlyHigh                  : QGradient = ... # 0x2f
    StrongBliss              : QGradient = ... # 0x30
    FreshMilk                : QGradient = ... # 0x31
    SnowAgain                : QGradient = ... # 0x32
    FebruaryInk              : QGradient = ... # 0x33
    KindSteel                : QGradient = ... # 0x34
    SoftGrass                : QGradient = ... # 0x35
    GrownEarly               : QGradient = ... # 0x36
    SharpBlues               : QGradient = ... # 0x37
    ShadyWater               : QGradient = ... # 0x38
    DirtyBeauty              : QGradient = ... # 0x39
    GreatWhale               : QGradient = ... # 0x3a
    TeenNotebook             : QGradient = ... # 0x3b
    PoliteRumors             : QGradient = ... # 0x3c
    SweetPeriod              : QGradient = ... # 0x3d
    WideMatrix               : QGradient = ... # 0x3e
    SoftCherish              : QGradient = ... # 0x3f
    RedSalvation             : QGradient = ... # 0x40
    BurningSpring            : QGradient = ... # 0x41
    NightParty               : QGradient = ... # 0x42
    SkyGlider                : QGradient = ... # 0x43
    HeavenPeach              : QGradient = ... # 0x44
    PurpleDivision           : QGradient = ... # 0x45
    AquaSplash               : QGradient = ... # 0x46
    SpikyNaga                : QGradient = ... # 0x48
    LoveKiss                 : QGradient = ... # 0x49
    CleanMirror              : QGradient = ... # 0x4b
    PremiumDark              : QGradient = ... # 0x4c
    ColdEvening              : QGradient = ... # 0x4d
    CochitiLake              : QGradient = ... # 0x4e
    SummerGames              : QGradient = ... # 0x4f
    PassionateBed            : QGradient = ... # 0x50
    MountainRock             : QGradient = ... # 0x51
    DesertHump               : QGradient = ... # 0x52
    JungleDay                : QGradient = ... # 0x53
    PhoenixStart             : QGradient = ... # 0x54
    OctoberSilence           : QGradient = ... # 0x55
    FarawayRiver             : QGradient = ... # 0x56
    AlchemistLab             : QGradient = ... # 0x57
    OverSun                  : QGradient = ... # 0x58
    PremiumWhite             : QGradient = ... # 0x59
    MarsParty                : QGradient = ... # 0x5a
    EternalConstance         : QGradient = ... # 0x5b
    JapanBlush               : QGradient = ... # 0x5c
    SmilingRain              : QGradient = ... # 0x5d
    CloudyApple              : QGradient = ... # 0x5e
    BigMango                 : QGradient = ... # 0x5f
    HealthyWater             : QGradient = ... # 0x60
    AmourAmour               : QGradient = ... # 0x61
    RiskyConcrete            : QGradient = ... # 0x62
    StrongStick              : QGradient = ... # 0x63
    ViciousStance            : QGradient = ... # 0x64
    PaloAlto                 : QGradient = ... # 0x65
    HappyMemories            : QGradient = ... # 0x66
    MidnightBloom            : QGradient = ... # 0x67
    Crystalline              : QGradient = ... # 0x68
    PartyBliss               : QGradient = ... # 0x6a
    ConfidentCloud           : QGradient = ... # 0x6b
    LeCocktail               : QGradient = ... # 0x6c
    RiverCity                : QGradient = ... # 0x6d
    FrozenBerry              : QGradient = ... # 0x6e
    ChildCare                : QGradient = ... # 0x70
    FlyingLemon              : QGradient = ... # 0x71
    NewRetrowave             : QGradient = ... # 0x72
    HiddenJaguar             : QGradient = ... # 0x73
    AboveTheSky              : QGradient = ... # 0x74
    Nega                     : QGradient = ... # 0x75
    DenseWater               : QGradient = ... # 0x76
    Seashore                 : QGradient = ... # 0x78
    MarbleWall               : QGradient = ... # 0x79
    CheerfulCaramel          : QGradient = ... # 0x7a
    NightSky                 : QGradient = ... # 0x7b
    MagicLake                : QGradient = ... # 0x7c
    YoungGrass               : QGradient = ... # 0x7d
    ColorfulPeach            : QGradient = ... # 0x7e
    GentleCare               : QGradient = ... # 0x7f
    PlumBath                 : QGradient = ... # 0x80
    HappyUnicorn             : QGradient = ... # 0x81
    AfricanField             : QGradient = ... # 0x83
    SolidStone               : QGradient = ... # 0x84
    OrangeJuice              : QGradient = ... # 0x85
    GlassWater               : QGradient = ... # 0x86
    NorthMiracle             : QGradient = ... # 0x88
    FruitBlend               : QGradient = ... # 0x89
    MillenniumPine           : QGradient = ... # 0x8a
    HighFlight               : QGradient = ... # 0x8b
    MoleHall                 : QGradient = ... # 0x8c
    SpaceShift               : QGradient = ... # 0x8e
    ForestInei               : QGradient = ... # 0x8f
    RoyalGarden              : QGradient = ... # 0x90
    RichMetal                : QGradient = ... # 0x91
    JuicyCake                : QGradient = ... # 0x92
    SmartIndigo              : QGradient = ... # 0x93
    SandStrike               : QGradient = ... # 0x94
    NorseBeauty              : QGradient = ... # 0x95
    AquaGuidance             : QGradient = ... # 0x96
    SunVeggie                : QGradient = ... # 0x97
    SeaLord                  : QGradient = ... # 0x98
    BlackSea                 : QGradient = ... # 0x99
    GrassShampoo             : QGradient = ... # 0x9a
    LandingAircraft          : QGradient = ... # 0x9b
    WitchDance               : QGradient = ... # 0x9c
    SleeplessNight           : QGradient = ... # 0x9d
    AngelCare                : QGradient = ... # 0x9e
    CrystalRiver             : QGradient = ... # 0x9f
    SoftLipstick             : QGradient = ... # 0xa0
    SaltMountain             : QGradient = ... # 0xa1
    PerfectWhite             : QGradient = ... # 0xa2
    FreshOasis               : QGradient = ... # 0xa3
    StrictNovember           : QGradient = ... # 0xa4
    MorningSalad             : QGradient = ... # 0xa5
    DeepRelief               : QGradient = ... # 0xa6
    SeaStrike                : QGradient = ... # 0xa7
    NightCall                : QGradient = ... # 0xa8
    SupremeSky               : QGradient = ... # 0xa9
    LightBlue                : QGradient = ... # 0xaa
    MindCrawl                : QGradient = ... # 0xab
    LilyMeadow               : QGradient = ... # 0xac
    SugarLollipop            : QGradient = ... # 0xad
    SweetDessert             : QGradient = ... # 0xae
    MagicRay                 : QGradient = ... # 0xaf
    TeenParty                : QGradient = ... # 0xb0
    FrozenHeat               : QGradient = ... # 0xb1
    GagarinView              : QGradient = ... # 0xb2
    FabledSunset             : QGradient = ... # 0xb3
    PerfectBlue              : QGradient = ... # 0xb4
    NumPresets               : QGradient = ... # 0xb5

    class CoordinateMode(object):
        LogicalMode              : QGradient.CoordinateMode = ... # 0x0
        StretchToDeviceMode      : QGradient.CoordinateMode = ... # 0x1
        ObjectBoundingMode       : QGradient.CoordinateMode = ... # 0x2
        ObjectMode               : QGradient.CoordinateMode = ... # 0x3

    class InterpolationMode(object):
        ColorInterpolation       : QGradient.InterpolationMode = ... # 0x0
        ComponentInterpolation   : QGradient.InterpolationMode = ... # 0x1

    class Preset(object):
        WarmFlame                : QGradient.Preset = ... # 0x1
        NightFade                : QGradient.Preset = ... # 0x2
        SpringWarmth             : QGradient.Preset = ... # 0x3
        JuicyPeach               : QGradient.Preset = ... # 0x4
        YoungPassion             : QGradient.Preset = ... # 0x5
        LadyLips                 : QGradient.Preset = ... # 0x6
        SunnyMorning             : QGradient.Preset = ... # 0x7
        RainyAshville            : QGradient.Preset = ... # 0x8
        FrozenDreams             : QGradient.Preset = ... # 0x9
        WinterNeva               : QGradient.Preset = ... # 0xa
        DustyGrass               : QGradient.Preset = ... # 0xb
        TemptingAzure            : QGradient.Preset = ... # 0xc
        HeavyRain                : QGradient.Preset = ... # 0xd
        AmyCrisp                 : QGradient.Preset = ... # 0xe
        MeanFruit                : QGradient.Preset = ... # 0xf
        DeepBlue                 : QGradient.Preset = ... # 0x10
        RipeMalinka              : QGradient.Preset = ... # 0x11
        CloudyKnoxville          : QGradient.Preset = ... # 0x12
        MalibuBeach              : QGradient.Preset = ... # 0x13
        NewLife                  : QGradient.Preset = ... # 0x14
        TrueSunset               : QGradient.Preset = ... # 0x15
        MorpheusDen              : QGradient.Preset = ... # 0x16
        RareWind                 : QGradient.Preset = ... # 0x17
        NearMoon                 : QGradient.Preset = ... # 0x18
        WildApple                : QGradient.Preset = ... # 0x19
        SaintPetersburg          : QGradient.Preset = ... # 0x1a
        PlumPlate                : QGradient.Preset = ... # 0x1c
        EverlastingSky           : QGradient.Preset = ... # 0x1d
        HappyFisher              : QGradient.Preset = ... # 0x1e
        Blessing                 : QGradient.Preset = ... # 0x1f
        SharpeyeEagle            : QGradient.Preset = ... # 0x20
        LadogaBottom             : QGradient.Preset = ... # 0x21
        LemonGate                : QGradient.Preset = ... # 0x22
        ItmeoBranding            : QGradient.Preset = ... # 0x23
        ZeusMiracle              : QGradient.Preset = ... # 0x24
        OldHat                   : QGradient.Preset = ... # 0x25
        StarWine                 : QGradient.Preset = ... # 0x26
        HappyAcid                : QGradient.Preset = ... # 0x29
        AwesomePine              : QGradient.Preset = ... # 0x2a
        NewYork                  : QGradient.Preset = ... # 0x2b
        ShyRainbow               : QGradient.Preset = ... # 0x2c
        MixedHopes               : QGradient.Preset = ... # 0x2e
        FlyHigh                  : QGradient.Preset = ... # 0x2f
        StrongBliss              : QGradient.Preset = ... # 0x30
        FreshMilk                : QGradient.Preset = ... # 0x31
        SnowAgain                : QGradient.Preset = ... # 0x32
        FebruaryInk              : QGradient.Preset = ... # 0x33
        KindSteel                : QGradient.Preset = ... # 0x34
        SoftGrass                : QGradient.Preset = ... # 0x35
        GrownEarly               : QGradient.Preset = ... # 0x36
        SharpBlues               : QGradient.Preset = ... # 0x37
        ShadyWater               : QGradient.Preset = ... # 0x38
        DirtyBeauty              : QGradient.Preset = ... # 0x39
        GreatWhale               : QGradient.Preset = ... # 0x3a
        TeenNotebook             : QGradient.Preset = ... # 0x3b
        PoliteRumors             : QGradient.Preset = ... # 0x3c
        SweetPeriod              : QGradient.Preset = ... # 0x3d
        WideMatrix               : QGradient.Preset = ... # 0x3e
        SoftCherish              : QGradient.Preset = ... # 0x3f
        RedSalvation             : QGradient.Preset = ... # 0x40
        BurningSpring            : QGradient.Preset = ... # 0x41
        NightParty               : QGradient.Preset = ... # 0x42
        SkyGlider                : QGradient.Preset = ... # 0x43
        HeavenPeach              : QGradient.Preset = ... # 0x44
        PurpleDivision           : QGradient.Preset = ... # 0x45
        AquaSplash               : QGradient.Preset = ... # 0x46
        SpikyNaga                : QGradient.Preset = ... # 0x48
        LoveKiss                 : QGradient.Preset = ... # 0x49
        CleanMirror              : QGradient.Preset = ... # 0x4b
        PremiumDark              : QGradient.Preset = ... # 0x4c
        ColdEvening              : QGradient.Preset = ... # 0x4d
        CochitiLake              : QGradient.Preset = ... # 0x4e
        SummerGames              : QGradient.Preset = ... # 0x4f
        PassionateBed            : QGradient.Preset = ... # 0x50
        MountainRock             : QGradient.Preset = ... # 0x51
        DesertHump               : QGradient.Preset = ... # 0x52
        JungleDay                : QGradient.Preset = ... # 0x53
        PhoenixStart             : QGradient.Preset = ... # 0x54
        OctoberSilence           : QGradient.Preset = ... # 0x55
        FarawayRiver             : QGradient.Preset = ... # 0x56
        AlchemistLab             : QGradient.Preset = ... # 0x57
        OverSun                  : QGradient.Preset = ... # 0x58
        PremiumWhite             : QGradient.Preset = ... # 0x59
        MarsParty                : QGradient.Preset = ... # 0x5a
        EternalConstance         : QGradient.Preset = ... # 0x5b
        JapanBlush               : QGradient.Preset = ... # 0x5c
        SmilingRain              : QGradient.Preset = ... # 0x5d
        CloudyApple              : QGradient.Preset = ... # 0x5e
        BigMango                 : QGradient.Preset = ... # 0x5f
        HealthyWater             : QGradient.Preset = ... # 0x60
        AmourAmour               : QGradient.Preset = ... # 0x61
        RiskyConcrete            : QGradient.Preset = ... # 0x62
        StrongStick              : QGradient.Preset = ... # 0x63
        ViciousStance            : QGradient.Preset = ... # 0x64
        PaloAlto                 : QGradient.Preset = ... # 0x65
        HappyMemories            : QGradient.Preset = ... # 0x66
        MidnightBloom            : QGradient.Preset = ... # 0x67
        Crystalline              : QGradient.Preset = ... # 0x68
        PartyBliss               : QGradient.Preset = ... # 0x6a
        ConfidentCloud           : QGradient.Preset = ... # 0x6b
        LeCocktail               : QGradient.Preset = ... # 0x6c
        RiverCity                : QGradient.Preset = ... # 0x6d
        FrozenBerry              : QGradient.Preset = ... # 0x6e
        ChildCare                : QGradient.Preset = ... # 0x70
        FlyingLemon              : QGradient.Preset = ... # 0x71
        NewRetrowave             : QGradient.Preset = ... # 0x72
        HiddenJaguar             : QGradient.Preset = ... # 0x73
        AboveTheSky              : QGradient.Preset = ... # 0x74
        Nega                     : QGradient.Preset = ... # 0x75
        DenseWater               : QGradient.Preset = ... # 0x76
        Seashore                 : QGradient.Preset = ... # 0x78
        MarbleWall               : QGradient.Preset = ... # 0x79
        CheerfulCaramel          : QGradient.Preset = ... # 0x7a
        NightSky                 : QGradient.Preset = ... # 0x7b
        MagicLake                : QGradient.Preset = ... # 0x7c
        YoungGrass               : QGradient.Preset = ... # 0x7d
        ColorfulPeach            : QGradient.Preset = ... # 0x7e
        GentleCare               : QGradient.Preset = ... # 0x7f
        PlumBath                 : QGradient.Preset = ... # 0x80
        HappyUnicorn             : QGradient.Preset = ... # 0x81
        AfricanField             : QGradient.Preset = ... # 0x83
        SolidStone               : QGradient.Preset = ... # 0x84
        OrangeJuice              : QGradient.Preset = ... # 0x85
        GlassWater               : QGradient.Preset = ... # 0x86
        NorthMiracle             : QGradient.Preset = ... # 0x88
        FruitBlend               : QGradient.Preset = ... # 0x89
        MillenniumPine           : QGradient.Preset = ... # 0x8a
        HighFlight               : QGradient.Preset = ... # 0x8b
        MoleHall                 : QGradient.Preset = ... # 0x8c
        SpaceShift               : QGradient.Preset = ... # 0x8e
        ForestInei               : QGradient.Preset = ... # 0x8f
        RoyalGarden              : QGradient.Preset = ... # 0x90
        RichMetal                : QGradient.Preset = ... # 0x91
        JuicyCake                : QGradient.Preset = ... # 0x92
        SmartIndigo              : QGradient.Preset = ... # 0x93
        SandStrike               : QGradient.Preset = ... # 0x94
        NorseBeauty              : QGradient.Preset = ... # 0x95
        AquaGuidance             : QGradient.Preset = ... # 0x96
        SunVeggie                : QGradient.Preset = ... # 0x97
        SeaLord                  : QGradient.Preset = ... # 0x98
        BlackSea                 : QGradient.Preset = ... # 0x99
        GrassShampoo             : QGradient.Preset = ... # 0x9a
        LandingAircraft          : QGradient.Preset = ... # 0x9b
        WitchDance               : QGradient.Preset = ... # 0x9c
        SleeplessNight           : QGradient.Preset = ... # 0x9d
        AngelCare                : QGradient.Preset = ... # 0x9e
        CrystalRiver             : QGradient.Preset = ... # 0x9f
        SoftLipstick             : QGradient.Preset = ... # 0xa0
        SaltMountain             : QGradient.Preset = ... # 0xa1
        PerfectWhite             : QGradient.Preset = ... # 0xa2
        FreshOasis               : QGradient.Preset = ... # 0xa3
        StrictNovember           : QGradient.Preset = ... # 0xa4
        MorningSalad             : QGradient.Preset = ... # 0xa5
        DeepRelief               : QGradient.Preset = ... # 0xa6
        SeaStrike                : QGradient.Preset = ... # 0xa7
        NightCall                : QGradient.Preset = ... # 0xa8
        SupremeSky               : QGradient.Preset = ... # 0xa9
        LightBlue                : QGradient.Preset = ... # 0xaa
        MindCrawl                : QGradient.Preset = ... # 0xab
        LilyMeadow               : QGradient.Preset = ... # 0xac
        SugarLollipop            : QGradient.Preset = ... # 0xad
        SweetDessert             : QGradient.Preset = ... # 0xae
        MagicRay                 : QGradient.Preset = ... # 0xaf
        TeenParty                : QGradient.Preset = ... # 0xb0
        FrozenHeat               : QGradient.Preset = ... # 0xb1
        GagarinView              : QGradient.Preset = ... # 0xb2
        FabledSunset             : QGradient.Preset = ... # 0xb3
        PerfectBlue              : QGradient.Preset = ... # 0xb4
        NumPresets               : QGradient.Preset = ... # 0xb5

    class Spread(object):
        PadSpread                : QGradient.Spread = ... # 0x0
        ReflectSpread            : QGradient.Spread = ... # 0x1
        RepeatSpread             : QGradient.Spread = ... # 0x2

    class Type(object):
        LinearGradient           : QGradient.Type = ... # 0x0
        RadialGradient           : QGradient.Type = ... # 0x1
        ConicalGradient          : QGradient.Type = ... # 0x2
        NoGradient               : QGradient.Type = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QGradient:PySide2.QtGui.QGradient) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QGradient.Preset) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def coordinateMode(self) -> PySide2.QtGui.QGradient.CoordinateMode: ...
    def interpolationMode(self) -> PySide2.QtGui.QGradient.InterpolationMode: ...
    def setColorAt(self, pos:float, color:PySide2.QtGui.QColor) -> None: ...
    def setCoordinateMode(self, mode:PySide2.QtGui.QGradient.CoordinateMode) -> None: ...
    def setInterpolationMode(self, mode:PySide2.QtGui.QGradient.InterpolationMode) -> None: ...
    def setSpread(self, spread:PySide2.QtGui.QGradient.Spread) -> None: ...
    def setStops(self, stops:typing.List) -> None: ...
    def spread(self) -> PySide2.QtGui.QGradient.Spread: ...
    def stops(self) -> typing.List: ...
    def type(self) -> PySide2.QtGui.QGradient.Type: ...


class QGuiApplication(PySide2.QtCore.QCoreApplication):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Sequence) -> None: ...

    @staticmethod
    def allWindows() -> typing.List: ...
    @staticmethod
    def applicationDisplayName() -> str: ...
    @staticmethod
    def applicationState() -> PySide2.QtCore.Qt.ApplicationState: ...
    @staticmethod
    def changeOverrideCursor(arg__1:PySide2.QtGui.QCursor) -> None: ...
    @staticmethod
    def clipboard() -> PySide2.QtGui.QClipboard: ...
    @staticmethod
    def desktopFileName() -> str: ...
    @staticmethod
    def desktopSettingsAware() -> bool: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def focusObject() -> PySide2.QtCore.QObject: ...
    @staticmethod
    def focusWindow() -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @staticmethod
    def highDpiScaleFactorRoundingPolicy() -> PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy: ...
    @staticmethod
    def inputMethod() -> PySide2.QtGui.QInputMethod: ...
    @staticmethod
    def isFallbackSessionManagementEnabled() -> bool: ...
    @staticmethod
    def isLeftToRight() -> bool: ...
    @staticmethod
    def isRightToLeft() -> bool: ...
    def isSavingSession(self) -> bool: ...
    def isSessionRestored(self) -> bool: ...
    @staticmethod
    def keyboardModifiers() -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    @staticmethod
    def layoutDirection() -> PySide2.QtCore.Qt.LayoutDirection: ...
    @staticmethod
    def modalWindow() -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def mouseButtons() -> PySide2.QtCore.Qt.MouseButtons: ...
    def notify(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def overrideCursor() -> PySide2.QtGui.QCursor: ...
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def platformName() -> str: ...
    @staticmethod
    def primaryScreen() -> PySide2.QtGui.QScreen: ...
    @staticmethod
    def queryKeyboardModifiers() -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    @staticmethod
    def quitOnLastWindowClosed() -> bool: ...
    @staticmethod
    def restoreOverrideCursor() -> None: ...
    @staticmethod
    def screenAt(point:PySide2.QtCore.QPoint) -> PySide2.QtGui.QScreen: ...
    @staticmethod
    def screens() -> typing.List: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    @staticmethod
    def setApplicationDisplayName(name:str) -> None: ...
    @staticmethod
    def setDesktopFileName(name:str) -> None: ...
    @staticmethod
    def setDesktopSettingsAware(on:bool) -> None: ...
    @staticmethod
    def setFallbackSessionManagementEnabled(arg__1:bool) -> None: ...
    @staticmethod
    def setFont(arg__1:PySide2.QtGui.QFont) -> None: ...
    @staticmethod
    def setHighDpiScaleFactorRoundingPolicy(policy:PySide2.QtCore.Qt.HighDpiScaleFactorRoundingPolicy) -> None: ...
    @staticmethod
    def setLayoutDirection(direction:PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    @staticmethod
    def setOverrideCursor(arg__1:PySide2.QtGui.QCursor) -> None: ...
    @staticmethod
    def setPalette(pal:PySide2.QtGui.QPalette) -> None: ...
    @staticmethod
    def setQuitOnLastWindowClosed(quit:bool) -> None: ...
    @staticmethod
    def setWindowIcon(icon:PySide2.QtGui.QIcon) -> None: ...
    @staticmethod
    def styleHints() -> PySide2.QtGui.QStyleHints: ...
    @staticmethod
    def sync() -> None: ...
    @staticmethod
    def topLevelAt(pos:PySide2.QtCore.QPoint) -> PySide2.QtGui.QWindow: ...
    @staticmethod
    def topLevelWindows() -> typing.List: ...
    @staticmethod
    def windowIcon() -> PySide2.QtGui.QIcon: ...


class QHelpEvent(PySide2.QtCore.QEvent):

    def __init__(self, type:PySide2.QtCore.QEvent.Type, pos:PySide2.QtCore.QPoint, globalPos:PySide2.QtCore.QPoint) -> None: ...

    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QHideEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QHoverEvent(PySide2.QtGui.QInputEvent):

    def __init__(self, type:PySide2.QtCore.QEvent.Type, pos:PySide2.QtCore.QPointF, oldPos:PySide2.QtCore.QPointF, modifiers:PySide2.QtCore.Qt.KeyboardModifiers=...) -> None: ...

    def oldPos(self) -> PySide2.QtCore.QPoint: ...
    def oldPosF(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...


class QIcon(Shiboken.Object):
    Normal                   : QIcon = ... # 0x0
    On                       : QIcon = ... # 0x0
    Disabled                 : QIcon = ... # 0x1
    Off                      : QIcon = ... # 0x1
    Active                   : QIcon = ... # 0x2
    Selected                 : QIcon = ... # 0x3

    class Mode(object):
        Normal                   : QIcon.Mode = ... # 0x0
        Disabled                 : QIcon.Mode = ... # 0x1
        Active                   : QIcon.Mode = ... # 0x2
        Selected                 : QIcon.Mode = ... # 0x3

    class State(object):
        On                       : QIcon.State = ... # 0x0
        Off                      : QIcon.State = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, engine:PySide2.QtGui.QIconEngine) -> None: ...
    @typing.overload
    def __init__(self, fileName:str) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QIcon) -> None: ...
    @typing.overload
    def __init__(self, pixmap:PySide2.QtGui.QPixmap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def actualSize(self, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def actualSize(self, window:PySide2.QtGui.QWindow, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> PySide2.QtCore.QSize: ...
    def addFile(self, fileName:str, size:PySide2.QtCore.QSize=..., mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> None: ...
    def addPixmap(self, pixmap:PySide2.QtGui.QPixmap, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> None: ...
    def availableSizes(self, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> typing.List: ...
    def cacheKey(self) -> int: ...
    @staticmethod
    def fallbackSearchPaths() -> typing.List: ...
    @staticmethod
    def fallbackThemeName() -> str: ...
    @typing.overload
    @staticmethod
    def fromTheme(name:str) -> PySide2.QtGui.QIcon: ...
    @typing.overload
    @staticmethod
    def fromTheme(name:str, fallback:PySide2.QtGui.QIcon) -> PySide2.QtGui.QIcon: ...
    @staticmethod
    def hasThemeIcon(name:str) -> bool: ...
    def isMask(self) -> bool: ...
    def isNull(self) -> bool: ...
    def name(self) -> str: ...
    @typing.overload
    def paint(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, alignment:PySide2.QtCore.Qt.Alignment=..., mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> None: ...
    @typing.overload
    def paint(self, painter:PySide2.QtGui.QPainter, x:int, y:int, w:int, h:int, alignment:PySide2.QtCore.Qt.Alignment=..., mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> None: ...
    @typing.overload
    def pixmap(self, extent:int, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, w:int, h:int, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def pixmap(self, window:PySide2.QtGui.QWindow, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def setFallbackSearchPaths(paths:typing.Sequence) -> None: ...
    @staticmethod
    def setFallbackThemeName(name:str) -> None: ...
    def setIsMask(self, isMask:bool) -> None: ...
    @staticmethod
    def setThemeName(path:str) -> None: ...
    @staticmethod
    def setThemeSearchPaths(searchpath:typing.Sequence) -> None: ...
    def swap(self, other:PySide2.QtGui.QIcon) -> None: ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def themeSearchPaths() -> typing.List: ...


class QIconDragEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QIconEngine(Shiboken.Object):
    AvailableSizesHook       : QIconEngine = ... # 0x1
    IconNameHook             : QIconEngine = ... # 0x2
    IsNullHook               : QIconEngine = ... # 0x3
    ScaledPixmapHook         : QIconEngine = ... # 0x4

    class AvailableSizesArgument(Shiboken.Object):

        def __init__(self) -> None: ...


    class IconEngineHook(object):
        AvailableSizesHook       : QIconEngine.IconEngineHook = ... # 0x1
        IconNameHook             : QIconEngine.IconEngineHook = ... # 0x2
        IsNullHook               : QIconEngine.IconEngineHook = ... # 0x3
        ScaledPixmapHook         : QIconEngine.IconEngineHook = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QIconEngine) -> None: ...

    def actualSize(self, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode, state:PySide2.QtGui.QIcon.State) -> PySide2.QtCore.QSize: ...
    def addFile(self, fileName:str, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode, state:PySide2.QtGui.QIcon.State) -> None: ...
    def addPixmap(self, pixmap:PySide2.QtGui.QPixmap, mode:PySide2.QtGui.QIcon.Mode, state:PySide2.QtGui.QIcon.State) -> None: ...
    def availableSizes(self, mode:PySide2.QtGui.QIcon.Mode=..., state:PySide2.QtGui.QIcon.State=...) -> typing.List: ...
    def clone(self) -> PySide2.QtGui.QIconEngine: ...
    def iconName(self) -> str: ...
    def isNull(self) -> bool: ...
    def key(self) -> str: ...
    def paint(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, mode:PySide2.QtGui.QIcon.Mode, state:PySide2.QtGui.QIcon.State) -> None: ...
    def pixmap(self, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode, state:PySide2.QtGui.QIcon.State) -> PySide2.QtGui.QPixmap: ...
    def read(self, in_:PySide2.QtCore.QDataStream) -> bool: ...
    def scaledPixmap(self, size:PySide2.QtCore.QSize, mode:PySide2.QtGui.QIcon.Mode, state:PySide2.QtGui.QIcon.State, scale:float) -> PySide2.QtGui.QPixmap: ...
    def write(self, out:PySide2.QtCore.QDataStream) -> bool: ...


class QImage(PySide2.QtGui.QPaintDevice):
    Format_Invalid           : QImage = ... # 0x0
    InvertRgb                : QImage = ... # 0x0
    Format_Mono              : QImage = ... # 0x1
    InvertRgba               : QImage = ... # 0x1
    Format_MonoLSB           : QImage = ... # 0x2
    Format_Indexed8          : QImage = ... # 0x3
    Format_RGB32             : QImage = ... # 0x4
    Format_ARGB32            : QImage = ... # 0x5
    Format_ARGB32_Premultiplied: QImage = ... # 0x6
    Format_RGB16             : QImage = ... # 0x7
    Format_ARGB8565_Premultiplied: QImage = ... # 0x8
    Format_RGB666            : QImage = ... # 0x9
    Format_ARGB6666_Premultiplied: QImage = ... # 0xa
    Format_RGB555            : QImage = ... # 0xb
    Format_ARGB8555_Premultiplied: QImage = ... # 0xc
    Format_RGB888            : QImage = ... # 0xd
    Format_RGB444            : QImage = ... # 0xe
    Format_ARGB4444_Premultiplied: QImage = ... # 0xf
    Format_RGBX8888          : QImage = ... # 0x10
    Format_RGBA8888          : QImage = ... # 0x11
    Format_RGBA8888_Premultiplied: QImage = ... # 0x12
    Format_BGR30             : QImage = ... # 0x13
    Format_A2BGR30_Premultiplied: QImage = ... # 0x14
    Format_RGB30             : QImage = ... # 0x15
    Format_A2RGB30_Premultiplied: QImage = ... # 0x16
    Format_Alpha8            : QImage = ... # 0x17
    Format_Grayscale8        : QImage = ... # 0x18
    Format_RGBX64            : QImage = ... # 0x19
    Format_RGBA64            : QImage = ... # 0x1a
    Format_RGBA64_Premultiplied: QImage = ... # 0x1b
    Format_Grayscale16       : QImage = ... # 0x1c
    Format_BGR888            : QImage = ... # 0x1d
    NImageFormats            : QImage = ... # 0x1e

    class Format(object):
        Format_Invalid           : QImage.Format = ... # 0x0
        Format_Mono              : QImage.Format = ... # 0x1
        Format_MonoLSB           : QImage.Format = ... # 0x2
        Format_Indexed8          : QImage.Format = ... # 0x3
        Format_RGB32             : QImage.Format = ... # 0x4
        Format_ARGB32            : QImage.Format = ... # 0x5
        Format_ARGB32_Premultiplied: QImage.Format = ... # 0x6
        Format_RGB16             : QImage.Format = ... # 0x7
        Format_ARGB8565_Premultiplied: QImage.Format = ... # 0x8
        Format_RGB666            : QImage.Format = ... # 0x9
        Format_ARGB6666_Premultiplied: QImage.Format = ... # 0xa
        Format_RGB555            : QImage.Format = ... # 0xb
        Format_ARGB8555_Premultiplied: QImage.Format = ... # 0xc
        Format_RGB888            : QImage.Format = ... # 0xd
        Format_RGB444            : QImage.Format = ... # 0xe
        Format_ARGB4444_Premultiplied: QImage.Format = ... # 0xf
        Format_RGBX8888          : QImage.Format = ... # 0x10
        Format_RGBA8888          : QImage.Format = ... # 0x11
        Format_RGBA8888_Premultiplied: QImage.Format = ... # 0x12
        Format_BGR30             : QImage.Format = ... # 0x13
        Format_A2BGR30_Premultiplied: QImage.Format = ... # 0x14
        Format_RGB30             : QImage.Format = ... # 0x15
        Format_A2RGB30_Premultiplied: QImage.Format = ... # 0x16
        Format_Alpha8            : QImage.Format = ... # 0x17
        Format_Grayscale8        : QImage.Format = ... # 0x18
        Format_RGBX64            : QImage.Format = ... # 0x19
        Format_RGBA64            : QImage.Format = ... # 0x1a
        Format_RGBA64_Premultiplied: QImage.Format = ... # 0x1b
        Format_Grayscale16       : QImage.Format = ... # 0x1c
        Format_BGR888            : QImage.Format = ... # 0x1d
        NImageFormats            : QImage.Format = ... # 0x1e

    class InvertMode(object):
        InvertRgb                : QImage.InvertMode = ... # 0x0
        InvertRgba               : QImage.InvertMode = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, arg__1:str, arg__2:int, arg__3:int, arg__4:PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, arg__1:str, arg__2:int, arg__3:int, arg__4:int, arg__5:PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, data:bytes, width:int, height:int, bytesPerLine:int, format:PySide2.QtGui.QImage.Format, cleanupFunction:typing.Optional[typing.Callable]=..., cleanupInfo:typing.Optional[int]=...) -> None: ...
    @typing.overload
    def __init__(self, data:bytes, width:int, height:int, format:PySide2.QtGui.QImage.Format, cleanupFunction:typing.Optional[typing.Callable]=..., cleanupInfo:typing.Optional[int]=...) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:typing.Optional[bytes]=...) -> None: ...
    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, format:PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, format:PySide2.QtGui.QImage.Format) -> None: ...
    @typing.overload
    def __init__(self, xpm:typing.Sequence) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def allGray(self) -> bool: ...
    def alphaChannel(self) -> PySide2.QtGui.QImage: ...
    def bitPlaneCount(self) -> int: ...
    def bits(self) -> bytes: ...
    def byteCount(self) -> int: ...
    def bytesPerLine(self) -> int: ...
    def cacheKey(self) -> int: ...
    def color(self, i:int) -> int: ...
    def colorCount(self) -> int: ...
    def colorSpace(self) -> PySide2.QtGui.QColorSpace: ...
    def colorTable(self) -> typing.List: ...
    def constBits(self) -> bytes: ...
    def constScanLine(self, arg__1:int) -> bytes: ...
    def convertTo(self, f:PySide2.QtGui.QImage.Format, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    def convertToColorSpace(self, arg__1:PySide2.QtGui.QColorSpace) -> None: ...
    @typing.overload
    def convertToFormat(self, f:PySide2.QtGui.QImage.Format, colorTable:typing.List, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def convertToFormat(self, f:PySide2.QtGui.QImage.Format, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QImage: ...
    def convertToFormat_helper(self, format:PySide2.QtGui.QImage.Format, flags:PySide2.QtCore.Qt.ImageConversionFlags) -> PySide2.QtGui.QImage: ...
    def convertToFormat_inplace(self, format:PySide2.QtGui.QImage.Format, flags:PySide2.QtCore.Qt.ImageConversionFlags) -> bool: ...
    def convertedToColorSpace(self, arg__1:PySide2.QtGui.QColorSpace) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def copy(self, rect:PySide2.QtCore.QRect=...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def copy(self, x:int, y:int, w:int, h:int) -> PySide2.QtGui.QImage: ...
    def createAlphaMask(self, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QImage: ...
    def createHeuristicMask(self, clipTight:bool=...) -> PySide2.QtGui.QImage: ...
    def createMaskFromColor(self, color:int, mode:PySide2.QtCore.Qt.MaskMode=...) -> PySide2.QtGui.QImage: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def dotsPerMeterX(self) -> int: ...
    def dotsPerMeterY(self) -> int: ...
    @typing.overload
    def fill(self, color:PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fill(self, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def fill(self, pixel:int) -> None: ...
    def format(self) -> PySide2.QtGui.QImage.Format: ...
    @staticmethod
    def fromData(data:PySide2.QtCore.QByteArray, format:typing.Optional[bytes]=...) -> PySide2.QtGui.QImage: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def invertPixels(self, mode:PySide2.QtGui.QImage.InvertMode=...) -> None: ...
    def isGrayscale(self) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def load(self, device:PySide2.QtCore.QIODevice, format:bytes) -> bool: ...
    @typing.overload
    def load(self, fileName:str, format:typing.Optional[bytes]=...) -> bool: ...
    def loadFromData(self, data:PySide2.QtCore.QByteArray, aformat:typing.Optional[bytes]=...) -> bool: ...
    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def mirrored(self, horizontally:bool=..., vertically:bool=...) -> PySide2.QtGui.QImage: ...
    def mirrored_helper(self, horizontal:bool, vertical:bool) -> PySide2.QtGui.QImage: ...
    def mirrored_inplace(self, horizontal:bool, vertical:bool) -> None: ...
    def offset(self) -> PySide2.QtCore.QPoint: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    @typing.overload
    def pixel(self, pt:PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def pixel(self, x:int, y:int) -> int: ...
    @typing.overload
    def pixelColor(self, pt:PySide2.QtCore.QPoint) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def pixelColor(self, x:int, y:int) -> PySide2.QtGui.QColor: ...
    def pixelFormat(self) -> PySide2.QtGui.QPixelFormat: ...
    @typing.overload
    def pixelIndex(self, pt:PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def pixelIndex(self, x:int, y:int) -> int: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def reinterpretAsFormat(self, f:PySide2.QtGui.QImage.Format) -> bool: ...
    def rgbSwapped(self) -> PySide2.QtGui.QImage: ...
    def rgbSwapped_helper(self) -> PySide2.QtGui.QImage: ...
    def rgbSwapped_inplace(self) -> None: ...
    @typing.overload
    def save(self, device:PySide2.QtCore.QIODevice, format:typing.Optional[bytes]=..., quality:int=...) -> bool: ...
    @typing.overload
    def save(self, fileName:str, format:typing.Optional[bytes]=..., quality:int=...) -> bool: ...
    @typing.overload
    def scaled(self, s:PySide2.QtCore.QSize, aspectMode:PySide2.QtCore.Qt.AspectRatioMode=..., mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def scaled(self, w:int, h:int, aspectMode:PySide2.QtCore.Qt.AspectRatioMode=..., mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QImage: ...
    def scaledToHeight(self, h:int, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QImage: ...
    def scaledToWidth(self, w:int, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QImage: ...
    def scanLine(self, arg__1:int) -> bytes: ...
    def setAlphaChannel(self, alphaChannel:PySide2.QtGui.QImage) -> None: ...
    def setColor(self, i:int, c:int) -> None: ...
    def setColorCount(self, arg__1:int) -> None: ...
    def setColorSpace(self, arg__1:PySide2.QtGui.QColorSpace) -> None: ...
    def setColorTable(self, colors:typing.List) -> None: ...
    def setDevicePixelRatio(self, scaleFactor:float) -> None: ...
    def setDotsPerMeterX(self, arg__1:int) -> None: ...
    def setDotsPerMeterY(self, arg__1:int) -> None: ...
    def setOffset(self, arg__1:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def setPixel(self, pt:PySide2.QtCore.QPoint, index_or_rgb:int) -> None: ...
    @typing.overload
    def setPixel(self, x:int, y:int, index_or_rgb:int) -> None: ...
    @typing.overload
    def setPixelColor(self, pt:PySide2.QtCore.QPoint, c:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setPixelColor(self, x:int, y:int, c:PySide2.QtGui.QColor) -> None: ...
    def setText(self, key:str, value:str) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeInBytes(self) -> int: ...
    def smoothScaled(self, w:int, h:int) -> PySide2.QtGui.QImage: ...
    def swap(self, other:PySide2.QtGui.QImage) -> None: ...
    def text(self, key:str=...) -> str: ...
    def textKeys(self) -> typing.List: ...
    @staticmethod
    def toImageFormat(format:PySide2.QtGui.QPixelFormat) -> PySide2.QtGui.QImage.Format: ...
    @staticmethod
    def toPixelFormat(format:PySide2.QtGui.QImage.Format) -> PySide2.QtGui.QPixelFormat: ...
    @typing.overload
    def transformed(self, matrix:PySide2.QtGui.QMatrix, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def transformed(self, matrix:PySide2.QtGui.QTransform, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QImage: ...
    @typing.overload
    @staticmethod
    def trueMatrix(arg__1:PySide2.QtGui.QMatrix, w:int, h:int) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    @staticmethod
    def trueMatrix(arg__1:PySide2.QtGui.QTransform, w:int, h:int) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def valid(self, pt:PySide2.QtCore.QPoint) -> bool: ...
    @typing.overload
    def valid(self, x:int, y:int) -> bool: ...
    def width(self) -> int: ...


class QImageIOHandler(Shiboken.Object):
    Size                     : QImageIOHandler = ... # 0x0
    TransformationNone       : QImageIOHandler = ... # 0x0
    ClipRect                 : QImageIOHandler = ... # 0x1
    TransformationMirror     : QImageIOHandler = ... # 0x1
    Description              : QImageIOHandler = ... # 0x2
    TransformationFlip       : QImageIOHandler = ... # 0x2
    ScaledClipRect           : QImageIOHandler = ... # 0x3
    TransformationRotate180  : QImageIOHandler = ... # 0x3
    ScaledSize               : QImageIOHandler = ... # 0x4
    TransformationRotate90   : QImageIOHandler = ... # 0x4
    CompressionRatio         : QImageIOHandler = ... # 0x5
    TransformationMirrorAndRotate90: QImageIOHandler = ... # 0x5
    Gamma                    : QImageIOHandler = ... # 0x6
    TransformationFlipAndRotate90: QImageIOHandler = ... # 0x6
    Quality                  : QImageIOHandler = ... # 0x7
    TransformationRotate270  : QImageIOHandler = ... # 0x7
    Name                     : QImageIOHandler = ... # 0x8
    SubType                  : QImageIOHandler = ... # 0x9
    IncrementalReading       : QImageIOHandler = ... # 0xa
    Endianness               : QImageIOHandler = ... # 0xb
    Animation                : QImageIOHandler = ... # 0xc
    BackgroundColor          : QImageIOHandler = ... # 0xd
    ImageFormat              : QImageIOHandler = ... # 0xe
    SupportedSubTypes        : QImageIOHandler = ... # 0xf
    OptimizedWrite           : QImageIOHandler = ... # 0x10
    ProgressiveScanWrite     : QImageIOHandler = ... # 0x11
    ImageTransformation      : QImageIOHandler = ... # 0x12
    TransformedByDefault     : QImageIOHandler = ... # 0x13

    class ImageOption(object):
        Size                     : QImageIOHandler.ImageOption = ... # 0x0
        ClipRect                 : QImageIOHandler.ImageOption = ... # 0x1
        Description              : QImageIOHandler.ImageOption = ... # 0x2
        ScaledClipRect           : QImageIOHandler.ImageOption = ... # 0x3
        ScaledSize               : QImageIOHandler.ImageOption = ... # 0x4
        CompressionRatio         : QImageIOHandler.ImageOption = ... # 0x5
        Gamma                    : QImageIOHandler.ImageOption = ... # 0x6
        Quality                  : QImageIOHandler.ImageOption = ... # 0x7
        Name                     : QImageIOHandler.ImageOption = ... # 0x8
        SubType                  : QImageIOHandler.ImageOption = ... # 0x9
        IncrementalReading       : QImageIOHandler.ImageOption = ... # 0xa
        Endianness               : QImageIOHandler.ImageOption = ... # 0xb
        Animation                : QImageIOHandler.ImageOption = ... # 0xc
        BackgroundColor          : QImageIOHandler.ImageOption = ... # 0xd
        ImageFormat              : QImageIOHandler.ImageOption = ... # 0xe
        SupportedSubTypes        : QImageIOHandler.ImageOption = ... # 0xf
        OptimizedWrite           : QImageIOHandler.ImageOption = ... # 0x10
        ProgressiveScanWrite     : QImageIOHandler.ImageOption = ... # 0x11
        ImageTransformation      : QImageIOHandler.ImageOption = ... # 0x12
        TransformedByDefault     : QImageIOHandler.ImageOption = ... # 0x13

    class Transformation(object):
        TransformationNone       : QImageIOHandler.Transformation = ... # 0x0
        TransformationMirror     : QImageIOHandler.Transformation = ... # 0x1
        TransformationFlip       : QImageIOHandler.Transformation = ... # 0x2
        TransformationRotate180  : QImageIOHandler.Transformation = ... # 0x3
        TransformationRotate90   : QImageIOHandler.Transformation = ... # 0x4
        TransformationMirrorAndRotate90: QImageIOHandler.Transformation = ... # 0x5
        TransformationFlipAndRotate90: QImageIOHandler.Transformation = ... # 0x6
        TransformationRotate270  : QImageIOHandler.Transformation = ... # 0x7

    class Transformations(object): ...

    def __init__(self) -> None: ...

    def canRead(self) -> bool: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide2.QtCore.QRect: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def imageCount(self) -> int: ...
    def jumpToImage(self, imageNumber:int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    def nextImageDelay(self) -> int: ...
    def option(self, option:PySide2.QtGui.QImageIOHandler.ImageOption) -> typing.Any: ...
    def read(self, image:PySide2.QtGui.QImage) -> bool: ...
    def setDevice(self, device:PySide2.QtCore.QIODevice) -> None: ...
    def setFormat(self, format:PySide2.QtCore.QByteArray) -> None: ...
    def setOption(self, option:PySide2.QtGui.QImageIOHandler.ImageOption, value:typing.Any) -> None: ...
    def supportsOption(self, option:PySide2.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def write(self, image:PySide2.QtGui.QImage) -> bool: ...


class QImageReader(Shiboken.Object):
    UnknownError             : QImageReader = ... # 0x0
    FileNotFoundError        : QImageReader = ... # 0x1
    DeviceError              : QImageReader = ... # 0x2
    UnsupportedFormatError   : QImageReader = ... # 0x3
    InvalidDataError         : QImageReader = ... # 0x4

    class ImageReaderError(object):
        UnknownError             : QImageReader.ImageReaderError = ... # 0x0
        FileNotFoundError        : QImageReader.ImageReaderError = ... # 0x1
        DeviceError              : QImageReader.ImageReaderError = ... # 0x2
        UnsupportedFormatError   : QImageReader.ImageReaderError = ... # 0x3
        InvalidDataError         : QImageReader.ImageReaderError = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device:PySide2.QtCore.QIODevice, format:PySide2.QtCore.QByteArray=...) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:PySide2.QtCore.QByteArray=...) -> None: ...

    def autoDetectImageFormat(self) -> bool: ...
    def autoTransform(self) -> bool: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def canRead(self) -> bool: ...
    def clipRect(self) -> PySide2.QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def currentImageRect(self) -> PySide2.QtCore.QRect: ...
    def decideFormatFromContent(self) -> bool: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def error(self) -> PySide2.QtGui.QImageReader.ImageReaderError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def gamma(self) -> float: ...
    def imageCount(self) -> int: ...
    @typing.overload
    @staticmethod
    def imageFormat(device:PySide2.QtCore.QIODevice) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def imageFormat(fileName:str) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    def imageFormat(self) -> PySide2.QtGui.QImage.Format: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType:PySide2.QtCore.QByteArray) -> typing.List: ...
    def jumpToImage(self, imageNumber:int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def loopCount(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def quality(self) -> int: ...
    def read(self) -> PySide2.QtGui.QImage: ...
    def scaledClipRect(self) -> PySide2.QtCore.QRect: ...
    def scaledSize(self) -> PySide2.QtCore.QSize: ...
    def setAutoDetectImageFormat(self, enabled:bool) -> None: ...
    def setAutoTransform(self, enabled:bool) -> None: ...
    def setBackgroundColor(self, color:PySide2.QtGui.QColor) -> None: ...
    def setClipRect(self, rect:PySide2.QtCore.QRect) -> None: ...
    def setDecideFormatFromContent(self, ignored:bool) -> None: ...
    def setDevice(self, device:PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName:str) -> None: ...
    def setFormat(self, format:PySide2.QtCore.QByteArray) -> None: ...
    def setGamma(self, gamma:float) -> None: ...
    def setQuality(self, quality:int) -> None: ...
    def setScaledClipRect(self, rect:PySide2.QtCore.QRect) -> None: ...
    def setScaledSize(self, size:PySide2.QtCore.QSize) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def subType(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> typing.List: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List: ...
    def supportedSubTypes(self) -> typing.List: ...
    def supportsAnimation(self) -> bool: ...
    def supportsOption(self, option:PySide2.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def text(self, key:str) -> str: ...
    def textKeys(self) -> typing.List: ...
    def transformation(self) -> PySide2.QtGui.QImageIOHandler.Transformations: ...


class QImageWriter(Shiboken.Object):
    UnknownError             : QImageWriter = ... # 0x0
    DeviceError              : QImageWriter = ... # 0x1
    UnsupportedFormatError   : QImageWriter = ... # 0x2
    InvalidImageError        : QImageWriter = ... # 0x3

    class ImageWriterError(object):
        UnknownError             : QImageWriter.ImageWriterError = ... # 0x0
        DeviceError              : QImageWriter.ImageWriterError = ... # 0x1
        UnsupportedFormatError   : QImageWriter.ImageWriterError = ... # 0x2
        InvalidImageError        : QImageWriter.ImageWriterError = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device:PySide2.QtCore.QIODevice, format:PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:PySide2.QtCore.QByteArray=...) -> None: ...

    def canWrite(self) -> bool: ...
    def compression(self) -> int: ...
    def description(self) -> str: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def error(self) -> PySide2.QtGui.QImageWriter.ImageWriterError: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def gamma(self) -> float: ...
    @staticmethod
    def imageFormatsForMimeType(mimeType:PySide2.QtCore.QByteArray) -> typing.List: ...
    def optimizedWrite(self) -> bool: ...
    def progressiveScanWrite(self) -> bool: ...
    def quality(self) -> int: ...
    def setCompression(self, compression:int) -> None: ...
    def setDescription(self, description:str) -> None: ...
    def setDevice(self, device:PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName:str) -> None: ...
    def setFormat(self, format:PySide2.QtCore.QByteArray) -> None: ...
    def setGamma(self, gamma:float) -> None: ...
    def setOptimizedWrite(self, optimize:bool) -> None: ...
    def setProgressiveScanWrite(self, progressive:bool) -> None: ...
    def setQuality(self, quality:int) -> None: ...
    def setSubType(self, type:PySide2.QtCore.QByteArray) -> None: ...
    def setText(self, key:str, text:str) -> None: ...
    def setTransformation(self, orientation:PySide2.QtGui.QImageIOHandler.Transformations) -> None: ...
    def subType(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def supportedImageFormats() -> typing.List: ...
    @staticmethod
    def supportedMimeTypes() -> typing.List: ...
    def supportedSubTypes(self) -> typing.List: ...
    def supportsOption(self, option:PySide2.QtGui.QImageIOHandler.ImageOption) -> bool: ...
    def transformation(self) -> PySide2.QtGui.QImageIOHandler.Transformations: ...
    def write(self, image:PySide2.QtGui.QImage) -> bool: ...


class QInputEvent(PySide2.QtCore.QEvent):

    def __init__(self, type:PySide2.QtCore.QEvent.Type, modifiers:PySide2.QtCore.Qt.KeyboardModifiers=...) -> None: ...

    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def setModifiers(self, amodifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    def setTimestamp(self, atimestamp:int) -> None: ...
    def timestamp(self) -> int: ...


class QInputMethod(PySide2.QtCore.QObject):
    Click                    : QInputMethod = ... # 0x0
    ContextMenu              : QInputMethod = ... # 0x1

    class Action(object):
        Click                    : QInputMethod.Action = ... # 0x0
        ContextMenu              : QInputMethod.Action = ... # 0x1
    def anchorRectangle(self) -> PySide2.QtCore.QRectF: ...
    def commit(self) -> None: ...
    def cursorRectangle(self) -> PySide2.QtCore.QRectF: ...
    def hide(self) -> None: ...
    def inputDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def inputItemClipRectangle(self) -> PySide2.QtCore.QRectF: ...
    def inputItemRectangle(self) -> PySide2.QtCore.QRectF: ...
    def inputItemTransform(self) -> PySide2.QtGui.QTransform: ...
    def invokeAction(self, a:PySide2.QtGui.QInputMethod.Action, cursorPosition:int) -> None: ...
    def isAnimating(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyboardRectangle(self) -> PySide2.QtCore.QRectF: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    @staticmethod
    def queryFocusObject(query:PySide2.QtCore.Qt.InputMethodQuery, argument:typing.Any) -> typing.Any: ...
    def reset(self) -> None: ...
    def setInputItemRectangle(self, rect:PySide2.QtCore.QRectF) -> None: ...
    def setInputItemTransform(self, transform:PySide2.QtGui.QTransform) -> None: ...
    def setVisible(self, visible:bool) -> None: ...
    def show(self) -> None: ...
    def update(self, queries:PySide2.QtCore.Qt.InputMethodQueries) -> None: ...


class QInputMethodEvent(PySide2.QtCore.QEvent):
    TextFormat               : QInputMethodEvent = ... # 0x0
    Cursor                   : QInputMethodEvent = ... # 0x1
    Language                 : QInputMethodEvent = ... # 0x2
    Ruby                     : QInputMethodEvent = ... # 0x3
    Selection                : QInputMethodEvent = ... # 0x4

    class Attribute(Shiboken.Object):

        @typing.overload
        def __init__(self, Attribute:PySide2.QtGui.QInputMethodEvent.Attribute) -> None: ...
        @typing.overload
        def __init__(self, typ:PySide2.QtGui.QInputMethodEvent.AttributeType, s:int, l:int) -> None: ...
        @typing.overload
        def __init__(self, typ:PySide2.QtGui.QInputMethodEvent.AttributeType, s:int, l:int, val:typing.Any) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class AttributeType(object):
        TextFormat               : QInputMethodEvent.AttributeType = ... # 0x0
        Cursor                   : QInputMethodEvent.AttributeType = ... # 0x1
        Language                 : QInputMethodEvent.AttributeType = ... # 0x2
        Ruby                     : QInputMethodEvent.AttributeType = ... # 0x3
        Selection                : QInputMethodEvent.AttributeType = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QInputMethodEvent) -> None: ...
    @typing.overload
    def __init__(self, preeditText:str, attributes:typing.Sequence) -> None: ...

    def attributes(self) -> typing.List: ...
    def commitString(self) -> str: ...
    def preeditString(self) -> str: ...
    def replacementLength(self) -> int: ...
    def replacementStart(self) -> int: ...
    def setCommitString(self, commitString:str, replaceFrom:int=..., replaceLength:int=...) -> None: ...


class QInputMethodQueryEvent(PySide2.QtCore.QEvent):

    def __init__(self, queries:PySide2.QtCore.Qt.InputMethodQueries) -> None: ...

    def queries(self) -> PySide2.QtCore.Qt.InputMethodQueries: ...
    def setValue(self, query:PySide2.QtCore.Qt.InputMethodQuery, value:typing.Any) -> None: ...
    def value(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...


class QIntValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, bottom:int, top:int, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def bottom(self) -> int: ...
    def fixup(self, input:str) -> None: ...
    def setBottom(self, arg__1:int) -> None: ...
    def setRange(self, bottom:int, top:int) -> None: ...
    def setTop(self, arg__1:int) -> None: ...
    def top(self) -> int: ...
    def validate(self, arg__1:str, arg__2:int) -> PySide2.QtGui.QValidator.State: ...


class QKeyEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type:PySide2.QtCore.QEvent.Type, key:int, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, nativeScanCode:int, nativeVirtualKey:int, nativeModifiers:int, text:str=..., autorep:bool=..., count:int=...) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtCore.QEvent.Type, key:int, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, text:str=..., autorep:bool=..., count:int=...) -> None: ...

    def count(self) -> int: ...
    def isAutoRepeat(self) -> bool: ...
    def key(self) -> int: ...
    def matches(self, key:PySide2.QtGui.QKeySequence.StandardKey) -> bool: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def nativeModifiers(self) -> int: ...
    def nativeScanCode(self) -> int: ...
    def nativeVirtualKey(self) -> int: ...
    def text(self) -> str: ...


class QKeySequence(Shiboken.Object):
    NativeText               : QKeySequence = ... # 0x0
    NoMatch                  : QKeySequence = ... # 0x0
    UnknownKey               : QKeySequence = ... # 0x0
    HelpContents             : QKeySequence = ... # 0x1
    PartialMatch             : QKeySequence = ... # 0x1
    PortableText             : QKeySequence = ... # 0x1
    ExactMatch               : QKeySequence = ... # 0x2
    WhatsThis                : QKeySequence = ... # 0x2
    Open                     : QKeySequence = ... # 0x3
    Close                    : QKeySequence = ... # 0x4
    Save                     : QKeySequence = ... # 0x5
    New                      : QKeySequence = ... # 0x6
    Delete                   : QKeySequence = ... # 0x7
    Cut                      : QKeySequence = ... # 0x8
    Copy                     : QKeySequence = ... # 0x9
    Paste                    : QKeySequence = ... # 0xa
    Undo                     : QKeySequence = ... # 0xb
    Redo                     : QKeySequence = ... # 0xc
    Back                     : QKeySequence = ... # 0xd
    Forward                  : QKeySequence = ... # 0xe
    Refresh                  : QKeySequence = ... # 0xf
    ZoomIn                   : QKeySequence = ... # 0x10
    ZoomOut                  : QKeySequence = ... # 0x11
    Print                    : QKeySequence = ... # 0x12
    AddTab                   : QKeySequence = ... # 0x13
    NextChild                : QKeySequence = ... # 0x14
    PreviousChild            : QKeySequence = ... # 0x15
    Find                     : QKeySequence = ... # 0x16
    FindNext                 : QKeySequence = ... # 0x17
    FindPrevious             : QKeySequence = ... # 0x18
    Replace                  : QKeySequence = ... # 0x19
    SelectAll                : QKeySequence = ... # 0x1a
    Bold                     : QKeySequence = ... # 0x1b
    Italic                   : QKeySequence = ... # 0x1c
    Underline                : QKeySequence = ... # 0x1d
    MoveToNextChar           : QKeySequence = ... # 0x1e
    MoveToPreviousChar       : QKeySequence = ... # 0x1f
    MoveToNextWord           : QKeySequence = ... # 0x20
    MoveToPreviousWord       : QKeySequence = ... # 0x21
    MoveToNextLine           : QKeySequence = ... # 0x22
    MoveToPreviousLine       : QKeySequence = ... # 0x23
    MoveToNextPage           : QKeySequence = ... # 0x24
    MoveToPreviousPage       : QKeySequence = ... # 0x25
    MoveToStartOfLine        : QKeySequence = ... # 0x26
    MoveToEndOfLine          : QKeySequence = ... # 0x27
    MoveToStartOfBlock       : QKeySequence = ... # 0x28
    MoveToEndOfBlock         : QKeySequence = ... # 0x29
    MoveToStartOfDocument    : QKeySequence = ... # 0x2a
    MoveToEndOfDocument      : QKeySequence = ... # 0x2b
    SelectNextChar           : QKeySequence = ... # 0x2c
    SelectPreviousChar       : QKeySequence = ... # 0x2d
    SelectNextWord           : QKeySequence = ... # 0x2e
    SelectPreviousWord       : QKeySequence = ... # 0x2f
    SelectNextLine           : QKeySequence = ... # 0x30
    SelectPreviousLine       : QKeySequence = ... # 0x31
    SelectNextPage           : QKeySequence = ... # 0x32
    SelectPreviousPage       : QKeySequence = ... # 0x33
    SelectStartOfLine        : QKeySequence = ... # 0x34
    SelectEndOfLine          : QKeySequence = ... # 0x35
    SelectStartOfBlock       : QKeySequence = ... # 0x36
    SelectEndOfBlock         : QKeySequence = ... # 0x37
    SelectStartOfDocument    : QKeySequence = ... # 0x38
    SelectEndOfDocument      : QKeySequence = ... # 0x39
    DeleteStartOfWord        : QKeySequence = ... # 0x3a
    DeleteEndOfWord          : QKeySequence = ... # 0x3b
    DeleteEndOfLine          : QKeySequence = ... # 0x3c
    InsertParagraphSeparator : QKeySequence = ... # 0x3d
    InsertLineSeparator      : QKeySequence = ... # 0x3e
    SaveAs                   : QKeySequence = ... # 0x3f
    Preferences              : QKeySequence = ... # 0x40
    Quit                     : QKeySequence = ... # 0x41
    FullScreen               : QKeySequence = ... # 0x42
    Deselect                 : QKeySequence = ... # 0x43
    DeleteCompleteLine       : QKeySequence = ... # 0x44
    Backspace                : QKeySequence = ... # 0x45
    Cancel                   : QKeySequence = ... # 0x46

    class SequenceFormat(object):
        NativeText               : QKeySequence.SequenceFormat = ... # 0x0
        PortableText             : QKeySequence.SequenceFormat = ... # 0x1

    class SequenceMatch(object):
        NoMatch                  : QKeySequence.SequenceMatch = ... # 0x0
        PartialMatch             : QKeySequence.SequenceMatch = ... # 0x1
        ExactMatch               : QKeySequence.SequenceMatch = ... # 0x2

    class StandardKey(object):
        UnknownKey               : QKeySequence.StandardKey = ... # 0x0
        HelpContents             : QKeySequence.StandardKey = ... # 0x1
        WhatsThis                : QKeySequence.StandardKey = ... # 0x2
        Open                     : QKeySequence.StandardKey = ... # 0x3
        Close                    : QKeySequence.StandardKey = ... # 0x4
        Save                     : QKeySequence.StandardKey = ... # 0x5
        New                      : QKeySequence.StandardKey = ... # 0x6
        Delete                   : QKeySequence.StandardKey = ... # 0x7
        Cut                      : QKeySequence.StandardKey = ... # 0x8
        Copy                     : QKeySequence.StandardKey = ... # 0x9
        Paste                    : QKeySequence.StandardKey = ... # 0xa
        Undo                     : QKeySequence.StandardKey = ... # 0xb
        Redo                     : QKeySequence.StandardKey = ... # 0xc
        Back                     : QKeySequence.StandardKey = ... # 0xd
        Forward                  : QKeySequence.StandardKey = ... # 0xe
        Refresh                  : QKeySequence.StandardKey = ... # 0xf
        ZoomIn                   : QKeySequence.StandardKey = ... # 0x10
        ZoomOut                  : QKeySequence.StandardKey = ... # 0x11
        Print                    : QKeySequence.StandardKey = ... # 0x12
        AddTab                   : QKeySequence.StandardKey = ... # 0x13
        NextChild                : QKeySequence.StandardKey = ... # 0x14
        PreviousChild            : QKeySequence.StandardKey = ... # 0x15
        Find                     : QKeySequence.StandardKey = ... # 0x16
        FindNext                 : QKeySequence.StandardKey = ... # 0x17
        FindPrevious             : QKeySequence.StandardKey = ... # 0x18
        Replace                  : QKeySequence.StandardKey = ... # 0x19
        SelectAll                : QKeySequence.StandardKey = ... # 0x1a
        Bold                     : QKeySequence.StandardKey = ... # 0x1b
        Italic                   : QKeySequence.StandardKey = ... # 0x1c
        Underline                : QKeySequence.StandardKey = ... # 0x1d
        MoveToNextChar           : QKeySequence.StandardKey = ... # 0x1e
        MoveToPreviousChar       : QKeySequence.StandardKey = ... # 0x1f
        MoveToNextWord           : QKeySequence.StandardKey = ... # 0x20
        MoveToPreviousWord       : QKeySequence.StandardKey = ... # 0x21
        MoveToNextLine           : QKeySequence.StandardKey = ... # 0x22
        MoveToPreviousLine       : QKeySequence.StandardKey = ... # 0x23
        MoveToNextPage           : QKeySequence.StandardKey = ... # 0x24
        MoveToPreviousPage       : QKeySequence.StandardKey = ... # 0x25
        MoveToStartOfLine        : QKeySequence.StandardKey = ... # 0x26
        MoveToEndOfLine          : QKeySequence.StandardKey = ... # 0x27
        MoveToStartOfBlock       : QKeySequence.StandardKey = ... # 0x28
        MoveToEndOfBlock         : QKeySequence.StandardKey = ... # 0x29
        MoveToStartOfDocument    : QKeySequence.StandardKey = ... # 0x2a
        MoveToEndOfDocument      : QKeySequence.StandardKey = ... # 0x2b
        SelectNextChar           : QKeySequence.StandardKey = ... # 0x2c
        SelectPreviousChar       : QKeySequence.StandardKey = ... # 0x2d
        SelectNextWord           : QKeySequence.StandardKey = ... # 0x2e
        SelectPreviousWord       : QKeySequence.StandardKey = ... # 0x2f
        SelectNextLine           : QKeySequence.StandardKey = ... # 0x30
        SelectPreviousLine       : QKeySequence.StandardKey = ... # 0x31
        SelectNextPage           : QKeySequence.StandardKey = ... # 0x32
        SelectPreviousPage       : QKeySequence.StandardKey = ... # 0x33
        SelectStartOfLine        : QKeySequence.StandardKey = ... # 0x34
        SelectEndOfLine          : QKeySequence.StandardKey = ... # 0x35
        SelectStartOfBlock       : QKeySequence.StandardKey = ... # 0x36
        SelectEndOfBlock         : QKeySequence.StandardKey = ... # 0x37
        SelectStartOfDocument    : QKeySequence.StandardKey = ... # 0x38
        SelectEndOfDocument      : QKeySequence.StandardKey = ... # 0x39
        DeleteStartOfWord        : QKeySequence.StandardKey = ... # 0x3a
        DeleteEndOfWord          : QKeySequence.StandardKey = ... # 0x3b
        DeleteEndOfLine          : QKeySequence.StandardKey = ... # 0x3c
        InsertParagraphSeparator : QKeySequence.StandardKey = ... # 0x3d
        InsertLineSeparator      : QKeySequence.StandardKey = ... # 0x3e
        SaveAs                   : QKeySequence.StandardKey = ... # 0x3f
        Preferences              : QKeySequence.StandardKey = ... # 0x40
        Quit                     : QKeySequence.StandardKey = ... # 0x41
        FullScreen               : QKeySequence.StandardKey = ... # 0x42
        Deselect                 : QKeySequence.StandardKey = ... # 0x43
        DeleteCompleteLine       : QKeySequence.StandardKey = ... # 0x44
        Backspace                : QKeySequence.StandardKey = ... # 0x45
        Cancel                   : QKeySequence.StandardKey = ... # 0x46

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, k1:int, k2:int=..., k3:int=..., k4:int=...) -> None: ...
    @typing.overload
    def __init__(self, key:PySide2.QtGui.QKeySequence.StandardKey) -> None: ...
    @typing.overload
    def __init__(self, key:str, format:PySide2.QtGui.QKeySequence.SequenceFormat=...) -> None: ...
    @typing.overload
    def __init__(self, ks:PySide2.QtGui.QKeySequence) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, in_:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, out:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def count(self) -> int: ...
    @staticmethod
    def fromString(str:str, format:PySide2.QtGui.QKeySequence.SequenceFormat=...) -> PySide2.QtGui.QKeySequence: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def keyBindings(key:PySide2.QtGui.QKeySequence.StandardKey) -> typing.List: ...
    @staticmethod
    def listFromString(str:str, format:PySide2.QtGui.QKeySequence.SequenceFormat=...) -> typing.List: ...
    @staticmethod
    def listToString(list:typing.Sequence, format:PySide2.QtGui.QKeySequence.SequenceFormat=...) -> str: ...
    def matches(self, seq:PySide2.QtGui.QKeySequence) -> PySide2.QtGui.QKeySequence.SequenceMatch: ...
    @staticmethod
    def mnemonic(text:str) -> PySide2.QtGui.QKeySequence: ...
    def swap(self, other:PySide2.QtGui.QKeySequence) -> None: ...
    def toString(self, format:PySide2.QtGui.QKeySequence.SequenceFormat=...) -> str: ...


class QLinearGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QLinearGradient:PySide2.QtGui.QLinearGradient) -> None: ...
    @typing.overload
    def __init__(self, start:PySide2.QtCore.QPointF, finalStop:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, xStart:float, yStart:float, xFinalStop:float, yFinalStop:float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def finalStop(self) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def setFinalStop(self, stop:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setFinalStop(self, x:float, y:float) -> None: ...
    @typing.overload
    def setStart(self, start:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setStart(self, x:float, y:float) -> None: ...
    def start(self) -> PySide2.QtCore.QPointF: ...


class QMatrix(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m11:float, m12:float, m21:float, m22:float, dx:float, dy:float) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QMatrix) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __imul__(self, arg__1:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QMatrix: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, l:PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def __mul__(self, l:PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def __mul__(self, o:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    def __mul__(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, p:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    def inverted(self) -> typing.Tuple: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    @typing.overload
    def map(self, a:PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def map(self, a:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def map(self, l:PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def map(self, l:PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def map(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def map(self, p:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def map(self, p:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def map(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def map(self, x:int, y:int) -> typing.Tuple: ...
    @typing.overload
    def map(self, x:float, y:float) -> typing.Tuple: ...
    @typing.overload
    def mapRect(self, arg__1:PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def mapRect(self, arg__1:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToPolygon(self, r:PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygon: ...
    def reset(self) -> None: ...
    def rotate(self, a:float) -> PySide2.QtGui.QMatrix: ...
    def scale(self, sx:float, sy:float) -> PySide2.QtGui.QMatrix: ...
    def setMatrix(self, m11:float, m12:float, m21:float, m22:float, dx:float, dy:float) -> None: ...
    def shear(self, sh:float, sv:float) -> PySide2.QtGui.QMatrix: ...
    def translate(self, dx:float, dy:float) -> PySide2.QtGui.QMatrix: ...


class QMatrix2x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x2:PySide2.QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix2x2) -> PySide2.QtGui.QMatrix2x2: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix2x2: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix2x2) -> PySide2.QtGui.QMatrix2x2: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix2x2: ...


class QMatrix2x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x3:PySide2.QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix2x3) -> PySide2.QtGui.QMatrix2x3: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix2x3: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix2x3) -> PySide2.QtGui.QMatrix2x3: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix3x2: ...


class QMatrix2x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix2x4:PySide2.QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix2x4) -> PySide2.QtGui.QMatrix2x4: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix2x4: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix2x4) -> PySide2.QtGui.QMatrix2x4: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix4x2: ...


class QMatrix3x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x2:PySide2.QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix3x2) -> PySide2.QtGui.QMatrix3x2: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix3x2: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix3x2) -> PySide2.QtGui.QMatrix3x2: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix2x3: ...


class QMatrix3x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x3:PySide2.QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix3x3) -> PySide2.QtGui.QMatrix3x3: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix3x3: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix3x3) -> PySide2.QtGui.QMatrix3x3: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix3x3: ...


class QMatrix3x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix3x4:PySide2.QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix3x4) -> PySide2.QtGui.QMatrix3x4: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix3x4: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix3x4) -> PySide2.QtGui.QMatrix3x4: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix4x3: ...


class QMatrix4x2(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix4x2:PySide2.QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix4x2) -> PySide2.QtGui.QMatrix4x2: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix4x2: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix4x2) -> PySide2.QtGui.QMatrix4x2: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix2x4: ...


class QMatrix4x3(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QMatrix4x3:PySide2.QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def __init__(self, arg__1:typing.Iterable) -> None: ...

    def __call__(self, row:int, column:int) -> float: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix4x3) -> PySide2.QtGui.QMatrix4x3: ...
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix4x3: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix4x3) -> PySide2.QtGui.QMatrix4x3: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def data(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def isIdentity(self) -> bool: ...
    def setToIdentity(self) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix3x4: ...


class QMatrix4x4(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m11:float, m12:float, m13:float, m14:float, m21:float, m22:float, m23:float, m24:float, m31:float, m32:float, m33:float, m34:float, m41:float, m42:float, m43:float, m44:float) -> None: ...
    @typing.overload
    def __init__(self, matrix:PySide2.QtGui.QMatrix) -> None: ...
    @typing.overload
    def __init__(self, transform:PySide2.QtGui.QTransform) -> None: ...
    @typing.overload
    def __init__(self, values:typing.Sequence) -> None: ...

    def __add__(self, m2:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    @staticmethod
    def __copy__() -> None: ...
    def __dummy(self, arg__1:typing.Sequence) -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __imul__(self, factor:float) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __imul__(self, other:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    def __isub__(self, other:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __mul__(self, m2:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def __mul__(self, point:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __neg__(self) -> PySide2.QtGui.QMatrix4x4: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, m2:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QMatrix4x4: ...
    def column(self, index:int) -> PySide2.QtGui.QVector4D: ...
    def copyDataTo(self) -> float: ...
    def data(self) -> typing.List: ...
    def determinant(self) -> float: ...
    def fill(self, value:float) -> None: ...
    def flipCoordinates(self) -> None: ...
    def frustum(self, left:float, right:float, bottom:float, top:float, nearPlane:float, farPlane:float) -> None: ...
    def inverted(self) -> typing.Tuple: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def lookAt(self, eye:PySide2.QtGui.QVector3D, center:PySide2.QtGui.QVector3D, up:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def map(self, point:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def map(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def map(self, point:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def map(self, point:PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def mapRect(self, rect:PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def mapRect(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapVector(self, vector:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def normalMatrix(self) -> PySide2.QtGui.QMatrix3x3: ...
    def optimize(self) -> None: ...
    @typing.overload
    def ortho(self, left:float, right:float, bottom:float, top:float, nearPlane:float, farPlane:float) -> None: ...
    @typing.overload
    def ortho(self, rect:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def ortho(self, rect:PySide2.QtCore.QRectF) -> None: ...
    def perspective(self, verticalAngle:float, aspectRatio:float, nearPlane:float, farPlane:float) -> None: ...
    @typing.overload
    def rotate(self, angle:float, vector:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def rotate(self, angle:float, x:float, y:float, z:float=...) -> None: ...
    @typing.overload
    def rotate(self, quaternion:PySide2.QtGui.QQuaternion) -> None: ...
    def row(self, index:int) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def scale(self, factor:float) -> None: ...
    @typing.overload
    def scale(self, vector:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def scale(self, x:float, y:float) -> None: ...
    @typing.overload
    def scale(self, x:float, y:float, z:float) -> None: ...
    def setColumn(self, index:int, value:PySide2.QtGui.QVector4D) -> None: ...
    def setRow(self, index:int, value:PySide2.QtGui.QVector4D) -> None: ...
    def setToIdentity(self) -> None: ...
    def toAffine(self) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    def toTransform(self) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def toTransform(self, distanceToPlane:float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def translate(self, vector:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def translate(self, x:float, y:float) -> None: ...
    @typing.overload
    def translate(self, x:float, y:float, z:float) -> None: ...
    def transposed(self) -> PySide2.QtGui.QMatrix4x4: ...
    @typing.overload
    def viewport(self, left:float, bottom:float, width:float, height:float, nearPlane:float=..., farPlane:float=...) -> None: ...
    @typing.overload
    def viewport(self, rect:PySide2.QtCore.QRectF) -> None: ...


class QMouseEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type:PySide2.QtCore.QEvent.Type, localPos:PySide2.QtCore.QPointF, button:PySide2.QtCore.Qt.MouseButton, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtCore.QEvent.Type, localPos:PySide2.QtCore.QPointF, screenPos:PySide2.QtCore.QPointF, button:PySide2.QtCore.Qt.MouseButton, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtCore.QEvent.Type, localPos:PySide2.QtCore.QPointF, windowPos:PySide2.QtCore.QPointF, screenPos:PySide2.QtCore.QPointF, button:PySide2.QtCore.Qt.MouseButton, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtCore.QEvent.Type, localPos:PySide2.QtCore.QPointF, windowPos:PySide2.QtCore.QPointF, screenPos:PySide2.QtCore.QPointF, button:PySide2.QtCore.Qt.MouseButton, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, source:PySide2.QtCore.Qt.MouseEventSource) -> None: ...

    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def flags(self) -> PySide2.QtCore.Qt.MouseEventFlags: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def setLocalPos(self, localPosition:PySide2.QtCore.QPointF) -> None: ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QMoveEvent(PySide2.QtCore.QEvent):

    def __init__(self, pos:PySide2.QtCore.QPoint, oldPos:PySide2.QtCore.QPoint) -> None: ...

    def oldPos(self) -> PySide2.QtCore.QPoint: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...


class QMovie(PySide2.QtCore.QObject):
    CacheNone                : QMovie = ... # 0x0
    NotRunning               : QMovie = ... # 0x0
    CacheAll                 : QMovie = ... # 0x1
    Paused                   : QMovie = ... # 0x1
    Running                  : QMovie = ... # 0x2

    class CacheMode(object):
        CacheNone                : QMovie.CacheMode = ... # 0x0
        CacheAll                 : QMovie.CacheMode = ... # 0x1

    class MovieState(object):
        NotRunning               : QMovie.MovieState = ... # 0x0
        Paused                   : QMovie.MovieState = ... # 0x1
        Running                  : QMovie.MovieState = ... # 0x2

    @typing.overload
    def __init__(self, device:PySide2.QtCore.QIODevice, format:PySide2.QtCore.QByteArray=..., parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:PySide2.QtCore.QByteArray=..., parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def cacheMode(self) -> PySide2.QtGui.QMovie.CacheMode: ...
    def currentFrameNumber(self) -> int: ...
    def currentImage(self) -> PySide2.QtGui.QImage: ...
    def currentPixmap(self) -> PySide2.QtGui.QPixmap: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def frameCount(self) -> int: ...
    def frameRect(self) -> PySide2.QtCore.QRect: ...
    def isValid(self) -> bool: ...
    def jumpToFrame(self, frameNumber:int) -> bool: ...
    def jumpToNextFrame(self) -> bool: ...
    def lastError(self) -> PySide2.QtGui.QImageReader.ImageReaderError: ...
    def lastErrorString(self) -> str: ...
    def loopCount(self) -> int: ...
    def nextFrameDelay(self) -> int: ...
    def scaledSize(self) -> PySide2.QtCore.QSize: ...
    def setBackgroundColor(self, color:PySide2.QtGui.QColor) -> None: ...
    def setCacheMode(self, mode:PySide2.QtGui.QMovie.CacheMode) -> None: ...
    def setDevice(self, device:PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName:str) -> None: ...
    def setFormat(self, format:PySide2.QtCore.QByteArray) -> None: ...
    def setPaused(self, paused:bool) -> None: ...
    def setScaledSize(self, size:PySide2.QtCore.QSize) -> None: ...
    def setSpeed(self, percentSpeed:int) -> None: ...
    def speed(self) -> int: ...
    def start(self) -> None: ...
    def state(self) -> PySide2.QtGui.QMovie.MovieState: ...
    def stop(self) -> None: ...
    @staticmethod
    def supportedFormats() -> typing.List: ...


class QNativeGestureEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, type:PySide2.QtCore.Qt.NativeGestureType, dev:PySide2.QtGui.QTouchDevice, localPos:PySide2.QtCore.QPointF, windowPos:PySide2.QtCore.QPointF, screenPos:PySide2.QtCore.QPointF, value:float, sequenceId:int, intArgument:int) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtCore.Qt.NativeGestureType, localPos:PySide2.QtCore.QPointF, windowPos:PySide2.QtCore.QPointF, screenPos:PySide2.QtCore.QPointF, value:float, sequenceId:int, intArgument:int) -> None: ...

    def device(self) -> PySide2.QtGui.QTouchDevice: ...
    def gestureType(self) -> PySide2.QtCore.Qt.NativeGestureType: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def localPos(self) -> PySide2.QtCore.QPointF: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def screenPos(self) -> PySide2.QtCore.QPointF: ...
    def value(self) -> float: ...
    def windowPos(self) -> PySide2.QtCore.QPointF: ...


class QOffscreenSurface(PySide2.QtCore.QObject, PySide2.QtGui.QSurface):

    @typing.overload
    def __init__(self, screen:PySide2.QtGui.QScreen, parent:PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, screen:typing.Optional[PySide2.QtGui.QScreen]=...) -> None: ...

    def create(self) -> None: ...
    def destroy(self) -> None: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def isValid(self) -> bool: ...
    def nativeHandle(self) -> int: ...
    def requestedFormat(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    def setFormat(self, format:PySide2.QtGui.QSurfaceFormat) -> None: ...
    def setNativeHandle(self, handle:int) -> None: ...
    def setScreen(self, screen:PySide2.QtGui.QScreen) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide2.QtGui.QSurface.SurfaceType: ...


class QOpenGLBuffer(Shiboken.Object):
    RangeRead                : QOpenGLBuffer = ... # 0x1
    RangeWrite               : QOpenGLBuffer = ... # 0x2
    RangeInvalidate          : QOpenGLBuffer = ... # 0x4
    RangeInvalidateBuffer    : QOpenGLBuffer = ... # 0x8
    RangeFlushExplicit       : QOpenGLBuffer = ... # 0x10
    RangeUnsynchronized      : QOpenGLBuffer = ... # 0x20
    VertexBuffer             : QOpenGLBuffer = ... # 0x8892
    IndexBuffer              : QOpenGLBuffer = ... # 0x8893
    ReadOnly                 : QOpenGLBuffer = ... # 0x88b8
    WriteOnly                : QOpenGLBuffer = ... # 0x88b9
    ReadWrite                : QOpenGLBuffer = ... # 0x88ba
    StreamDraw               : QOpenGLBuffer = ... # 0x88e0
    StreamRead               : QOpenGLBuffer = ... # 0x88e1
    StreamCopy               : QOpenGLBuffer = ... # 0x88e2
    StaticDraw               : QOpenGLBuffer = ... # 0x88e4
    StaticRead               : QOpenGLBuffer = ... # 0x88e5
    StaticCopy               : QOpenGLBuffer = ... # 0x88e6
    DynamicDraw              : QOpenGLBuffer = ... # 0x88e8
    DynamicRead              : QOpenGLBuffer = ... # 0x88e9
    DynamicCopy              : QOpenGLBuffer = ... # 0x88ea
    PixelPackBuffer          : QOpenGLBuffer = ... # 0x88eb
    PixelUnpackBuffer        : QOpenGLBuffer = ... # 0x88ec

    class Access(object):
        ReadOnly                 : QOpenGLBuffer.Access = ... # 0x88b8
        WriteOnly                : QOpenGLBuffer.Access = ... # 0x88b9
        ReadWrite                : QOpenGLBuffer.Access = ... # 0x88ba

    class RangeAccessFlag(object):
        RangeRead                : QOpenGLBuffer.RangeAccessFlag = ... # 0x1
        RangeWrite               : QOpenGLBuffer.RangeAccessFlag = ... # 0x2
        RangeInvalidate          : QOpenGLBuffer.RangeAccessFlag = ... # 0x4
        RangeInvalidateBuffer    : QOpenGLBuffer.RangeAccessFlag = ... # 0x8
        RangeFlushExplicit       : QOpenGLBuffer.RangeAccessFlag = ... # 0x10
        RangeUnsynchronized      : QOpenGLBuffer.RangeAccessFlag = ... # 0x20

    class RangeAccessFlags(object): ...

    class Type(object):
        VertexBuffer             : QOpenGLBuffer.Type = ... # 0x8892
        IndexBuffer              : QOpenGLBuffer.Type = ... # 0x8893
        PixelPackBuffer          : QOpenGLBuffer.Type = ... # 0x88eb
        PixelUnpackBuffer        : QOpenGLBuffer.Type = ... # 0x88ec

    class UsagePattern(object):
        StreamDraw               : QOpenGLBuffer.UsagePattern = ... # 0x88e0
        StreamRead               : QOpenGLBuffer.UsagePattern = ... # 0x88e1
        StreamCopy               : QOpenGLBuffer.UsagePattern = ... # 0x88e2
        StaticDraw               : QOpenGLBuffer.UsagePattern = ... # 0x88e4
        StaticRead               : QOpenGLBuffer.UsagePattern = ... # 0x88e5
        StaticCopy               : QOpenGLBuffer.UsagePattern = ... # 0x88e6
        DynamicDraw              : QOpenGLBuffer.UsagePattern = ... # 0x88e8
        DynamicRead              : QOpenGLBuffer.UsagePattern = ... # 0x88e9
        DynamicCopy              : QOpenGLBuffer.UsagePattern = ... # 0x88ea

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QOpenGLBuffer) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtGui.QOpenGLBuffer.Type) -> None: ...

    @typing.overload
    def allocate(self, count:int) -> None: ...
    @typing.overload
    def allocate(self, data:int, count:int) -> None: ...
    def bind(self) -> bool: ...
    def bufferId(self) -> int: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def map(self, access:PySide2.QtGui.QOpenGLBuffer.Access) -> int: ...
    def mapRange(self, offset:int, count:int, access:PySide2.QtGui.QOpenGLBuffer.RangeAccessFlags) -> int: ...
    def read(self, offset:int, data:int, count:int) -> bool: ...
    @typing.overload
    def release(self) -> None: ...
    @typing.overload
    @staticmethod
    def release(type:PySide2.QtGui.QOpenGLBuffer.Type) -> None: ...
    def setUsagePattern(self, value:PySide2.QtGui.QOpenGLBuffer.UsagePattern) -> None: ...
    def size(self) -> int: ...
    def type(self) -> PySide2.QtGui.QOpenGLBuffer.Type: ...
    def unmap(self) -> bool: ...
    def usagePattern(self) -> PySide2.QtGui.QOpenGLBuffer.UsagePattern: ...
    def write(self, offset:int, data:int, count:int) -> None: ...


class QOpenGLContext(PySide2.QtCore.QObject):
    LibGL                    : QOpenGLContext = ... # 0x0
    LibGLES                  : QOpenGLContext = ... # 0x1

    class OpenGLModuleType(object):
        LibGL                    : QOpenGLContext.OpenGLModuleType = ... # 0x0
        LibGLES                  : QOpenGLContext.OpenGLModuleType = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    @staticmethod
    def areSharing(first:PySide2.QtGui.QOpenGLContext, second:PySide2.QtGui.QOpenGLContext) -> bool: ...
    def create(self) -> bool: ...
    @staticmethod
    def currentContext() -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def extensions(self) -> typing.Set: ...
    def extraFunctions(self) -> PySide2.QtGui.QOpenGLExtraFunctions: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def functions(self) -> PySide2.QtGui.QOpenGLFunctions: ...
    @staticmethod
    def globalShareContext() -> PySide2.QtGui.QOpenGLContext: ...
    def hasExtension(self, extension:PySide2.QtCore.QByteArray) -> bool: ...
    def isOpenGLES(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self, surface:PySide2.QtGui.QSurface) -> bool: ...
    def nativeHandle(self) -> typing.Any: ...
    @staticmethod
    def openGLModuleHandle() -> int: ...
    @staticmethod
    def openGLModuleType() -> PySide2.QtGui.QOpenGLContext.OpenGLModuleType: ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    def setFormat(self, format:PySide2.QtGui.QSurfaceFormat) -> None: ...
    def setNativeHandle(self, handle:typing.Any) -> None: ...
    def setScreen(self, screen:PySide2.QtGui.QScreen) -> None: ...
    def setShareContext(self, shareContext:PySide2.QtGui.QOpenGLContext) -> None: ...
    def shareContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def shareGroup(self) -> PySide2.QtGui.QOpenGLContextGroup: ...
    @staticmethod
    def supportsThreadedOpenGL() -> bool: ...
    def surface(self) -> PySide2.QtGui.QSurface: ...
    def swapBuffers(self, surface:PySide2.QtGui.QSurface) -> None: ...
    def versionFunctions(self, versionProfile:PySide2.QtGui.QOpenGLVersionProfile=...) -> PySide2.QtGui.QAbstractOpenGLFunctions: ...


class QOpenGLContextGroup(PySide2.QtCore.QObject):
    @staticmethod
    def currentContextGroup() -> PySide2.QtGui.QOpenGLContextGroup: ...
    def shares(self) -> typing.List: ...


class QOpenGLDebugLogger(PySide2.QtCore.QObject):
    AsynchronousLogging      : QOpenGLDebugLogger = ... # 0x0
    SynchronousLogging       : QOpenGLDebugLogger = ... # 0x1

    class LoggingMode(object):
        AsynchronousLogging      : QOpenGLDebugLogger.LoggingMode = ... # 0x0
        SynchronousLogging       : QOpenGLDebugLogger.LoggingMode = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    @typing.overload
    def disableMessages(self, ids:typing.List, sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=..., types:PySide2.QtGui.QOpenGLDebugMessage.Types=...) -> None: ...
    @typing.overload
    def disableMessages(self, sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=..., types:PySide2.QtGui.QOpenGLDebugMessage.Types=..., severities:PySide2.QtGui.QOpenGLDebugMessage.Severities=...) -> None: ...
    @typing.overload
    def enableMessages(self, ids:typing.List, sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=..., types:PySide2.QtGui.QOpenGLDebugMessage.Types=...) -> None: ...
    @typing.overload
    def enableMessages(self, sources:PySide2.QtGui.QOpenGLDebugMessage.Sources=..., types:PySide2.QtGui.QOpenGLDebugMessage.Types=..., severities:PySide2.QtGui.QOpenGLDebugMessage.Severities=...) -> None: ...
    def initialize(self) -> bool: ...
    def isLogging(self) -> bool: ...
    def logMessage(self, debugMessage:PySide2.QtGui.QOpenGLDebugMessage) -> None: ...
    def loggedMessages(self) -> typing.List: ...
    def loggingMode(self) -> PySide2.QtGui.QOpenGLDebugLogger.LoggingMode: ...
    def maximumMessageLength(self) -> int: ...
    def popGroup(self) -> None: ...
    def pushGroup(self, name:str, id:int=..., source:PySide2.QtGui.QOpenGLDebugMessage.Source=...) -> None: ...
    def startLogging(self, loggingMode:PySide2.QtGui.QOpenGLDebugLogger.LoggingMode=...) -> None: ...
    def stopLogging(self) -> None: ...


class QOpenGLDebugMessage(Shiboken.Object):
    InvalidSeverity          : QOpenGLDebugMessage = ... # 0x0
    InvalidSource            : QOpenGLDebugMessage = ... # 0x0
    InvalidType              : QOpenGLDebugMessage = ... # 0x0
    APISource                : QOpenGLDebugMessage = ... # 0x1
    ErrorType                : QOpenGLDebugMessage = ... # 0x1
    HighSeverity             : QOpenGLDebugMessage = ... # 0x1
    DeprecatedBehaviorType   : QOpenGLDebugMessage = ... # 0x2
    MediumSeverity           : QOpenGLDebugMessage = ... # 0x2
    WindowSystemSource       : QOpenGLDebugMessage = ... # 0x2
    LowSeverity              : QOpenGLDebugMessage = ... # 0x4
    ShaderCompilerSource     : QOpenGLDebugMessage = ... # 0x4
    UndefinedBehaviorType    : QOpenGLDebugMessage = ... # 0x4
    LastSeverity             : QOpenGLDebugMessage = ... # 0x8
    NotificationSeverity     : QOpenGLDebugMessage = ... # 0x8
    PortabilityType          : QOpenGLDebugMessage = ... # 0x8
    ThirdPartySource         : QOpenGLDebugMessage = ... # 0x8
    ApplicationSource        : QOpenGLDebugMessage = ... # 0x10
    PerformanceType          : QOpenGLDebugMessage = ... # 0x10
    LastSource               : QOpenGLDebugMessage = ... # 0x20
    OtherSource              : QOpenGLDebugMessage = ... # 0x20
    OtherType                : QOpenGLDebugMessage = ... # 0x20
    MarkerType               : QOpenGLDebugMessage = ... # 0x40
    GroupPushType            : QOpenGLDebugMessage = ... # 0x80
    GroupPopType             : QOpenGLDebugMessage = ... # 0x100
    LastType                 : QOpenGLDebugMessage = ... # 0x100
    AnySeverity              : QOpenGLDebugMessage = ... # -0x1
    AnySource                : QOpenGLDebugMessage = ... # -0x1
    AnyType                  : QOpenGLDebugMessage = ... # -0x1

    class Severities(object): ...

    class Severity(object):
        InvalidSeverity          : QOpenGLDebugMessage.Severity = ... # 0x0
        HighSeverity             : QOpenGLDebugMessage.Severity = ... # 0x1
        MediumSeverity           : QOpenGLDebugMessage.Severity = ... # 0x2
        LowSeverity              : QOpenGLDebugMessage.Severity = ... # 0x4
        LastSeverity             : QOpenGLDebugMessage.Severity = ... # 0x8
        NotificationSeverity     : QOpenGLDebugMessage.Severity = ... # 0x8
        AnySeverity              : QOpenGLDebugMessage.Severity = ... # -0x1

    class Source(object):
        InvalidSource            : QOpenGLDebugMessage.Source = ... # 0x0
        APISource                : QOpenGLDebugMessage.Source = ... # 0x1
        WindowSystemSource       : QOpenGLDebugMessage.Source = ... # 0x2
        ShaderCompilerSource     : QOpenGLDebugMessage.Source = ... # 0x4
        ThirdPartySource         : QOpenGLDebugMessage.Source = ... # 0x8
        ApplicationSource        : QOpenGLDebugMessage.Source = ... # 0x10
        LastSource               : QOpenGLDebugMessage.Source = ... # 0x20
        OtherSource              : QOpenGLDebugMessage.Source = ... # 0x20
        AnySource                : QOpenGLDebugMessage.Source = ... # -0x1

    class Sources(object): ...

    class Type(object):
        InvalidType              : QOpenGLDebugMessage.Type = ... # 0x0
        ErrorType                : QOpenGLDebugMessage.Type = ... # 0x1
        DeprecatedBehaviorType   : QOpenGLDebugMessage.Type = ... # 0x2
        UndefinedBehaviorType    : QOpenGLDebugMessage.Type = ... # 0x4
        PortabilityType          : QOpenGLDebugMessage.Type = ... # 0x8
        PerformanceType          : QOpenGLDebugMessage.Type = ... # 0x10
        OtherType                : QOpenGLDebugMessage.Type = ... # 0x20
        MarkerType               : QOpenGLDebugMessage.Type = ... # 0x40
        GroupPushType            : QOpenGLDebugMessage.Type = ... # 0x80
        GroupPopType             : QOpenGLDebugMessage.Type = ... # 0x100
        LastType                 : QOpenGLDebugMessage.Type = ... # 0x100
        AnyType                  : QOpenGLDebugMessage.Type = ... # -0x1

    class Types(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, debugMessage:PySide2.QtGui.QOpenGLDebugMessage) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def createApplicationMessage(text:str, id:int=..., severity:PySide2.QtGui.QOpenGLDebugMessage.Severity=..., type:PySide2.QtGui.QOpenGLDebugMessage.Type=...) -> PySide2.QtGui.QOpenGLDebugMessage: ...
    @staticmethod
    def createThirdPartyMessage(text:str, id:int=..., severity:PySide2.QtGui.QOpenGLDebugMessage.Severity=..., type:PySide2.QtGui.QOpenGLDebugMessage.Type=...) -> PySide2.QtGui.QOpenGLDebugMessage: ...
    def id(self) -> int: ...
    def message(self) -> str: ...
    def severity(self) -> PySide2.QtGui.QOpenGLDebugMessage.Severity: ...
    def source(self) -> PySide2.QtGui.QOpenGLDebugMessage.Source: ...
    def swap(self, other:PySide2.QtGui.QOpenGLDebugMessage) -> None: ...
    def type(self) -> PySide2.QtGui.QOpenGLDebugMessage.Type: ...


class QOpenGLExtraFunctions(PySide2.QtGui.QOpenGLFunctions):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context:PySide2.QtGui.QOpenGLContext) -> None: ...

    def glActiveShaderProgram(self, pipeline:int, program:int) -> None: ...
    def glBeginQuery(self, target:int, id:int) -> None: ...
    def glBeginTransformFeedback(self, primitiveMode:int) -> None: ...
    def glBindBufferBase(self, target:int, index:int, buffer:int) -> None: ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:int, layer:int, access:int, format:int) -> None: ...
    def glBindProgramPipeline(self, pipeline:int) -> None: ...
    def glBindSampler(self, unit:int, sampler:int) -> None: ...
    def glBindTransformFeedback(self, target:int, id:int) -> None: ...
    def glBindVertexArray(self, array:int) -> None: ...
    def glBlendBarrier(self) -> None: ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendEquationi(self, buf:int, mode:int) -> None: ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glBlendFunci(self, buf:int, src:int, dst:int) -> None: ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int) -> None: ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int) -> None: ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence) -> None: ...
    def glColorMaski(self, index:int, r:int, g:int, b:int, a:int) -> None: ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int) -> None: ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:int) -> None: ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes) -> None: ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glDisablei(self, target:int, index:int) -> None: ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int) -> None: ...
    def glDrawArraysIndirect(self, mode:int, indirect:int) -> None: ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int) -> None: ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence) -> None: ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int) -> None: ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int) -> None: ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int) -> None: ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int) -> None: ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int) -> None: ...
    def glEnablei(self, target:int, index:int) -> None: ...
    def glEndQuery(self, target:int) -> None: ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int) -> None: ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int) -> None: ...
    def glGenProgramPipelines(self, n:int, pipelines:typing.Sequence) -> None: ...
    def glGenQueries(self, n:int, ids:typing.Sequence) -> None: ...
    def glGenSamplers(self, count:int, samplers:typing.Sequence) -> None: ...
    def glGenTransformFeedbacks(self, n:int, ids:typing.Sequence) -> None: ...
    def glGenVertexArrays(self, n:int, arrays:typing.Sequence) -> None: ...
    def glGetActiveUniformBlockiv(self, program:int, uniformBlockIndex:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetActiveUniformsiv(self, program:int, uniformCount:int, uniformIndices:typing.Sequence, pname:int, params:typing.Sequence) -> None: ...
    def glGetBufferParameteri64v(self, target:int, pname:int) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetFramebufferParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    def glGetInteger64i_v(self, target:int, index:int) -> int: ...
    def glGetInteger64v(self, pname:int) -> int: ...
    def glGetIntegeri_v(self, target:int, index:int, data:typing.Sequence) -> None: ...
    def glGetInternalformativ(self, target:int, internalformat:int, pname:int, bufSize:int, params:typing.Sequence) -> None: ...
    def glGetMultisamplefv(self, pname:int, index:int, val:typing.Sequence) -> None: ...
    def glGetProgramBinary(self, program:int, bufSize:int, binary:int) -> typing.Tuple: ...
    def glGetProgramInterfaceiv(self, program:int, programInterface:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetProgramPipelineiv(self, pipeline:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceiv(self, program:int, programInterface:int, index:int, propCount:int, props:typing.Sequence, bufSize:int, length:typing.Sequence, params:typing.Sequence) -> None: ...
    def glGetQueryObjectuiv(self, id:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetQueryiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetSamplerParameterIiv(self, sampler:int, pname:int) -> int: ...
    def glGetSamplerParameterIuiv(self, sampler:int, pname:int) -> int: ...
    def glGetSamplerParameterfv(self, sampler:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetSamplerParameteriv(self, sampler:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetTexLevelParameterfv(self, target:int, level:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetTexLevelParameteriv(self, target:int, level:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetTexParameterIiv(self, target:int, pname:int) -> int: ...
    def glGetTexParameterIuiv(self, target:int, pname:int) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformuiv(self, program:int, location:int, params:typing.Sequence) -> None: ...
    def glGetVertexAttribIiv(self, index:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetVertexAttribIuiv(self, index:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetnUniformfv(self, program:int, location:int, bufSize:int) -> float: ...
    def glGetnUniformiv(self, program:int, location:int, bufSize:int) -> int: ...
    def glGetnUniformuiv(self, program:int, location:int, bufSize:int) -> int: ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence) -> None: ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int) -> None: ...
    def glIsEnabledi(self, target:int, index:int) -> int: ...
    def glIsProgramPipeline(self, pipeline:int) -> int: ...
    def glIsQuery(self, id:int) -> int: ...
    def glIsSampler(self, sampler:int) -> int: ...
    def glIsTransformFeedback(self, id:int) -> int: ...
    def glIsVertexArray(self, array:int) -> int: ...
    def glMemoryBarrier(self, barriers:int) -> None: ...
    def glMemoryBarrierByRegion(self, barriers:int) -> None: ...
    def glMinSampleShading(self, value:float) -> None: ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes) -> None: ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes) -> None: ...
    def glPatchParameteri(self, pname:int, value:int) -> None: ...
    def glPopDebugGroup(self) -> None: ...
    def glPrimitiveBoundingBox(self, minX:float, minY:float, minZ:float, minW:float, maxX:float, maxY:float, maxZ:float, maxW:float) -> None: ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int) -> None: ...
    def glProgramParameteri(self, program:int, pname:int, value:int) -> None: ...
    def glProgramUniform1f(self, program:int, location:int, v0:float) -> None: ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1i(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int) -> None: ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float) -> None: ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int) -> None: ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float) -> None: ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float) -> None: ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes) -> None: ...
    def glReadBuffer(self, mode:int) -> None: ...
    def glReadnPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, bufSize:int, data:int) -> None: ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int) -> None: ...
    def glSampleMaski(self, maskNumber:int, mask:int) -> None: ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float) -> None: ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int) -> None: ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence) -> None: ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int) -> None: ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int) -> None: ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:int) -> None: ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int) -> None: ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:int) -> None: ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1ui(self, location:int, v0:int) -> None: ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform2ui(self, location:int, v0:int, v1:int) -> None: ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int) -> None: ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int) -> None: ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence) -> None: ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int) -> None: ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUnmapBuffer(self, target:int) -> int: ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int) -> None: ...
    def glValidateProgramPipeline(self, pipeline:int) -> None: ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int) -> None: ...
    def glVertexAttribDivisor(self, index:int, divisor:int) -> None: ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:int, relativeoffset:int) -> None: ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int) -> None: ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence) -> None: ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int) -> None: ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int) -> None: ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int) -> None: ...


class QOpenGLFramebufferObject(Shiboken.Object):
    DontRestoreFramebufferBinding: QOpenGLFramebufferObject = ... # 0x0
    NoAttachment             : QOpenGLFramebufferObject = ... # 0x0
    CombinedDepthStencil     : QOpenGLFramebufferObject = ... # 0x1
    RestoreFramebufferBindingToDefault: QOpenGLFramebufferObject = ... # 0x1
    Depth                    : QOpenGLFramebufferObject = ... # 0x2
    RestoreFrameBufferBinding: QOpenGLFramebufferObject = ... # 0x2

    class Attachment(object):
        NoAttachment             : QOpenGLFramebufferObject.Attachment = ... # 0x0
        CombinedDepthStencil     : QOpenGLFramebufferObject.Attachment = ... # 0x1
        Depth                    : QOpenGLFramebufferObject.Attachment = ... # 0x2

    class FramebufferRestorePolicy(object):
        DontRestoreFramebufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x0
        RestoreFramebufferBindingToDefault: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x1
        RestoreFrameBufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = ... # 0x2

    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, attachment:PySide2.QtGui.QOpenGLFramebufferObject.Attachment, target:int=..., internalFormat:int=...) -> None: ...
    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, format:PySide2.QtGui.QOpenGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSize, target:int=...) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, attachment:PySide2.QtGui.QOpenGLFramebufferObject.Attachment, target:int=..., internalFormat:int=...) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, format:PySide2.QtGui.QOpenGLFramebufferObjectFormat) -> None: ...
    @typing.overload
    def __init__(self, width:int, height:int, target:int=...) -> None: ...

    @typing.overload
    def addColorAttachment(self, size:PySide2.QtCore.QSize, internalFormat:int=...) -> None: ...
    @typing.overload
    def addColorAttachment(self, width:int, height:int, internalFormat:int=...) -> None: ...
    def attachment(self) -> PySide2.QtGui.QOpenGLFramebufferObject.Attachment: ...
    def bind(self) -> bool: ...
    @staticmethod
    def bindDefault() -> bool: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject, source:PySide2.QtGui.QOpenGLFramebufferObject, buffers:int=..., filter:int=...) -> None: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject, targetRect:PySide2.QtCore.QRect, source:PySide2.QtGui.QOpenGLFramebufferObject, sourceRect:PySide2.QtCore.QRect, buffers:int, filter:int, readColorAttachmentIndex:int, drawColorAttachmentIndex:int) -> None: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject, targetRect:PySide2.QtCore.QRect, source:PySide2.QtGui.QOpenGLFramebufferObject, sourceRect:PySide2.QtCore.QRect, buffers:int, filter:int, readColorAttachmentIndex:int, drawColorAttachmentIndex:int, restorePolicy:PySide2.QtGui.QOpenGLFramebufferObject.FramebufferRestorePolicy) -> None: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target:PySide2.QtGui.QOpenGLFramebufferObject, targetRect:PySide2.QtCore.QRect, source:PySide2.QtGui.QOpenGLFramebufferObject, sourceRect:PySide2.QtCore.QRect, buffers:int=..., filter:int=...) -> None: ...
    def format(self) -> PySide2.QtGui.QOpenGLFramebufferObjectFormat: ...
    def handle(self) -> int: ...
    @staticmethod
    def hasOpenGLFramebufferBlit() -> bool: ...
    @staticmethod
    def hasOpenGLFramebufferObjects() -> bool: ...
    def height(self) -> int: ...
    def isBound(self) -> bool: ...
    def isValid(self) -> bool: ...
    def release(self) -> bool: ...
    def setAttachment(self, attachment:PySide2.QtGui.QOpenGLFramebufferObject.Attachment) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizes(self) -> typing.List: ...
    @typing.overload
    def takeTexture(self) -> int: ...
    @typing.overload
    def takeTexture(self, colorAttachmentIndex:int) -> int: ...
    def texture(self) -> int: ...
    def textures(self) -> typing.List: ...
    @typing.overload
    def toImage(self) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def toImage(self, flipped:bool) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def toImage(self, flipped:bool, colorAttachmentIndex:int) -> PySide2.QtGui.QImage: ...
    def width(self) -> int: ...


class QOpenGLFramebufferObjectFormat(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QOpenGLFramebufferObjectFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def attachment(self) -> PySide2.QtGui.QOpenGLFramebufferObject.Attachment: ...
    def internalTextureFormat(self) -> int: ...
    def mipmap(self) -> bool: ...
    def samples(self) -> int: ...
    def setAttachment(self, attachment:PySide2.QtGui.QOpenGLFramebufferObject.Attachment) -> None: ...
    def setInternalTextureFormat(self, internalTextureFormat:int) -> None: ...
    def setMipmap(self, enabled:bool) -> None: ...
    def setSamples(self, samples:int) -> None: ...
    def setTextureTarget(self, target:int) -> None: ...
    def textureTarget(self) -> int: ...


class QOpenGLFunctions(Shiboken.Object):
    Multitexture             : QOpenGLFunctions = ... # 0x1
    Shaders                  : QOpenGLFunctions = ... # 0x2
    Buffers                  : QOpenGLFunctions = ... # 0x4
    Framebuffers             : QOpenGLFunctions = ... # 0x8
    BlendColor               : QOpenGLFunctions = ... # 0x10
    BlendEquation            : QOpenGLFunctions = ... # 0x20
    BlendEquationSeparate    : QOpenGLFunctions = ... # 0x40
    BlendFuncSeparate        : QOpenGLFunctions = ... # 0x80
    BlendSubtract            : QOpenGLFunctions = ... # 0x100
    CompressedTextures       : QOpenGLFunctions = ... # 0x200
    Multisample              : QOpenGLFunctions = ... # 0x400
    StencilSeparate          : QOpenGLFunctions = ... # 0x800
    NPOTTextures             : QOpenGLFunctions = ... # 0x1000
    NPOTTextureRepeat        : QOpenGLFunctions = ... # 0x2000
    FixedFunctionPipeline    : QOpenGLFunctions = ... # 0x4000
    TextureRGFormats         : QOpenGLFunctions = ... # 0x8000
    MultipleRenderTargets    : QOpenGLFunctions = ... # 0x10000
    BlendEquationAdvanced    : QOpenGLFunctions = ... # 0x20000

    class OpenGLFeature(object):
        Multitexture             : QOpenGLFunctions.OpenGLFeature = ... # 0x1
        Shaders                  : QOpenGLFunctions.OpenGLFeature = ... # 0x2
        Buffers                  : QOpenGLFunctions.OpenGLFeature = ... # 0x4
        Framebuffers             : QOpenGLFunctions.OpenGLFeature = ... # 0x8
        BlendColor               : QOpenGLFunctions.OpenGLFeature = ... # 0x10
        BlendEquation            : QOpenGLFunctions.OpenGLFeature = ... # 0x20
        BlendEquationSeparate    : QOpenGLFunctions.OpenGLFeature = ... # 0x40
        BlendFuncSeparate        : QOpenGLFunctions.OpenGLFeature = ... # 0x80
        BlendSubtract            : QOpenGLFunctions.OpenGLFeature = ... # 0x100
        CompressedTextures       : QOpenGLFunctions.OpenGLFeature = ... # 0x200
        Multisample              : QOpenGLFunctions.OpenGLFeature = ... # 0x400
        StencilSeparate          : QOpenGLFunctions.OpenGLFeature = ... # 0x800
        NPOTTextures             : QOpenGLFunctions.OpenGLFeature = ... # 0x1000
        NPOTTextureRepeat        : QOpenGLFunctions.OpenGLFeature = ... # 0x2000
        FixedFunctionPipeline    : QOpenGLFunctions.OpenGLFeature = ... # 0x4000
        TextureRGFormats         : QOpenGLFunctions.OpenGLFeature = ... # 0x8000
        MultipleRenderTargets    : QOpenGLFunctions.OpenGLFeature = ... # 0x10000
        BlendEquationAdvanced    : QOpenGLFunctions.OpenGLFeature = ... # 0x20000

    class OpenGLFeatures(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, context:PySide2.QtGui.QOpenGLContext) -> None: ...

    def glActiveTexture(self, texture:int) -> None: ...
    def glAttachShader(self, program:int, shader:int) -> None: ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes) -> None: ...
    def glBindBuffer(self, target:int, buffer:int) -> None: ...
    def glBindFramebuffer(self, target:int, framebuffer:int) -> None: ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int) -> None: ...
    def glBindTexture(self, target:int, texture:int) -> None: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glBlendEquation(self, mode:int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int) -> None: ...
    def glBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def glBlendFuncSeparate(self, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int) -> None: ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClear(self, mask:int) -> None: ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def glClearDepthf(self, depth:float) -> None: ...
    def glClearStencil(self, s:int) -> None: ...
    def glColorMask(self, red:int, green:int, blue:int, alpha:int) -> None: ...
    def glCompileShader(self, shader:int) -> None: ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int) -> None: ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int) -> None: ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int) -> None: ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int) -> None: ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int) -> None: ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glDeleteProgram(self, program:int) -> None: ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glDeleteShader(self, shader:int) -> None: ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glDepthFunc(self, func:int) -> None: ...
    def glDepthMask(self, flag:int) -> None: ...
    def glDepthRangef(self, zNear:float, zFar:float) -> None: ...
    def glDetachShader(self, program:int, shader:int) -> None: ...
    def glDisable(self, cap:int) -> None: ...
    def glDisableVertexAttribArray(self, index:int) -> None: ...
    def glDrawArrays(self, mode:int, first:int, count:int) -> None: ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int) -> None: ...
    def glEnable(self, cap:int) -> None: ...
    def glEnableVertexAttribArray(self, index:int) -> None: ...
    def glFinish(self) -> None: ...
    def glFlush(self) -> None: ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int) -> None: ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int) -> None: ...
    def glFrontFace(self, mode:int) -> None: ...
    def glGenBuffers(self, n:int, buffers:typing.Sequence) -> None: ...
    def glGenFramebuffers(self, n:int, framebuffers:typing.Sequence) -> None: ...
    def glGenRenderbuffers(self, n:int, renderbuffers:typing.Sequence) -> None: ...
    def glGenTextures(self, n:int, textures:typing.Sequence) -> None: ...
    def glGenerateMipmap(self, target:int) -> None: ...
    def glGetAttachedShaders(self, program:int, maxcount:int, count:typing.Sequence, shaders:typing.Sequence) -> None: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetBufferParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetError(self) -> int: ...
    def glGetFloatv(self, pname:int, params:typing.Sequence) -> None: ...
    def glGetFramebufferAttachmentParameteriv(self, target:int, attachment:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetIntegerv(self, pname:int, params:typing.Sequence) -> None: ...
    def glGetProgramiv(self, program:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetRenderbufferParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetShaderPrecisionFormat(self, shadertype:int, precisiontype:int, range:typing.Sequence, precision:typing.Sequence) -> None: ...
    def glGetShaderiv(self, shader:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glGetUniformfv(self, program:int, location:int, params:typing.Sequence) -> None: ...
    def glGetUniformiv(self, program:int, location:int, params:typing.Sequence) -> None: ...
    def glGetVertexAttribfv(self, index:int, pname:int, params:typing.Sequence) -> None: ...
    def glGetVertexAttribiv(self, index:int, pname:int, params:typing.Sequence) -> None: ...
    def glHint(self, target:int, mode:int) -> None: ...
    def glIsBuffer(self, buffer:int) -> int: ...
    def glIsEnabled(self, cap:int) -> int: ...
    def glIsFramebuffer(self, framebuffer:int) -> int: ...
    def glIsProgram(self, program:int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> int: ...
    def glIsShader(self, shader:int) -> int: ...
    def glIsTexture(self, texture:int) -> int: ...
    def glLineWidth(self, width:float) -> None: ...
    def glLinkProgram(self, program:int) -> None: ...
    def glPixelStorei(self, pname:int, param:int) -> None: ...
    def glPolygonOffset(self, factor:float, units:float) -> None: ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int) -> None: ...
    def glSampleCoverage(self, value:float, invert:int) -> None: ...
    def glScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def glShaderBinary(self, n:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int) -> None: ...
    def glStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def glStencilMask(self, mask:int) -> None: ...
    def glStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int) -> None: ...
    def glStencilOpSeparate(self, face:int, fail:int, zfail:int, zpass:int) -> None: ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int) -> None: ...
    def glTexParameterf(self, target:int, pname:int, param:float) -> None: ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexParameteri(self, target:int, pname:int, param:int) -> None: ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence) -> None: ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int) -> None: ...
    def glUniform1f(self, location:int, x:float) -> None: ...
    def glUniform1fv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniform1i(self, location:int, x:int) -> None: ...
    def glUniform1iv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniform2f(self, location:int, x:float, y:float) -> None: ...
    def glUniform2fv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniform2i(self, location:int, x:int, y:int) -> None: ...
    def glUniform2iv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniform3f(self, location:int, x:float, y:float, z:float) -> None: ...
    def glUniform3fv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniform3i(self, location:int, x:int, y:int, z:int) -> None: ...
    def glUniform3iv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniform4f(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    def glUniform4fv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniform4i(self, location:int, x:int, y:int, z:int, w:int) -> None: ...
    def glUniform4iv(self, location:int, count:int, v:typing.Sequence) -> None: ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:int, value:typing.Sequence) -> None: ...
    def glUseProgram(self, program:int) -> None: ...
    def glValidateProgram(self, program:int) -> None: ...
    def glVertexAttrib1f(self, indx:int, x:float) -> None: ...
    def glVertexAttrib1fv(self, indx:int, values:typing.Sequence) -> None: ...
    def glVertexAttrib2f(self, indx:int, x:float, y:float) -> None: ...
    def glVertexAttrib2fv(self, indx:int, values:typing.Sequence) -> None: ...
    def glVertexAttrib3f(self, indx:int, x:float, y:float, z:float) -> None: ...
    def glVertexAttrib3fv(self, indx:int, values:typing.Sequence) -> None: ...
    def glVertexAttrib4f(self, indx:int, x:float, y:float, z:float, w:float) -> None: ...
    def glVertexAttrib4fv(self, indx:int, values:typing.Sequence) -> None: ...
    def glVertexAttribPointer(self, indx:int, size:int, type:int, normalized:int, stride:int, ptr:int) -> None: ...
    def glViewport(self, x:int, y:int, width:int, height:int) -> None: ...
    def hasOpenGLFeature(self, feature:PySide2.QtGui.QOpenGLFunctions.OpenGLFeature) -> bool: ...
    def initializeOpenGLFunctions(self) -> None: ...
    def openGLFeatures(self) -> PySide2.QtGui.QOpenGLFunctions.OpenGLFeatures: ...


class QOpenGLPixelTransferOptions(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QOpenGLPixelTransferOptions) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> int: ...
    def imageHeight(self) -> int: ...
    def isLeastSignificantBitFirst(self) -> bool: ...
    def isSwapBytesEnabled(self) -> bool: ...
    def rowLength(self) -> int: ...
    def setAlignment(self, alignment:int) -> None: ...
    def setImageHeight(self, imageHeight:int) -> None: ...
    def setLeastSignificantByteFirst(self, lsbFirst:bool) -> None: ...
    def setRowLength(self, rowLength:int) -> None: ...
    def setSkipImages(self, skipImages:int) -> None: ...
    def setSkipPixels(self, skipPixels:int) -> None: ...
    def setSkipRows(self, skipRows:int) -> None: ...
    def setSwapBytesEnabled(self, swapBytes:bool) -> None: ...
    def skipImages(self) -> int: ...
    def skipPixels(self) -> int: ...
    def skipRows(self) -> int: ...
    def swap(self, other:PySide2.QtGui.QOpenGLPixelTransferOptions) -> None: ...


class QOpenGLShader(PySide2.QtCore.QObject):
    Vertex                   : QOpenGLShader = ... # 0x1
    Fragment                 : QOpenGLShader = ... # 0x2
    Geometry                 : QOpenGLShader = ... # 0x4
    TessellationControl      : QOpenGLShader = ... # 0x8
    TessellationEvaluation   : QOpenGLShader = ... # 0x10
    Compute                  : QOpenGLShader = ... # 0x20

    class ShaderType(object): ...

    class ShaderTypeBit(object):
        Vertex                   : QOpenGLShader.ShaderTypeBit = ... # 0x1
        Fragment                 : QOpenGLShader.ShaderTypeBit = ... # 0x2
        Geometry                 : QOpenGLShader.ShaderTypeBit = ... # 0x4
        TessellationControl      : QOpenGLShader.ShaderTypeBit = ... # 0x8
        TessellationEvaluation   : QOpenGLShader.ShaderTypeBit = ... # 0x10
        Compute                  : QOpenGLShader.ShaderTypeBit = ... # 0x20

    def __init__(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    @typing.overload
    def compileSourceCode(self, source:PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source:str) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source:bytes) -> bool: ...
    def compileSourceFile(self, fileName:str) -> bool: ...
    @staticmethod
    def hasOpenGLShaders(type:PySide2.QtGui.QOpenGLShader.ShaderType, context:typing.Optional[PySide2.QtGui.QOpenGLContext]=...) -> bool: ...
    def isCompiled(self) -> bool: ...
    def log(self) -> str: ...
    def shaderId(self) -> int: ...
    def shaderType(self) -> PySide2.QtGui.QOpenGLShader.ShaderType: ...
    def sourceCode(self) -> PySide2.QtCore.QByteArray: ...


class QOpenGLShaderProgram(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    @typing.overload
    def addCacheableShaderFromSourceCode(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, source:PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def addCacheableShaderFromSourceCode(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, source:str) -> bool: ...
    @typing.overload
    def addCacheableShaderFromSourceCode(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, source:bytes) -> bool: ...
    def addCacheableShaderFromSourceFile(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, fileName:str) -> bool: ...
    def addShader(self, shader:PySide2.QtGui.QOpenGLShader) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, source:PySide2.QtCore.QByteArray) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, source:str) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, source:bytes) -> bool: ...
    def addShaderFromSourceFile(self, type:PySide2.QtGui.QOpenGLShader.ShaderType, fileName:str) -> bool: ...
    @typing.overload
    def attributeLocation(self, name:PySide2.QtCore.QByteArray) -> int: ...
    @typing.overload
    def attributeLocation(self, name:str) -> int: ...
    @typing.overload
    def attributeLocation(self, name:bytes) -> int: ...
    def bind(self) -> bool: ...
    @typing.overload
    def bindAttributeLocation(self, name:PySide2.QtCore.QByteArray, location:int) -> None: ...
    @typing.overload
    def bindAttributeLocation(self, name:str, location:int) -> None: ...
    @typing.overload
    def bindAttributeLocation(self, name:bytes, location:int) -> None: ...
    def create(self) -> bool: ...
    def defaultInnerTessellationLevels(self) -> typing.List: ...
    def defaultOuterTessellationLevels(self) -> typing.List: ...
    @typing.overload
    def disableAttributeArray(self, location:int) -> None: ...
    @typing.overload
    def disableAttributeArray(self, name:bytes) -> None: ...
    @typing.overload
    def enableAttributeArray(self, location:int) -> None: ...
    @typing.overload
    def enableAttributeArray(self, name:bytes) -> None: ...
    @staticmethod
    def hasOpenGLShaderPrograms(context:typing.Optional[PySide2.QtGui.QOpenGLContext]=...) -> bool: ...
    def isLinked(self) -> bool: ...
    def link(self) -> bool: ...
    def log(self) -> str: ...
    def maxGeometryOutputVertices(self) -> int: ...
    def patchVertexCount(self) -> int: ...
    def programId(self) -> int: ...
    def release(self) -> None: ...
    def removeAllShaders(self) -> None: ...
    def removeShader(self, shader:PySide2.QtGui.QOpenGLShader) -> None: ...
    @typing.overload
    def setAttributeArray(self, location:int, type:int, values:int, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray(self, location:int, values:typing.Sequence, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray(self, name:bytes, type:int, values:int, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeArray(self, name:bytes, values:typing.Sequence, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeBuffer(self, location:int, type:int, offset:int, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeBuffer(self, name:bytes, type:int, offset:int, tupleSize:int, stride:int=...) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, value:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, values:typing.Sequence, columns:int, rows:int) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, x:float, y:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, value:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, values:typing.Sequence, columns:int, rows:int) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, x:float, y:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name:bytes, x:float, y:float, z:float, w:float) -> None: ...
    def setDefaultInnerTessellationLevels(self, levels:typing.List) -> None: ...
    def setDefaultOuterTessellationLevels(self, levels:typing.List) -> None: ...
    def setPatchVertexCount(self, count:int) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, point:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, size:PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, size:PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QTransform) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:float) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:typing.Tuple) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:typing.Tuple) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:typing.Tuple) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:int) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, value:int) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, x:float, y:float) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setUniformValue(self, location:int, x:float, y:float, z:float, w:float) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, point:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, size:PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, size:PySide2.QtCore.QSizeF) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QTransform) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:typing.Tuple) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:typing.Tuple) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, value:typing.Tuple) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, x:float, y:float) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, x:float, y:float, z:float) -> None: ...
    @typing.overload
    def setUniformValue(self, name:bytes, x:float, y:float, z:float, w:float) -> None: ...
    @typing.overload
    def setUniformValue1f(self, arg__1:bytes, arg__2:float) -> None: ...
    @typing.overload
    def setUniformValue1f(self, arg__1:int, arg__2:float) -> None: ...
    @typing.overload
    def setUniformValue1i(self, arg__1:bytes, arg__2:int) -> None: ...
    @typing.overload
    def setUniformValue1i(self, arg__1:int, arg__2:int) -> None: ...
    @typing.overload
    def setUniformValueArray(self, location:int, values:typing.Sequence, count:int, tupleSize:int) -> None: ...
    @typing.overload
    def setUniformValueArray(self, location:int, values:typing.Sequence, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray(self, location:int, values:typing.Sequence, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray(self, name:bytes, values:typing.Sequence, count:int, tupleSize:int) -> None: ...
    @typing.overload
    def setUniformValueArray(self, name:bytes, values:typing.Sequence, count:int) -> None: ...
    @typing.overload
    def setUniformValueArray(self, name:bytes, values:typing.Sequence, count:int) -> None: ...
    def shaders(self) -> typing.List: ...
    @typing.overload
    def uniformLocation(self, name:PySide2.QtCore.QByteArray) -> int: ...
    @typing.overload
    def uniformLocation(self, name:str) -> int: ...
    @typing.overload
    def uniformLocation(self, name:bytes) -> int: ...


class QOpenGLTexture(Shiboken.Object):
    CompareNone              : QOpenGLTexture = ... # 0x0
    GenerateMipMaps          : QOpenGLTexture = ... # 0x0
    NoFormat                 : QOpenGLTexture = ... # 0x0
    NoFormatClass            : QOpenGLTexture = ... # 0x0
    NoPixelType              : QOpenGLTexture = ... # 0x0
    NoSourceFormat           : QOpenGLTexture = ... # 0x0
    ResetTextureUnit         : QOpenGLTexture = ... # 0x0
    ZeroValue                : QOpenGLTexture = ... # 0x0
    DontGenerateMipMaps      : QOpenGLTexture = ... # 0x1
    DontResetTextureUnit     : QOpenGLTexture = ... # 0x1
    FormatClass_128Bit       : QOpenGLTexture = ... # 0x1
    ImmutableStorage         : QOpenGLTexture = ... # 0x1
    OneValue                 : QOpenGLTexture = ... # 0x1
    FormatClass_96Bit        : QOpenGLTexture = ... # 0x2
    ImmutableMultisampleStorage: QOpenGLTexture = ... # 0x2
    FormatClass_64Bit        : QOpenGLTexture = ... # 0x3
    FormatClass_48Bit        : QOpenGLTexture = ... # 0x4
    TextureRectangle         : QOpenGLTexture = ... # 0x4
    FormatClass_32Bit        : QOpenGLTexture = ... # 0x5
    FormatClass_24Bit        : QOpenGLTexture = ... # 0x6
    FormatClass_16Bit        : QOpenGLTexture = ... # 0x7
    FormatClass_8Bit         : QOpenGLTexture = ... # 0x8
    TextureArrays            : QOpenGLTexture = ... # 0x8
    FormatClass_RGTC1_R      : QOpenGLTexture = ... # 0x9
    FormatClass_RGTC2_RG     : QOpenGLTexture = ... # 0xa
    FormatClass_BPTC_Unorm   : QOpenGLTexture = ... # 0xb
    FormatClass_BPTC_Float   : QOpenGLTexture = ... # 0xc
    FormatClass_S3TC_DXT1_RGB: QOpenGLTexture = ... # 0xd
    FormatClass_S3TC_DXT1_RGBA: QOpenGLTexture = ... # 0xe
    FormatClass_S3TC_DXT3_RGBA: QOpenGLTexture = ... # 0xf
    FormatClass_S3TC_DXT5_RGBA: QOpenGLTexture = ... # 0x10
    Texture3D                : QOpenGLTexture = ... # 0x10
    FormatClass_Unique       : QOpenGLTexture = ... # 0x11
    TextureMultisample       : QOpenGLTexture = ... # 0x20
    TextureBuffer            : QOpenGLTexture = ... # 0x40
    TextureCubeMapArrays     : QOpenGLTexture = ... # 0x80
    Swizzle                  : QOpenGLTexture = ... # 0x100
    CompareNever             : QOpenGLTexture = ... # 0x200
    StencilTexturing         : QOpenGLTexture = ... # 0x200
    CompareLess              : QOpenGLTexture = ... # 0x201
    CompareEqual             : QOpenGLTexture = ... # 0x202
    CompareLessEqual         : QOpenGLTexture = ... # 0x203
    CompareGreater           : QOpenGLTexture = ... # 0x204
    CommpareNotEqual         : QOpenGLTexture = ... # 0x205
    CompareGreaterEqual      : QOpenGLTexture = ... # 0x206
    CompareAlways            : QOpenGLTexture = ... # 0x207
    AnisotropicFiltering     : QOpenGLTexture = ... # 0x400
    NPOTTextures             : QOpenGLTexture = ... # 0x800
    Target1D                 : QOpenGLTexture = ... # 0xde0
    Target2D                 : QOpenGLTexture = ... # 0xde1
    NPOTTextureRepeat        : QOpenGLTexture = ... # 0x1000
    Int8                     : QOpenGLTexture = ... # 0x1400
    UInt8                    : QOpenGLTexture = ... # 0x1401
    Int16                    : QOpenGLTexture = ... # 0x1402
    UInt16                   : QOpenGLTexture = ... # 0x1403
    Int32                    : QOpenGLTexture = ... # 0x1404
    UInt32                   : QOpenGLTexture = ... # 0x1405
    Float32                  : QOpenGLTexture = ... # 0x1406
    Float16                  : QOpenGLTexture = ... # 0x140b
    Stencil                  : QOpenGLTexture = ... # 0x1901
    StencilMode              : QOpenGLTexture = ... # 0x1901
    Depth                    : QOpenGLTexture = ... # 0x1902
    DepthFormat              : QOpenGLTexture = ... # 0x1902
    DepthMode                : QOpenGLTexture = ... # 0x1902
    Red                      : QOpenGLTexture = ... # 0x1903
    RedValue                 : QOpenGLTexture = ... # 0x1903
    GreenValue               : QOpenGLTexture = ... # 0x1904
    BlueValue                : QOpenGLTexture = ... # 0x1905
    Alpha                    : QOpenGLTexture = ... # 0x1906
    AlphaFormat              : QOpenGLTexture = ... # 0x1906
    AlphaValue               : QOpenGLTexture = ... # 0x1906
    RGB                      : QOpenGLTexture = ... # 0x1907
    RGBFormat                : QOpenGLTexture = ... # 0x1907
    RGBA                     : QOpenGLTexture = ... # 0x1908
    RGBAFormat               : QOpenGLTexture = ... # 0x1908
    Luminance                : QOpenGLTexture = ... # 0x1909
    LuminanceFormat          : QOpenGLTexture = ... # 0x1909
    LuminanceAlpha           : QOpenGLTexture = ... # 0x190a
    LuminanceAlphaFormat     : QOpenGLTexture = ... # 0x190a
    Texture1D                : QOpenGLTexture = ... # 0x2000
    Nearest                  : QOpenGLTexture = ... # 0x2600
    Linear                   : QOpenGLTexture = ... # 0x2601
    NearestMipMapNearest     : QOpenGLTexture = ... # 0x2700
    LinearMipMapNearest      : QOpenGLTexture = ... # 0x2701
    NearestMipMapLinear      : QOpenGLTexture = ... # 0x2702
    LinearMipMapLinear       : QOpenGLTexture = ... # 0x2703
    DirectionS               : QOpenGLTexture = ... # 0x2802
    DirectionT               : QOpenGLTexture = ... # 0x2803
    Repeat                   : QOpenGLTexture = ... # 0x2901
    RG3B2                    : QOpenGLTexture = ... # 0x2a10
    TextureComparisonOperators: QOpenGLTexture = ... # 0x4000
    TextureMipMapLevel       : QOpenGLTexture = ... # 0x8000
    UInt8_RG3B2              : QOpenGLTexture = ... # 0x8032
    UInt16_RGBA4             : QOpenGLTexture = ... # 0x8033
    UInt16_RGB5A1            : QOpenGLTexture = ... # 0x8034
    UInt32_RGBA8             : QOpenGLTexture = ... # 0x8035
    UInt32_RGB10A2           : QOpenGLTexture = ... # 0x8036
    RGB8_UNorm               : QOpenGLTexture = ... # 0x8051
    RGB16_UNorm              : QOpenGLTexture = ... # 0x8054
    RGBA4                    : QOpenGLTexture = ... # 0x8056
    RGB5A1                   : QOpenGLTexture = ... # 0x8057
    RGBA8_UNorm              : QOpenGLTexture = ... # 0x8058
    RGBA16_UNorm             : QOpenGLTexture = ... # 0x805b
    BindingTarget1D          : QOpenGLTexture = ... # 0x8068
    BindingTarget2D          : QOpenGLTexture = ... # 0x8069
    BindingTarget3D          : QOpenGLTexture = ... # 0x806a
    Target3D                 : QOpenGLTexture = ... # 0x806f
    DirectionR               : QOpenGLTexture = ... # 0x8072
    BGR                      : QOpenGLTexture = ... # 0x80e0
    BGRA                     : QOpenGLTexture = ... # 0x80e1
    ClampToBorder            : QOpenGLTexture = ... # 0x812d
    ClampToEdge              : QOpenGLTexture = ... # 0x812f
    D16                      : QOpenGLTexture = ... # 0x81a5
    D24                      : QOpenGLTexture = ... # 0x81a6
    D32                      : QOpenGLTexture = ... # 0x81a7
    RG                       : QOpenGLTexture = ... # 0x8227
    RG_Integer               : QOpenGLTexture = ... # 0x8228
    R8_UNorm                 : QOpenGLTexture = ... # 0x8229
    R16_UNorm                : QOpenGLTexture = ... # 0x822a
    RG8_UNorm                : QOpenGLTexture = ... # 0x822b
    RG16_UNorm               : QOpenGLTexture = ... # 0x822c
    R16F                     : QOpenGLTexture = ... # 0x822d
    R32F                     : QOpenGLTexture = ... # 0x822e
    RG16F                    : QOpenGLTexture = ... # 0x822f
    RG32F                    : QOpenGLTexture = ... # 0x8230
    R8I                      : QOpenGLTexture = ... # 0x8231
    R8U                      : QOpenGLTexture = ... # 0x8232
    R16I                     : QOpenGLTexture = ... # 0x8233
    R16U                     : QOpenGLTexture = ... # 0x8234
    R32I                     : QOpenGLTexture = ... # 0x8235
    R32U                     : QOpenGLTexture = ... # 0x8236
    RG8I                     : QOpenGLTexture = ... # 0x8237
    RG8U                     : QOpenGLTexture = ... # 0x8238
    RG16I                    : QOpenGLTexture = ... # 0x8239
    RG16U                    : QOpenGLTexture = ... # 0x823a
    RG32I                    : QOpenGLTexture = ... # 0x823b
    RG32U                    : QOpenGLTexture = ... # 0x823c
    UInt8_RG3B2_Rev          : QOpenGLTexture = ... # 0x8362
    UInt16_R5G6B5            : QOpenGLTexture = ... # 0x8363
    UInt16_R5G6B5_Rev        : QOpenGLTexture = ... # 0x8364
    UInt16_RGBA4_Rev         : QOpenGLTexture = ... # 0x8365
    UInt16_RGB5A1_Rev        : QOpenGLTexture = ... # 0x8366
    UInt32_RGBA8_Rev         : QOpenGLTexture = ... # 0x8367
    UInt32_RGB10A2_Rev       : QOpenGLTexture = ... # 0x8368
    MirroredRepeat           : QOpenGLTexture = ... # 0x8370
    RGB_DXT1                 : QOpenGLTexture = ... # 0x83f0
    RGBA_DXT1                : QOpenGLTexture = ... # 0x83f1
    RGBA_DXT3                : QOpenGLTexture = ... # 0x83f2
    RGBA_DXT5                : QOpenGLTexture = ... # 0x83f3
    TargetRectangle          : QOpenGLTexture = ... # 0x84f5
    BindingTargetRectangle   : QOpenGLTexture = ... # 0x84f6
    DepthStencil             : QOpenGLTexture = ... # 0x84f9
    UInt32_D24S8             : QOpenGLTexture = ... # 0x84fa
    TargetCubeMap            : QOpenGLTexture = ... # 0x8513
    BindingTargetCubeMap     : QOpenGLTexture = ... # 0x8514
    CubeMapPositiveX         : QOpenGLTexture = ... # 0x8515
    CubeMapNegativeX         : QOpenGLTexture = ... # 0x8516
    CubeMapPositiveY         : QOpenGLTexture = ... # 0x8517
    CubeMapNegativeY         : QOpenGLTexture = ... # 0x8518
    CubeMapPositiveZ         : QOpenGLTexture = ... # 0x8519
    CubeMapNegativeZ         : QOpenGLTexture = ... # 0x851a
    RGBA32F                  : QOpenGLTexture = ... # 0x8814
    RGB32F                   : QOpenGLTexture = ... # 0x8815
    RGBA16F                  : QOpenGLTexture = ... # 0x881a
    RGB16F                   : QOpenGLTexture = ... # 0x881b
    CompareRefToTexture      : QOpenGLTexture = ... # 0x884e
    D24S8                    : QOpenGLTexture = ... # 0x88f0
    Target1DArray            : QOpenGLTexture = ... # 0x8c18
    Target2DArray            : QOpenGLTexture = ... # 0x8c1a
    BindingTarget1DArray     : QOpenGLTexture = ... # 0x8c1c
    BindingTarget2DArray     : QOpenGLTexture = ... # 0x8c1d
    TargetBuffer             : QOpenGLTexture = ... # 0x8c2a
    BindingTargetBuffer      : QOpenGLTexture = ... # 0x8c2c
    RG11B10F                 : QOpenGLTexture = ... # 0x8c3a
    UInt32_RG11B10F          : QOpenGLTexture = ... # 0x8c3b
    RGB9E5                   : QOpenGLTexture = ... # 0x8c3d
    UInt32_RGB9_E5           : QOpenGLTexture = ... # 0x8c3e
    SRGB8                    : QOpenGLTexture = ... # 0x8c41
    SRGB8_Alpha8             : QOpenGLTexture = ... # 0x8c43
    SRGB_DXT1                : QOpenGLTexture = ... # 0x8c4c
    SRGB_Alpha_DXT1          : QOpenGLTexture = ... # 0x8c4d
    SRGB_Alpha_DXT3          : QOpenGLTexture = ... # 0x8c4e
    SRGB_Alpha_DXT5          : QOpenGLTexture = ... # 0x8c4f
    D32F                     : QOpenGLTexture = ... # 0x8cac
    D32FS8X24                : QOpenGLTexture = ... # 0x8cad
    S8                       : QOpenGLTexture = ... # 0x8d48
    Float16OES               : QOpenGLTexture = ... # 0x8d61
    R5G6B5                   : QOpenGLTexture = ... # 0x8d62
    RGB8_ETC1                : QOpenGLTexture = ... # 0x8d64
    RGBA32U                  : QOpenGLTexture = ... # 0x8d70
    RGB32U                   : QOpenGLTexture = ... # 0x8d71
    RGBA16U                  : QOpenGLTexture = ... # 0x8d76
    RGB16U                   : QOpenGLTexture = ... # 0x8d77
    RGBA8U                   : QOpenGLTexture = ... # 0x8d7c
    RGB8U                    : QOpenGLTexture = ... # 0x8d7d
    RGBA32I                  : QOpenGLTexture = ... # 0x8d82
    RGB32I                   : QOpenGLTexture = ... # 0x8d83
    RGBA16I                  : QOpenGLTexture = ... # 0x8d88
    RGB16I                   : QOpenGLTexture = ... # 0x8d89
    RGBA8I                   : QOpenGLTexture = ... # 0x8d8e
    RGB8I                    : QOpenGLTexture = ... # 0x8d8f
    Red_Integer              : QOpenGLTexture = ... # 0x8d94
    RGB_Integer              : QOpenGLTexture = ... # 0x8d98
    RGBA_Integer             : QOpenGLTexture = ... # 0x8d99
    BGR_Integer              : QOpenGLTexture = ... # 0x8d9a
    BGRA_Integer             : QOpenGLTexture = ... # 0x8d9b
    Float32_D32_UInt32_S8_X24: QOpenGLTexture = ... # 0x8dad
    R_ATI1N_UNorm            : QOpenGLTexture = ... # 0x8dbb
    R_ATI1N_SNorm            : QOpenGLTexture = ... # 0x8dbc
    RG_ATI2N_UNorm           : QOpenGLTexture = ... # 0x8dbd
    RG_ATI2N_SNorm           : QOpenGLTexture = ... # 0x8dbe
    SwizzleRed               : QOpenGLTexture = ... # 0x8e42
    SwizzleGreen             : QOpenGLTexture = ... # 0x8e43
    SwizzleBlue              : QOpenGLTexture = ... # 0x8e44
    SwizzleAlpha             : QOpenGLTexture = ... # 0x8e45
    RGB_BP_UNorm             : QOpenGLTexture = ... # 0x8e8c
    SRGB_BP_UNorm            : QOpenGLTexture = ... # 0x8e8d
    RGB_BP_SIGNED_FLOAT      : QOpenGLTexture = ... # 0x8e8e
    RGB_BP_UNSIGNED_FLOAT    : QOpenGLTexture = ... # 0x8e8f
    R8_SNorm                 : QOpenGLTexture = ... # 0x8f94
    RG8_SNorm                : QOpenGLTexture = ... # 0x8f95
    RGB8_SNorm               : QOpenGLTexture = ... # 0x8f96
    RGBA8_SNorm              : QOpenGLTexture = ... # 0x8f97
    R16_SNorm                : QOpenGLTexture = ... # 0x8f98
    RG16_SNorm               : QOpenGLTexture = ... # 0x8f99
    RGB16_SNorm              : QOpenGLTexture = ... # 0x8f9a
    RGBA16_SNorm             : QOpenGLTexture = ... # 0x8f9b
    TargetCubeMapArray       : QOpenGLTexture = ... # 0x9009
    BindingTargetCubeMapArray: QOpenGLTexture = ... # 0x900a
    RGB10A2                  : QOpenGLTexture = ... # 0x906f
    Target2DMultisample      : QOpenGLTexture = ... # 0x9100
    Target2DMultisampleArray : QOpenGLTexture = ... # 0x9102
    BindingTarget2DMultisample: QOpenGLTexture = ... # 0x9104
    BindingTarget2DMultisampleArray: QOpenGLTexture = ... # 0x9105
    R11_EAC_UNorm            : QOpenGLTexture = ... # 0x9270
    R11_EAC_SNorm            : QOpenGLTexture = ... # 0x9271
    RG11_EAC_UNorm           : QOpenGLTexture = ... # 0x9272
    RG11_EAC_SNorm           : QOpenGLTexture = ... # 0x9273
    RGB8_ETC2                : QOpenGLTexture = ... # 0x9274
    SRGB8_ETC2               : QOpenGLTexture = ... # 0x9275
    RGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture = ... # 0x9276
    SRGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture = ... # 0x9277
    RGBA8_ETC2_EAC           : QOpenGLTexture = ... # 0x9278
    SRGB8_Alpha8_ETC2_EAC    : QOpenGLTexture = ... # 0x9279
    RGBA_ASTC_4x4            : QOpenGLTexture = ... # 0x93b0
    RGBA_ASTC_5x4            : QOpenGLTexture = ... # 0x93b1
    RGBA_ASTC_5x5            : QOpenGLTexture = ... # 0x93b2
    RGBA_ASTC_6x5            : QOpenGLTexture = ... # 0x93b3
    RGBA_ASTC_6x6            : QOpenGLTexture = ... # 0x93b4
    RGBA_ASTC_8x5            : QOpenGLTexture = ... # 0x93b5
    RGBA_ASTC_8x6            : QOpenGLTexture = ... # 0x93b6
    RGBA_ASTC_8x8            : QOpenGLTexture = ... # 0x93b7
    RGBA_ASTC_10x5           : QOpenGLTexture = ... # 0x93b8
    RGBA_ASTC_10x6           : QOpenGLTexture = ... # 0x93b9
    RGBA_ASTC_10x8           : QOpenGLTexture = ... # 0x93ba
    RGBA_ASTC_10x10          : QOpenGLTexture = ... # 0x93bb
    RGBA_ASTC_12x10          : QOpenGLTexture = ... # 0x93bc
    RGBA_ASTC_12x12          : QOpenGLTexture = ... # 0x93bd
    SRGB8_Alpha8_ASTC_4x4    : QOpenGLTexture = ... # 0x93d0
    SRGB8_Alpha8_ASTC_5x4    : QOpenGLTexture = ... # 0x93d1
    SRGB8_Alpha8_ASTC_5x5    : QOpenGLTexture = ... # 0x93d2
    SRGB8_Alpha8_ASTC_6x5    : QOpenGLTexture = ... # 0x93d3
    SRGB8_Alpha8_ASTC_6x6    : QOpenGLTexture = ... # 0x93d4
    SRGB8_Alpha8_ASTC_8x5    : QOpenGLTexture = ... # 0x93d5
    SRGB8_Alpha8_ASTC_8x6    : QOpenGLTexture = ... # 0x93d6
    SRGB8_Alpha8_ASTC_8x8    : QOpenGLTexture = ... # 0x93d7
    SRGB8_Alpha8_ASTC_10x5   : QOpenGLTexture = ... # 0x93d8
    SRGB8_Alpha8_ASTC_10x6   : QOpenGLTexture = ... # 0x93d9
    SRGB8_Alpha8_ASTC_10x8   : QOpenGLTexture = ... # 0x93da
    SRGB8_Alpha8_ASTC_10x10  : QOpenGLTexture = ... # 0x93db
    SRGB8_Alpha8_ASTC_12x10  : QOpenGLTexture = ... # 0x93dc
    SRGB8_Alpha8_ASTC_12x12  : QOpenGLTexture = ... # 0x93dd
    MaxFeatureFlag           : QOpenGLTexture = ... # 0x10000

    class BindingTarget(object):
        BindingTarget1D          : QOpenGLTexture.BindingTarget = ... # 0x8068
        BindingTarget2D          : QOpenGLTexture.BindingTarget = ... # 0x8069
        BindingTarget3D          : QOpenGLTexture.BindingTarget = ... # 0x806a
        BindingTargetRectangle   : QOpenGLTexture.BindingTarget = ... # 0x84f6
        BindingTargetCubeMap     : QOpenGLTexture.BindingTarget = ... # 0x8514
        BindingTarget1DArray     : QOpenGLTexture.BindingTarget = ... # 0x8c1c
        BindingTarget2DArray     : QOpenGLTexture.BindingTarget = ... # 0x8c1d
        BindingTargetBuffer      : QOpenGLTexture.BindingTarget = ... # 0x8c2c
        BindingTargetCubeMapArray: QOpenGLTexture.BindingTarget = ... # 0x900a
        BindingTarget2DMultisample: QOpenGLTexture.BindingTarget = ... # 0x9104
        BindingTarget2DMultisampleArray: QOpenGLTexture.BindingTarget = ... # 0x9105

    class ComparisonFunction(object):
        CompareNever             : QOpenGLTexture.ComparisonFunction = ... # 0x200
        CompareLess              : QOpenGLTexture.ComparisonFunction = ... # 0x201
        CompareEqual             : QOpenGLTexture.ComparisonFunction = ... # 0x202
        CompareLessEqual         : QOpenGLTexture.ComparisonFunction = ... # 0x203
        CompareGreater           : QOpenGLTexture.ComparisonFunction = ... # 0x204
        CommpareNotEqual         : QOpenGLTexture.ComparisonFunction = ... # 0x205
        CompareGreaterEqual      : QOpenGLTexture.ComparisonFunction = ... # 0x206
        CompareAlways            : QOpenGLTexture.ComparisonFunction = ... # 0x207

    class ComparisonMode(object):
        CompareNone              : QOpenGLTexture.ComparisonMode = ... # 0x0
        CompareRefToTexture      : QOpenGLTexture.ComparisonMode = ... # 0x884e

    class CoordinateDirection(object):
        DirectionS               : QOpenGLTexture.CoordinateDirection = ... # 0x2802
        DirectionT               : QOpenGLTexture.CoordinateDirection = ... # 0x2803
        DirectionR               : QOpenGLTexture.CoordinateDirection = ... # 0x8072

    class CubeMapFace(object):
        CubeMapPositiveX         : QOpenGLTexture.CubeMapFace = ... # 0x8515
        CubeMapNegativeX         : QOpenGLTexture.CubeMapFace = ... # 0x8516
        CubeMapPositiveY         : QOpenGLTexture.CubeMapFace = ... # 0x8517
        CubeMapNegativeY         : QOpenGLTexture.CubeMapFace = ... # 0x8518
        CubeMapPositiveZ         : QOpenGLTexture.CubeMapFace = ... # 0x8519
        CubeMapNegativeZ         : QOpenGLTexture.CubeMapFace = ... # 0x851a

    class DepthStencilMode(object):
        StencilMode              : QOpenGLTexture.DepthStencilMode = ... # 0x1901
        DepthMode                : QOpenGLTexture.DepthStencilMode = ... # 0x1902

    class Feature(object):
        ImmutableStorage         : QOpenGLTexture.Feature = ... # 0x1
        ImmutableMultisampleStorage: QOpenGLTexture.Feature = ... # 0x2
        TextureRectangle         : QOpenGLTexture.Feature = ... # 0x4
        TextureArrays            : QOpenGLTexture.Feature = ... # 0x8
        Texture3D                : QOpenGLTexture.Feature = ... # 0x10
        TextureMultisample       : QOpenGLTexture.Feature = ... # 0x20
        TextureBuffer            : QOpenGLTexture.Feature = ... # 0x40
        TextureCubeMapArrays     : QOpenGLTexture.Feature = ... # 0x80
        Swizzle                  : QOpenGLTexture.Feature = ... # 0x100
        StencilTexturing         : QOpenGLTexture.Feature = ... # 0x200
        AnisotropicFiltering     : QOpenGLTexture.Feature = ... # 0x400
        NPOTTextures             : QOpenGLTexture.Feature = ... # 0x800
        NPOTTextureRepeat        : QOpenGLTexture.Feature = ... # 0x1000
        Texture1D                : QOpenGLTexture.Feature = ... # 0x2000
        TextureComparisonOperators: QOpenGLTexture.Feature = ... # 0x4000
        TextureMipMapLevel       : QOpenGLTexture.Feature = ... # 0x8000
        MaxFeatureFlag           : QOpenGLTexture.Feature = ... # 0x10000

    class Features(object): ...

    class Filter(object):
        Nearest                  : QOpenGLTexture.Filter = ... # 0x2600
        Linear                   : QOpenGLTexture.Filter = ... # 0x2601
        NearestMipMapNearest     : QOpenGLTexture.Filter = ... # 0x2700
        LinearMipMapNearest      : QOpenGLTexture.Filter = ... # 0x2701
        NearestMipMapLinear      : QOpenGLTexture.Filter = ... # 0x2702
        LinearMipMapLinear       : QOpenGLTexture.Filter = ... # 0x2703

    class MipMapGeneration(object):
        GenerateMipMaps          : QOpenGLTexture.MipMapGeneration = ... # 0x0
        DontGenerateMipMaps      : QOpenGLTexture.MipMapGeneration = ... # 0x1

    class PixelFormat(object):
        NoSourceFormat           : QOpenGLTexture.PixelFormat = ... # 0x0
        Stencil                  : QOpenGLTexture.PixelFormat = ... # 0x1901
        Depth                    : QOpenGLTexture.PixelFormat = ... # 0x1902
        Red                      : QOpenGLTexture.PixelFormat = ... # 0x1903
        Alpha                    : QOpenGLTexture.PixelFormat = ... # 0x1906
        RGB                      : QOpenGLTexture.PixelFormat = ... # 0x1907
        RGBA                     : QOpenGLTexture.PixelFormat = ... # 0x1908
        Luminance                : QOpenGLTexture.PixelFormat = ... # 0x1909
        LuminanceAlpha           : QOpenGLTexture.PixelFormat = ... # 0x190a
        BGR                      : QOpenGLTexture.PixelFormat = ... # 0x80e0
        BGRA                     : QOpenGLTexture.PixelFormat = ... # 0x80e1
        RG                       : QOpenGLTexture.PixelFormat = ... # 0x8227
        RG_Integer               : QOpenGLTexture.PixelFormat = ... # 0x8228
        DepthStencil             : QOpenGLTexture.PixelFormat = ... # 0x84f9
        Red_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d94
        RGB_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d98
        RGBA_Integer             : QOpenGLTexture.PixelFormat = ... # 0x8d99
        BGR_Integer              : QOpenGLTexture.PixelFormat = ... # 0x8d9a
        BGRA_Integer             : QOpenGLTexture.PixelFormat = ... # 0x8d9b

    class PixelType(object):
        NoPixelType              : QOpenGLTexture.PixelType = ... # 0x0
        Int8                     : QOpenGLTexture.PixelType = ... # 0x1400
        UInt8                    : QOpenGLTexture.PixelType = ... # 0x1401
        Int16                    : QOpenGLTexture.PixelType = ... # 0x1402
        UInt16                   : QOpenGLTexture.PixelType = ... # 0x1403
        Int32                    : QOpenGLTexture.PixelType = ... # 0x1404
        UInt32                   : QOpenGLTexture.PixelType = ... # 0x1405
        Float32                  : QOpenGLTexture.PixelType = ... # 0x1406
        Float16                  : QOpenGLTexture.PixelType = ... # 0x140b
        UInt8_RG3B2              : QOpenGLTexture.PixelType = ... # 0x8032
        UInt16_RGBA4             : QOpenGLTexture.PixelType = ... # 0x8033
        UInt16_RGB5A1            : QOpenGLTexture.PixelType = ... # 0x8034
        UInt32_RGBA8             : QOpenGLTexture.PixelType = ... # 0x8035
        UInt32_RGB10A2           : QOpenGLTexture.PixelType = ... # 0x8036
        UInt8_RG3B2_Rev          : QOpenGLTexture.PixelType = ... # 0x8362
        UInt16_R5G6B5            : QOpenGLTexture.PixelType = ... # 0x8363
        UInt16_R5G6B5_Rev        : QOpenGLTexture.PixelType = ... # 0x8364
        UInt16_RGBA4_Rev         : QOpenGLTexture.PixelType = ... # 0x8365
        UInt16_RGB5A1_Rev        : QOpenGLTexture.PixelType = ... # 0x8366
        UInt32_RGBA8_Rev         : QOpenGLTexture.PixelType = ... # 0x8367
        UInt32_RGB10A2_Rev       : QOpenGLTexture.PixelType = ... # 0x8368
        UInt32_D24S8             : QOpenGLTexture.PixelType = ... # 0x84fa
        UInt32_RG11B10F          : QOpenGLTexture.PixelType = ... # 0x8c3b
        UInt32_RGB9_E5           : QOpenGLTexture.PixelType = ... # 0x8c3e
        Float16OES               : QOpenGLTexture.PixelType = ... # 0x8d61
        Float32_D32_UInt32_S8_X24: QOpenGLTexture.PixelType = ... # 0x8dad

    class SwizzleComponent(object):
        SwizzleRed               : QOpenGLTexture.SwizzleComponent = ... # 0x8e42
        SwizzleGreen             : QOpenGLTexture.SwizzleComponent = ... # 0x8e43
        SwizzleBlue              : QOpenGLTexture.SwizzleComponent = ... # 0x8e44
        SwizzleAlpha             : QOpenGLTexture.SwizzleComponent = ... # 0x8e45

    class SwizzleValue(object):
        ZeroValue                : QOpenGLTexture.SwizzleValue = ... # 0x0
        OneValue                 : QOpenGLTexture.SwizzleValue = ... # 0x1
        RedValue                 : QOpenGLTexture.SwizzleValue = ... # 0x1903
        GreenValue               : QOpenGLTexture.SwizzleValue = ... # 0x1904
        BlueValue                : QOpenGLTexture.SwizzleValue = ... # 0x1905
        AlphaValue               : QOpenGLTexture.SwizzleValue = ... # 0x1906

    class Target(object):
        Target1D                 : QOpenGLTexture.Target = ... # 0xde0
        Target2D                 : QOpenGLTexture.Target = ... # 0xde1
        Target3D                 : QOpenGLTexture.Target = ... # 0x806f
        TargetRectangle          : QOpenGLTexture.Target = ... # 0x84f5
        TargetCubeMap            : QOpenGLTexture.Target = ... # 0x8513
        Target1DArray            : QOpenGLTexture.Target = ... # 0x8c18
        Target2DArray            : QOpenGLTexture.Target = ... # 0x8c1a
        TargetBuffer             : QOpenGLTexture.Target = ... # 0x8c2a
        TargetCubeMapArray       : QOpenGLTexture.Target = ... # 0x9009
        Target2DMultisample      : QOpenGLTexture.Target = ... # 0x9100
        Target2DMultisampleArray : QOpenGLTexture.Target = ... # 0x9102

    class TextureFormat(object):
        NoFormat                 : QOpenGLTexture.TextureFormat = ... # 0x0
        DepthFormat              : QOpenGLTexture.TextureFormat = ... # 0x1902
        AlphaFormat              : QOpenGLTexture.TextureFormat = ... # 0x1906
        RGBFormat                : QOpenGLTexture.TextureFormat = ... # 0x1907
        RGBAFormat               : QOpenGLTexture.TextureFormat = ... # 0x1908
        LuminanceFormat          : QOpenGLTexture.TextureFormat = ... # 0x1909
        LuminanceAlphaFormat     : QOpenGLTexture.TextureFormat = ... # 0x190a
        RG3B2                    : QOpenGLTexture.TextureFormat = ... # 0x2a10
        RGB8_UNorm               : QOpenGLTexture.TextureFormat = ... # 0x8051
        RGB16_UNorm              : QOpenGLTexture.TextureFormat = ... # 0x8054
        RGBA4                    : QOpenGLTexture.TextureFormat = ... # 0x8056
        RGB5A1                   : QOpenGLTexture.TextureFormat = ... # 0x8057
        RGBA8_UNorm              : QOpenGLTexture.TextureFormat = ... # 0x8058
        RGBA16_UNorm             : QOpenGLTexture.TextureFormat = ... # 0x805b
        D16                      : QOpenGLTexture.TextureFormat = ... # 0x81a5
        D24                      : QOpenGLTexture.TextureFormat = ... # 0x81a6
        D32                      : QOpenGLTexture.TextureFormat = ... # 0x81a7
        R8_UNorm                 : QOpenGLTexture.TextureFormat = ... # 0x8229
        R16_UNorm                : QOpenGLTexture.TextureFormat = ... # 0x822a
        RG8_UNorm                : QOpenGLTexture.TextureFormat = ... # 0x822b
        RG16_UNorm               : QOpenGLTexture.TextureFormat = ... # 0x822c
        R16F                     : QOpenGLTexture.TextureFormat = ... # 0x822d
        R32F                     : QOpenGLTexture.TextureFormat = ... # 0x822e
        RG16F                    : QOpenGLTexture.TextureFormat = ... # 0x822f
        RG32F                    : QOpenGLTexture.TextureFormat = ... # 0x8230
        R8I                      : QOpenGLTexture.TextureFormat = ... # 0x8231
        R8U                      : QOpenGLTexture.TextureFormat = ... # 0x8232
        R16I                     : QOpenGLTexture.TextureFormat = ... # 0x8233
        R16U                     : QOpenGLTexture.TextureFormat = ... # 0x8234
        R32I                     : QOpenGLTexture.TextureFormat = ... # 0x8235
        R32U                     : QOpenGLTexture.TextureFormat = ... # 0x8236
        RG8I                     : QOpenGLTexture.TextureFormat = ... # 0x8237
        RG8U                     : QOpenGLTexture.TextureFormat = ... # 0x8238
        RG16I                    : QOpenGLTexture.TextureFormat = ... # 0x8239
        RG16U                    : QOpenGLTexture.TextureFormat = ... # 0x823a
        RG32I                    : QOpenGLTexture.TextureFormat = ... # 0x823b
        RG32U                    : QOpenGLTexture.TextureFormat = ... # 0x823c
        RGB_DXT1                 : QOpenGLTexture.TextureFormat = ... # 0x83f0
        RGBA_DXT1                : QOpenGLTexture.TextureFormat = ... # 0x83f1
        RGBA_DXT3                : QOpenGLTexture.TextureFormat = ... # 0x83f2
        RGBA_DXT5                : QOpenGLTexture.TextureFormat = ... # 0x83f3
        RGBA32F                  : QOpenGLTexture.TextureFormat = ... # 0x8814
        RGB32F                   : QOpenGLTexture.TextureFormat = ... # 0x8815
        RGBA16F                  : QOpenGLTexture.TextureFormat = ... # 0x881a
        RGB16F                   : QOpenGLTexture.TextureFormat = ... # 0x881b
        D24S8                    : QOpenGLTexture.TextureFormat = ... # 0x88f0
        RG11B10F                 : QOpenGLTexture.TextureFormat = ... # 0x8c3a
        RGB9E5                   : QOpenGLTexture.TextureFormat = ... # 0x8c3d
        SRGB8                    : QOpenGLTexture.TextureFormat = ... # 0x8c41
        SRGB8_Alpha8             : QOpenGLTexture.TextureFormat = ... # 0x8c43
        SRGB_DXT1                : QOpenGLTexture.TextureFormat = ... # 0x8c4c
        SRGB_Alpha_DXT1          : QOpenGLTexture.TextureFormat = ... # 0x8c4d
        SRGB_Alpha_DXT3          : QOpenGLTexture.TextureFormat = ... # 0x8c4e
        SRGB_Alpha_DXT5          : QOpenGLTexture.TextureFormat = ... # 0x8c4f
        D32F                     : QOpenGLTexture.TextureFormat = ... # 0x8cac
        D32FS8X24                : QOpenGLTexture.TextureFormat = ... # 0x8cad
        S8                       : QOpenGLTexture.TextureFormat = ... # 0x8d48
        R5G6B5                   : QOpenGLTexture.TextureFormat = ... # 0x8d62
        RGB8_ETC1                : QOpenGLTexture.TextureFormat = ... # 0x8d64
        RGBA32U                  : QOpenGLTexture.TextureFormat = ... # 0x8d70
        RGB32U                   : QOpenGLTexture.TextureFormat = ... # 0x8d71
        RGBA16U                  : QOpenGLTexture.TextureFormat = ... # 0x8d76
        RGB16U                   : QOpenGLTexture.TextureFormat = ... # 0x8d77
        RGBA8U                   : QOpenGLTexture.TextureFormat = ... # 0x8d7c
        RGB8U                    : QOpenGLTexture.TextureFormat = ... # 0x8d7d
        RGBA32I                  : QOpenGLTexture.TextureFormat = ... # 0x8d82
        RGB32I                   : QOpenGLTexture.TextureFormat = ... # 0x8d83
        RGBA16I                  : QOpenGLTexture.TextureFormat = ... # 0x8d88
        RGB16I                   : QOpenGLTexture.TextureFormat = ... # 0x8d89
        RGBA8I                   : QOpenGLTexture.TextureFormat = ... # 0x8d8e
        RGB8I                    : QOpenGLTexture.TextureFormat = ... # 0x8d8f
        R_ATI1N_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x8dbb
        R_ATI1N_SNorm            : QOpenGLTexture.TextureFormat = ... # 0x8dbc
        RG_ATI2N_UNorm           : QOpenGLTexture.TextureFormat = ... # 0x8dbd
        RG_ATI2N_SNorm           : QOpenGLTexture.TextureFormat = ... # 0x8dbe
        RGB_BP_UNorm             : QOpenGLTexture.TextureFormat = ... # 0x8e8c
        SRGB_BP_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x8e8d
        RGB_BP_SIGNED_FLOAT      : QOpenGLTexture.TextureFormat = ... # 0x8e8e
        RGB_BP_UNSIGNED_FLOAT    : QOpenGLTexture.TextureFormat = ... # 0x8e8f
        R8_SNorm                 : QOpenGLTexture.TextureFormat = ... # 0x8f94
        RG8_SNorm                : QOpenGLTexture.TextureFormat = ... # 0x8f95
        RGB8_SNorm               : QOpenGLTexture.TextureFormat = ... # 0x8f96
        RGBA8_SNorm              : QOpenGLTexture.TextureFormat = ... # 0x8f97
        R16_SNorm                : QOpenGLTexture.TextureFormat = ... # 0x8f98
        RG16_SNorm               : QOpenGLTexture.TextureFormat = ... # 0x8f99
        RGB16_SNorm              : QOpenGLTexture.TextureFormat = ... # 0x8f9a
        RGBA16_SNorm             : QOpenGLTexture.TextureFormat = ... # 0x8f9b
        RGB10A2                  : QOpenGLTexture.TextureFormat = ... # 0x906f
        R11_EAC_UNorm            : QOpenGLTexture.TextureFormat = ... # 0x9270
        R11_EAC_SNorm            : QOpenGLTexture.TextureFormat = ... # 0x9271
        RG11_EAC_UNorm           : QOpenGLTexture.TextureFormat = ... # 0x9272
        RG11_EAC_SNorm           : QOpenGLTexture.TextureFormat = ... # 0x9273
        RGB8_ETC2                : QOpenGLTexture.TextureFormat = ... # 0x9274
        SRGB8_ETC2               : QOpenGLTexture.TextureFormat = ... # 0x9275
        RGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ... # 0x9276
        SRGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ... # 0x9277
        RGBA8_ETC2_EAC           : QOpenGLTexture.TextureFormat = ... # 0x9278
        SRGB8_Alpha8_ETC2_EAC    : QOpenGLTexture.TextureFormat = ... # 0x9279
        RGBA_ASTC_4x4            : QOpenGLTexture.TextureFormat = ... # 0x93b0
        RGBA_ASTC_5x4            : QOpenGLTexture.TextureFormat = ... # 0x93b1
        RGBA_ASTC_5x5            : QOpenGLTexture.TextureFormat = ... # 0x93b2
        RGBA_ASTC_6x5            : QOpenGLTexture.TextureFormat = ... # 0x93b3
        RGBA_ASTC_6x6            : QOpenGLTexture.TextureFormat = ... # 0x93b4
        RGBA_ASTC_8x5            : QOpenGLTexture.TextureFormat = ... # 0x93b5
        RGBA_ASTC_8x6            : QOpenGLTexture.TextureFormat = ... # 0x93b6
        RGBA_ASTC_8x8            : QOpenGLTexture.TextureFormat = ... # 0x93b7
        RGBA_ASTC_10x5           : QOpenGLTexture.TextureFormat = ... # 0x93b8
        RGBA_ASTC_10x6           : QOpenGLTexture.TextureFormat = ... # 0x93b9
        RGBA_ASTC_10x8           : QOpenGLTexture.TextureFormat = ... # 0x93ba
        RGBA_ASTC_10x10          : QOpenGLTexture.TextureFormat = ... # 0x93bb
        RGBA_ASTC_12x10          : QOpenGLTexture.TextureFormat = ... # 0x93bc
        RGBA_ASTC_12x12          : QOpenGLTexture.TextureFormat = ... # 0x93bd
        SRGB8_Alpha8_ASTC_4x4    : QOpenGLTexture.TextureFormat = ... # 0x93d0
        SRGB8_Alpha8_ASTC_5x4    : QOpenGLTexture.TextureFormat = ... # 0x93d1
        SRGB8_Alpha8_ASTC_5x5    : QOpenGLTexture.TextureFormat = ... # 0x93d2
        SRGB8_Alpha8_ASTC_6x5    : QOpenGLTexture.TextureFormat = ... # 0x93d3
        SRGB8_Alpha8_ASTC_6x6    : QOpenGLTexture.TextureFormat = ... # 0x93d4
        SRGB8_Alpha8_ASTC_8x5    : QOpenGLTexture.TextureFormat = ... # 0x93d5
        SRGB8_Alpha8_ASTC_8x6    : QOpenGLTexture.TextureFormat = ... # 0x93d6
        SRGB8_Alpha8_ASTC_8x8    : QOpenGLTexture.TextureFormat = ... # 0x93d7
        SRGB8_Alpha8_ASTC_10x5   : QOpenGLTexture.TextureFormat = ... # 0x93d8
        SRGB8_Alpha8_ASTC_10x6   : QOpenGLTexture.TextureFormat = ... # 0x93d9
        SRGB8_Alpha8_ASTC_10x8   : QOpenGLTexture.TextureFormat = ... # 0x93da
        SRGB8_Alpha8_ASTC_10x10  : QOpenGLTexture.TextureFormat = ... # 0x93db
        SRGB8_Alpha8_ASTC_12x10  : QOpenGLTexture.TextureFormat = ... # 0x93dc
        SRGB8_Alpha8_ASTC_12x12  : QOpenGLTexture.TextureFormat = ... # 0x93dd

    class TextureFormatClass(object):
        NoFormatClass            : QOpenGLTexture.TextureFormatClass = ... # 0x0
        FormatClass_128Bit       : QOpenGLTexture.TextureFormatClass = ... # 0x1
        FormatClass_96Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x2
        FormatClass_64Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x3
        FormatClass_48Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x4
        FormatClass_32Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x5
        FormatClass_24Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x6
        FormatClass_16Bit        : QOpenGLTexture.TextureFormatClass = ... # 0x7
        FormatClass_8Bit         : QOpenGLTexture.TextureFormatClass = ... # 0x8
        FormatClass_RGTC1_R      : QOpenGLTexture.TextureFormatClass = ... # 0x9
        FormatClass_RGTC2_RG     : QOpenGLTexture.TextureFormatClass = ... # 0xa
        FormatClass_BPTC_Unorm   : QOpenGLTexture.TextureFormatClass = ... # 0xb
        FormatClass_BPTC_Float   : QOpenGLTexture.TextureFormatClass = ... # 0xc
        FormatClass_S3TC_DXT1_RGB: QOpenGLTexture.TextureFormatClass = ... # 0xd
        FormatClass_S3TC_DXT1_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0xe
        FormatClass_S3TC_DXT3_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0xf
        FormatClass_S3TC_DXT5_RGBA: QOpenGLTexture.TextureFormatClass = ... # 0x10
        FormatClass_Unique       : QOpenGLTexture.TextureFormatClass = ... # 0x11

    class TextureUnitReset(object):
        ResetTextureUnit         : QOpenGLTexture.TextureUnitReset = ... # 0x0
        DontResetTextureUnit     : QOpenGLTexture.TextureUnitReset = ... # 0x1

    class WrapMode(object):
        Repeat                   : QOpenGLTexture.WrapMode = ... # 0x2901
        ClampToBorder            : QOpenGLTexture.WrapMode = ... # 0x812d
        ClampToEdge              : QOpenGLTexture.WrapMode = ... # 0x812f
        MirroredRepeat           : QOpenGLTexture.WrapMode = ... # 0x8370

    @typing.overload
    def __init__(self, image:PySide2.QtGui.QImage, genMipMaps:PySide2.QtGui.QOpenGLTexture.MipMapGeneration=...) -> None: ...
    @typing.overload
    def __init__(self, target:PySide2.QtGui.QOpenGLTexture.Target) -> None: ...

    @typing.overload
    def allocateStorage(self) -> None: ...
    @typing.overload
    def allocateStorage(self, pixelFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, pixelType:PySide2.QtGui.QOpenGLTexture.PixelType) -> None: ...
    @typing.overload
    def bind(self) -> None: ...
    @typing.overload
    def bind(self, unit:int, reset:PySide2.QtGui.QOpenGLTexture.TextureUnitReset=...) -> None: ...
    def borderColor(self) -> PySide2.QtGui.QColor: ...
    @typing.overload
    @staticmethod
    def boundTextureId(target:PySide2.QtGui.QOpenGLTexture.BindingTarget) -> int: ...
    @typing.overload
    @staticmethod
    def boundTextureId(unit:int, target:PySide2.QtGui.QOpenGLTexture.BindingTarget) -> int: ...
    def comparisonFunction(self) -> PySide2.QtGui.QOpenGLTexture.ComparisonFunction: ...
    def comparisonMode(self) -> PySide2.QtGui.QOpenGLTexture.ComparisonMode: ...
    def create(self) -> bool: ...
    def createTextureView(self, target:PySide2.QtGui.QOpenGLTexture.Target, viewFormat:PySide2.QtGui.QOpenGLTexture.TextureFormat, minimumMipmapLevel:int, maximumMipmapLevel:int, minimumLayer:int, maximumLayer:int) -> PySide2.QtGui.QOpenGLTexture: ...
    def depth(self) -> int: ...
    def depthStencilMode(self) -> PySide2.QtGui.QOpenGLTexture.DepthStencilMode: ...
    def destroy(self) -> None: ...
    def faces(self) -> int: ...
    def format(self) -> PySide2.QtGui.QOpenGLTexture.TextureFormat: ...
    @typing.overload
    def generateMipMaps(self) -> None: ...
    @typing.overload
    def generateMipMaps(self, baseLevel:int, resetBaseLevel:bool=...) -> None: ...
    @staticmethod
    def hasFeature(feature:PySide2.QtGui.QOpenGLTexture.Feature) -> bool: ...
    def height(self) -> int: ...
    def isAutoMipMapGenerationEnabled(self) -> bool: ...
    @typing.overload
    def isBound(self) -> bool: ...
    @typing.overload
    def isBound(self, unit:int) -> bool: ...
    def isCreated(self) -> bool: ...
    def isFixedSamplePositions(self) -> bool: ...
    def isStorageAllocated(self) -> bool: ...
    def isTextureView(self) -> bool: ...
    def layers(self) -> int: ...
    def levelOfDetailRange(self) -> typing.Tuple: ...
    def levelofDetailBias(self) -> float: ...
    def magnificationFilter(self) -> PySide2.QtGui.QOpenGLTexture.Filter: ...
    def maximumAnisotropy(self) -> float: ...
    def maximumLevelOfDetail(self) -> float: ...
    def maximumMipLevels(self) -> int: ...
    def minMagFilters(self) -> typing.Tuple: ...
    def minificationFilter(self) -> PySide2.QtGui.QOpenGLTexture.Filter: ...
    def minimumLevelOfDetail(self) -> float: ...
    def mipBaseLevel(self) -> int: ...
    def mipLevelRange(self) -> typing.Tuple: ...
    def mipLevels(self) -> int: ...
    def mipMaxLevel(self) -> int: ...
    @typing.overload
    def release(self) -> None: ...
    @typing.overload
    def release(self, unit:int, reset:PySide2.QtGui.QOpenGLTexture.TextureUnitReset=...) -> None: ...
    def samples(self) -> int: ...
    def setAutoMipMapGenerationEnabled(self, enabled:bool) -> None: ...
    @typing.overload
    def setBorderColor(self, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setBorderColor(self, r:float, g:float, b:float, a:float) -> None: ...
    @typing.overload
    def setBorderColor(self, r:int, g:int, b:int, a:int) -> None: ...
    @typing.overload
    def setBorderColor(self, r:int, g:int, b:int, a:int) -> None: ...
    def setComparisonFunction(self, function:PySide2.QtGui.QOpenGLTexture.ComparisonFunction) -> None: ...
    def setComparisonMode(self, mode:PySide2.QtGui.QOpenGLTexture.ComparisonMode) -> None: ...
    @typing.overload
    def setCompressedData(self, dataSize:int, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setCompressedData(self, mipLevel:int, dataSize:int, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setCompressedData(self, mipLevel:int, layer:int, cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace, dataSize:int, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setCompressedData(self, mipLevel:int, layer:int, dataSize:int, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setCompressedData(self, mipLevel:int, layer:int, layerCount:int, cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace, dataSize:int, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, image:PySide2.QtGui.QImage, genMipMaps:PySide2.QtGui.QOpenGLTexture.MipMapGeneration=...) -> None: ...
    @typing.overload
    def setData(self, mipLevel:int, layer:int, cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, mipLevel:int, layer:int, layerCount:int, cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, mipLevel:int, layer:int, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, mipLevel:int, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, xOffset:int, yOffset:int, zOffset:int, width:int, height:int, depth:int, mipLevel:int, layer:int, cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace, layerCount:int, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, xOffset:int, yOffset:int, zOffset:int, width:int, height:int, depth:int, mipLevel:int, layer:int, cubeFace:PySide2.QtGui.QOpenGLTexture.CubeMapFace, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, xOffset:int, yOffset:int, zOffset:int, width:int, height:int, depth:int, mipLevel:int, layer:int, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    @typing.overload
    def setData(self, xOffset:int, yOffset:int, zOffset:int, width:int, height:int, depth:int, sourceFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat, sourceType:PySide2.QtGui.QOpenGLTexture.PixelType, data:int, options:typing.Optional[PySide2.QtGui.QOpenGLPixelTransferOptions]=...) -> None: ...
    def setDepthStencilMode(self, mode:PySide2.QtGui.QOpenGLTexture.DepthStencilMode) -> None: ...
    def setFixedSamplePositions(self, fixed:bool) -> None: ...
    def setFormat(self, format:PySide2.QtGui.QOpenGLTexture.TextureFormat) -> None: ...
    def setLayers(self, layers:int) -> None: ...
    def setLevelOfDetailRange(self, min:float, max:float) -> None: ...
    def setLevelofDetailBias(self, bias:float) -> None: ...
    def setMagnificationFilter(self, filter:PySide2.QtGui.QOpenGLTexture.Filter) -> None: ...
    def setMaximumAnisotropy(self, anisotropy:float) -> None: ...
    def setMaximumLevelOfDetail(self, value:float) -> None: ...
    def setMinMagFilters(self, minificationFilter:PySide2.QtGui.QOpenGLTexture.Filter, magnificationFilter:PySide2.QtGui.QOpenGLTexture.Filter) -> None: ...
    def setMinificationFilter(self, filter:PySide2.QtGui.QOpenGLTexture.Filter) -> None: ...
    def setMinimumLevelOfDetail(self, value:float) -> None: ...
    def setMipBaseLevel(self, baseLevel:int) -> None: ...
    def setMipLevelRange(self, baseLevel:int, maxLevel:int) -> None: ...
    def setMipLevels(self, levels:int) -> None: ...
    def setMipMaxLevel(self, maxLevel:int) -> None: ...
    def setSamples(self, samples:int) -> None: ...
    def setSize(self, width:int, height:int=..., depth:int=...) -> None: ...
    @typing.overload
    def setSwizzleMask(self, component:PySide2.QtGui.QOpenGLTexture.SwizzleComponent, value:PySide2.QtGui.QOpenGLTexture.SwizzleValue) -> None: ...
    @typing.overload
    def setSwizzleMask(self, r:PySide2.QtGui.QOpenGLTexture.SwizzleValue, g:PySide2.QtGui.QOpenGLTexture.SwizzleValue, b:PySide2.QtGui.QOpenGLTexture.SwizzleValue, a:PySide2.QtGui.QOpenGLTexture.SwizzleValue) -> None: ...
    @typing.overload
    def setWrapMode(self, direction:PySide2.QtGui.QOpenGLTexture.CoordinateDirection, mode:PySide2.QtGui.QOpenGLTexture.WrapMode) -> None: ...
    @typing.overload
    def setWrapMode(self, mode:PySide2.QtGui.QOpenGLTexture.WrapMode) -> None: ...
    def swizzleMask(self, component:PySide2.QtGui.QOpenGLTexture.SwizzleComponent) -> PySide2.QtGui.QOpenGLTexture.SwizzleValue: ...
    def target(self) -> PySide2.QtGui.QOpenGLTexture.Target: ...
    def textureId(self) -> int: ...
    def width(self) -> int: ...
    def wrapMode(self, direction:PySide2.QtGui.QOpenGLTexture.CoordinateDirection) -> PySide2.QtGui.QOpenGLTexture.WrapMode: ...


class QOpenGLTextureBlitter(Shiboken.Object):
    OriginBottomLeft         : QOpenGLTextureBlitter = ... # 0x0
    OriginTopLeft            : QOpenGLTextureBlitter = ... # 0x1

    class Origin(object):
        OriginBottomLeft         : QOpenGLTextureBlitter.Origin = ... # 0x0
        OriginTopLeft            : QOpenGLTextureBlitter.Origin = ... # 0x1

    def __init__(self) -> None: ...

    def bind(self, target:int=...) -> None: ...
    @typing.overload
    def blit(self, texture:int, targetTransform:PySide2.QtGui.QMatrix4x4, sourceOrigin:PySide2.QtGui.QOpenGLTextureBlitter.Origin) -> None: ...
    @typing.overload
    def blit(self, texture:int, targetTransform:PySide2.QtGui.QMatrix4x4, sourceTransform:PySide2.QtGui.QMatrix3x3) -> None: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def release(self) -> None: ...
    def setOpacity(self, opacity:float) -> None: ...
    def setRedBlueSwizzle(self, swizzle:bool) -> None: ...
    @staticmethod
    def sourceTransform(subTexture:PySide2.QtCore.QRectF, textureSize:PySide2.QtCore.QSize, origin:PySide2.QtGui.QOpenGLTextureBlitter.Origin) -> PySide2.QtGui.QMatrix3x3: ...
    def supportsExternalOESTarget(self) -> bool: ...
    @staticmethod
    def targetTransform(target:PySide2.QtCore.QRectF, viewport:PySide2.QtCore.QRect) -> PySide2.QtGui.QMatrix4x4: ...


class QOpenGLTimeMonitor(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def isResultAvailable(self) -> bool: ...
    def objectIds(self) -> typing.List: ...
    def recordSample(self) -> int: ...
    def reset(self) -> None: ...
    def sampleCount(self) -> int: ...
    def setSampleCount(self, sampleCount:int) -> None: ...
    def waitForIntervals(self) -> typing.List: ...
    def waitForSamples(self) -> typing.List: ...


class QOpenGLTimerQuery(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def begin(self) -> None: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def end(self) -> None: ...
    def isCreated(self) -> bool: ...
    def isResultAvailable(self) -> bool: ...
    def objectId(self) -> int: ...
    def recordTimestamp(self) -> None: ...
    def waitForResult(self) -> int: ...
    def waitForTimestamp(self) -> int: ...


class QOpenGLVersionProfile(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, format:PySide2.QtGui.QSurfaceFormat) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QOpenGLVersionProfile) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def hasProfiles(self) -> bool: ...
    def isLegacyVersion(self) -> bool: ...
    def isValid(self) -> bool: ...
    def profile(self) -> PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile: ...
    def setProfile(self, profile:PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile) -> None: ...
    def setVersion(self, majorVersion:int, minorVersion:int) -> None: ...
    def version(self) -> typing.Tuple: ...


class QOpenGLVertexArrayObject(PySide2.QtCore.QObject):

    class Binder(Shiboken.Object):

        def __init__(self, v:PySide2.QtGui.QOpenGLVertexArrayObject) -> None: ...

        def rebind(self) -> None: ...
        def release(self) -> None: ...

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def bind(self) -> None: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def objectId(self) -> int: ...
    def release(self) -> None: ...


class QOpenGLWindow(PySide2.QtGui.QPaintDeviceWindow):
    NoPartialUpdate          : QOpenGLWindow = ... # 0x0
    PartialUpdateBlit        : QOpenGLWindow = ... # 0x1
    PartialUpdateBlend       : QOpenGLWindow = ... # 0x2

    class UpdateBehavior(object):
        NoPartialUpdate          : QOpenGLWindow.UpdateBehavior = ... # 0x0
        PartialUpdateBlit        : QOpenGLWindow.UpdateBehavior = ... # 0x1
        PartialUpdateBlend       : QOpenGLWindow.UpdateBehavior = ... # 0x2

    @typing.overload
    def __init__(self, shareContext:PySide2.QtGui.QOpenGLContext, updateBehavior:PySide2.QtGui.QOpenGLWindow.UpdateBehavior=..., parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...
    @typing.overload
    def __init__(self, updateBehavior:PySide2.QtGui.QOpenGLWindow.UpdateBehavior=..., parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...

    def context(self) -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self) -> None: ...
    def grabFramebuffer(self) -> PySide2.QtGui.QImage: ...
    def initializeGL(self) -> None: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def paintOverGL(self) -> None: ...
    def paintUnderGL(self) -> None: ...
    def redirected(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeGL(self, w:int, h:int) -> None: ...
    def shareContext(self) -> PySide2.QtGui.QOpenGLContext: ...
    def updateBehavior(self) -> PySide2.QtGui.QOpenGLWindow.UpdateBehavior: ...


class QPageLayout(Shiboken.Object):
    Millimeter               : QPageLayout = ... # 0x0
    Portrait                 : QPageLayout = ... # 0x0
    StandardMode             : QPageLayout = ... # 0x0
    FullPageMode             : QPageLayout = ... # 0x1
    Landscape                : QPageLayout = ... # 0x1
    Point                    : QPageLayout = ... # 0x1
    Inch                     : QPageLayout = ... # 0x2
    Pica                     : QPageLayout = ... # 0x3
    Didot                    : QPageLayout = ... # 0x4
    Cicero                   : QPageLayout = ... # 0x5

    class Mode(object):
        StandardMode             : QPageLayout.Mode = ... # 0x0
        FullPageMode             : QPageLayout.Mode = ... # 0x1

    class Orientation(object):
        Portrait                 : QPageLayout.Orientation = ... # 0x0
        Landscape                : QPageLayout.Orientation = ... # 0x1

    class Unit(object):
        Millimeter               : QPageLayout.Unit = ... # 0x0
        Point                    : QPageLayout.Unit = ... # 0x1
        Inch                     : QPageLayout.Unit = ... # 0x2
        Pica                     : QPageLayout.Unit = ... # 0x3
        Didot                    : QPageLayout.Unit = ... # 0x4
        Cicero                   : QPageLayout.Unit = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QPageLayout) -> None: ...
    @typing.overload
    def __init__(self, pageSize:PySide2.QtGui.QPageSize, orientation:PySide2.QtGui.QPageLayout.Orientation, margins:PySide2.QtCore.QMarginsF, units:PySide2.QtGui.QPageLayout.Unit=..., minMargins:PySide2.QtCore.QMarginsF=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def fullRect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def fullRect(self, units:PySide2.QtGui.QPageLayout.Unit) -> PySide2.QtCore.QRectF: ...
    def fullRectPixels(self, resolution:int) -> PySide2.QtCore.QRect: ...
    def fullRectPoints(self) -> PySide2.QtCore.QRect: ...
    def isEquivalentTo(self, other:PySide2.QtGui.QPageLayout) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    def margins(self) -> PySide2.QtCore.QMarginsF: ...
    @typing.overload
    def margins(self, units:PySide2.QtGui.QPageLayout.Unit) -> PySide2.QtCore.QMarginsF: ...
    def marginsPixels(self, resolution:int) -> PySide2.QtCore.QMargins: ...
    def marginsPoints(self) -> PySide2.QtCore.QMargins: ...
    def maximumMargins(self) -> PySide2.QtCore.QMarginsF: ...
    def minimumMargins(self) -> PySide2.QtCore.QMarginsF: ...
    def mode(self) -> PySide2.QtGui.QPageLayout.Mode: ...
    def orientation(self) -> PySide2.QtGui.QPageLayout.Orientation: ...
    def pageSize(self) -> PySide2.QtGui.QPageSize: ...
    @typing.overload
    def paintRect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def paintRect(self, units:PySide2.QtGui.QPageLayout.Unit) -> PySide2.QtCore.QRectF: ...
    def paintRectPixels(self, resolution:int) -> PySide2.QtCore.QRect: ...
    def paintRectPoints(self) -> PySide2.QtCore.QRect: ...
    def setBottomMargin(self, bottomMargin:float) -> bool: ...
    def setLeftMargin(self, leftMargin:float) -> bool: ...
    def setMargins(self, margins:PySide2.QtCore.QMarginsF) -> bool: ...
    def setMinimumMargins(self, minMargins:PySide2.QtCore.QMarginsF) -> None: ...
    def setMode(self, mode:PySide2.QtGui.QPageLayout.Mode) -> None: ...
    def setOrientation(self, orientation:PySide2.QtGui.QPageLayout.Orientation) -> None: ...
    def setPageSize(self, pageSize:PySide2.QtGui.QPageSize, minMargins:PySide2.QtCore.QMarginsF=...) -> None: ...
    def setRightMargin(self, rightMargin:float) -> bool: ...
    def setTopMargin(self, topMargin:float) -> bool: ...
    def setUnits(self, units:PySide2.QtGui.QPageLayout.Unit) -> None: ...
    def swap(self, other:PySide2.QtGui.QPageLayout) -> None: ...
    def units(self) -> PySide2.QtGui.QPageLayout.Unit: ...


class QPageSize(Shiboken.Object):
    A4                       : QPageSize = ... # 0x0
    FuzzyMatch               : QPageSize = ... # 0x0
    Millimeter               : QPageSize = ... # 0x0
    B5                       : QPageSize = ... # 0x1
    FuzzyOrientationMatch    : QPageSize = ... # 0x1
    Point                    : QPageSize = ... # 0x1
    AnsiA                    : QPageSize = ... # 0x2
    ExactMatch               : QPageSize = ... # 0x2
    Inch                     : QPageSize = ... # 0x2
    Letter                   : QPageSize = ... # 0x2
    Legal                    : QPageSize = ... # 0x3
    Pica                     : QPageSize = ... # 0x3
    Didot                    : QPageSize = ... # 0x4
    Executive                : QPageSize = ... # 0x4
    A0                       : QPageSize = ... # 0x5
    Cicero                   : QPageSize = ... # 0x5
    A1                       : QPageSize = ... # 0x6
    A2                       : QPageSize = ... # 0x7
    A3                       : QPageSize = ... # 0x8
    A5                       : QPageSize = ... # 0x9
    A6                       : QPageSize = ... # 0xa
    A7                       : QPageSize = ... # 0xb
    A8                       : QPageSize = ... # 0xc
    A9                       : QPageSize = ... # 0xd
    B0                       : QPageSize = ... # 0xe
    B1                       : QPageSize = ... # 0xf
    B10                      : QPageSize = ... # 0x10
    B2                       : QPageSize = ... # 0x11
    B3                       : QPageSize = ... # 0x12
    B4                       : QPageSize = ... # 0x13
    B6                       : QPageSize = ... # 0x14
    B7                       : QPageSize = ... # 0x15
    B8                       : QPageSize = ... # 0x16
    B9                       : QPageSize = ... # 0x17
    C5E                      : QPageSize = ... # 0x18
    EnvelopeC5               : QPageSize = ... # 0x18
    Comm10E                  : QPageSize = ... # 0x19
    Envelope10               : QPageSize = ... # 0x19
    DLE                      : QPageSize = ... # 0x1a
    EnvelopeDL               : QPageSize = ... # 0x1a
    Folio                    : QPageSize = ... # 0x1b
    AnsiB                    : QPageSize = ... # 0x1c
    Ledger                   : QPageSize = ... # 0x1c
    Tabloid                  : QPageSize = ... # 0x1d
    Custom                   : QPageSize = ... # 0x1e
    A10                      : QPageSize = ... # 0x1f
    A3Extra                  : QPageSize = ... # 0x20
    A4Extra                  : QPageSize = ... # 0x21
    A4Plus                   : QPageSize = ... # 0x22
    A4Small                  : QPageSize = ... # 0x23
    A5Extra                  : QPageSize = ... # 0x24
    B5Extra                  : QPageSize = ... # 0x25
    JisB0                    : QPageSize = ... # 0x26
    JisB1                    : QPageSize = ... # 0x27
    JisB2                    : QPageSize = ... # 0x28
    JisB3                    : QPageSize = ... # 0x29
    JisB4                    : QPageSize = ... # 0x2a
    JisB5                    : QPageSize = ... # 0x2b
    JisB6                    : QPageSize = ... # 0x2c
    JisB7                    : QPageSize = ... # 0x2d
    JisB8                    : QPageSize = ... # 0x2e
    JisB9                    : QPageSize = ... # 0x2f
    JisB10                   : QPageSize = ... # 0x30
    AnsiC                    : QPageSize = ... # 0x31
    AnsiD                    : QPageSize = ... # 0x32
    AnsiE                    : QPageSize = ... # 0x33
    LegalExtra               : QPageSize = ... # 0x34
    LetterExtra              : QPageSize = ... # 0x35
    LetterPlus               : QPageSize = ... # 0x36
    LetterSmall              : QPageSize = ... # 0x37
    TabloidExtra             : QPageSize = ... # 0x38
    ArchA                    : QPageSize = ... # 0x39
    ArchB                    : QPageSize = ... # 0x3a
    ArchC                    : QPageSize = ... # 0x3b
    ArchD                    : QPageSize = ... # 0x3c
    ArchE                    : QPageSize = ... # 0x3d
    Imperial7x9              : QPageSize = ... # 0x3e
    Imperial8x10             : QPageSize = ... # 0x3f
    Imperial9x11             : QPageSize = ... # 0x40
    Imperial9x12             : QPageSize = ... # 0x41
    Imperial10x11            : QPageSize = ... # 0x42
    Imperial10x13            : QPageSize = ... # 0x43
    Imperial10x14            : QPageSize = ... # 0x44
    Imperial12x11            : QPageSize = ... # 0x45
    Imperial15x11            : QPageSize = ... # 0x46
    ExecutiveStandard        : QPageSize = ... # 0x47
    Note                     : QPageSize = ... # 0x48
    Quarto                   : QPageSize = ... # 0x49
    Statement                : QPageSize = ... # 0x4a
    SuperA                   : QPageSize = ... # 0x4b
    SuperB                   : QPageSize = ... # 0x4c
    Postcard                 : QPageSize = ... # 0x4d
    DoublePostcard           : QPageSize = ... # 0x4e
    Prc16K                   : QPageSize = ... # 0x4f
    Prc32K                   : QPageSize = ... # 0x50
    Prc32KBig                : QPageSize = ... # 0x51
    FanFoldUS                : QPageSize = ... # 0x52
    FanFoldGerman            : QPageSize = ... # 0x53
    FanFoldGermanLegal       : QPageSize = ... # 0x54
    EnvelopeB4               : QPageSize = ... # 0x55
    EnvelopeB5               : QPageSize = ... # 0x56
    EnvelopeB6               : QPageSize = ... # 0x57
    EnvelopeC0               : QPageSize = ... # 0x58
    EnvelopeC1               : QPageSize = ... # 0x59
    EnvelopeC2               : QPageSize = ... # 0x5a
    EnvelopeC3               : QPageSize = ... # 0x5b
    EnvelopeC4               : QPageSize = ... # 0x5c
    EnvelopeC6               : QPageSize = ... # 0x5d
    EnvelopeC65              : QPageSize = ... # 0x5e
    EnvelopeC7               : QPageSize = ... # 0x5f
    Envelope9                : QPageSize = ... # 0x60
    Envelope11               : QPageSize = ... # 0x61
    Envelope12               : QPageSize = ... # 0x62
    Envelope14               : QPageSize = ... # 0x63
    EnvelopeMonarch          : QPageSize = ... # 0x64
    EnvelopePersonal         : QPageSize = ... # 0x65
    EnvelopeChou3            : QPageSize = ... # 0x66
    EnvelopeChou4            : QPageSize = ... # 0x67
    EnvelopeInvite           : QPageSize = ... # 0x68
    EnvelopeItalian          : QPageSize = ... # 0x69
    EnvelopeKaku2            : QPageSize = ... # 0x6a
    EnvelopeKaku3            : QPageSize = ... # 0x6b
    EnvelopePrc1             : QPageSize = ... # 0x6c
    EnvelopePrc2             : QPageSize = ... # 0x6d
    EnvelopePrc3             : QPageSize = ... # 0x6e
    EnvelopePrc4             : QPageSize = ... # 0x6f
    EnvelopePrc5             : QPageSize = ... # 0x70
    EnvelopePrc6             : QPageSize = ... # 0x71
    EnvelopePrc7             : QPageSize = ... # 0x72
    EnvelopePrc8             : QPageSize = ... # 0x73
    EnvelopePrc9             : QPageSize = ... # 0x74
    EnvelopePrc10            : QPageSize = ... # 0x75
    EnvelopeYou4             : QPageSize = ... # 0x76
    LastPageSize             : QPageSize = ... # 0x76
    NPageSize                : QPageSize = ... # 0x76
    NPaperSize               : QPageSize = ... # 0x76

    class PageSizeId(object):
        A4                       : QPageSize.PageSizeId = ... # 0x0
        B5                       : QPageSize.PageSizeId = ... # 0x1
        AnsiA                    : QPageSize.PageSizeId = ... # 0x2
        Letter                   : QPageSize.PageSizeId = ... # 0x2
        Legal                    : QPageSize.PageSizeId = ... # 0x3
        Executive                : QPageSize.PageSizeId = ... # 0x4
        A0                       : QPageSize.PageSizeId = ... # 0x5
        A1                       : QPageSize.PageSizeId = ... # 0x6
        A2                       : QPageSize.PageSizeId = ... # 0x7
        A3                       : QPageSize.PageSizeId = ... # 0x8
        A5                       : QPageSize.PageSizeId = ... # 0x9
        A6                       : QPageSize.PageSizeId = ... # 0xa
        A7                       : QPageSize.PageSizeId = ... # 0xb
        A8                       : QPageSize.PageSizeId = ... # 0xc
        A9                       : QPageSize.PageSizeId = ... # 0xd
        B0                       : QPageSize.PageSizeId = ... # 0xe
        B1                       : QPageSize.PageSizeId = ... # 0xf
        B10                      : QPageSize.PageSizeId = ... # 0x10
        B2                       : QPageSize.PageSizeId = ... # 0x11
        B3                       : QPageSize.PageSizeId = ... # 0x12
        B4                       : QPageSize.PageSizeId = ... # 0x13
        B6                       : QPageSize.PageSizeId = ... # 0x14
        B7                       : QPageSize.PageSizeId = ... # 0x15
        B8                       : QPageSize.PageSizeId = ... # 0x16
        B9                       : QPageSize.PageSizeId = ... # 0x17
        C5E                      : QPageSize.PageSizeId = ... # 0x18
        EnvelopeC5               : QPageSize.PageSizeId = ... # 0x18
        Comm10E                  : QPageSize.PageSizeId = ... # 0x19
        Envelope10               : QPageSize.PageSizeId = ... # 0x19
        DLE                      : QPageSize.PageSizeId = ... # 0x1a
        EnvelopeDL               : QPageSize.PageSizeId = ... # 0x1a
        Folio                    : QPageSize.PageSizeId = ... # 0x1b
        AnsiB                    : QPageSize.PageSizeId = ... # 0x1c
        Ledger                   : QPageSize.PageSizeId = ... # 0x1c
        Tabloid                  : QPageSize.PageSizeId = ... # 0x1d
        Custom                   : QPageSize.PageSizeId = ... # 0x1e
        A10                      : QPageSize.PageSizeId = ... # 0x1f
        A3Extra                  : QPageSize.PageSizeId = ... # 0x20
        A4Extra                  : QPageSize.PageSizeId = ... # 0x21
        A4Plus                   : QPageSize.PageSizeId = ... # 0x22
        A4Small                  : QPageSize.PageSizeId = ... # 0x23
        A5Extra                  : QPageSize.PageSizeId = ... # 0x24
        B5Extra                  : QPageSize.PageSizeId = ... # 0x25
        JisB0                    : QPageSize.PageSizeId = ... # 0x26
        JisB1                    : QPageSize.PageSizeId = ... # 0x27
        JisB2                    : QPageSize.PageSizeId = ... # 0x28
        JisB3                    : QPageSize.PageSizeId = ... # 0x29
        JisB4                    : QPageSize.PageSizeId = ... # 0x2a
        JisB5                    : QPageSize.PageSizeId = ... # 0x2b
        JisB6                    : QPageSize.PageSizeId = ... # 0x2c
        JisB7                    : QPageSize.PageSizeId = ... # 0x2d
        JisB8                    : QPageSize.PageSizeId = ... # 0x2e
        JisB9                    : QPageSize.PageSizeId = ... # 0x2f
        JisB10                   : QPageSize.PageSizeId = ... # 0x30
        AnsiC                    : QPageSize.PageSizeId = ... # 0x31
        AnsiD                    : QPageSize.PageSizeId = ... # 0x32
        AnsiE                    : QPageSize.PageSizeId = ... # 0x33
        LegalExtra               : QPageSize.PageSizeId = ... # 0x34
        LetterExtra              : QPageSize.PageSizeId = ... # 0x35
        LetterPlus               : QPageSize.PageSizeId = ... # 0x36
        LetterSmall              : QPageSize.PageSizeId = ... # 0x37
        TabloidExtra             : QPageSize.PageSizeId = ... # 0x38
        ArchA                    : QPageSize.PageSizeId = ... # 0x39
        ArchB                    : QPageSize.PageSizeId = ... # 0x3a
        ArchC                    : QPageSize.PageSizeId = ... # 0x3b
        ArchD                    : QPageSize.PageSizeId = ... # 0x3c
        ArchE                    : QPageSize.PageSizeId = ... # 0x3d
        Imperial7x9              : QPageSize.PageSizeId = ... # 0x3e
        Imperial8x10             : QPageSize.PageSizeId = ... # 0x3f
        Imperial9x11             : QPageSize.PageSizeId = ... # 0x40
        Imperial9x12             : QPageSize.PageSizeId = ... # 0x41
        Imperial10x11            : QPageSize.PageSizeId = ... # 0x42
        Imperial10x13            : QPageSize.PageSizeId = ... # 0x43
        Imperial10x14            : QPageSize.PageSizeId = ... # 0x44
        Imperial12x11            : QPageSize.PageSizeId = ... # 0x45
        Imperial15x11            : QPageSize.PageSizeId = ... # 0x46
        ExecutiveStandard        : QPageSize.PageSizeId = ... # 0x47
        Note                     : QPageSize.PageSizeId = ... # 0x48
        Quarto                   : QPageSize.PageSizeId = ... # 0x49
        Statement                : QPageSize.PageSizeId = ... # 0x4a
        SuperA                   : QPageSize.PageSizeId = ... # 0x4b
        SuperB                   : QPageSize.PageSizeId = ... # 0x4c
        Postcard                 : QPageSize.PageSizeId = ... # 0x4d
        DoublePostcard           : QPageSize.PageSizeId = ... # 0x4e
        Prc16K                   : QPageSize.PageSizeId = ... # 0x4f
        Prc32K                   : QPageSize.PageSizeId = ... # 0x50
        Prc32KBig                : QPageSize.PageSizeId = ... # 0x51
        FanFoldUS                : QPageSize.PageSizeId = ... # 0x52
        FanFoldGerman            : QPageSize.PageSizeId = ... # 0x53
        FanFoldGermanLegal       : QPageSize.PageSizeId = ... # 0x54
        EnvelopeB4               : QPageSize.PageSizeId = ... # 0x55
        EnvelopeB5               : QPageSize.PageSizeId = ... # 0x56
        EnvelopeB6               : QPageSize.PageSizeId = ... # 0x57
        EnvelopeC0               : QPageSize.PageSizeId = ... # 0x58
        EnvelopeC1               : QPageSize.PageSizeId = ... # 0x59
        EnvelopeC2               : QPageSize.PageSizeId = ... # 0x5a
        EnvelopeC3               : QPageSize.PageSizeId = ... # 0x5b
        EnvelopeC4               : QPageSize.PageSizeId = ... # 0x5c
        EnvelopeC6               : QPageSize.PageSizeId = ... # 0x5d
        EnvelopeC65              : QPageSize.PageSizeId = ... # 0x5e
        EnvelopeC7               : QPageSize.PageSizeId = ... # 0x5f
        Envelope9                : QPageSize.PageSizeId = ... # 0x60
        Envelope11               : QPageSize.PageSizeId = ... # 0x61
        Envelope12               : QPageSize.PageSizeId = ... # 0x62
        Envelope14               : QPageSize.PageSizeId = ... # 0x63
        EnvelopeMonarch          : QPageSize.PageSizeId = ... # 0x64
        EnvelopePersonal         : QPageSize.PageSizeId = ... # 0x65
        EnvelopeChou3            : QPageSize.PageSizeId = ... # 0x66
        EnvelopeChou4            : QPageSize.PageSizeId = ... # 0x67
        EnvelopeInvite           : QPageSize.PageSizeId = ... # 0x68
        EnvelopeItalian          : QPageSize.PageSizeId = ... # 0x69
        EnvelopeKaku2            : QPageSize.PageSizeId = ... # 0x6a
        EnvelopeKaku3            : QPageSize.PageSizeId = ... # 0x6b
        EnvelopePrc1             : QPageSize.PageSizeId = ... # 0x6c
        EnvelopePrc2             : QPageSize.PageSizeId = ... # 0x6d
        EnvelopePrc3             : QPageSize.PageSizeId = ... # 0x6e
        EnvelopePrc4             : QPageSize.PageSizeId = ... # 0x6f
        EnvelopePrc5             : QPageSize.PageSizeId = ... # 0x70
        EnvelopePrc6             : QPageSize.PageSizeId = ... # 0x71
        EnvelopePrc7             : QPageSize.PageSizeId = ... # 0x72
        EnvelopePrc8             : QPageSize.PageSizeId = ... # 0x73
        EnvelopePrc9             : QPageSize.PageSizeId = ... # 0x74
        EnvelopePrc10            : QPageSize.PageSizeId = ... # 0x75
        EnvelopeYou4             : QPageSize.PageSizeId = ... # 0x76
        LastPageSize             : QPageSize.PageSizeId = ... # 0x76
        NPageSize                : QPageSize.PageSizeId = ... # 0x76
        NPaperSize               : QPageSize.PageSizeId = ... # 0x76

    class SizeMatchPolicy(object):
        FuzzyMatch               : QPageSize.SizeMatchPolicy = ... # 0x0
        FuzzyOrientationMatch    : QPageSize.SizeMatchPolicy = ... # 0x1
        ExactMatch               : QPageSize.SizeMatchPolicy = ... # 0x2

    class Unit(object):
        Millimeter               : QPageSize.Unit = ... # 0x0
        Point                    : QPageSize.Unit = ... # 0x1
        Inch                     : QPageSize.Unit = ... # 0x2
        Pica                     : QPageSize.Unit = ... # 0x3
        Didot                    : QPageSize.Unit = ... # 0x4
        Cicero                   : QPageSize.Unit = ... # 0x5

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QPageSize) -> None: ...
    @typing.overload
    def __init__(self, pageSizeId:PySide2.QtGui.QPageSize.PageSizeId) -> None: ...
    @typing.overload
    def __init__(self, pointSize:PySide2.QtCore.QSize, name:str=..., matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=...) -> None: ...
    @typing.overload
    def __init__(self, size:PySide2.QtCore.QSizeF, units:PySide2.QtGui.QPageSize.Unit, name:str=..., matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    @staticmethod
    def definitionSize(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    def definitionSize(self) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def definitionUnits(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId) -> PySide2.QtGui.QPageSize.Unit: ...
    @typing.overload
    def definitionUnits(self) -> PySide2.QtGui.QPageSize.Unit: ...
    @typing.overload
    @staticmethod
    def id(pointSize:PySide2.QtCore.QSize, matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=...) -> PySide2.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    def id(self) -> PySide2.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    @staticmethod
    def id(size:PySide2.QtCore.QSizeF, units:PySide2.QtGui.QPageSize.Unit, matchPolicy:PySide2.QtGui.QPageSize.SizeMatchPolicy=...) -> PySide2.QtGui.QPageSize.PageSizeId: ...
    @typing.overload
    @staticmethod
    def id(windowsId:int) -> PySide2.QtGui.QPageSize.PageSizeId: ...
    def isEquivalentTo(self, other:PySide2.QtGui.QPageSize) -> bool: ...
    def isValid(self) -> bool: ...
    @typing.overload
    @staticmethod
    def key(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId) -> str: ...
    @typing.overload
    def key(self) -> str: ...
    @typing.overload
    @staticmethod
    def name(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId) -> str: ...
    @typing.overload
    def name(self) -> str: ...
    def rect(self, units:PySide2.QtGui.QPageSize.Unit) -> PySide2.QtCore.QRectF: ...
    def rectPixels(self, resolution:int) -> PySide2.QtCore.QRect: ...
    def rectPoints(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    @staticmethod
    def size(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId, units:PySide2.QtGui.QPageSize.Unit) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    def size(self, units:PySide2.QtGui.QPageSize.Unit) -> PySide2.QtCore.QSizeF: ...
    @typing.overload
    @staticmethod
    def sizePixels(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId, resolution:int) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def sizePixels(self, resolution:int) -> PySide2.QtCore.QSize: ...
    @typing.overload
    @staticmethod
    def sizePoints(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def sizePoints(self) -> PySide2.QtCore.QSize: ...
    def swap(self, other:PySide2.QtGui.QPageSize) -> None: ...
    @typing.overload
    @staticmethod
    def windowsId(pageSizeId:PySide2.QtGui.QPageSize.PageSizeId) -> int: ...
    @typing.overload
    def windowsId(self) -> int: ...


class QPagedPaintDevice(PySide2.QtGui.QPaintDevice):
    A4                       : QPagedPaintDevice = ... # 0x0
    PdfVersion_1_4           : QPagedPaintDevice = ... # 0x0
    B5                       : QPagedPaintDevice = ... # 0x1
    PdfVersion_A1b           : QPagedPaintDevice = ... # 0x1
    AnsiA                    : QPagedPaintDevice = ... # 0x2
    Letter                   : QPagedPaintDevice = ... # 0x2
    PdfVersion_1_6           : QPagedPaintDevice = ... # 0x2
    Legal                    : QPagedPaintDevice = ... # 0x3
    Executive                : QPagedPaintDevice = ... # 0x4
    A0                       : QPagedPaintDevice = ... # 0x5
    A1                       : QPagedPaintDevice = ... # 0x6
    A2                       : QPagedPaintDevice = ... # 0x7
    A3                       : QPagedPaintDevice = ... # 0x8
    A5                       : QPagedPaintDevice = ... # 0x9
    A6                       : QPagedPaintDevice = ... # 0xa
    A7                       : QPagedPaintDevice = ... # 0xb
    A8                       : QPagedPaintDevice = ... # 0xc
    A9                       : QPagedPaintDevice = ... # 0xd
    B0                       : QPagedPaintDevice = ... # 0xe
    B1                       : QPagedPaintDevice = ... # 0xf
    B10                      : QPagedPaintDevice = ... # 0x10
    B2                       : QPagedPaintDevice = ... # 0x11
    B3                       : QPagedPaintDevice = ... # 0x12
    B4                       : QPagedPaintDevice = ... # 0x13
    B6                       : QPagedPaintDevice = ... # 0x14
    B7                       : QPagedPaintDevice = ... # 0x15
    B8                       : QPagedPaintDevice = ... # 0x16
    B9                       : QPagedPaintDevice = ... # 0x17
    C5E                      : QPagedPaintDevice = ... # 0x18
    EnvelopeC5               : QPagedPaintDevice = ... # 0x18
    Comm10E                  : QPagedPaintDevice = ... # 0x19
    Envelope10               : QPagedPaintDevice = ... # 0x19
    DLE                      : QPagedPaintDevice = ... # 0x1a
    EnvelopeDL               : QPagedPaintDevice = ... # 0x1a
    Folio                    : QPagedPaintDevice = ... # 0x1b
    AnsiB                    : QPagedPaintDevice = ... # 0x1c
    Ledger                   : QPagedPaintDevice = ... # 0x1c
    Tabloid                  : QPagedPaintDevice = ... # 0x1d
    Custom                   : QPagedPaintDevice = ... # 0x1e
    A10                      : QPagedPaintDevice = ... # 0x1f
    A3Extra                  : QPagedPaintDevice = ... # 0x20
    A4Extra                  : QPagedPaintDevice = ... # 0x21
    A4Plus                   : QPagedPaintDevice = ... # 0x22
    A4Small                  : QPagedPaintDevice = ... # 0x23
    A5Extra                  : QPagedPaintDevice = ... # 0x24
    B5Extra                  : QPagedPaintDevice = ... # 0x25
    JisB0                    : QPagedPaintDevice = ... # 0x26
    JisB1                    : QPagedPaintDevice = ... # 0x27
    JisB2                    : QPagedPaintDevice = ... # 0x28
    JisB3                    : QPagedPaintDevice = ... # 0x29
    JisB4                    : QPagedPaintDevice = ... # 0x2a
    JisB5                    : QPagedPaintDevice = ... # 0x2b
    JisB6                    : QPagedPaintDevice = ... # 0x2c
    JisB7                    : QPagedPaintDevice = ... # 0x2d
    JisB8                    : QPagedPaintDevice = ... # 0x2e
    JisB9                    : QPagedPaintDevice = ... # 0x2f
    JisB10                   : QPagedPaintDevice = ... # 0x30
    AnsiC                    : QPagedPaintDevice = ... # 0x31
    AnsiD                    : QPagedPaintDevice = ... # 0x32
    AnsiE                    : QPagedPaintDevice = ... # 0x33
    LegalExtra               : QPagedPaintDevice = ... # 0x34
    LetterExtra              : QPagedPaintDevice = ... # 0x35
    LetterPlus               : QPagedPaintDevice = ... # 0x36
    LetterSmall              : QPagedPaintDevice = ... # 0x37
    TabloidExtra             : QPagedPaintDevice = ... # 0x38
    ArchA                    : QPagedPaintDevice = ... # 0x39
    ArchB                    : QPagedPaintDevice = ... # 0x3a
    ArchC                    : QPagedPaintDevice = ... # 0x3b
    ArchD                    : QPagedPaintDevice = ... # 0x3c
    ArchE                    : QPagedPaintDevice = ... # 0x3d
    Imperial7x9              : QPagedPaintDevice = ... # 0x3e
    Imperial8x10             : QPagedPaintDevice = ... # 0x3f
    Imperial9x11             : QPagedPaintDevice = ... # 0x40
    Imperial9x12             : QPagedPaintDevice = ... # 0x41
    Imperial10x11            : QPagedPaintDevice = ... # 0x42
    Imperial10x13            : QPagedPaintDevice = ... # 0x43
    Imperial10x14            : QPagedPaintDevice = ... # 0x44
    Imperial12x11            : QPagedPaintDevice = ... # 0x45
    Imperial15x11            : QPagedPaintDevice = ... # 0x46
    ExecutiveStandard        : QPagedPaintDevice = ... # 0x47
    Note                     : QPagedPaintDevice = ... # 0x48
    Quarto                   : QPagedPaintDevice = ... # 0x49
    Statement                : QPagedPaintDevice = ... # 0x4a
    SuperA                   : QPagedPaintDevice = ... # 0x4b
    SuperB                   : QPagedPaintDevice = ... # 0x4c
    Postcard                 : QPagedPaintDevice = ... # 0x4d
    DoublePostcard           : QPagedPaintDevice = ... # 0x4e
    Prc16K                   : QPagedPaintDevice = ... # 0x4f
    Prc32K                   : QPagedPaintDevice = ... # 0x50
    Prc32KBig                : QPagedPaintDevice = ... # 0x51
    FanFoldUS                : QPagedPaintDevice = ... # 0x52
    FanFoldGerman            : QPagedPaintDevice = ... # 0x53
    FanFoldGermanLegal       : QPagedPaintDevice = ... # 0x54
    EnvelopeB4               : QPagedPaintDevice = ... # 0x55
    EnvelopeB5               : QPagedPaintDevice = ... # 0x56
    EnvelopeB6               : QPagedPaintDevice = ... # 0x57
    EnvelopeC0               : QPagedPaintDevice = ... # 0x58
    EnvelopeC1               : QPagedPaintDevice = ... # 0x59
    EnvelopeC2               : QPagedPaintDevice = ... # 0x5a
    EnvelopeC3               : QPagedPaintDevice = ... # 0x5b
    EnvelopeC4               : QPagedPaintDevice = ... # 0x5c
    EnvelopeC6               : QPagedPaintDevice = ... # 0x5d
    EnvelopeC65              : QPagedPaintDevice = ... # 0x5e
    EnvelopeC7               : QPagedPaintDevice = ... # 0x5f
    Envelope9                : QPagedPaintDevice = ... # 0x60
    Envelope11               : QPagedPaintDevice = ... # 0x61
    Envelope12               : QPagedPaintDevice = ... # 0x62
    Envelope14               : QPagedPaintDevice = ... # 0x63
    EnvelopeMonarch          : QPagedPaintDevice = ... # 0x64
    EnvelopePersonal         : QPagedPaintDevice = ... # 0x65
    EnvelopeChou3            : QPagedPaintDevice = ... # 0x66
    EnvelopeChou4            : QPagedPaintDevice = ... # 0x67
    EnvelopeInvite           : QPagedPaintDevice = ... # 0x68
    EnvelopeItalian          : QPagedPaintDevice = ... # 0x69
    EnvelopeKaku2            : QPagedPaintDevice = ... # 0x6a
    EnvelopeKaku3            : QPagedPaintDevice = ... # 0x6b
    EnvelopePrc1             : QPagedPaintDevice = ... # 0x6c
    EnvelopePrc2             : QPagedPaintDevice = ... # 0x6d
    EnvelopePrc3             : QPagedPaintDevice = ... # 0x6e
    EnvelopePrc4             : QPagedPaintDevice = ... # 0x6f
    EnvelopePrc5             : QPagedPaintDevice = ... # 0x70
    EnvelopePrc6             : QPagedPaintDevice = ... # 0x71
    EnvelopePrc7             : QPagedPaintDevice = ... # 0x72
    EnvelopePrc8             : QPagedPaintDevice = ... # 0x73
    EnvelopePrc9             : QPagedPaintDevice = ... # 0x74
    EnvelopePrc10            : QPagedPaintDevice = ... # 0x75
    EnvelopeYou4             : QPagedPaintDevice = ... # 0x76
    LastPageSize             : QPagedPaintDevice = ... # 0x76
    NPageSize                : QPagedPaintDevice = ... # 0x76
    NPaperSize               : QPagedPaintDevice = ... # 0x76

    class Margins(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Margins:PySide2.QtGui.QPagedPaintDevice.Margins) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class PageSize(object):
        A4                       : QPagedPaintDevice.PageSize = ... # 0x0
        B5                       : QPagedPaintDevice.PageSize = ... # 0x1
        AnsiA                    : QPagedPaintDevice.PageSize = ... # 0x2
        Letter                   : QPagedPaintDevice.PageSize = ... # 0x2
        Legal                    : QPagedPaintDevice.PageSize = ... # 0x3
        Executive                : QPagedPaintDevice.PageSize = ... # 0x4
        A0                       : QPagedPaintDevice.PageSize = ... # 0x5
        A1                       : QPagedPaintDevice.PageSize = ... # 0x6
        A2                       : QPagedPaintDevice.PageSize = ... # 0x7
        A3                       : QPagedPaintDevice.PageSize = ... # 0x8
        A5                       : QPagedPaintDevice.PageSize = ... # 0x9
        A6                       : QPagedPaintDevice.PageSize = ... # 0xa
        A7                       : QPagedPaintDevice.PageSize = ... # 0xb
        A8                       : QPagedPaintDevice.PageSize = ... # 0xc
        A9                       : QPagedPaintDevice.PageSize = ... # 0xd
        B0                       : QPagedPaintDevice.PageSize = ... # 0xe
        B1                       : QPagedPaintDevice.PageSize = ... # 0xf
        B10                      : QPagedPaintDevice.PageSize = ... # 0x10
        B2                       : QPagedPaintDevice.PageSize = ... # 0x11
        B3                       : QPagedPaintDevice.PageSize = ... # 0x12
        B4                       : QPagedPaintDevice.PageSize = ... # 0x13
        B6                       : QPagedPaintDevice.PageSize = ... # 0x14
        B7                       : QPagedPaintDevice.PageSize = ... # 0x15
        B8                       : QPagedPaintDevice.PageSize = ... # 0x16
        B9                       : QPagedPaintDevice.PageSize = ... # 0x17
        C5E                      : QPagedPaintDevice.PageSize = ... # 0x18
        EnvelopeC5               : QPagedPaintDevice.PageSize = ... # 0x18
        Comm10E                  : QPagedPaintDevice.PageSize = ... # 0x19
        Envelope10               : QPagedPaintDevice.PageSize = ... # 0x19
        DLE                      : QPagedPaintDevice.PageSize = ... # 0x1a
        EnvelopeDL               : QPagedPaintDevice.PageSize = ... # 0x1a
        Folio                    : QPagedPaintDevice.PageSize = ... # 0x1b
        AnsiB                    : QPagedPaintDevice.PageSize = ... # 0x1c
        Ledger                   : QPagedPaintDevice.PageSize = ... # 0x1c
        Tabloid                  : QPagedPaintDevice.PageSize = ... # 0x1d
        Custom                   : QPagedPaintDevice.PageSize = ... # 0x1e
        A10                      : QPagedPaintDevice.PageSize = ... # 0x1f
        A3Extra                  : QPagedPaintDevice.PageSize = ... # 0x20
        A4Extra                  : QPagedPaintDevice.PageSize = ... # 0x21
        A4Plus                   : QPagedPaintDevice.PageSize = ... # 0x22
        A4Small                  : QPagedPaintDevice.PageSize = ... # 0x23
        A5Extra                  : QPagedPaintDevice.PageSize = ... # 0x24
        B5Extra                  : QPagedPaintDevice.PageSize = ... # 0x25
        JisB0                    : QPagedPaintDevice.PageSize = ... # 0x26
        JisB1                    : QPagedPaintDevice.PageSize = ... # 0x27
        JisB2                    : QPagedPaintDevice.PageSize = ... # 0x28
        JisB3                    : QPagedPaintDevice.PageSize = ... # 0x29
        JisB4                    : QPagedPaintDevice.PageSize = ... # 0x2a
        JisB5                    : QPagedPaintDevice.PageSize = ... # 0x2b
        JisB6                    : QPagedPaintDevice.PageSize = ... # 0x2c
        JisB7                    : QPagedPaintDevice.PageSize = ... # 0x2d
        JisB8                    : QPagedPaintDevice.PageSize = ... # 0x2e
        JisB9                    : QPagedPaintDevice.PageSize = ... # 0x2f
        JisB10                   : QPagedPaintDevice.PageSize = ... # 0x30
        AnsiC                    : QPagedPaintDevice.PageSize = ... # 0x31
        AnsiD                    : QPagedPaintDevice.PageSize = ... # 0x32
        AnsiE                    : QPagedPaintDevice.PageSize = ... # 0x33
        LegalExtra               : QPagedPaintDevice.PageSize = ... # 0x34
        LetterExtra              : QPagedPaintDevice.PageSize = ... # 0x35
        LetterPlus               : QPagedPaintDevice.PageSize = ... # 0x36
        LetterSmall              : QPagedPaintDevice.PageSize = ... # 0x37
        TabloidExtra             : QPagedPaintDevice.PageSize = ... # 0x38
        ArchA                    : QPagedPaintDevice.PageSize = ... # 0x39
        ArchB                    : QPagedPaintDevice.PageSize = ... # 0x3a
        ArchC                    : QPagedPaintDevice.PageSize = ... # 0x3b
        ArchD                    : QPagedPaintDevice.PageSize = ... # 0x3c
        ArchE                    : QPagedPaintDevice.PageSize = ... # 0x3d
        Imperial7x9              : QPagedPaintDevice.PageSize = ... # 0x3e
        Imperial8x10             : QPagedPaintDevice.PageSize = ... # 0x3f
        Imperial9x11             : QPagedPaintDevice.PageSize = ... # 0x40
        Imperial9x12             : QPagedPaintDevice.PageSize = ... # 0x41
        Imperial10x11            : QPagedPaintDevice.PageSize = ... # 0x42
        Imperial10x13            : QPagedPaintDevice.PageSize = ... # 0x43
        Imperial10x14            : QPagedPaintDevice.PageSize = ... # 0x44
        Imperial12x11            : QPagedPaintDevice.PageSize = ... # 0x45
        Imperial15x11            : QPagedPaintDevice.PageSize = ... # 0x46
        ExecutiveStandard        : QPagedPaintDevice.PageSize = ... # 0x47
        Note                     : QPagedPaintDevice.PageSize = ... # 0x48
        Quarto                   : QPagedPaintDevice.PageSize = ... # 0x49
        Statement                : QPagedPaintDevice.PageSize = ... # 0x4a
        SuperA                   : QPagedPaintDevice.PageSize = ... # 0x4b
        SuperB                   : QPagedPaintDevice.PageSize = ... # 0x4c
        Postcard                 : QPagedPaintDevice.PageSize = ... # 0x4d
        DoublePostcard           : QPagedPaintDevice.PageSize = ... # 0x4e
        Prc16K                   : QPagedPaintDevice.PageSize = ... # 0x4f
        Prc32K                   : QPagedPaintDevice.PageSize = ... # 0x50
        Prc32KBig                : QPagedPaintDevice.PageSize = ... # 0x51
        FanFoldUS                : QPagedPaintDevice.PageSize = ... # 0x52
        FanFoldGerman            : QPagedPaintDevice.PageSize = ... # 0x53
        FanFoldGermanLegal       : QPagedPaintDevice.PageSize = ... # 0x54
        EnvelopeB4               : QPagedPaintDevice.PageSize = ... # 0x55
        EnvelopeB5               : QPagedPaintDevice.PageSize = ... # 0x56
        EnvelopeB6               : QPagedPaintDevice.PageSize = ... # 0x57
        EnvelopeC0               : QPagedPaintDevice.PageSize = ... # 0x58
        EnvelopeC1               : QPagedPaintDevice.PageSize = ... # 0x59
        EnvelopeC2               : QPagedPaintDevice.PageSize = ... # 0x5a
        EnvelopeC3               : QPagedPaintDevice.PageSize = ... # 0x5b
        EnvelopeC4               : QPagedPaintDevice.PageSize = ... # 0x5c
        EnvelopeC6               : QPagedPaintDevice.PageSize = ... # 0x5d
        EnvelopeC65              : QPagedPaintDevice.PageSize = ... # 0x5e
        EnvelopeC7               : QPagedPaintDevice.PageSize = ... # 0x5f
        Envelope9                : QPagedPaintDevice.PageSize = ... # 0x60
        Envelope11               : QPagedPaintDevice.PageSize = ... # 0x61
        Envelope12               : QPagedPaintDevice.PageSize = ... # 0x62
        Envelope14               : QPagedPaintDevice.PageSize = ... # 0x63
        EnvelopeMonarch          : QPagedPaintDevice.PageSize = ... # 0x64
        EnvelopePersonal         : QPagedPaintDevice.PageSize = ... # 0x65
        EnvelopeChou3            : QPagedPaintDevice.PageSize = ... # 0x66
        EnvelopeChou4            : QPagedPaintDevice.PageSize = ... # 0x67
        EnvelopeInvite           : QPagedPaintDevice.PageSize = ... # 0x68
        EnvelopeItalian          : QPagedPaintDevice.PageSize = ... # 0x69
        EnvelopeKaku2            : QPagedPaintDevice.PageSize = ... # 0x6a
        EnvelopeKaku3            : QPagedPaintDevice.PageSize = ... # 0x6b
        EnvelopePrc1             : QPagedPaintDevice.PageSize = ... # 0x6c
        EnvelopePrc2             : QPagedPaintDevice.PageSize = ... # 0x6d
        EnvelopePrc3             : QPagedPaintDevice.PageSize = ... # 0x6e
        EnvelopePrc4             : QPagedPaintDevice.PageSize = ... # 0x6f
        EnvelopePrc5             : QPagedPaintDevice.PageSize = ... # 0x70
        EnvelopePrc6             : QPagedPaintDevice.PageSize = ... # 0x71
        EnvelopePrc7             : QPagedPaintDevice.PageSize = ... # 0x72
        EnvelopePrc8             : QPagedPaintDevice.PageSize = ... # 0x73
        EnvelopePrc9             : QPagedPaintDevice.PageSize = ... # 0x74
        EnvelopePrc10            : QPagedPaintDevice.PageSize = ... # 0x75
        EnvelopeYou4             : QPagedPaintDevice.PageSize = ... # 0x76
        LastPageSize             : QPagedPaintDevice.PageSize = ... # 0x76
        NPageSize                : QPagedPaintDevice.PageSize = ... # 0x76
        NPaperSize               : QPagedPaintDevice.PageSize = ... # 0x76

    class PdfVersion(object):
        PdfVersion_1_4           : QPagedPaintDevice.PdfVersion = ... # 0x0
        PdfVersion_A1b           : QPagedPaintDevice.PdfVersion = ... # 0x1
        PdfVersion_1_6           : QPagedPaintDevice.PdfVersion = ... # 0x2

    def __init__(self) -> None: ...

    def devicePageLayout(self) -> PySide2.QtGui.QPageLayout: ...
    def margins(self) -> PySide2.QtGui.QPagedPaintDevice.Margins: ...
    def newPage(self) -> bool: ...
    def pageLayout(self) -> PySide2.QtGui.QPageLayout: ...
    def pageSize(self) -> PySide2.QtGui.QPagedPaintDevice.PageSize: ...
    def pageSizeMM(self) -> PySide2.QtCore.QSizeF: ...
    def setMargins(self, margins:PySide2.QtGui.QPagedPaintDevice.Margins) -> None: ...
    def setPageLayout(self, pageLayout:PySide2.QtGui.QPageLayout) -> bool: ...
    @typing.overload
    def setPageMargins(self, margins:PySide2.QtCore.QMarginsF) -> bool: ...
    @typing.overload
    def setPageMargins(self, margins:PySide2.QtCore.QMarginsF, units:PySide2.QtGui.QPageLayout.Unit) -> bool: ...
    def setPageOrientation(self, orientation:PySide2.QtGui.QPageLayout.Orientation) -> bool: ...
    @typing.overload
    def setPageSize(self, pageSize:PySide2.QtGui.QPageSize) -> bool: ...
    @typing.overload
    def setPageSize(self, size:PySide2.QtGui.QPagedPaintDevice.PageSize) -> None: ...
    def setPageSizeMM(self, size:PySide2.QtCore.QSizeF) -> None: ...


class QPaintDevice(Shiboken.Object):
    PdmWidth                 : QPaintDevice = ... # 0x1
    PdmHeight                : QPaintDevice = ... # 0x2
    PdmWidthMM               : QPaintDevice = ... # 0x3
    PdmHeightMM              : QPaintDevice = ... # 0x4
    PdmNumColors             : QPaintDevice = ... # 0x5
    PdmDepth                 : QPaintDevice = ... # 0x6
    PdmDpiX                  : QPaintDevice = ... # 0x7
    PdmDpiY                  : QPaintDevice = ... # 0x8
    PdmPhysicalDpiX          : QPaintDevice = ... # 0x9
    PdmPhysicalDpiY          : QPaintDevice = ... # 0xa
    PdmDevicePixelRatio      : QPaintDevice = ... # 0xb
    PdmDevicePixelRatioScaled: QPaintDevice = ... # 0xc

    class PaintDeviceMetric(object):
        PdmWidth                 : QPaintDevice.PaintDeviceMetric = ... # 0x1
        PdmHeight                : QPaintDevice.PaintDeviceMetric = ... # 0x2
        PdmWidthMM               : QPaintDevice.PaintDeviceMetric = ... # 0x3
        PdmHeightMM              : QPaintDevice.PaintDeviceMetric = ... # 0x4
        PdmNumColors             : QPaintDevice.PaintDeviceMetric = ... # 0x5
        PdmDepth                 : QPaintDevice.PaintDeviceMetric = ... # 0x6
        PdmDpiX                  : QPaintDevice.PaintDeviceMetric = ... # 0x7
        PdmDpiY                  : QPaintDevice.PaintDeviceMetric = ... # 0x8
        PdmPhysicalDpiX          : QPaintDevice.PaintDeviceMetric = ... # 0x9
        PdmPhysicalDpiY          : QPaintDevice.PaintDeviceMetric = ... # 0xa
        PdmDevicePixelRatio      : QPaintDevice.PaintDeviceMetric = ... # 0xb
        PdmDevicePixelRatioScaled: QPaintDevice.PaintDeviceMetric = ... # 0xc

    def __init__(self) -> None: ...

    def colorCount(self) -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> int: ...
    def devicePixelRatioF(self) -> float: ...
    @staticmethod
    def devicePixelRatioFScale() -> float: ...
    def height(self) -> int: ...
    def heightMM(self) -> int: ...
    def initPainter(self, painter:PySide2.QtGui.QPainter) -> None: ...
    def logicalDpiX(self) -> int: ...
    def logicalDpiY(self) -> int: ...
    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintingActive(self) -> bool: ...
    def physicalDpiX(self) -> int: ...
    def physicalDpiY(self) -> int: ...
    def redirected(self, offset:PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def sharedPainter(self) -> PySide2.QtGui.QPainter: ...
    def width(self) -> int: ...
    def widthMM(self) -> int: ...


class QPaintDeviceWindow(PySide2.QtGui.QWindow, PySide2.QtGui.QPaintDevice):
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1:PySide2.QtGui.QExposeEvent) -> None: ...
    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent) -> None: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, rect:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def update(self, region:PySide2.QtGui.QRegion) -> None: ...


class QPaintEngine(Shiboken.Object):
    OddEvenMode              : QPaintEngine = ... # 0x0
    X11                      : QPaintEngine = ... # 0x0
    DirtyPen                 : QPaintEngine = ... # 0x1
    PrimitiveTransform       : QPaintEngine = ... # 0x1
    WindingMode              : QPaintEngine = ... # 0x1
    Windows                  : QPaintEngine = ... # 0x1
    ConvexMode               : QPaintEngine = ... # 0x2
    DirtyBrush               : QPaintEngine = ... # 0x2
    PatternTransform         : QPaintEngine = ... # 0x2
    QuickDraw                : QPaintEngine = ... # 0x2
    CoreGraphics             : QPaintEngine = ... # 0x3
    PolylineMode             : QPaintEngine = ... # 0x3
    DirtyBrushOrigin         : QPaintEngine = ... # 0x4
    MacPrinter               : QPaintEngine = ... # 0x4
    PixmapTransform          : QPaintEngine = ... # 0x4
    QWindowSystem            : QPaintEngine = ... # 0x5
    PostScript               : QPaintEngine = ... # 0x6
    OpenGL                   : QPaintEngine = ... # 0x7
    DirtyFont                : QPaintEngine = ... # 0x8
    PatternBrush             : QPaintEngine = ... # 0x8
    Picture                  : QPaintEngine = ... # 0x8
    SVG                      : QPaintEngine = ... # 0x9
    Raster                   : QPaintEngine = ... # 0xa
    Direct3D                 : QPaintEngine = ... # 0xb
    Pdf                      : QPaintEngine = ... # 0xc
    OpenVG                   : QPaintEngine = ... # 0xd
    OpenGL2                  : QPaintEngine = ... # 0xe
    PaintBuffer              : QPaintEngine = ... # 0xf
    Blitter                  : QPaintEngine = ... # 0x10
    DirtyBackground          : QPaintEngine = ... # 0x10
    LinearGradientFill       : QPaintEngine = ... # 0x10
    Direct2D                 : QPaintEngine = ... # 0x11
    DirtyBackgroundMode      : QPaintEngine = ... # 0x20
    RadialGradientFill       : QPaintEngine = ... # 0x20
    User                     : QPaintEngine = ... # 0x32
    ConicalGradientFill      : QPaintEngine = ... # 0x40
    DirtyTransform           : QPaintEngine = ... # 0x40
    MaxUser                  : QPaintEngine = ... # 0x64
    AlphaBlend               : QPaintEngine = ... # 0x80
    DirtyClipRegion          : QPaintEngine = ... # 0x80
    DirtyClipPath            : QPaintEngine = ... # 0x100
    PorterDuff               : QPaintEngine = ... # 0x100
    DirtyHints               : QPaintEngine = ... # 0x200
    PainterPaths             : QPaintEngine = ... # 0x200
    Antialiasing             : QPaintEngine = ... # 0x400
    DirtyCompositionMode     : QPaintEngine = ... # 0x400
    BrushStroke              : QPaintEngine = ... # 0x800
    DirtyClipEnabled         : QPaintEngine = ... # 0x800
    ConstantOpacity          : QPaintEngine = ... # 0x1000
    DirtyOpacity             : QPaintEngine = ... # 0x1000
    MaskedBrush              : QPaintEngine = ... # 0x2000
    PerspectiveTransform     : QPaintEngine = ... # 0x4000
    BlendModes               : QPaintEngine = ... # 0x8000
    AllDirty                 : QPaintEngine = ... # 0xffff
    ObjectBoundingModeGradients: QPaintEngine = ... # 0x10000
    RasterOpModes            : QPaintEngine = ... # 0x20000
    PaintOutsidePaintEvent   : QPaintEngine = ... # 0x20000000
    AllFeatures              : QPaintEngine = ... # -0x1

    class DirtyFlag(object):
        DirtyPen                 : QPaintEngine.DirtyFlag = ... # 0x1
        DirtyBrush               : QPaintEngine.DirtyFlag = ... # 0x2
        DirtyBrushOrigin         : QPaintEngine.DirtyFlag = ... # 0x4
        DirtyFont                : QPaintEngine.DirtyFlag = ... # 0x8
        DirtyBackground          : QPaintEngine.DirtyFlag = ... # 0x10
        DirtyBackgroundMode      : QPaintEngine.DirtyFlag = ... # 0x20
        DirtyTransform           : QPaintEngine.DirtyFlag = ... # 0x40
        DirtyClipRegion          : QPaintEngine.DirtyFlag = ... # 0x80
        DirtyClipPath            : QPaintEngine.DirtyFlag = ... # 0x100
        DirtyHints               : QPaintEngine.DirtyFlag = ... # 0x200
        DirtyCompositionMode     : QPaintEngine.DirtyFlag = ... # 0x400
        DirtyClipEnabled         : QPaintEngine.DirtyFlag = ... # 0x800
        DirtyOpacity             : QPaintEngine.DirtyFlag = ... # 0x1000
        AllDirty                 : QPaintEngine.DirtyFlag = ... # 0xffff

    class DirtyFlags(object): ...

    class PaintEngineFeature(object):
        PrimitiveTransform       : QPaintEngine.PaintEngineFeature = ... # 0x1
        PatternTransform         : QPaintEngine.PaintEngineFeature = ... # 0x2
        PixmapTransform          : QPaintEngine.PaintEngineFeature = ... # 0x4
        PatternBrush             : QPaintEngine.PaintEngineFeature = ... # 0x8
        LinearGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x10
        RadialGradientFill       : QPaintEngine.PaintEngineFeature = ... # 0x20
        ConicalGradientFill      : QPaintEngine.PaintEngineFeature = ... # 0x40
        AlphaBlend               : QPaintEngine.PaintEngineFeature = ... # 0x80
        PorterDuff               : QPaintEngine.PaintEngineFeature = ... # 0x100
        PainterPaths             : QPaintEngine.PaintEngineFeature = ... # 0x200
        Antialiasing             : QPaintEngine.PaintEngineFeature = ... # 0x400
        BrushStroke              : QPaintEngine.PaintEngineFeature = ... # 0x800
        ConstantOpacity          : QPaintEngine.PaintEngineFeature = ... # 0x1000
        MaskedBrush              : QPaintEngine.PaintEngineFeature = ... # 0x2000
        PerspectiveTransform     : QPaintEngine.PaintEngineFeature = ... # 0x4000
        BlendModes               : QPaintEngine.PaintEngineFeature = ... # 0x8000
        ObjectBoundingModeGradients: QPaintEngine.PaintEngineFeature = ... # 0x10000
        RasterOpModes            : QPaintEngine.PaintEngineFeature = ... # 0x20000
        PaintOutsidePaintEvent   : QPaintEngine.PaintEngineFeature = ... # 0x20000000
        AllFeatures              : QPaintEngine.PaintEngineFeature = ... # -0x1

    class PaintEngineFeatures(object): ...

    class PolygonDrawMode(object):
        OddEvenMode              : QPaintEngine.PolygonDrawMode = ... # 0x0
        WindingMode              : QPaintEngine.PolygonDrawMode = ... # 0x1
        ConvexMode               : QPaintEngine.PolygonDrawMode = ... # 0x2
        PolylineMode             : QPaintEngine.PolygonDrawMode = ... # 0x3

    class Type(object):
        X11                      : QPaintEngine.Type = ... # 0x0
        Windows                  : QPaintEngine.Type = ... # 0x1
        QuickDraw                : QPaintEngine.Type = ... # 0x2
        CoreGraphics             : QPaintEngine.Type = ... # 0x3
        MacPrinter               : QPaintEngine.Type = ... # 0x4
        QWindowSystem            : QPaintEngine.Type = ... # 0x5
        PostScript               : QPaintEngine.Type = ... # 0x6
        OpenGL                   : QPaintEngine.Type = ... # 0x7
        Picture                  : QPaintEngine.Type = ... # 0x8
        SVG                      : QPaintEngine.Type = ... # 0x9
        Raster                   : QPaintEngine.Type = ... # 0xa
        Direct3D                 : QPaintEngine.Type = ... # 0xb
        Pdf                      : QPaintEngine.Type = ... # 0xc
        OpenVG                   : QPaintEngine.Type = ... # 0xd
        OpenGL2                  : QPaintEngine.Type = ... # 0xe
        PaintBuffer              : QPaintEngine.Type = ... # 0xf
        Blitter                  : QPaintEngine.Type = ... # 0x10
        Direct2D                 : QPaintEngine.Type = ... # 0x11
        User                     : QPaintEngine.Type = ... # 0x32
        MaxUser                  : QPaintEngine.Type = ... # 0x64

    def __init__(self, features:PySide2.QtGui.QPaintEngine.PaintEngineFeatures=...) -> None: ...

    def begin(self, pdev:PySide2.QtGui.QPaintDevice) -> bool: ...
    def clearDirty(self, df:PySide2.QtGui.QPaintEngine.DirtyFlags) -> None: ...
    def coordinateOffset(self) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def drawEllipse(self, r:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def drawEllipse(self, r:PySide2.QtCore.QRectF) -> None: ...
    def drawImage(self, r:PySide2.QtCore.QRectF, pm:PySide2.QtGui.QImage, sr:PySide2.QtCore.QRectF, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    @typing.overload
    def drawLines(self, lines:PySide2.QtCore.QLine, lineCount:int) -> None: ...
    @typing.overload
    def drawLines(self, lines:PySide2.QtCore.QLineF, lineCount:int) -> None: ...
    def drawPath(self, path:PySide2.QtGui.QPainterPath) -> None: ...
    def drawPixmap(self, r:PySide2.QtCore.QRectF, pm:PySide2.QtGui.QPixmap, sr:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPoints(self, points:PySide2.QtCore.QPoint, pointCount:int) -> None: ...
    @typing.overload
    def drawPoints(self, points:PySide2.QtCore.QPointF, pointCount:int) -> None: ...
    @typing.overload
    def drawPolygon(self, points:PySide2.QtCore.QPoint, pointCount:int, mode:PySide2.QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @typing.overload
    def drawPolygon(self, points:PySide2.QtCore.QPointF, pointCount:int, mode:PySide2.QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @typing.overload
    def drawRects(self, rects:PySide2.QtCore.QRect, rectCount:int) -> None: ...
    @typing.overload
    def drawRects(self, rects:PySide2.QtCore.QRectF, rectCount:int) -> None: ...
    def drawTextItem(self, p:PySide2.QtCore.QPointF, textItem:PySide2.QtGui.QTextItem) -> None: ...
    def drawTiledPixmap(self, r:PySide2.QtCore.QRectF, pixmap:PySide2.QtGui.QPixmap, s:PySide2.QtCore.QPointF) -> None: ...
    def end(self) -> bool: ...
    def hasFeature(self, feature:PySide2.QtGui.QPaintEngine.PaintEngineFeatures) -> bool: ...
    def isActive(self) -> bool: ...
    def isExtended(self) -> bool: ...
    def paintDevice(self) -> PySide2.QtGui.QPaintDevice: ...
    def painter(self) -> PySide2.QtGui.QPainter: ...
    def setActive(self, newState:bool) -> None: ...
    def setDirty(self, df:PySide2.QtGui.QPaintEngine.DirtyFlags) -> None: ...
    def setSystemClip(self, baseClip:PySide2.QtGui.QRegion) -> None: ...
    def setSystemRect(self, rect:PySide2.QtCore.QRect) -> None: ...
    def syncState(self) -> None: ...
    def systemClip(self) -> PySide2.QtGui.QRegion: ...
    def systemRect(self) -> PySide2.QtCore.QRect: ...
    def testDirty(self, df:PySide2.QtGui.QPaintEngine.DirtyFlags) -> bool: ...
    def type(self) -> PySide2.QtGui.QPaintEngine.Type: ...
    def updateState(self, state:PySide2.QtGui.QPaintEngineState) -> None: ...


class QPaintEngineState(Shiboken.Object):

    def __init__(self) -> None: ...

    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide2.QtCore.Qt.BGMode: ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def brushNeedsResolving(self) -> bool: ...
    def brushOrigin(self) -> PySide2.QtCore.QPointF: ...
    def clipOperation(self) -> PySide2.QtCore.Qt.ClipOperation: ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide2.QtGui.QRegion: ...
    def compositionMode(self) -> PySide2.QtGui.QPainter.CompositionMode: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def isClipEnabled(self) -> bool: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def opacity(self) -> float: ...
    def painter(self) -> PySide2.QtGui.QPainter: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    def penNeedsResolving(self) -> bool: ...
    def renderHints(self) -> PySide2.QtGui.QPainter.RenderHints: ...
    def state(self) -> PySide2.QtGui.QPaintEngine.DirtyFlags: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...


class QPaintEvent(PySide2.QtCore.QEvent):

    @typing.overload
    def __init__(self, paintRect:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, paintRegion:PySide2.QtGui.QRegion) -> None: ...

    def rect(self) -> PySide2.QtCore.QRect: ...
    def region(self) -> PySide2.QtGui.QRegion: ...


class QPainter(Shiboken.Object):
    CompositionMode_SourceOver: QPainter = ... # 0x0
    Antialiasing             : QPainter = ... # 0x1
    CompositionMode_DestinationOver: QPainter = ... # 0x1
    OpaqueHint               : QPainter = ... # 0x1
    CompositionMode_Clear    : QPainter = ... # 0x2
    TextAntialiasing         : QPainter = ... # 0x2
    CompositionMode_Source   : QPainter = ... # 0x3
    CompositionMode_Destination: QPainter = ... # 0x4
    SmoothPixmapTransform    : QPainter = ... # 0x4
    CompositionMode_SourceIn : QPainter = ... # 0x5
    CompositionMode_DestinationIn: QPainter = ... # 0x6
    CompositionMode_SourceOut: QPainter = ... # 0x7
    CompositionMode_DestinationOut: QPainter = ... # 0x8
    HighQualityAntialiasing  : QPainter = ... # 0x8
    CompositionMode_SourceAtop: QPainter = ... # 0x9
    CompositionMode_DestinationAtop: QPainter = ... # 0xa
    CompositionMode_Xor      : QPainter = ... # 0xb
    CompositionMode_Plus     : QPainter = ... # 0xc
    CompositionMode_Multiply : QPainter = ... # 0xd
    CompositionMode_Screen   : QPainter = ... # 0xe
    CompositionMode_Overlay  : QPainter = ... # 0xf
    CompositionMode_Darken   : QPainter = ... # 0x10
    NonCosmeticDefaultPen    : QPainter = ... # 0x10
    CompositionMode_Lighten  : QPainter = ... # 0x11
    CompositionMode_ColorDodge: QPainter = ... # 0x12
    CompositionMode_ColorBurn: QPainter = ... # 0x13
    CompositionMode_HardLight: QPainter = ... # 0x14
    CompositionMode_SoftLight: QPainter = ... # 0x15
    CompositionMode_Difference: QPainter = ... # 0x16
    CompositionMode_Exclusion: QPainter = ... # 0x17
    RasterOp_SourceOrDestination: QPainter = ... # 0x18
    RasterOp_SourceAndDestination: QPainter = ... # 0x19
    RasterOp_SourceXorDestination: QPainter = ... # 0x1a
    RasterOp_NotSourceAndNotDestination: QPainter = ... # 0x1b
    RasterOp_NotSourceOrNotDestination: QPainter = ... # 0x1c
    RasterOp_NotSourceXorDestination: QPainter = ... # 0x1d
    RasterOp_NotSource       : QPainter = ... # 0x1e
    RasterOp_NotSourceAndDestination: QPainter = ... # 0x1f
    Qt4CompatiblePainting    : QPainter = ... # 0x20
    RasterOp_SourceAndNotDestination: QPainter = ... # 0x20
    RasterOp_NotSourceOrDestination: QPainter = ... # 0x21
    RasterOp_SourceOrNotDestination: QPainter = ... # 0x22
    RasterOp_ClearDestination: QPainter = ... # 0x23
    RasterOp_SetDestination  : QPainter = ... # 0x24
    RasterOp_NotDestination  : QPainter = ... # 0x25
    LosslessImageRendering   : QPainter = ... # 0x40

    class CompositionMode(object):
        CompositionMode_SourceOver: QPainter.CompositionMode = ... # 0x0
        CompositionMode_DestinationOver: QPainter.CompositionMode = ... # 0x1
        CompositionMode_Clear    : QPainter.CompositionMode = ... # 0x2
        CompositionMode_Source   : QPainter.CompositionMode = ... # 0x3
        CompositionMode_Destination: QPainter.CompositionMode = ... # 0x4
        CompositionMode_SourceIn : QPainter.CompositionMode = ... # 0x5
        CompositionMode_DestinationIn: QPainter.CompositionMode = ... # 0x6
        CompositionMode_SourceOut: QPainter.CompositionMode = ... # 0x7
        CompositionMode_DestinationOut: QPainter.CompositionMode = ... # 0x8
        CompositionMode_SourceAtop: QPainter.CompositionMode = ... # 0x9
        CompositionMode_DestinationAtop: QPainter.CompositionMode = ... # 0xa
        CompositionMode_Xor      : QPainter.CompositionMode = ... # 0xb
        CompositionMode_Plus     : QPainter.CompositionMode = ... # 0xc
        CompositionMode_Multiply : QPainter.CompositionMode = ... # 0xd
        CompositionMode_Screen   : QPainter.CompositionMode = ... # 0xe
        CompositionMode_Overlay  : QPainter.CompositionMode = ... # 0xf
        CompositionMode_Darken   : QPainter.CompositionMode = ... # 0x10
        CompositionMode_Lighten  : QPainter.CompositionMode = ... # 0x11
        CompositionMode_ColorDodge: QPainter.CompositionMode = ... # 0x12
        CompositionMode_ColorBurn: QPainter.CompositionMode = ... # 0x13
        CompositionMode_HardLight: QPainter.CompositionMode = ... # 0x14
        CompositionMode_SoftLight: QPainter.CompositionMode = ... # 0x15
        CompositionMode_Difference: QPainter.CompositionMode = ... # 0x16
        CompositionMode_Exclusion: QPainter.CompositionMode = ... # 0x17
        RasterOp_SourceOrDestination: QPainter.CompositionMode = ... # 0x18
        RasterOp_SourceAndDestination: QPainter.CompositionMode = ... # 0x19
        RasterOp_SourceXorDestination: QPainter.CompositionMode = ... # 0x1a
        RasterOp_NotSourceAndNotDestination: QPainter.CompositionMode = ... # 0x1b
        RasterOp_NotSourceOrNotDestination: QPainter.CompositionMode = ... # 0x1c
        RasterOp_NotSourceXorDestination: QPainter.CompositionMode = ... # 0x1d
        RasterOp_NotSource       : QPainter.CompositionMode = ... # 0x1e
        RasterOp_NotSourceAndDestination: QPainter.CompositionMode = ... # 0x1f
        RasterOp_SourceAndNotDestination: QPainter.CompositionMode = ... # 0x20
        RasterOp_NotSourceOrDestination: QPainter.CompositionMode = ... # 0x21
        RasterOp_SourceOrNotDestination: QPainter.CompositionMode = ... # 0x22
        RasterOp_ClearDestination: QPainter.CompositionMode = ... # 0x23
        RasterOp_SetDestination  : QPainter.CompositionMode = ... # 0x24
        RasterOp_NotDestination  : QPainter.CompositionMode = ... # 0x25

    class PixmapFragment(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, PixmapFragment:PySide2.QtGui.QPainter.PixmapFragment) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        @staticmethod
        def create(pos:PySide2.QtCore.QPointF, sourceRect:PySide2.QtCore.QRectF, scaleX:float=..., scaleY:float=..., rotation:float=..., opacity:float=...) -> PySide2.QtGui.QPainter.PixmapFragment: ...

    class PixmapFragmentHint(object):
        OpaqueHint               : QPainter.PixmapFragmentHint = ... # 0x1

    class PixmapFragmentHints(object): ...

    class RenderHint(object):
        Antialiasing             : QPainter.RenderHint = ... # 0x1
        TextAntialiasing         : QPainter.RenderHint = ... # 0x2
        SmoothPixmapTransform    : QPainter.RenderHint = ... # 0x4
        HighQualityAntialiasing  : QPainter.RenderHint = ... # 0x8
        NonCosmeticDefaultPen    : QPainter.RenderHint = ... # 0x10
        Qt4CompatiblePainting    : QPainter.RenderHint = ... # 0x20
        LosslessImageRendering   : QPainter.RenderHint = ... # 0x40

    class RenderHints(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QPaintDevice) -> None: ...

    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundMode(self) -> PySide2.QtCore.Qt.BGMode: ...
    def begin(self, arg__1:PySide2.QtGui.QPaintDevice) -> bool: ...
    def beginNativePainting(self) -> None: ...
    @typing.overload
    def boundingRect(self, rect:PySide2.QtCore.QRect, flags:int, text:str) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, rect:PySide2.QtCore.QRectF, flags:int, text:str) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, rect:PySide2.QtCore.QRectF, text:str, o:PySide2.QtGui.QTextOption=...) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, x:int, y:int, w:int, h:int, flags:int, text:str) -> PySide2.QtCore.QRect: ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def brushOrigin(self) -> PySide2.QtCore.QPoint: ...
    def clipBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def clipRegion(self) -> PySide2.QtGui.QRegion: ...
    def combinedMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def combinedTransform(self) -> PySide2.QtGui.QTransform: ...
    def compositionMode(self) -> PySide2.QtGui.QPainter.CompositionMode: ...
    def device(self) -> PySide2.QtGui.QPaintDevice: ...
    def deviceMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def deviceTransform(self) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def drawArc(self, arg__1:PySide2.QtCore.QRect, a:int, alen:int) -> None: ...
    @typing.overload
    def drawArc(self, rect:PySide2.QtCore.QRectF, a:int, alen:int) -> None: ...
    @typing.overload
    def drawArc(self, x:int, y:int, w:int, h:int, a:int, alen:int) -> None: ...
    @typing.overload
    def drawChord(self, arg__1:PySide2.QtCore.QRect, a:int, alen:int) -> None: ...
    @typing.overload
    def drawChord(self, rect:PySide2.QtCore.QRectF, a:int, alen:int) -> None: ...
    @typing.overload
    def drawChord(self, x:int, y:int, w:int, h:int, a:int, alen:int) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, arg__1:typing.List) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, arg__1:typing.List) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, polygon:PySide2.QtGui.QPolygon) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, polygon:PySide2.QtGui.QPolygonF) -> None: ...
    @typing.overload
    def drawEllipse(self, center:PySide2.QtCore.QPoint, rx:int, ry:int) -> None: ...
    @typing.overload
    def drawEllipse(self, center:PySide2.QtCore.QPointF, rx:float, ry:float) -> None: ...
    @typing.overload
    def drawEllipse(self, r:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def drawEllipse(self, r:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawEllipse(self, x:int, y:int, w:int, h:int) -> None: ...
    @typing.overload
    def drawImage(self, p:PySide2.QtCore.QPoint, image:PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, p:PySide2.QtCore.QPoint, image:PySide2.QtGui.QImage, sr:PySide2.QtCore.QRect, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    @typing.overload
    def drawImage(self, p:PySide2.QtCore.QPointF, image:PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, p:PySide2.QtCore.QPointF, image:PySide2.QtGui.QImage, sr:PySide2.QtCore.QRectF, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    @typing.overload
    def drawImage(self, r:PySide2.QtCore.QRect, image:PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, r:PySide2.QtCore.QRectF, image:PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def drawImage(self, targetRect:PySide2.QtCore.QRect, image:PySide2.QtGui.QImage, sourceRect:PySide2.QtCore.QRect, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    @typing.overload
    def drawImage(self, targetRect:PySide2.QtCore.QRectF, image:PySide2.QtGui.QImage, sourceRect:PySide2.QtCore.QRectF, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    @typing.overload
    def drawImage(self, x:int, y:int, image:PySide2.QtGui.QImage, sx:int=..., sy:int=..., sw:int=..., sh:int=..., flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    @typing.overload
    def drawLine(self, line:PySide2.QtCore.QLine) -> None: ...
    @typing.overload
    def drawLine(self, line:PySide2.QtCore.QLineF) -> None: ...
    @typing.overload
    def drawLine(self, p1:PySide2.QtCore.QPoint, p2:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def drawLine(self, p1:PySide2.QtCore.QPointF, p2:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def drawLine(self, x1:int, y1:int, x2:int, y2:int) -> None: ...
    @typing.overload
    def drawLines(self, lines:typing.List) -> None: ...
    @typing.overload
    def drawLines(self, lines:typing.List) -> None: ...
    @typing.overload
    def drawLines(self, pointPairs:typing.List) -> None: ...
    @typing.overload
    def drawLines(self, pointPairs:typing.List) -> None: ...
    def drawPath(self, path:PySide2.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def drawPicture(self, p:PySide2.QtCore.QPoint, picture:PySide2.QtGui.QPicture) -> None: ...
    @typing.overload
    def drawPicture(self, p:PySide2.QtCore.QPointF, picture:PySide2.QtGui.QPicture) -> None: ...
    @typing.overload
    def drawPicture(self, x:int, y:int, picture:PySide2.QtGui.QPicture) -> None: ...
    @typing.overload
    def drawPie(self, arg__1:PySide2.QtCore.QRect, a:int, alen:int) -> None: ...
    @typing.overload
    def drawPie(self, rect:PySide2.QtCore.QRectF, a:int, alen:int) -> None: ...
    @typing.overload
    def drawPie(self, x:int, y:int, w:int, h:int, a:int, alen:int) -> None: ...
    @typing.overload
    def drawPixmap(self, p:PySide2.QtCore.QPoint, pm:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, p:PySide2.QtCore.QPoint, pm:PySide2.QtGui.QPixmap, sr:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def drawPixmap(self, p:PySide2.QtCore.QPointF, pm:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, p:PySide2.QtCore.QPointF, pm:PySide2.QtGui.QPixmap, sr:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPixmap(self, r:PySide2.QtCore.QRect, pm:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, targetRect:PySide2.QtCore.QRect, pixmap:PySide2.QtGui.QPixmap, sourceRect:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def drawPixmap(self, targetRect:PySide2.QtCore.QRectF, pixmap:PySide2.QtGui.QPixmap, sourceRect:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPixmap(self, x:int, y:int, pm:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, x:int, y:int, pm:PySide2.QtGui.QPixmap, sx:int, sy:int, sw:int, sh:int) -> None: ...
    @typing.overload
    def drawPixmap(self, x:int, y:int, w:int, h:int, pm:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, x:int, y:int, w:int, h:int, pm:PySide2.QtGui.QPixmap, sx:int, sy:int, sw:int, sh:int) -> None: ...
    def drawPixmapFragments(self, fragments:PySide2.QtGui.QPainter.PixmapFragment, fragmentCount:int, pixmap:PySide2.QtGui.QPixmap, hints:PySide2.QtGui.QPainter.PixmapFragmentHints=...) -> None: ...
    @typing.overload
    def drawPoint(self, p:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def drawPoint(self, pt:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def drawPoint(self, x:int, y:int) -> None: ...
    @typing.overload
    def drawPoints(self, arg__1:typing.List) -> None: ...
    @typing.overload
    def drawPoints(self, arg__1:typing.List) -> None: ...
    @typing.overload
    def drawPoints(self, points:PySide2.QtGui.QPolygon) -> None: ...
    @typing.overload
    def drawPoints(self, points:PySide2.QtGui.QPolygonF) -> None: ...
    @typing.overload
    def drawPolygon(self, arg__1:typing.List, arg__2:PySide2.QtCore.Qt.FillRule) -> None: ...
    @typing.overload
    def drawPolygon(self, arg__1:typing.List, arg__2:PySide2.QtCore.Qt.FillRule) -> None: ...
    @typing.overload
    def drawPolygon(self, polygon:PySide2.QtGui.QPolygon, fillRule:PySide2.QtCore.Qt.FillRule=...) -> None: ...
    @typing.overload
    def drawPolygon(self, polygon:PySide2.QtGui.QPolygonF, fillRule:PySide2.QtCore.Qt.FillRule=...) -> None: ...
    @typing.overload
    def drawPolyline(self, arg__1:typing.List) -> None: ...
    @typing.overload
    def drawPolyline(self, arg__1:typing.List) -> None: ...
    @typing.overload
    def drawPolyline(self, polygon:PySide2.QtGui.QPolygon) -> None: ...
    @typing.overload
    def drawPolyline(self, polyline:PySide2.QtGui.QPolygonF) -> None: ...
    @typing.overload
    def drawRect(self, rect:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def drawRect(self, rect:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawRect(self, x1:int, y1:int, w:int, h:int) -> None: ...
    @typing.overload
    def drawRects(self, rectangles:typing.List) -> None: ...
    @typing.overload
    def drawRects(self, rectangles:typing.List) -> None: ...
    @typing.overload
    def drawRoundRect(self, r:PySide2.QtCore.QRect, xround:int=..., yround:int=...) -> None: ...
    @typing.overload
    def drawRoundRect(self, r:PySide2.QtCore.QRectF, xround:int=..., yround:int=...) -> None: ...
    @typing.overload
    def drawRoundRect(self, x:int, y:int, w:int, h:int, xRound:int=..., yRound:int=...) -> None: ...
    @typing.overload
    def drawRoundedRect(self, rect:PySide2.QtCore.QRect, xRadius:float, yRadius:float, mode:PySide2.QtCore.Qt.SizeMode=...) -> None: ...
    @typing.overload
    def drawRoundedRect(self, rect:PySide2.QtCore.QRectF, xRadius:float, yRadius:float, mode:PySide2.QtCore.Qt.SizeMode=...) -> None: ...
    @typing.overload
    def drawRoundedRect(self, x:int, y:int, w:int, h:int, xRadius:float, yRadius:float, mode:PySide2.QtCore.Qt.SizeMode=...) -> None: ...
    @typing.overload
    def drawStaticText(self, left:int, top:int, staticText:PySide2.QtGui.QStaticText) -> None: ...
    @typing.overload
    def drawStaticText(self, topLeftPosition:PySide2.QtCore.QPoint, staticText:PySide2.QtGui.QStaticText) -> None: ...
    @typing.overload
    def drawStaticText(self, topLeftPosition:PySide2.QtCore.QPointF, staticText:PySide2.QtGui.QStaticText) -> None: ...
    @typing.overload
    def drawText(self, p:PySide2.QtCore.QPoint, s:str) -> None: ...
    @typing.overload
    def drawText(self, p:PySide2.QtCore.QPointF, s:str) -> None: ...
    @typing.overload
    def drawText(self, r:PySide2.QtCore.QRect, flags:int, text:str, br:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def drawText(self, r:PySide2.QtCore.QRectF, flags:int, text:str, br:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def drawText(self, r:PySide2.QtCore.QRectF, text:str, o:PySide2.QtGui.QTextOption=...) -> None: ...
    @typing.overload
    def drawText(self, x:int, y:int, s:str) -> None: ...
    @typing.overload
    def drawText(self, x:int, y:int, w:int, h:int, flags:int, text:str, br:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def drawTextItem(self, p:PySide2.QtCore.QPoint, ti:PySide2.QtGui.QTextItem) -> None: ...
    @typing.overload
    def drawTextItem(self, p:PySide2.QtCore.QPointF, ti:PySide2.QtGui.QTextItem) -> None: ...
    @typing.overload
    def drawTextItem(self, x:int, y:int, ti:PySide2.QtGui.QTextItem) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, arg__1:PySide2.QtCore.QRect, arg__2:PySide2.QtGui.QPixmap, pos:PySide2.QtCore.QPoint=...) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, rect:PySide2.QtCore.QRectF, pm:PySide2.QtGui.QPixmap, offset:PySide2.QtCore.QPointF=...) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, x:int, y:int, w:int, h:int, arg__5:PySide2.QtGui.QPixmap, sx:int=..., sy:int=...) -> None: ...
    def end(self) -> bool: ...
    def endNativePainting(self) -> None: ...
    @typing.overload
    def eraseRect(self, arg__1:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def eraseRect(self, arg__1:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def eraseRect(self, x:int, y:int, w:int, h:int) -> None: ...
    def fillPath(self, path:PySide2.QtGui.QPainterPath, brush:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def fillRect(self, arg__1:PySide2.QtCore.QRect, arg__2:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def fillRect(self, arg__1:PySide2.QtCore.QRect, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def fillRect(self, arg__1:PySide2.QtCore.QRectF, arg__2:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def fillRect(self, arg__1:PySide2.QtCore.QRectF, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def fillRect(self, r:PySide2.QtCore.QRect, c:PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, r:PySide2.QtCore.QRect, preset:PySide2.QtGui.QGradient.Preset) -> None: ...
    @typing.overload
    def fillRect(self, r:PySide2.QtCore.QRect, style:PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def fillRect(self, r:PySide2.QtCore.QRectF, c:PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, r:PySide2.QtCore.QRectF, preset:PySide2.QtGui.QGradient.Preset) -> None: ...
    @typing.overload
    def fillRect(self, r:PySide2.QtCore.QRectF, style:PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def fillRect(self, x:int, y:int, w:int, h:int, arg__5:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def fillRect(self, x:int, y:int, w:int, h:int, c:PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, x:int, y:int, w:int, h:int, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def fillRect(self, x:int, y:int, w:int, h:int, preset:PySide2.QtGui.QGradient.Preset) -> None: ...
    @typing.overload
    def fillRect(self, x:int, y:int, w:int, h:int, style:PySide2.QtCore.Qt.BrushStyle) -> None: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def fontInfo(self) -> PySide2.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide2.QtGui.QFontMetrics: ...
    def hasClipping(self) -> bool: ...
    def initFrom(self, device:PySide2.QtGui.QPaintDevice) -> None: ...
    def isActive(self) -> bool: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def matrixEnabled(self) -> bool: ...
    def opacity(self) -> float: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    @staticmethod
    def redirected(device:PySide2.QtGui.QPaintDevice, offset:typing.Optional[PySide2.QtCore.QPoint]=...) -> PySide2.QtGui.QPaintDevice: ...
    def renderHints(self) -> PySide2.QtGui.QPainter.RenderHints: ...
    def resetMatrix(self) -> None: ...
    def resetTransform(self) -> None: ...
    def restore(self) -> None: ...
    @staticmethod
    def restoreRedirected(device:PySide2.QtGui.QPaintDevice) -> None: ...
    def rotate(self, a:float) -> None: ...
    def save(self) -> None: ...
    def scale(self, sx:float, sy:float) -> None: ...
    def setBackground(self, bg:PySide2.QtGui.QBrush) -> None: ...
    def setBackgroundMode(self, mode:PySide2.QtCore.Qt.BGMode) -> None: ...
    @typing.overload
    def setBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def setBrush(self, style:PySide2.QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def setBrushOrigin(self, arg__1:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def setBrushOrigin(self, arg__1:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setBrushOrigin(self, x:int, y:int) -> None: ...
    def setClipPath(self, path:PySide2.QtGui.QPainterPath, op:PySide2.QtCore.Qt.ClipOperation=...) -> None: ...
    @typing.overload
    def setClipRect(self, arg__1:PySide2.QtCore.QRect, op:PySide2.QtCore.Qt.ClipOperation=...) -> None: ...
    @typing.overload
    def setClipRect(self, arg__1:PySide2.QtCore.QRectF, op:PySide2.QtCore.Qt.ClipOperation=...) -> None: ...
    @typing.overload
    def setClipRect(self, x:int, y:int, w:int, h:int, op:PySide2.QtCore.Qt.ClipOperation=...) -> None: ...
    def setClipRegion(self, arg__1:PySide2.QtGui.QRegion, op:PySide2.QtCore.Qt.ClipOperation=...) -> None: ...
    def setClipping(self, enable:bool) -> None: ...
    def setCompositionMode(self, mode:PySide2.QtGui.QPainter.CompositionMode) -> None: ...
    def setFont(self, f:PySide2.QtGui.QFont) -> None: ...
    def setLayoutDirection(self, direction:PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setMatrix(self, matrix:PySide2.QtGui.QMatrix, combine:bool=...) -> None: ...
    def setMatrixEnabled(self, enabled:bool) -> None: ...
    def setOpacity(self, opacity:float) -> None: ...
    @typing.overload
    def setPen(self, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setPen(self, pen:PySide2.QtGui.QPen) -> None: ...
    @typing.overload
    def setPen(self, style:PySide2.QtCore.Qt.PenStyle) -> None: ...
    @staticmethod
    def setRedirected(device:PySide2.QtGui.QPaintDevice, replacement:PySide2.QtGui.QPaintDevice, offset:PySide2.QtCore.QPoint=...) -> None: ...
    def setRenderHint(self, hint:PySide2.QtGui.QPainter.RenderHint, on:bool=...) -> None: ...
    def setRenderHints(self, hints:PySide2.QtGui.QPainter.RenderHints, on:bool=...) -> None: ...
    def setTransform(self, transform:PySide2.QtGui.QTransform, combine:bool=...) -> None: ...
    def setViewTransformEnabled(self, enable:bool) -> None: ...
    @typing.overload
    def setViewport(self, viewport:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def setViewport(self, x:int, y:int, w:int, h:int) -> None: ...
    @typing.overload
    def setWindow(self, window:PySide2.QtCore.QRect) -> None: ...
    @typing.overload
    def setWindow(self, x:int, y:int, w:int, h:int) -> None: ...
    def setWorldMatrix(self, matrix:PySide2.QtGui.QMatrix, combine:bool=...) -> None: ...
    def setWorldMatrixEnabled(self, enabled:bool) -> None: ...
    def setWorldTransform(self, matrix:PySide2.QtGui.QTransform, combine:bool=...) -> None: ...
    def shear(self, sh:float, sv:float) -> None: ...
    def strokePath(self, path:PySide2.QtGui.QPainterPath, pen:PySide2.QtGui.QPen) -> None: ...
    def testRenderHint(self, hint:PySide2.QtGui.QPainter.RenderHint) -> bool: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def translate(self, dx:float, dy:float) -> None: ...
    @typing.overload
    def translate(self, offset:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def translate(self, offset:PySide2.QtCore.QPointF) -> None: ...
    def viewTransformEnabled(self) -> bool: ...
    def viewport(self) -> PySide2.QtCore.QRect: ...
    def window(self) -> PySide2.QtCore.QRect: ...
    def worldMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def worldMatrixEnabled(self) -> bool: ...
    def worldTransform(self) -> PySide2.QtGui.QTransform: ...


class QPainterPath(Shiboken.Object):
    MoveToElement            : QPainterPath = ... # 0x0
    LineToElement            : QPainterPath = ... # 0x1
    CurveToElement           : QPainterPath = ... # 0x2
    CurveToDataElement       : QPainterPath = ... # 0x3

    class Element(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Element:PySide2.QtGui.QPainterPath.Element) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isCurveTo(self) -> bool: ...
        def isLineTo(self) -> bool: ...
        def isMoveTo(self) -> bool: ...

    class ElementType(object):
        MoveToElement            : QPainterPath.ElementType = ... # 0x0
        LineToElement            : QPainterPath.ElementType = ... # 0x1
        CurveToElement           : QPainterPath.ElementType = ... # 0x2
        CurveToDataElement       : QPainterPath.ElementType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def __init__(self, startPoint:PySide2.QtCore.QPointF) -> None: ...

    def __add__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __and__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __iand__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __ior__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __isub__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QTransform) -> PySide2.QtGui.QPainterPath: ...
    def __or__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, other:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def addEllipse(self, center:PySide2.QtCore.QPointF, rx:float, ry:float) -> None: ...
    @typing.overload
    def addEllipse(self, rect:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def addEllipse(self, x:float, y:float, w:float, h:float) -> None: ...
    def addPath(self, path:PySide2.QtGui.QPainterPath) -> None: ...
    def addPolygon(self, polygon:PySide2.QtGui.QPolygonF) -> None: ...
    @typing.overload
    def addRect(self, rect:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def addRect(self, x:float, y:float, w:float, h:float) -> None: ...
    def addRegion(self, region:PySide2.QtGui.QRegion) -> None: ...
    @typing.overload
    def addRoundRect(self, rect:PySide2.QtCore.QRectF, roundness:int) -> None: ...
    @typing.overload
    def addRoundRect(self, rect:PySide2.QtCore.QRectF, xRnd:int, yRnd:int) -> None: ...
    @typing.overload
    def addRoundRect(self, x:float, y:float, w:float, h:float, roundness:int) -> None: ...
    @typing.overload
    def addRoundRect(self, x:float, y:float, w:float, h:float, xRnd:int, yRnd:int) -> None: ...
    @typing.overload
    def addRoundedRect(self, rect:PySide2.QtCore.QRectF, xRadius:float, yRadius:float, mode:PySide2.QtCore.Qt.SizeMode=...) -> None: ...
    @typing.overload
    def addRoundedRect(self, x:float, y:float, w:float, h:float, xRadius:float, yRadius:float, mode:PySide2.QtCore.Qt.SizeMode=...) -> None: ...
    @typing.overload
    def addText(self, point:PySide2.QtCore.QPointF, f:PySide2.QtGui.QFont, text:str) -> None: ...
    @typing.overload
    def addText(self, x:float, y:float, f:PySide2.QtGui.QFont, text:str) -> None: ...
    def angleAtPercent(self, t:float) -> float: ...
    @typing.overload
    def arcMoveTo(self, rect:PySide2.QtCore.QRectF, angle:float) -> None: ...
    @typing.overload
    def arcMoveTo(self, x:float, y:float, w:float, h:float, angle:float) -> None: ...
    @typing.overload
    def arcTo(self, rect:PySide2.QtCore.QRectF, startAngle:float, arcLength:float) -> None: ...
    @typing.overload
    def arcTo(self, x:float, y:float, w:float, h:float, startAngle:float, arcLength:float) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def closeSubpath(self) -> None: ...
    def connectPath(self, path:PySide2.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def contains(self, p:PySide2.QtGui.QPainterPath) -> bool: ...
    @typing.overload
    def contains(self, pt:PySide2.QtCore.QPointF) -> bool: ...
    @typing.overload
    def contains(self, rect:PySide2.QtCore.QRectF) -> bool: ...
    def controlPointRect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def cubicTo(self, ctrlPt1:PySide2.QtCore.QPointF, ctrlPt2:PySide2.QtCore.QPointF, endPt:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def cubicTo(self, ctrlPt1x:float, ctrlPt1y:float, ctrlPt2x:float, ctrlPt2y:float, endPtx:float, endPty:float) -> None: ...
    def currentPosition(self) -> PySide2.QtCore.QPointF: ...
    def elementAt(self, i:int) -> PySide2.QtGui.QPainterPath.Element: ...
    def elementCount(self) -> int: ...
    def fillRule(self) -> PySide2.QtCore.Qt.FillRule: ...
    def intersected(self, r:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def intersects(self, p:PySide2.QtGui.QPainterPath) -> bool: ...
    @typing.overload
    def intersects(self, rect:PySide2.QtCore.QRectF) -> bool: ...
    def isEmpty(self) -> bool: ...
    def length(self) -> float: ...
    @typing.overload
    def lineTo(self, p:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def lineTo(self, x:float, y:float) -> None: ...
    @typing.overload
    def moveTo(self, p:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def moveTo(self, x:float, y:float) -> None: ...
    def percentAtLength(self, t:float) -> float: ...
    def pointAtPercent(self, t:float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def quadTo(self, ctrlPt:PySide2.QtCore.QPointF, endPt:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def quadTo(self, ctrlPtx:float, ctrlPty:float, endPtx:float, endPty:float) -> None: ...
    def reserve(self, size:int) -> None: ...
    def setElementPositionAt(self, i:int, x:float, y:float) -> None: ...
    def setFillRule(self, fillRule:PySide2.QtCore.Qt.FillRule) -> None: ...
    def simplified(self) -> PySide2.QtGui.QPainterPath: ...
    def slopeAtPercent(self, t:float) -> float: ...
    def subtracted(self, r:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def subtractedInverted(self, r:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def swap(self, other:PySide2.QtGui.QPainterPath) -> None: ...
    @typing.overload
    def toFillPolygon(self, matrix:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def toFillPolygon(self, matrix:PySide2.QtGui.QTransform=...) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def toFillPolygons(self, matrix:PySide2.QtGui.QMatrix) -> typing.List: ...
    @typing.overload
    def toFillPolygons(self, matrix:PySide2.QtGui.QTransform=...) -> typing.List: ...
    def toReversed(self) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def toSubpathPolygons(self, matrix:PySide2.QtGui.QMatrix) -> typing.List: ...
    @typing.overload
    def toSubpathPolygons(self, matrix:PySide2.QtGui.QTransform=...) -> typing.List: ...
    @typing.overload
    def translate(self, dx:float, dy:float) -> None: ...
    @typing.overload
    def translate(self, offset:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def translated(self, dx:float, dy:float) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def translated(self, offset:PySide2.QtCore.QPointF) -> PySide2.QtGui.QPainterPath: ...
    def united(self, r:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...


class QPainterPathStroker(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pen:PySide2.QtGui.QPen) -> None: ...

    def capStyle(self) -> PySide2.QtCore.Qt.PenCapStyle: ...
    def createStroke(self, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    def curveThreshold(self) -> float: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List: ...
    def joinStyle(self) -> PySide2.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setCapStyle(self, style:PySide2.QtCore.Qt.PenCapStyle) -> None: ...
    def setCurveThreshold(self, threshold:float) -> None: ...
    def setDashOffset(self, offset:float) -> None: ...
    @typing.overload
    def setDashPattern(self, arg__1:PySide2.QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def setDashPattern(self, dashPattern:typing.List) -> None: ...
    def setJoinStyle(self, style:PySide2.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, length:float) -> None: ...
    def setWidth(self, width:float) -> None: ...
    def width(self) -> float: ...


class QPalette(Shiboken.Object):
    Active                   : QPalette = ... # 0x0
    Foreground               : QPalette = ... # 0x0
    Normal                   : QPalette = ... # 0x0
    WindowText               : QPalette = ... # 0x0
    Button                   : QPalette = ... # 0x1
    Disabled                 : QPalette = ... # 0x1
    Inactive                 : QPalette = ... # 0x2
    Light                    : QPalette = ... # 0x2
    Midlight                 : QPalette = ... # 0x3
    NColorGroups             : QPalette = ... # 0x3
    Current                  : QPalette = ... # 0x4
    Dark                     : QPalette = ... # 0x4
    All                      : QPalette = ... # 0x5
    Mid                      : QPalette = ... # 0x5
    Text                     : QPalette = ... # 0x6
    BrightText               : QPalette = ... # 0x7
    ButtonText               : QPalette = ... # 0x8
    Base                     : QPalette = ... # 0x9
    Background               : QPalette = ... # 0xa
    Window                   : QPalette = ... # 0xa
    Shadow                   : QPalette = ... # 0xb
    Highlight                : QPalette = ... # 0xc
    HighlightedText          : QPalette = ... # 0xd
    Link                     : QPalette = ... # 0xe
    LinkVisited              : QPalette = ... # 0xf
    AlternateBase            : QPalette = ... # 0x10
    NoRole                   : QPalette = ... # 0x11
    ToolTipBase              : QPalette = ... # 0x12
    ToolTipText              : QPalette = ... # 0x13
    PlaceholderText          : QPalette = ... # 0x14
    NColorRoles              : QPalette = ... # 0x15

    class ColorGroup(object):
        Active                   : QPalette.ColorGroup = ... # 0x0
        Normal                   : QPalette.ColorGroup = ... # 0x0
        Disabled                 : QPalette.ColorGroup = ... # 0x1
        Inactive                 : QPalette.ColorGroup = ... # 0x2
        NColorGroups             : QPalette.ColorGroup = ... # 0x3
        Current                  : QPalette.ColorGroup = ... # 0x4
        All                      : QPalette.ColorGroup = ... # 0x5

    class ColorRole(object):
        Foreground               : QPalette.ColorRole = ... # 0x0
        WindowText               : QPalette.ColorRole = ... # 0x0
        Button                   : QPalette.ColorRole = ... # 0x1
        Light                    : QPalette.ColorRole = ... # 0x2
        Midlight                 : QPalette.ColorRole = ... # 0x3
        Dark                     : QPalette.ColorRole = ... # 0x4
        Mid                      : QPalette.ColorRole = ... # 0x5
        Text                     : QPalette.ColorRole = ... # 0x6
        BrightText               : QPalette.ColorRole = ... # 0x7
        ButtonText               : QPalette.ColorRole = ... # 0x8
        Base                     : QPalette.ColorRole = ... # 0x9
        Background               : QPalette.ColorRole = ... # 0xa
        Window                   : QPalette.ColorRole = ... # 0xa
        Shadow                   : QPalette.ColorRole = ... # 0xb
        Highlight                : QPalette.ColorRole = ... # 0xc
        HighlightedText          : QPalette.ColorRole = ... # 0xd
        Link                     : QPalette.ColorRole = ... # 0xe
        LinkVisited              : QPalette.ColorRole = ... # 0xf
        AlternateBase            : QPalette.ColorRole = ... # 0x10
        NoRole                   : QPalette.ColorRole = ... # 0x11
        ToolTipBase              : QPalette.ColorRole = ... # 0x12
        ToolTipText              : QPalette.ColorRole = ... # 0x13
        PlaceholderText          : QPalette.ColorRole = ... # 0x14
        NColorRoles              : QPalette.ColorRole = ... # 0x15

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, button:PySide2.QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, button:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, button:PySide2.QtGui.QColor, window:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, palette:PySide2.QtGui.QPalette) -> None: ...
    @typing.overload
    def __init__(self, windowText:PySide2.QtGui.QBrush, button:PySide2.QtGui.QBrush, light:PySide2.QtGui.QBrush, dark:PySide2.QtGui.QBrush, mid:PySide2.QtGui.QBrush, text:PySide2.QtGui.QBrush, bright_text:PySide2.QtGui.QBrush, base:PySide2.QtGui.QBrush, window:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def __init__(self, windowText:PySide2.QtGui.QColor, window:PySide2.QtGui.QColor, light:PySide2.QtGui.QColor, dark:PySide2.QtGui.QColor, mid:PySide2.QtGui.QColor, text:PySide2.QtGui.QColor, base:PySide2.QtGui.QColor) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, ds:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, ds:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def alternateBase(self) -> PySide2.QtGui.QBrush: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def base(self) -> PySide2.QtGui.QBrush: ...
    def brightText(self) -> PySide2.QtGui.QBrush: ...
    @typing.overload
    def brush(self, cg:PySide2.QtGui.QPalette.ColorGroup, cr:PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QBrush: ...
    @typing.overload
    def brush(self, cr:PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QBrush: ...
    def button(self) -> PySide2.QtGui.QBrush: ...
    def buttonText(self) -> PySide2.QtGui.QBrush: ...
    def cacheKey(self) -> int: ...
    @typing.overload
    def color(self, cg:PySide2.QtGui.QPalette.ColorGroup, cr:PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def color(self, cr:PySide2.QtGui.QPalette.ColorRole) -> PySide2.QtGui.QColor: ...
    def currentColorGroup(self) -> PySide2.QtGui.QPalette.ColorGroup: ...
    def dark(self) -> PySide2.QtGui.QBrush: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def highlight(self) -> PySide2.QtGui.QBrush: ...
    def highlightedText(self) -> PySide2.QtGui.QBrush: ...
    def isBrushSet(self, cg:PySide2.QtGui.QPalette.ColorGroup, cr:PySide2.QtGui.QPalette.ColorRole) -> bool: ...
    def isCopyOf(self, p:PySide2.QtGui.QPalette) -> bool: ...
    def isEqual(self, cr1:PySide2.QtGui.QPalette.ColorGroup, cr2:PySide2.QtGui.QPalette.ColorGroup) -> bool: ...
    def light(self) -> PySide2.QtGui.QBrush: ...
    def link(self) -> PySide2.QtGui.QBrush: ...
    def linkVisited(self) -> PySide2.QtGui.QBrush: ...
    def mid(self) -> PySide2.QtGui.QBrush: ...
    def midlight(self) -> PySide2.QtGui.QBrush: ...
    def placeholderText(self) -> PySide2.QtGui.QBrush: ...
    @typing.overload
    def resolve(self) -> int: ...
    @typing.overload
    def resolve(self, arg__1:PySide2.QtGui.QPalette) -> PySide2.QtGui.QPalette: ...
    @typing.overload
    def resolve(self, mask:int) -> None: ...
    @typing.overload
    def setBrush(self, cg:PySide2.QtGui.QPalette.ColorGroup, cr:PySide2.QtGui.QPalette.ColorRole, brush:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def setBrush(self, cr:PySide2.QtGui.QPalette.ColorRole, brush:PySide2.QtGui.QBrush) -> None: ...
    @typing.overload
    def setColor(self, cg:PySide2.QtGui.QPalette.ColorGroup, cr:PySide2.QtGui.QPalette.ColorRole, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setColor(self, cr:PySide2.QtGui.QPalette.ColorRole, color:PySide2.QtGui.QColor) -> None: ...
    def setColorGroup(self, cr:PySide2.QtGui.QPalette.ColorGroup, windowText:PySide2.QtGui.QBrush, button:PySide2.QtGui.QBrush, light:PySide2.QtGui.QBrush, dark:PySide2.QtGui.QBrush, mid:PySide2.QtGui.QBrush, text:PySide2.QtGui.QBrush, bright_text:PySide2.QtGui.QBrush, base:PySide2.QtGui.QBrush, window:PySide2.QtGui.QBrush) -> None: ...
    def setCurrentColorGroup(self, cg:PySide2.QtGui.QPalette.ColorGroup) -> None: ...
    def shadow(self) -> PySide2.QtGui.QBrush: ...
    def swap(self, other:PySide2.QtGui.QPalette) -> None: ...
    def text(self) -> PySide2.QtGui.QBrush: ...
    def toolTipBase(self) -> PySide2.QtGui.QBrush: ...
    def toolTipText(self) -> PySide2.QtGui.QBrush: ...
    def window(self) -> PySide2.QtGui.QBrush: ...
    def windowText(self) -> PySide2.QtGui.QBrush: ...


class QPdfWriter(PySide2.QtCore.QObject, PySide2.QtGui.QPagedPaintDevice):

    @typing.overload
    def __init__(self, device:PySide2.QtCore.QIODevice) -> None: ...
    @typing.overload
    def __init__(self, filename:str) -> None: ...

    def addFileAttachment(self, fileName:str, data:PySide2.QtCore.QByteArray, mimeType:str=...) -> None: ...
    def creator(self) -> str: ...
    def documentXmpMetadata(self) -> PySide2.QtCore.QByteArray: ...
    def metric(self, id:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def pdfVersion(self) -> PySide2.QtGui.QPagedPaintDevice.PdfVersion: ...
    def resolution(self) -> int: ...
    def setCreator(self, creator:str) -> None: ...
    def setDocumentXmpMetadata(self, xmpMetadata:PySide2.QtCore.QByteArray) -> None: ...
    def setMargins(self, m:PySide2.QtGui.QPagedPaintDevice.Margins) -> None: ...
    def setPageSize(self, size:PySide2.QtGui.QPagedPaintDevice.PageSize) -> None: ...
    def setPageSizeMM(self, size:PySide2.QtCore.QSizeF) -> None: ...
    def setPdfVersion(self, version:PySide2.QtGui.QPagedPaintDevice.PdfVersion) -> None: ...
    def setResolution(self, resolution:int) -> None: ...
    def setTitle(self, title:str) -> None: ...
    def title(self) -> str: ...


class QPen(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def __init__(self, brush:PySide2.QtGui.QBrush, width:float, s:PySide2.QtCore.Qt.PenStyle=..., c:PySide2.QtCore.Qt.PenCapStyle=..., j:PySide2.QtCore.Qt.PenJoinStyle=...) -> None: ...
    @typing.overload
    def __init__(self, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def __init__(self, pen:PySide2.QtGui.QPen) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def brush(self) -> PySide2.QtGui.QBrush: ...
    def capStyle(self) -> PySide2.QtCore.Qt.PenCapStyle: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def dashOffset(self) -> float: ...
    def dashPattern(self) -> typing.List: ...
    def isCosmetic(self) -> bool: ...
    def isSolid(self) -> bool: ...
    def joinStyle(self) -> PySide2.QtCore.Qt.PenJoinStyle: ...
    def miterLimit(self) -> float: ...
    def setBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setCapStyle(self, pcs:PySide2.QtCore.Qt.PenCapStyle) -> None: ...
    def setColor(self, color:PySide2.QtGui.QColor) -> None: ...
    def setCosmetic(self, cosmetic:bool) -> None: ...
    def setDashOffset(self, doffset:float) -> None: ...
    def setDashPattern(self, pattern:typing.List) -> None: ...
    def setJoinStyle(self, pcs:PySide2.QtCore.Qt.PenJoinStyle) -> None: ...
    def setMiterLimit(self, limit:float) -> None: ...
    def setStyle(self, arg__1:PySide2.QtCore.Qt.PenStyle) -> None: ...
    def setWidth(self, width:int) -> None: ...
    def setWidthF(self, width:float) -> None: ...
    def style(self) -> PySide2.QtCore.Qt.PenStyle: ...
    def swap(self, other:PySide2.QtGui.QPen) -> None: ...
    def width(self) -> int: ...
    def widthF(self) -> float: ...


class QPicture(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QPicture) -> None: ...
    @typing.overload
    def __init__(self, formatVersion:int=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def data(self) -> bytes: ...
    def devType(self) -> int: ...
    @staticmethod
    def inputFormatList() -> typing.List: ...
    @staticmethod
    def inputFormats() -> typing.List: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def load(self, dev:PySide2.QtCore.QIODevice, format:typing.Optional[bytes]=...) -> bool: ...
    @typing.overload
    def load(self, fileName:str, format:typing.Optional[bytes]=...) -> bool: ...
    def metric(self, m:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    @staticmethod
    def outputFormatList() -> typing.List: ...
    @staticmethod
    def outputFormats() -> typing.List: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    @staticmethod
    def pictureFormat(fileName:str) -> bytes: ...
    def play(self, p:PySide2.QtGui.QPainter) -> bool: ...
    @typing.overload
    def save(self, dev:PySide2.QtCore.QIODevice, format:typing.Optional[bytes]=...) -> bool: ...
    @typing.overload
    def save(self, fileName:str, format:typing.Optional[bytes]=...) -> bool: ...
    def setBoundingRect(self, r:PySide2.QtCore.QRect) -> None: ...
    def setData(self, data:bytes, size:int) -> None: ...
    def size(self) -> int: ...
    def swap(self, other:PySide2.QtGui.QPicture) -> None: ...


class QPictureIO(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:bytes) -> None: ...
    @typing.overload
    def __init__(self, ioDevice:PySide2.QtCore.QIODevice, format:bytes) -> None: ...

    def description(self) -> str: ...
    def fileName(self) -> str: ...
    def format(self) -> bytes: ...
    def gamma(self) -> float: ...
    @staticmethod
    def inputFormats() -> typing.List: ...
    def ioDevice(self) -> PySide2.QtCore.QIODevice: ...
    @staticmethod
    def outputFormats() -> typing.List: ...
    def parameters(self) -> bytes: ...
    def picture(self) -> PySide2.QtGui.QPicture: ...
    @typing.overload
    @staticmethod
    def pictureFormat(arg__1:PySide2.QtCore.QIODevice) -> PySide2.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def pictureFormat(fileName:str) -> PySide2.QtCore.QByteArray: ...
    def quality(self) -> int: ...
    def read(self) -> bool: ...
    def setDescription(self, arg__1:str) -> None: ...
    def setFileName(self, arg__1:str) -> None: ...
    def setFormat(self, arg__1:bytes) -> None: ...
    def setGamma(self, arg__1:float) -> None: ...
    def setIODevice(self, arg__1:PySide2.QtCore.QIODevice) -> None: ...
    def setParameters(self, arg__1:bytes) -> None: ...
    def setPicture(self, arg__1:PySide2.QtGui.QPicture) -> None: ...
    def setQuality(self, arg__1:int) -> None: ...
    def setStatus(self, arg__1:int) -> None: ...
    def status(self) -> int: ...
    def write(self) -> bool: ...


class QPixelFormat(Shiboken.Object):
    AtBeginning              : QPixelFormat = ... # 0x0
    LittleEndian             : QPixelFormat = ... # 0x0
    NotPremultiplied         : QPixelFormat = ... # 0x0
    RGB                      : QPixelFormat = ... # 0x0
    UnsignedInteger          : QPixelFormat = ... # 0x0
    UsesAlpha                : QPixelFormat = ... # 0x0
    YUV444                   : QPixelFormat = ... # 0x0
    AtEnd                    : QPixelFormat = ... # 0x1
    BGR                      : QPixelFormat = ... # 0x1
    BigEndian                : QPixelFormat = ... # 0x1
    IgnoresAlpha             : QPixelFormat = ... # 0x1
    Premultiplied            : QPixelFormat = ... # 0x1
    UnsignedShort            : QPixelFormat = ... # 0x1
    YUV422                   : QPixelFormat = ... # 0x1
    CurrentSystemEndian      : QPixelFormat = ... # 0x2
    Indexed                  : QPixelFormat = ... # 0x2
    UnsignedByte             : QPixelFormat = ... # 0x2
    YUV411                   : QPixelFormat = ... # 0x2
    FloatingPoint            : QPixelFormat = ... # 0x3
    Grayscale                : QPixelFormat = ... # 0x3
    YUV420P                  : QPixelFormat = ... # 0x3
    CMYK                     : QPixelFormat = ... # 0x4
    YUV420SP                 : QPixelFormat = ... # 0x4
    HSL                      : QPixelFormat = ... # 0x5
    YV12                     : QPixelFormat = ... # 0x5
    HSV                      : QPixelFormat = ... # 0x6
    UYVY                     : QPixelFormat = ... # 0x6
    YUV                      : QPixelFormat = ... # 0x7
    YUYV                     : QPixelFormat = ... # 0x7
    Alpha                    : QPixelFormat = ... # 0x8
    NV12                     : QPixelFormat = ... # 0x8
    NV21                     : QPixelFormat = ... # 0x9
    IMC1                     : QPixelFormat = ... # 0xa
    IMC2                     : QPixelFormat = ... # 0xb
    IMC3                     : QPixelFormat = ... # 0xc
    IMC4                     : QPixelFormat = ... # 0xd
    Y8                       : QPixelFormat = ... # 0xe
    Y16                      : QPixelFormat = ... # 0xf

    class AlphaPosition(object):
        AtBeginning              : QPixelFormat.AlphaPosition = ... # 0x0
        AtEnd                    : QPixelFormat.AlphaPosition = ... # 0x1

    class AlphaPremultiplied(object):
        NotPremultiplied         : QPixelFormat.AlphaPremultiplied = ... # 0x0
        Premultiplied            : QPixelFormat.AlphaPremultiplied = ... # 0x1

    class AlphaUsage(object):
        UsesAlpha                : QPixelFormat.AlphaUsage = ... # 0x0
        IgnoresAlpha             : QPixelFormat.AlphaUsage = ... # 0x1

    class ByteOrder(object):
        LittleEndian             : QPixelFormat.ByteOrder = ... # 0x0
        BigEndian                : QPixelFormat.ByteOrder = ... # 0x1
        CurrentSystemEndian      : QPixelFormat.ByteOrder = ... # 0x2

    class ColorModel(object):
        RGB                      : QPixelFormat.ColorModel = ... # 0x0
        BGR                      : QPixelFormat.ColorModel = ... # 0x1
        Indexed                  : QPixelFormat.ColorModel = ... # 0x2
        Grayscale                : QPixelFormat.ColorModel = ... # 0x3
        CMYK                     : QPixelFormat.ColorModel = ... # 0x4
        HSL                      : QPixelFormat.ColorModel = ... # 0x5
        HSV                      : QPixelFormat.ColorModel = ... # 0x6
        YUV                      : QPixelFormat.ColorModel = ... # 0x7
        Alpha                    : QPixelFormat.ColorModel = ... # 0x8

    class TypeInterpretation(object):
        UnsignedInteger          : QPixelFormat.TypeInterpretation = ... # 0x0
        UnsignedShort            : QPixelFormat.TypeInterpretation = ... # 0x1
        UnsignedByte             : QPixelFormat.TypeInterpretation = ... # 0x2
        FloatingPoint            : QPixelFormat.TypeInterpretation = ... # 0x3

    class YUVLayout(object):
        YUV444                   : QPixelFormat.YUVLayout = ... # 0x0
        YUV422                   : QPixelFormat.YUVLayout = ... # 0x1
        YUV411                   : QPixelFormat.YUVLayout = ... # 0x2
        YUV420P                  : QPixelFormat.YUVLayout = ... # 0x3
        YUV420SP                 : QPixelFormat.YUVLayout = ... # 0x4
        YV12                     : QPixelFormat.YUVLayout = ... # 0x5
        UYVY                     : QPixelFormat.YUVLayout = ... # 0x6
        YUYV                     : QPixelFormat.YUVLayout = ... # 0x7
        NV12                     : QPixelFormat.YUVLayout = ... # 0x8
        NV21                     : QPixelFormat.YUVLayout = ... # 0x9
        IMC1                     : QPixelFormat.YUVLayout = ... # 0xa
        IMC2                     : QPixelFormat.YUVLayout = ... # 0xb
        IMC3                     : QPixelFormat.YUVLayout = ... # 0xc
        IMC4                     : QPixelFormat.YUVLayout = ... # 0xd
        Y8                       : QPixelFormat.YUVLayout = ... # 0xe
        Y16                      : QPixelFormat.YUVLayout = ... # 0xf

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPixelFormat:PySide2.QtGui.QPixelFormat) -> None: ...
    @typing.overload
    def __init__(self, colorModel:PySide2.QtGui.QPixelFormat.ColorModel, firstSize:int, secondSize:int, thirdSize:int, fourthSize:int, fifthSize:int, alphaSize:int, alphaUsage:PySide2.QtGui.QPixelFormat.AlphaUsage, alphaPosition:PySide2.QtGui.QPixelFormat.AlphaPosition, premultiplied:PySide2.QtGui.QPixelFormat.AlphaPremultiplied, typeInterpretation:PySide2.QtGui.QPixelFormat.TypeInterpretation, byteOrder:PySide2.QtGui.QPixelFormat.ByteOrder=..., subEnum:int=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alphaPosition(self) -> PySide2.QtGui.QPixelFormat.AlphaPosition: ...
    def alphaSize(self) -> int: ...
    def alphaUsage(self) -> PySide2.QtGui.QPixelFormat.AlphaUsage: ...
    def bitsPerPixel(self) -> int: ...
    def blackSize(self) -> int: ...
    def blueSize(self) -> int: ...
    def brightnessSize(self) -> int: ...
    def byteOrder(self) -> PySide2.QtGui.QPixelFormat.ByteOrder: ...
    def channelCount(self) -> int: ...
    def colorModel(self) -> PySide2.QtGui.QPixelFormat.ColorModel: ...
    def cyanSize(self) -> int: ...
    def greenSize(self) -> int: ...
    def hueSize(self) -> int: ...
    def lightnessSize(self) -> int: ...
    def magentaSize(self) -> int: ...
    def premultiplied(self) -> PySide2.QtGui.QPixelFormat.AlphaPremultiplied: ...
    def redSize(self) -> int: ...
    def saturationSize(self) -> int: ...
    def subEnum(self) -> int: ...
    def typeInterpretation(self) -> PySide2.QtGui.QPixelFormat.TypeInterpretation: ...
    def yellowSize(self) -> int: ...
    def yuvLayout(self) -> PySide2.QtGui.QPixelFormat.YUVLayout: ...


class QPixmap(PySide2.QtGui.QPaintDevice):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QPixmap) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:typing.Optional[bytes]=..., flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> None: ...
    @typing.overload
    def __init__(self, image:PySide2.QtGui.QImage) -> None: ...
    @typing.overload
    def __init__(self, w:int, h:int) -> None: ...
    @typing.overload
    def __init__(self, xpm:typing.Sequence) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def cacheKey(self) -> int: ...
    def convertFromImage(self, img:PySide2.QtGui.QImage, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> bool: ...
    @typing.overload
    def copy(self, rect:PySide2.QtCore.QRect=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def copy(self, x:int, y:int, width:int, height:int) -> PySide2.QtGui.QPixmap: ...
    def createHeuristicMask(self, clipTight:bool=...) -> PySide2.QtGui.QBitmap: ...
    def createMaskFromColor(self, maskColor:PySide2.QtGui.QColor, mode:PySide2.QtCore.Qt.MaskMode=...) -> PySide2.QtGui.QBitmap: ...
    @staticmethod
    def defaultDepth() -> int: ...
    def depth(self) -> int: ...
    def devType(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    @typing.overload
    def fill(self, device:PySide2.QtGui.QPaintDevice, ofs:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def fill(self, device:PySide2.QtGui.QPaintDevice, xofs:int, yofs:int) -> None: ...
    @typing.overload
    def fill(self, fillColor:PySide2.QtGui.QColor=...) -> None: ...
    @staticmethod
    def fromImage(image:PySide2.QtGui.QImage, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def fromImageInPlace(image:PySide2.QtGui.QImage, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def fromImageReader(imageReader:PySide2.QtGui.QImageReader, flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def grabWidget(widget:PySide2.QtCore.QObject, rect:PySide2.QtCore.QRect) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def grabWidget(widget:PySide2.QtCore.QObject, x:int=..., y:int=..., w:int=..., h:int=...) -> PySide2.QtGui.QPixmap: ...
    @staticmethod
    def grabWindow(arg__1:int, x:int=..., y:int=..., w:int=..., h:int=...) -> PySide2.QtGui.QPixmap: ...
    def hasAlpha(self) -> bool: ...
    def hasAlphaChannel(self) -> bool: ...
    def height(self) -> int: ...
    def isNull(self) -> bool: ...
    def isQBitmap(self) -> bool: ...
    def load(self, fileName:str, format:typing.Optional[bytes]=..., flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> bool: ...
    @typing.overload
    def loadFromData(self, buf:bytes, len:int, format:typing.Optional[bytes]=..., flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> bool: ...
    @typing.overload
    def loadFromData(self, data:PySide2.QtCore.QByteArray, format:typing.Optional[bytes]=..., flags:PySide2.QtCore.Qt.ImageConversionFlags=...) -> bool: ...
    def mask(self) -> PySide2.QtGui.QBitmap: ...
    def metric(self, arg__1:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def save(self, device:PySide2.QtCore.QIODevice, format:typing.Optional[bytes]=..., quality:int=...) -> bool: ...
    @typing.overload
    def save(self, fileName:str, format:typing.Optional[bytes]=..., quality:int=...) -> bool: ...
    @typing.overload
    def scaled(self, s:PySide2.QtCore.QSize, aspectMode:PySide2.QtCore.Qt.AspectRatioMode=..., mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def scaled(self, w:int, h:int, aspectMode:PySide2.QtCore.Qt.AspectRatioMode=..., mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QPixmap: ...
    def scaledToHeight(self, h:int, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QPixmap: ...
    def scaledToWidth(self, w:int, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def scroll(self, dx:int, dy:int, rect:PySide2.QtCore.QRect, exposed:typing.Optional[PySide2.QtGui.QRegion]=...) -> None: ...
    @typing.overload
    def scroll(self, dx:int, dy:int, x:int, y:int, width:int, height:int, exposed:typing.Optional[PySide2.QtGui.QRegion]=...) -> None: ...
    def setDevicePixelRatio(self, scaleFactor:float) -> None: ...
    def setMask(self, arg__1:PySide2.QtGui.QBitmap) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def swap(self, other:PySide2.QtGui.QPixmap) -> None: ...
    def toImage(self) -> PySide2.QtGui.QImage: ...
    @typing.overload
    def transformed(self, arg__1:PySide2.QtGui.QMatrix, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def transformed(self, arg__1:PySide2.QtGui.QTransform, mode:PySide2.QtCore.Qt.TransformationMode=...) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def trueMatrix(m:PySide2.QtGui.QMatrix, w:int, h:int) -> PySide2.QtGui.QMatrix: ...
    @typing.overload
    @staticmethod
    def trueMatrix(m:PySide2.QtGui.QTransform, w:int, h:int) -> PySide2.QtGui.QTransform: ...
    def width(self) -> int: ...


class QPixmapCache(Shiboken.Object):

    class Key(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other:PySide2.QtGui.QPixmapCache.Key) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def isValid(self) -> bool: ...
        def swap(self, other:PySide2.QtGui.QPixmapCache.Key) -> None: ...

    def __init__(self) -> None: ...

    @staticmethod
    def cacheLimit() -> int: ...
    @staticmethod
    def clear() -> None: ...
    @typing.overload
    @staticmethod
    def find(key:PySide2.QtGui.QPixmapCache.Key, pixmap:PySide2.QtGui.QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def find(key:str) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def find(key:str, pixmap:PySide2.QtGui.QPixmap) -> bool: ...
    @typing.overload
    def find(self, arg__1:PySide2.QtGui.QPixmapCache.Key) -> None: ...
    @typing.overload
    @staticmethod
    def insert(key:str, pixmap:PySide2.QtGui.QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def insert(pixmap:PySide2.QtGui.QPixmap) -> PySide2.QtGui.QPixmapCache.Key: ...
    @typing.overload
    @staticmethod
    def remove(key:PySide2.QtGui.QPixmapCache.Key) -> None: ...
    @typing.overload
    @staticmethod
    def remove(key:str) -> None: ...
    @staticmethod
    def replace(key:PySide2.QtGui.QPixmapCache.Key, pixmap:PySide2.QtGui.QPixmap) -> bool: ...
    @staticmethod
    def setCacheLimit(arg__1:int) -> None: ...


class QPointingDeviceUniqueId(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QPointingDeviceUniqueId:PySide2.QtGui.QPointingDeviceUniqueId) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromNumericId(id:int) -> PySide2.QtGui.QPointingDeviceUniqueId: ...
    def isValid(self) -> bool: ...
    def numericId(self) -> int: ...


class QPolygon(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QPolygon) -> None: ...
    @typing.overload
    def __init__(self, r:PySide2.QtCore.QRect, closed:bool=...) -> None: ...
    @typing.overload
    def __init__(self, size:int) -> None: ...
    @typing.overload
    def __init__(self, v:typing.List) -> None: ...

    def __add__(self, l:typing.List) -> typing.List: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, t:PySide2.QtCore.QPoint) -> typing.List: ...
    @typing.overload
    def __lshift__(self, l:typing.List) -> typing.List: ...
    @typing.overload
    def __lshift__(self, stream:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, t:PySide2.QtCore.QPoint) -> typing.List: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QTransform) -> PySide2.QtGui.QPolygon: ...
    def __reduce__(self) -> object: ...
    def __rshift__(self, stream:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def append(self, l:typing.List) -> None: ...
    @typing.overload
    def append(self, t:PySide2.QtCore.QPoint) -> None: ...
    def at(self, i:int) -> PySide2.QtCore.QPoint: ...
    def back(self) -> PySide2.QtCore.QPoint: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide2.QtCore.QPoint: ...
    def constFirst(self) -> PySide2.QtCore.QPoint: ...
    def constLast(self) -> PySide2.QtCore.QPoint: ...
    def contains(self, t:PySide2.QtCore.QPoint) -> bool: ...
    def containsPoint(self, pt:PySide2.QtCore.QPoint, fillRule:PySide2.QtCore.Qt.FillRule) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, t:PySide2.QtCore.QPoint) -> int: ...
    def data(self) -> PySide2.QtCore.QPoint: ...
    def empty(self) -> bool: ...
    def endsWith(self, t:PySide2.QtCore.QPoint) -> bool: ...
    def fill(self, t:PySide2.QtCore.QPoint, size:int=...) -> typing.List: ...
    def first(self) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def fromList(list:typing.Sequence) -> typing.List: ...
    def front(self) -> PySide2.QtCore.QPoint: ...
    def indexOf(self, t:PySide2.QtCore.QPoint, from_:int=...) -> int: ...
    @typing.overload
    def insert(self, i:int, n:int, t:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def insert(self, i:int, t:PySide2.QtCore.QPoint) -> None: ...
    def intersected(self, r:PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    def intersects(self, r:PySide2.QtGui.QPolygon) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other:typing.List) -> bool: ...
    def last(self) -> PySide2.QtCore.QPoint: ...
    def lastIndexOf(self, t:PySide2.QtCore.QPoint, from_:int=...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos:int, len:int=...) -> typing.List: ...
    def move(self, from_:int, to:int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, t:PySide2.QtCore.QPoint) -> None: ...
    def push_back(self, t:PySide2.QtCore.QPoint) -> None: ...
    def push_front(self, t:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def remove(self, i:int) -> None: ...
    @typing.overload
    def remove(self, i:int, n:int) -> None: ...
    def removeAll(self, t:PySide2.QtCore.QPoint) -> int: ...
    def removeAt(self, i:int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, t:PySide2.QtCore.QPoint) -> bool: ...
    def replace(self, i:int, t:PySide2.QtCore.QPoint) -> None: ...
    def reserve(self, size:int) -> None: ...
    def resize(self, size:int) -> None: ...
    def setSharable(self, sharable:bool) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    def squeeze(self) -> None: ...
    def startsWith(self, t:PySide2.QtCore.QPoint) -> bool: ...
    def subtracted(self, r:PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    def swap(self, other:PySide2.QtGui.QPolygon) -> None: ...
    def swapItemsAt(self, i:int, j:int) -> None: ...
    def takeAt(self, i:int) -> PySide2.QtCore.QPoint: ...
    def takeFirst(self) -> PySide2.QtCore.QPoint: ...
    def takeLast(self) -> PySide2.QtCore.QPoint: ...
    def toList(self) -> typing.List: ...
    @typing.overload
    def translate(self, dx:int, dy:int) -> None: ...
    @typing.overload
    def translate(self, offset:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def translated(self, dx:int, dy:int) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def translated(self, offset:PySide2.QtCore.QPoint) -> PySide2.QtGui.QPolygon: ...
    def united(self, r:PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def value(self, i:int) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def value(self, i:int, defaultValue:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...


class QPolygonF(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a:PySide2.QtGui.QPolygon) -> None: ...
    @typing.overload
    def __init__(self, a:PySide2.QtGui.QPolygonF) -> None: ...
    @typing.overload
    def __init__(self, r:PySide2.QtCore.QRectF) -> None: ...
    @typing.overload
    def __init__(self, size:int) -> None: ...
    @typing.overload
    def __init__(self, v:typing.List) -> None: ...

    def __add__(self, l:typing.List) -> typing.List: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, t:PySide2.QtCore.QPointF) -> typing.List: ...
    def __lshift__(self, stream:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QTransform) -> PySide2.QtGui.QPolygonF: ...
    def __rshift__(self, stream:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def append(self, l:typing.List) -> None: ...
    @typing.overload
    def append(self, t:PySide2.QtCore.QPointF) -> None: ...
    def at(self, i:int) -> PySide2.QtCore.QPointF: ...
    def back(self) -> PySide2.QtCore.QPointF: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> PySide2.QtCore.QPointF: ...
    def constFirst(self) -> PySide2.QtCore.QPointF: ...
    def constLast(self) -> PySide2.QtCore.QPointF: ...
    def contains(self, t:PySide2.QtCore.QPointF) -> bool: ...
    def containsPoint(self, pt:PySide2.QtCore.QPointF, fillRule:PySide2.QtCore.Qt.FillRule) -> bool: ...
    @typing.overload
    def count(self) -> int: ...
    @typing.overload
    def count(self, t:PySide2.QtCore.QPointF) -> int: ...
    def data(self) -> PySide2.QtCore.QPointF: ...
    def empty(self) -> bool: ...
    def endsWith(self, t:PySide2.QtCore.QPointF) -> bool: ...
    def fill(self, t:PySide2.QtCore.QPointF, size:int=...) -> typing.List: ...
    def first(self) -> PySide2.QtCore.QPointF: ...
    @staticmethod
    def fromList(list:typing.Sequence) -> typing.List: ...
    def front(self) -> PySide2.QtCore.QPointF: ...
    def indexOf(self, t:PySide2.QtCore.QPointF, from_:int=...) -> int: ...
    @typing.overload
    def insert(self, i:int, n:int, t:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def insert(self, i:int, t:PySide2.QtCore.QPointF) -> None: ...
    def intersected(self, r:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    def intersects(self, r:PySide2.QtGui.QPolygonF) -> bool: ...
    def isClosed(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other:typing.List) -> bool: ...
    def last(self) -> PySide2.QtCore.QPointF: ...
    def lastIndexOf(self, t:PySide2.QtCore.QPointF, from_:int=...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos:int, len:int=...) -> typing.List: ...
    def move(self, from_:int, to:int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, t:PySide2.QtCore.QPointF) -> None: ...
    def push_back(self, t:PySide2.QtCore.QPointF) -> None: ...
    def push_front(self, t:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def remove(self, i:int) -> None: ...
    @typing.overload
    def remove(self, i:int, n:int) -> None: ...
    def removeAll(self, t:PySide2.QtCore.QPointF) -> int: ...
    def removeAt(self, i:int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, t:PySide2.QtCore.QPointF) -> bool: ...
    def replace(self, i:int, t:PySide2.QtCore.QPointF) -> None: ...
    def reserve(self, size:int) -> None: ...
    def resize(self, size:int) -> None: ...
    def setSharable(self, sharable:bool) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    def squeeze(self) -> None: ...
    def startsWith(self, t:PySide2.QtCore.QPointF) -> bool: ...
    def subtracted(self, r:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    def swap(self, other:PySide2.QtGui.QPolygonF) -> None: ...
    def swapItemsAt(self, i:int, j:int) -> None: ...
    def takeAt(self, i:int) -> PySide2.QtCore.QPointF: ...
    def takeFirst(self) -> PySide2.QtCore.QPointF: ...
    def takeLast(self) -> PySide2.QtCore.QPointF: ...
    def toList(self) -> typing.List: ...
    def toPolygon(self) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def translate(self, dx:float, dy:float) -> None: ...
    @typing.overload
    def translate(self, offset:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def translated(self, dx:float, dy:float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def translated(self, offset:PySide2.QtCore.QPointF) -> PySide2.QtGui.QPolygonF: ...
    def united(self, r:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def value(self, i:int) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def value(self, i:int, defaultValue:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...


class QPyTextObject(PySide2.QtCore.QObject, PySide2.QtGui.QTextObjectInterface):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def drawObject(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF, doc:PySide2.QtGui.QTextDocument, posInDocument:int, format:PySide2.QtGui.QTextFormat) -> None: ...
    def intrinsicSize(self, doc:PySide2.QtGui.QTextDocument, posInDocument:int, format:PySide2.QtGui.QTextFormat) -> PySide2.QtCore.QSizeF: ...


class QQuaternion(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, scalar:float, vector:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, scalar:float, xpos:float, ypos:float, zpos:float) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector4D) -> None: ...

    def __add__(self, q2:PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, quaternion:PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    def __imul__(self, factor:float) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    def __imul__(self, quaternion:PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def __isub__(self, quaternion:PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    def __mul__(self, q2:PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def __neg__(self) -> PySide2.QtGui.QQuaternion: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, q2:PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QQuaternion: ...
    def conjugate(self) -> PySide2.QtGui.QQuaternion: ...
    def conjugated(self) -> PySide2.QtGui.QQuaternion: ...
    @staticmethod
    def dotProduct(q1:PySide2.QtGui.QQuaternion, q2:PySide2.QtGui.QQuaternion) -> float: ...
    @staticmethod
    def fromAxes(xAxis:PySide2.QtGui.QVector3D, yAxis:PySide2.QtGui.QVector3D, zAxis:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(axis:PySide2.QtGui.QVector3D, angle:float) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(x:float, y:float, z:float, angle:float) -> PySide2.QtGui.QQuaternion: ...
    @staticmethod
    def fromDirection(direction:PySide2.QtGui.QVector3D, up:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(eulerAngles:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    @typing.overload
    @staticmethod
    def fromEulerAngles(pitch:float, yaw:float, roll:float) -> PySide2.QtGui.QQuaternion: ...
    @staticmethod
    def fromRotationMatrix(rot3x3:PySide2.QtGui.QMatrix3x3) -> PySide2.QtGui.QQuaternion: ...
    def getAxes(self, xAxis:PySide2.QtGui.QVector3D, yAxis:PySide2.QtGui.QVector3D, zAxis:PySide2.QtGui.QVector3D) -> None: ...
    def inverted(self) -> PySide2.QtGui.QQuaternion: ...
    def isIdentity(self) -> bool: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @staticmethod
    def nlerp(q1:PySide2.QtGui.QQuaternion, q2:PySide2.QtGui.QQuaternion, t:float) -> PySide2.QtGui.QQuaternion: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide2.QtGui.QQuaternion: ...
    def rotatedVector(self, vector:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @staticmethod
    def rotationTo(from_:PySide2.QtGui.QVector3D, to:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
    def scalar(self) -> float: ...
    def setScalar(self, scalar:float) -> None: ...
    @typing.overload
    def setVector(self, vector:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def setVector(self, x:float, y:float, z:float) -> None: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def setZ(self, z:float) -> None: ...
    @staticmethod
    def slerp(q1:PySide2.QtGui.QQuaternion, q2:PySide2.QtGui.QQuaternion, t:float) -> PySide2.QtGui.QQuaternion: ...
    def toEulerAngles(self) -> PySide2.QtGui.QVector3D: ...
    def toRotationMatrix(self) -> PySide2.QtGui.QMatrix3x3: ...
    def toVector4D(self) -> PySide2.QtGui.QVector4D: ...
    def vector(self) -> PySide2.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QRadialGradient(PySide2.QtGui.QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QRadialGradient:PySide2.QtGui.QRadialGradient) -> None: ...
    @typing.overload
    def __init__(self, center:PySide2.QtCore.QPointF, centerRadius:float, focalPoint:PySide2.QtCore.QPointF, focalRadius:float) -> None: ...
    @typing.overload
    def __init__(self, center:PySide2.QtCore.QPointF, radius:float) -> None: ...
    @typing.overload
    def __init__(self, center:PySide2.QtCore.QPointF, radius:float, focalPoint:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, cx:float, cy:float, centerRadius:float, fx:float, fy:float, focalRadius:float) -> None: ...
    @typing.overload
    def __init__(self, cx:float, cy:float, radius:float) -> None: ...
    @typing.overload
    def __init__(self, cx:float, cy:float, radius:float, fx:float, fy:float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def center(self) -> PySide2.QtCore.QPointF: ...
    def centerRadius(self) -> float: ...
    def focalPoint(self) -> PySide2.QtCore.QPointF: ...
    def focalRadius(self) -> float: ...
    def radius(self) -> float: ...
    @typing.overload
    def setCenter(self, center:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setCenter(self, x:float, y:float) -> None: ...
    def setCenterRadius(self, radius:float) -> None: ...
    @typing.overload
    def setFocalPoint(self, focalPoint:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def setFocalPoint(self, x:float, y:float) -> None: ...
    def setFocalRadius(self, radius:float) -> None: ...
    def setRadius(self, radius:float) -> None: ...


class QRasterWindow(PySide2.QtGui.QPaintDeviceWindow):

    def __init__(self, parent:typing.Optional[PySide2.QtGui.QWindow]=...) -> None: ...

    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def redirected(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...


class QRawFont(Shiboken.Object):
    PixelAntialiasing        : QRawFont = ... # 0x0
    SeparateAdvances         : QRawFont = ... # 0x0
    KernedAdvances           : QRawFont = ... # 0x1
    SubPixelAntialiasing     : QRawFont = ... # 0x1
    UseDesignMetrics         : QRawFont = ... # 0x2

    class AntialiasingType(object):
        PixelAntialiasing        : QRawFont.AntialiasingType = ... # 0x0
        SubPixelAntialiasing     : QRawFont.AntialiasingType = ... # 0x1

    class LayoutFlag(object):
        SeparateAdvances         : QRawFont.LayoutFlag = ... # 0x0
        KernedAdvances           : QRawFont.LayoutFlag = ... # 0x1
        UseDesignMetrics         : QRawFont.LayoutFlag = ... # 0x2

    class LayoutFlags(object): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, pixelSize:float, hintingPreference:PySide2.QtGui.QFont.HintingPreference=...) -> None: ...
    @typing.overload
    def __init__(self, fontData:PySide2.QtCore.QByteArray, pixelSize:float, hintingPreference:PySide2.QtGui.QFont.HintingPreference=...) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QRawFont) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def advancesForGlyphIndexes(self, glyphIndexes:typing.List) -> typing.List: ...
    @typing.overload
    def advancesForGlyphIndexes(self, glyphIndexes:typing.List, layoutFlags:PySide2.QtGui.QRawFont.LayoutFlags) -> typing.List: ...
    def alphaMapForGlyph(self, glyphIndex:int, antialiasingType:PySide2.QtGui.QRawFont.AntialiasingType=..., transform:PySide2.QtGui.QTransform=...) -> PySide2.QtGui.QImage: ...
    def ascent(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    def boundingRect(self, glyphIndex:int) -> PySide2.QtCore.QRectF: ...
    def capHeight(self) -> float: ...
    def descent(self) -> float: ...
    def familyName(self) -> str: ...
    def fontTable(self, tagName:bytes) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def fromFont(font:PySide2.QtGui.QFont, writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem=...) -> PySide2.QtGui.QRawFont: ...
    def glyphIndexesForString(self, text:str) -> typing.List: ...
    def hintingPreference(self) -> PySide2.QtGui.QFont.HintingPreference: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def lineThickness(self) -> float: ...
    def loadFromData(self, fontData:PySide2.QtCore.QByteArray, pixelSize:float, hintingPreference:PySide2.QtGui.QFont.HintingPreference) -> None: ...
    def loadFromFile(self, fileName:str, pixelSize:float, hintingPreference:PySide2.QtGui.QFont.HintingPreference) -> None: ...
    def maxCharWidth(self) -> float: ...
    def pathForGlyph(self, glyphIndex:int) -> PySide2.QtGui.QPainterPath: ...
    def pixelSize(self) -> float: ...
    def setPixelSize(self, pixelSize:float) -> None: ...
    def style(self) -> PySide2.QtGui.QFont.Style: ...
    def styleName(self) -> str: ...
    def supportedWritingSystems(self) -> typing.List: ...
    @typing.overload
    def supportsCharacter(self, character:str) -> bool: ...
    @typing.overload
    def supportsCharacter(self, ucs4:int) -> bool: ...
    def swap(self, other:PySide2.QtGui.QRawFont) -> None: ...
    def underlinePosition(self) -> float: ...
    def unitsPerEm(self) -> float: ...
    def weight(self) -> int: ...
    def xHeight(self) -> float: ...


class QRegExpValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, rx:PySide2.QtCore.QRegExp, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def regExp(self) -> PySide2.QtCore.QRegExp: ...
    def setRegExp(self, rx:PySide2.QtCore.QRegExp) -> None: ...
    def validate(self, input:str, pos:int) -> PySide2.QtGui.QValidator.State: ...


class QRegion(Shiboken.Object):
    Rectangle                : QRegion = ... # 0x0
    Ellipse                  : QRegion = ... # 0x1

    class RegionType(object):
        Rectangle                : QRegion.RegionType = ... # 0x0
        Ellipse                  : QRegion.RegionType = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bitmap:PySide2.QtGui.QBitmap) -> None: ...
    @typing.overload
    def __init__(self, pa:PySide2.QtGui.QPolygon, fillRule:PySide2.QtCore.Qt.FillRule=...) -> None: ...
    @typing.overload
    def __init__(self, r:PySide2.QtCore.QRect, t:PySide2.QtGui.QRegion.RegionType=...) -> None: ...
    @typing.overload
    def __init__(self, region:PySide2.QtGui.QRegion) -> None: ...
    @typing.overload
    def __init__(self, x:int, y:int, w:int, h:int, t:PySide2.QtGui.QRegion.RegionType=...) -> None: ...

    @typing.overload
    def __add__(self, r:PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __add__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __and__(self, r:PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __and__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def __iadd__(self, r:PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __iadd__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __ior__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __isub__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __ixor__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QMatrix) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def __mul__(self, m:PySide2.QtGui.QTransform) -> PySide2.QtGui.QRegion: ...
    def __or__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def __xor__(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def begin(self) -> PySide2.QtCore.QRect: ...
    def boundingRect(self) -> PySide2.QtCore.QRect: ...
    def cbegin(self) -> PySide2.QtCore.QRect: ...
    def cend(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def contains(self, p:PySide2.QtCore.QPoint) -> bool: ...
    @typing.overload
    def contains(self, r:PySide2.QtCore.QRect) -> bool: ...
    def end(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def intersected(self, r:PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def intersected(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def intersects(self, r:PySide2.QtCore.QRect) -> bool: ...
    @typing.overload
    def intersects(self, r:PySide2.QtGui.QRegion) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def rectCount(self) -> int: ...
    def rects(self) -> typing.List: ...
    def setRects(self, rect:PySide2.QtCore.QRect, num:int) -> None: ...
    def subtracted(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def swap(self, other:PySide2.QtGui.QRegion) -> None: ...
    @typing.overload
    def translate(self, dx:int, dy:int) -> None: ...
    @typing.overload
    def translate(self, p:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def translated(self, dx:int, dy:int) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def translated(self, p:PySide2.QtCore.QPoint) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def united(self, r:PySide2.QtCore.QRect) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def united(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    def xored(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...


class QRegularExpressionValidator(PySide2.QtGui.QValidator):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, re:PySide2.QtCore.QRegularExpression, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def regularExpression(self) -> PySide2.QtCore.QRegularExpression: ...
    def setRegularExpression(self, re:PySide2.QtCore.QRegularExpression) -> None: ...
    def validate(self, input:str, pos:int) -> PySide2.QtGui.QValidator.State: ...


class QResizeEvent(PySide2.QtCore.QEvent):

    def __init__(self, size:PySide2.QtCore.QSize, oldSize:PySide2.QtCore.QSize) -> None: ...

    def oldSize(self) -> PySide2.QtCore.QSize: ...
    def size(self) -> PySide2.QtCore.QSize: ...


class QScreen(PySide2.QtCore.QObject):
    def angleBetween(self, a:PySide2.QtCore.Qt.ScreenOrientation, b:PySide2.QtCore.Qt.ScreenOrientation) -> int: ...
    def availableGeometry(self) -> PySide2.QtCore.QRect: ...
    def availableSize(self) -> PySide2.QtCore.QSize: ...
    def availableVirtualGeometry(self) -> PySide2.QtCore.QRect: ...
    def availableVirtualSize(self) -> PySide2.QtCore.QSize: ...
    def depth(self) -> int: ...
    def devicePixelRatio(self) -> float: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def grabWindow(self, window:int, x:int=..., y:int=..., w:int=..., h:int=...) -> PySide2.QtGui.QPixmap: ...
    def isLandscape(self, orientation:PySide2.QtCore.Qt.ScreenOrientation) -> bool: ...
    def isPortrait(self, orientation:PySide2.QtCore.Qt.ScreenOrientation) -> bool: ...
    def logicalDotsPerInch(self) -> float: ...
    def logicalDotsPerInchX(self) -> float: ...
    def logicalDotsPerInchY(self) -> float: ...
    def manufacturer(self) -> str: ...
    def mapBetween(self, a:PySide2.QtCore.Qt.ScreenOrientation, b:PySide2.QtCore.Qt.ScreenOrientation, rect:PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def model(self) -> str: ...
    def name(self) -> str: ...
    def nativeOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def orientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def orientationUpdateMask(self) -> PySide2.QtCore.Qt.ScreenOrientations: ...
    def physicalDotsPerInch(self) -> float: ...
    def physicalDotsPerInchX(self) -> float: ...
    def physicalDotsPerInchY(self) -> float: ...
    def physicalSize(self) -> PySide2.QtCore.QSizeF: ...
    def primaryOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def refreshRate(self) -> float: ...
    def serialNumber(self) -> str: ...
    def setOrientationUpdateMask(self, mask:PySide2.QtCore.Qt.ScreenOrientations) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def transformBetween(self, a:PySide2.QtCore.Qt.ScreenOrientation, b:PySide2.QtCore.Qt.ScreenOrientation, target:PySide2.QtCore.QRect) -> PySide2.QtGui.QTransform: ...
    def virtualGeometry(self) -> PySide2.QtCore.QRect: ...
    def virtualSiblingAt(self, point:PySide2.QtCore.QPoint) -> PySide2.QtGui.QScreen: ...
    def virtualSiblings(self) -> typing.List: ...
    def virtualSize(self) -> PySide2.QtCore.QSize: ...


class QScrollEvent(PySide2.QtCore.QEvent):
    ScrollStarted            : QScrollEvent = ... # 0x0
    ScrollUpdated            : QScrollEvent = ... # 0x1
    ScrollFinished           : QScrollEvent = ... # 0x2

    class ScrollState(object):
        ScrollStarted            : QScrollEvent.ScrollState = ... # 0x0
        ScrollUpdated            : QScrollEvent.ScrollState = ... # 0x1
        ScrollFinished           : QScrollEvent.ScrollState = ... # 0x2

    def __init__(self, contentPos:PySide2.QtCore.QPointF, overshoot:PySide2.QtCore.QPointF, scrollState:PySide2.QtGui.QScrollEvent.ScrollState) -> None: ...

    def contentPos(self) -> PySide2.QtCore.QPointF: ...
    def overshootDistance(self) -> PySide2.QtCore.QPointF: ...
    def scrollState(self) -> PySide2.QtGui.QScrollEvent.ScrollState: ...


class QScrollPrepareEvent(PySide2.QtCore.QEvent):

    def __init__(self, startPos:PySide2.QtCore.QPointF) -> None: ...

    def contentPos(self) -> PySide2.QtCore.QPointF: ...
    def contentPosRange(self) -> PySide2.QtCore.QRectF: ...
    def setContentPos(self, pos:PySide2.QtCore.QPointF) -> None: ...
    def setContentPosRange(self, rect:PySide2.QtCore.QRectF) -> None: ...
    def setViewportSize(self, size:PySide2.QtCore.QSizeF) -> None: ...
    def startPos(self) -> PySide2.QtCore.QPointF: ...
    def viewportSize(self) -> PySide2.QtCore.QSizeF: ...


class QSessionManager(PySide2.QtCore.QObject):
    RestartIfRunning         : QSessionManager = ... # 0x0
    RestartAnyway            : QSessionManager = ... # 0x1
    RestartImmediately       : QSessionManager = ... # 0x2
    RestartNever             : QSessionManager = ... # 0x3

    class RestartHint(object):
        RestartIfRunning         : QSessionManager.RestartHint = ... # 0x0
        RestartAnyway            : QSessionManager.RestartHint = ... # 0x1
        RestartImmediately       : QSessionManager.RestartHint = ... # 0x2
        RestartNever             : QSessionManager.RestartHint = ... # 0x3
    def allowsErrorInteraction(self) -> bool: ...
    def allowsInteraction(self) -> bool: ...
    def cancel(self) -> None: ...
    def discardCommand(self) -> typing.List: ...
    def isPhase2(self) -> bool: ...
    def release(self) -> None: ...
    def requestPhase2(self) -> None: ...
    def restartCommand(self) -> typing.List: ...
    def restartHint(self) -> PySide2.QtGui.QSessionManager.RestartHint: ...
    def sessionId(self) -> str: ...
    def sessionKey(self) -> str: ...
    def setDiscardCommand(self, arg__1:typing.Sequence) -> None: ...
    @typing.overload
    def setManagerProperty(self, name:str, value:str) -> None: ...
    @typing.overload
    def setManagerProperty(self, name:str, value:typing.Sequence) -> None: ...
    def setRestartCommand(self, arg__1:typing.Sequence) -> None: ...
    def setRestartHint(self, arg__1:PySide2.QtGui.QSessionManager.RestartHint) -> None: ...


class QShortcutEvent(PySide2.QtCore.QEvent):

    def __init__(self, key:PySide2.QtGui.QKeySequence, id:int, ambiguous:bool=...) -> None: ...

    def isAmbiguous(self) -> bool: ...
    def key(self) -> PySide2.QtGui.QKeySequence: ...
    def shortcutId(self) -> int: ...


class QShowEvent(PySide2.QtCore.QEvent):

    def __init__(self) -> None: ...


class QStandardItem(Shiboken.Object):
    Type                     : QStandardItem = ... # 0x0
    UserType                 : QStandardItem = ... # 0x3e8

    class ItemType(object):
        Type                     : QStandardItem.ItemType = ... # 0x0
        UserType                 : QStandardItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, icon:PySide2.QtGui.QIcon, text:str) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def __init__(self, rows:int, columns:int=...) -> None: ...
    @typing.overload
    def __init__(self, text:str) -> None: ...

    def __lshift__(self, out:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def accessibleDescription(self) -> str: ...
    def accessibleText(self) -> str: ...
    def appendColumn(self, items:typing.Sequence) -> None: ...
    @typing.overload
    def appendRow(self, item:PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def appendRow(self, items:typing.Sequence) -> None: ...
    def appendRows(self, items:typing.Sequence) -> None: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def child(self, row:int, column:int=...) -> PySide2.QtGui.QStandardItem: ...
    def clearData(self) -> None: ...
    def clone(self) -> PySide2.QtGui.QStandardItem: ...
    def column(self) -> int: ...
    def columnCount(self) -> int: ...
    def data(self, role:int=...) -> typing.Any: ...
    def emitDataChanged(self) -> None: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def hasChildren(self) -> bool: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def index(self) -> PySide2.QtCore.QModelIndex: ...
    def insertColumn(self, column:int, items:typing.Sequence) -> None: ...
    def insertColumns(self, column:int, count:int) -> None: ...
    @typing.overload
    def insertRow(self, row:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def insertRow(self, row:int, items:typing.Sequence) -> None: ...
    @typing.overload
    def insertRows(self, row:int, count:int) -> None: ...
    @typing.overload
    def insertRows(self, row:int, items:typing.Sequence) -> None: ...
    def isAutoTristate(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def isDragEnabled(self) -> bool: ...
    def isDropEnabled(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isSelectable(self) -> bool: ...
    def isTristate(self) -> bool: ...
    def isUserTristate(self) -> bool: ...
    def model(self) -> PySide2.QtGui.QStandardItemModel: ...
    def parent(self) -> PySide2.QtGui.QStandardItem: ...
    def read(self, in_:PySide2.QtCore.QDataStream) -> None: ...
    def removeColumn(self, column:int) -> None: ...
    def removeColumns(self, column:int, count:int) -> None: ...
    def removeRow(self, row:int) -> None: ...
    def removeRows(self, row:int, count:int) -> None: ...
    def row(self) -> int: ...
    def rowCount(self) -> int: ...
    def setAccessibleDescription(self, accessibleDescription:str) -> None: ...
    def setAccessibleText(self, accessibleText:str) -> None: ...
    def setAutoTristate(self, tristate:bool) -> None: ...
    def setBackground(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setCheckState(self, checkState:PySide2.QtCore.Qt.CheckState) -> None: ...
    def setCheckable(self, checkable:bool) -> None: ...
    @typing.overload
    def setChild(self, row:int, column:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def setChild(self, row:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    def setColumnCount(self, columns:int) -> None: ...
    def setData(self, value:typing.Any, role:int=...) -> None: ...
    def setDragEnabled(self, dragEnabled:bool) -> None: ...
    def setDropEnabled(self, dropEnabled:bool) -> None: ...
    def setEditable(self, editable:bool) -> None: ...
    def setEnabled(self, enabled:bool) -> None: ...
    def setFlags(self, flags:PySide2.QtCore.Qt.ItemFlags) -> None: ...
    def setFont(self, font:PySide2.QtGui.QFont) -> None: ...
    def setForeground(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setIcon(self, icon:PySide2.QtGui.QIcon) -> None: ...
    def setRowCount(self, rows:int) -> None: ...
    def setSelectable(self, selectable:bool) -> None: ...
    def setSizeHint(self, sizeHint:PySide2.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip:str) -> None: ...
    def setText(self, text:str) -> None: ...
    def setTextAlignment(self, textAlignment:PySide2.QtCore.Qt.Alignment) -> None: ...
    def setToolTip(self, toolTip:str) -> None: ...
    def setTristate(self, tristate:bool) -> None: ...
    def setUserTristate(self, tristate:bool) -> None: ...
    def setWhatsThis(self, whatsThis:str) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sortChildren(self, column:int, order:PySide2.QtCore.Qt.SortOrder=...) -> None: ...
    def statusTip(self) -> str: ...
    def takeChild(self, row:int, column:int=...) -> PySide2.QtGui.QStandardItem: ...
    def takeColumn(self, column:int) -> typing.List: ...
    def takeRow(self, row:int) -> typing.List: ...
    def text(self) -> str: ...
    def textAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out:PySide2.QtCore.QDataStream) -> None: ...


class QStandardItemModel(PySide2.QtCore.QAbstractItemModel):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, rows:int, columns:int, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def appendColumn(self, items:typing.Sequence) -> None: ...
    @typing.overload
    def appendRow(self, item:PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def appendRow(self, items:typing.Sequence) -> None: ...
    def clear(self) -> None: ...
    def clearItemData(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent:PySide2.QtCore.QModelIndex=...) -> int: ...
    def data(self, index:PySide2.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def dropMimeData(self, data:PySide2.QtCore.QMimeData, action:PySide2.QtCore.Qt.DropAction, row:int, column:int, parent:PySide2.QtCore.QModelIndex) -> bool: ...
    def findItems(self, text:str, flags:PySide2.QtCore.Qt.MatchFlags=..., column:int=...) -> typing.List: ...
    def flags(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def headerData(self, section:int, orientation:PySide2.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def horizontalHeaderItem(self, column:int) -> PySide2.QtGui.QStandardItem: ...
    def index(self, row:int, column:int, parent:PySide2.QtCore.QModelIndex=...) -> PySide2.QtCore.QModelIndex: ...
    def indexFromItem(self, item:PySide2.QtGui.QStandardItem) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def insertColumn(self, column:int, items:typing.Sequence) -> None: ...
    @typing.overload
    def insertColumn(self, column:int, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def insertColumns(self, column:int, count:int, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    @typing.overload
    def insertRow(self, row:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def insertRow(self, row:int, items:typing.Sequence) -> None: ...
    @typing.overload
    def insertRow(self, row:int, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def insertRows(self, row:int, count:int, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def invisibleRootItem(self) -> PySide2.QtGui.QStandardItem: ...
    def item(self, row:int, column:int=...) -> PySide2.QtGui.QStandardItem: ...
    def itemData(self, index:PySide2.QtCore.QModelIndex) -> typing.Dict: ...
    def itemFromIndex(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QStandardItem: ...
    def itemPrototype(self) -> PySide2.QtGui.QStandardItem: ...
    def mimeData(self, indexes:typing.List) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def removeColumns(self, column:int, count:int, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def removeRows(self, row:int, count:int, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def rowCount(self, parent:PySide2.QtCore.QModelIndex=...) -> int: ...
    def setColumnCount(self, columns:int) -> None: ...
    def setData(self, index:PySide2.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setHeaderData(self, section:int, orientation:PySide2.QtCore.Qt.Orientation, value:typing.Any, role:int=...) -> bool: ...
    def setHorizontalHeaderItem(self, column:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    def setHorizontalHeaderLabels(self, labels:typing.Sequence) -> None: ...
    @typing.overload
    def setItem(self, row:int, column:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    @typing.overload
    def setItem(self, row:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    def setItemData(self, index:PySide2.QtCore.QModelIndex, roles:typing.Dict) -> bool: ...
    def setItemPrototype(self, item:PySide2.QtGui.QStandardItem) -> None: ...
    def setItemRoleNames(self, roleNames:typing.Dict) -> None: ...
    def setRowCount(self, rows:int) -> None: ...
    def setSortRole(self, role:int) -> None: ...
    def setVerticalHeaderItem(self, row:int, item:PySide2.QtGui.QStandardItem) -> None: ...
    def setVerticalHeaderLabels(self, labels:typing.Sequence) -> None: ...
    def sibling(self, row:int, column:int, idx:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def sort(self, column:int, order:PySide2.QtCore.Qt.SortOrder=...) -> None: ...
    def sortRole(self) -> int: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeColumn(self, column:int) -> typing.List: ...
    def takeHorizontalHeaderItem(self, column:int) -> PySide2.QtGui.QStandardItem: ...
    def takeItem(self, row:int, column:int=...) -> PySide2.QtGui.QStandardItem: ...
    def takeRow(self, row:int) -> typing.List: ...
    def takeVerticalHeaderItem(self, row:int) -> PySide2.QtGui.QStandardItem: ...
    def verticalHeaderItem(self, row:int) -> PySide2.QtGui.QStandardItem: ...


class QStaticText(Shiboken.Object):
    ModerateCaching          : QStaticText = ... # 0x0
    AggressiveCaching        : QStaticText = ... # 0x1

    class PerformanceHint(object):
        ModerateCaching          : QStaticText.PerformanceHint = ... # 0x0
        AggressiveCaching        : QStaticText.PerformanceHint = ... # 0x1

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QStaticText) -> None: ...
    @typing.overload
    def __init__(self, text:str) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def performanceHint(self) -> PySide2.QtGui.QStaticText.PerformanceHint: ...
    def prepare(self, matrix:PySide2.QtGui.QTransform=..., font:PySide2.QtGui.QFont=...) -> None: ...
    def setPerformanceHint(self, performanceHint:PySide2.QtGui.QStaticText.PerformanceHint) -> None: ...
    def setText(self, text:str) -> None: ...
    def setTextFormat(self, textFormat:PySide2.QtCore.Qt.TextFormat) -> None: ...
    def setTextOption(self, textOption:PySide2.QtGui.QTextOption) -> None: ...
    def setTextWidth(self, textWidth:float) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def swap(self, other:PySide2.QtGui.QStaticText) -> None: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textOption(self) -> PySide2.QtGui.QTextOption: ...
    def textWidth(self) -> float: ...


class QStatusTipEvent(PySide2.QtCore.QEvent):

    def __init__(self, tip:str) -> None: ...

    def tip(self) -> str: ...


class QStyleHints(PySide2.QtCore.QObject):
    def cursorFlashTime(self) -> int: ...
    def fontSmoothingGamma(self) -> float: ...
    def keyboardAutoRepeatRate(self) -> int: ...
    def keyboardInputInterval(self) -> int: ...
    def mouseDoubleClickDistance(self) -> int: ...
    def mouseDoubleClickInterval(self) -> int: ...
    def mousePressAndHoldInterval(self) -> int: ...
    def mouseQuickSelectionThreshold(self) -> int: ...
    def passwordMaskCharacter(self) -> str: ...
    def passwordMaskDelay(self) -> int: ...
    def setCursorFlashTime(self, cursorFlashTime:int) -> None: ...
    def setFocusOnTouchRelease(self) -> bool: ...
    def setKeyboardInputInterval(self, keyboardInputInterval:int) -> None: ...
    def setMouseDoubleClickInterval(self, mouseDoubleClickInterval:int) -> None: ...
    def setMousePressAndHoldInterval(self, mousePressAndHoldInterval:int) -> None: ...
    def setMouseQuickSelectionThreshold(self, threshold:int) -> None: ...
    def setShowShortcutsInContextMenus(self, showShortcutsInContextMenus:bool) -> None: ...
    def setStartDragDistance(self, startDragDistance:int) -> None: ...
    def setStartDragTime(self, startDragTime:int) -> None: ...
    def setTabFocusBehavior(self, tabFocusBehavior:PySide2.QtCore.Qt.TabFocusBehavior) -> None: ...
    def setUseHoverEffects(self, useHoverEffects:bool) -> None: ...
    def setWheelScrollLines(self, scrollLines:int) -> None: ...
    def showIsFullScreen(self) -> bool: ...
    def showIsMaximized(self) -> bool: ...
    def showShortcutsInContextMenus(self) -> bool: ...
    def singleClickActivation(self) -> bool: ...
    def startDragDistance(self) -> int: ...
    def startDragTime(self) -> int: ...
    def startDragVelocity(self) -> int: ...
    def tabFocusBehavior(self) -> PySide2.QtCore.Qt.TabFocusBehavior: ...
    def touchDoubleTapDistance(self) -> int: ...
    def useHoverEffects(self) -> bool: ...
    def useRtlExtensions(self) -> bool: ...
    def wheelScrollLines(self) -> int: ...


class QSurface(Shiboken.Object):
    RasterSurface            : QSurface = ... # 0x0
    Window                   : QSurface = ... # 0x0
    Offscreen                : QSurface = ... # 0x1
    OpenGLSurface            : QSurface = ... # 0x1
    RasterGLSurface          : QSurface = ... # 0x2
    OpenVGSurface            : QSurface = ... # 0x3
    VulkanSurface            : QSurface = ... # 0x4
    MetalSurface             : QSurface = ... # 0x5

    class SurfaceClass(object):
        Window                   : QSurface.SurfaceClass = ... # 0x0
        Offscreen                : QSurface.SurfaceClass = ... # 0x1

    class SurfaceType(object):
        RasterSurface            : QSurface.SurfaceType = ... # 0x0
        OpenGLSurface            : QSurface.SurfaceType = ... # 0x1
        RasterGLSurface          : QSurface.SurfaceType = ... # 0x2
        OpenVGSurface            : QSurface.SurfaceType = ... # 0x3
        VulkanSurface            : QSurface.SurfaceType = ... # 0x4
        MetalSurface             : QSurface.SurfaceType = ... # 0x5

    def __init__(self, type:PySide2.QtGui.QSurface.SurfaceClass) -> None: ...

    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def supportsOpenGL(self) -> bool: ...
    def surfaceClass(self) -> PySide2.QtGui.QSurface.SurfaceClass: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide2.QtGui.QSurface.SurfaceType: ...


class QSurfaceFormat(Shiboken.Object):
    DefaultColorSpace        : QSurfaceFormat = ... # 0x0
    DefaultRenderableType    : QSurfaceFormat = ... # 0x0
    DefaultSwapBehavior      : QSurfaceFormat = ... # 0x0
    NoProfile                : QSurfaceFormat = ... # 0x0
    CoreProfile              : QSurfaceFormat = ... # 0x1
    OpenGL                   : QSurfaceFormat = ... # 0x1
    SingleBuffer             : QSurfaceFormat = ... # 0x1
    StereoBuffers            : QSurfaceFormat = ... # 0x1
    sRGBColorSpace           : QSurfaceFormat = ... # 0x1
    CompatibilityProfile     : QSurfaceFormat = ... # 0x2
    DebugContext             : QSurfaceFormat = ... # 0x2
    DoubleBuffer             : QSurfaceFormat = ... # 0x2
    OpenGLES                 : QSurfaceFormat = ... # 0x2
    TripleBuffer             : QSurfaceFormat = ... # 0x3
    DeprecatedFunctions      : QSurfaceFormat = ... # 0x4
    OpenVG                   : QSurfaceFormat = ... # 0x4
    ResetNotification        : QSurfaceFormat = ... # 0x8

    class ColorSpace(object):
        DefaultColorSpace        : QSurfaceFormat.ColorSpace = ... # 0x0
        sRGBColorSpace           : QSurfaceFormat.ColorSpace = ... # 0x1

    class FormatOption(object):
        StereoBuffers            : QSurfaceFormat.FormatOption = ... # 0x1
        DebugContext             : QSurfaceFormat.FormatOption = ... # 0x2
        DeprecatedFunctions      : QSurfaceFormat.FormatOption = ... # 0x4
        ResetNotification        : QSurfaceFormat.FormatOption = ... # 0x8

    class FormatOptions(object): ...

    class OpenGLContextProfile(object):
        NoProfile                : QSurfaceFormat.OpenGLContextProfile = ... # 0x0
        CoreProfile              : QSurfaceFormat.OpenGLContextProfile = ... # 0x1
        CompatibilityProfile     : QSurfaceFormat.OpenGLContextProfile = ... # 0x2

    class RenderableType(object):
        DefaultRenderableType    : QSurfaceFormat.RenderableType = ... # 0x0
        OpenGL                   : QSurfaceFormat.RenderableType = ... # 0x1
        OpenGLES                 : QSurfaceFormat.RenderableType = ... # 0x2
        OpenVG                   : QSurfaceFormat.RenderableType = ... # 0x4

    class SwapBehavior(object):
        DefaultSwapBehavior      : QSurfaceFormat.SwapBehavior = ... # 0x0
        SingleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x1
        DoubleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x2
        TripleBuffer             : QSurfaceFormat.SwapBehavior = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, options:PySide2.QtGui.QSurfaceFormat.FormatOptions) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QSurfaceFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alphaBufferSize(self) -> int: ...
    def blueBufferSize(self) -> int: ...
    def colorSpace(self) -> PySide2.QtGui.QSurfaceFormat.ColorSpace: ...
    @staticmethod
    def defaultFormat() -> PySide2.QtGui.QSurfaceFormat: ...
    def depthBufferSize(self) -> int: ...
    def greenBufferSize(self) -> int: ...
    def hasAlpha(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def options(self) -> PySide2.QtGui.QSurfaceFormat.FormatOptions: ...
    def profile(self) -> PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile: ...
    def redBufferSize(self) -> int: ...
    def renderableType(self) -> PySide2.QtGui.QSurfaceFormat.RenderableType: ...
    def samples(self) -> int: ...
    def setAlphaBufferSize(self, size:int) -> None: ...
    def setBlueBufferSize(self, size:int) -> None: ...
    def setColorSpace(self, colorSpace:PySide2.QtGui.QSurfaceFormat.ColorSpace) -> None: ...
    @staticmethod
    def setDefaultFormat(format:PySide2.QtGui.QSurfaceFormat) -> None: ...
    def setDepthBufferSize(self, size:int) -> None: ...
    def setGreenBufferSize(self, size:int) -> None: ...
    def setMajorVersion(self, majorVersion:int) -> None: ...
    def setMinorVersion(self, minorVersion:int) -> None: ...
    @typing.overload
    def setOption(self, opt:PySide2.QtGui.QSurfaceFormat.FormatOptions) -> None: ...
    @typing.overload
    def setOption(self, option:PySide2.QtGui.QSurfaceFormat.FormatOption, on:bool=...) -> None: ...
    def setOptions(self, options:PySide2.QtGui.QSurfaceFormat.FormatOptions) -> None: ...
    def setProfile(self, profile:PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile) -> None: ...
    def setRedBufferSize(self, size:int) -> None: ...
    def setRenderableType(self, type:PySide2.QtGui.QSurfaceFormat.RenderableType) -> None: ...
    def setSamples(self, numSamples:int) -> None: ...
    def setStencilBufferSize(self, size:int) -> None: ...
    def setStereo(self, enable:bool) -> None: ...
    def setSwapBehavior(self, behavior:PySide2.QtGui.QSurfaceFormat.SwapBehavior) -> None: ...
    def setSwapInterval(self, interval:int) -> None: ...
    def setVersion(self, major:int, minor:int) -> None: ...
    def stencilBufferSize(self) -> int: ...
    def stereo(self) -> bool: ...
    def swapBehavior(self) -> PySide2.QtGui.QSurfaceFormat.SwapBehavior: ...
    def swapInterval(self) -> int: ...
    @typing.overload
    def testOption(self, opt:PySide2.QtGui.QSurfaceFormat.FormatOptions) -> bool: ...
    @typing.overload
    def testOption(self, option:PySide2.QtGui.QSurfaceFormat.FormatOption) -> bool: ...
    def version(self) -> typing.Tuple: ...


class QSyntaxHighlighter(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, parent:PySide2.QtGui.QTextDocument) -> None: ...

    def currentBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def currentBlockState(self) -> int: ...
    def currentBlockUserData(self) -> PySide2.QtGui.QTextBlockUserData: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def format(self, pos:int) -> PySide2.QtGui.QTextCharFormat: ...
    def highlightBlock(self, text:str) -> None: ...
    def previousBlockState(self) -> int: ...
    def rehighlight(self) -> None: ...
    def rehighlightBlock(self, block:PySide2.QtGui.QTextBlock) -> None: ...
    def setCurrentBlockState(self, newState:int) -> None: ...
    def setCurrentBlockUserData(self, data:PySide2.QtGui.QTextBlockUserData) -> None: ...
    def setDocument(self, doc:PySide2.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def setFormat(self, start:int, count:int, color:PySide2.QtGui.QColor) -> None: ...
    @typing.overload
    def setFormat(self, start:int, count:int, font:PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def setFormat(self, start:int, count:int, format:PySide2.QtGui.QTextCharFormat) -> None: ...


class QTabletEvent(PySide2.QtGui.QInputEvent):
    NoDevice                 : QTabletEvent = ... # 0x0
    UnknownPointer           : QTabletEvent = ... # 0x0
    Pen                      : QTabletEvent = ... # 0x1
    Puck                     : QTabletEvent = ... # 0x1
    Cursor                   : QTabletEvent = ... # 0x2
    Stylus                   : QTabletEvent = ... # 0x2
    Airbrush                 : QTabletEvent = ... # 0x3
    Eraser                   : QTabletEvent = ... # 0x3
    FourDMouse               : QTabletEvent = ... # 0x4
    XFreeEraser              : QTabletEvent = ... # 0x5
    RotationStylus           : QTabletEvent = ... # 0x6

    class PointerType(object):
        UnknownPointer           : QTabletEvent.PointerType = ... # 0x0
        Pen                      : QTabletEvent.PointerType = ... # 0x1
        Cursor                   : QTabletEvent.PointerType = ... # 0x2
        Eraser                   : QTabletEvent.PointerType = ... # 0x3

    class TabletDevice(object):
        NoDevice                 : QTabletEvent.TabletDevice = ... # 0x0
        Puck                     : QTabletEvent.TabletDevice = ... # 0x1
        Stylus                   : QTabletEvent.TabletDevice = ... # 0x2
        Airbrush                 : QTabletEvent.TabletDevice = ... # 0x3
        FourDMouse               : QTabletEvent.TabletDevice = ... # 0x4
        XFreeEraser              : QTabletEvent.TabletDevice = ... # 0x5
        RotationStylus           : QTabletEvent.TabletDevice = ... # 0x6

    @typing.overload
    def __init__(self, t:PySide2.QtCore.QEvent.Type, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, device:int, pointerType:int, pressure:float, xTilt:int, yTilt:int, tangentialPressure:float, rotation:float, z:int, keyState:PySide2.QtCore.Qt.KeyboardModifiers, uniqueID:int) -> None: ...
    @typing.overload
    def __init__(self, t:PySide2.QtCore.QEvent.Type, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, device:int, pointerType:int, pressure:float, xTilt:int, yTilt:int, tangentialPressure:float, rotation:float, z:int, keyState:PySide2.QtCore.Qt.KeyboardModifiers, uniqueID:int, button:PySide2.QtCore.Qt.MouseButton, buttons:PySide2.QtCore.Qt.MouseButtons) -> None: ...

    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def device(self) -> PySide2.QtGui.QTabletEvent.TabletDevice: ...
    def deviceType(self) -> PySide2.QtGui.QTabletEvent.TabletDevice: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalPosF(self) -> PySide2.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def hiResGlobalX(self) -> float: ...
    def hiResGlobalY(self) -> float: ...
    def pointerType(self) -> PySide2.QtGui.QTabletEvent.PointerType: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def pressure(self) -> float: ...
    def rotation(self) -> float: ...
    def tangentialPressure(self) -> float: ...
    def uniqueId(self) -> int: ...
    def x(self) -> int: ...
    def xTilt(self) -> int: ...
    def y(self) -> int: ...
    def yTilt(self) -> int: ...
    def z(self) -> int: ...


class QTextBlock(Shiboken.Object):

    class iterator(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, o:PySide2.QtGui.QTextBlock.iterator) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def __iadd__(self, arg__1:int) -> PySide2.QtGui.QTextBlock.iterator: ...
        def __isub__(self, arg__1:int) -> PySide2.QtGui.QTextBlock.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def fragment(self) -> PySide2.QtGui.QTextFragment: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o:PySide2.QtGui.QTextBlock) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __iter__(self) -> object: ...
    def begin(self) -> PySide2.QtGui.QTextBlock.iterator: ...
    def blockFormat(self) -> PySide2.QtGui.QTextBlockFormat: ...
    def blockFormatIndex(self) -> int: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def clearLayout(self) -> None: ...
    def contains(self, position:int) -> bool: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def end(self) -> PySide2.QtGui.QTextBlock.iterator: ...
    def firstLineNumber(self) -> int: ...
    def fragmentIndex(self) -> int: ...
    def isValid(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def layout(self) -> PySide2.QtGui.QTextLayout: ...
    def length(self) -> int: ...
    def lineCount(self) -> int: ...
    def next(self) -> PySide2.QtGui.QTextBlock: ...
    def position(self) -> int: ...
    def previous(self) -> PySide2.QtGui.QTextBlock: ...
    def revision(self) -> int: ...
    def setLineCount(self, count:int) -> None: ...
    def setRevision(self, rev:int) -> None: ...
    def setUserData(self, data:PySide2.QtGui.QTextBlockUserData) -> None: ...
    def setUserState(self, state:int) -> None: ...
    def setVisible(self, visible:bool) -> None: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def textFormats(self) -> typing.List: ...
    def textList(self) -> PySide2.QtGui.QTextList: ...
    def userData(self) -> PySide2.QtGui.QTextBlockUserData: ...
    def userState(self) -> int: ...


class QTextBlockFormat(PySide2.QtGui.QTextFormat):
    SingleHeight             : QTextBlockFormat = ... # 0x0
    ProportionalHeight       : QTextBlockFormat = ... # 0x1
    FixedHeight              : QTextBlockFormat = ... # 0x2
    MinimumHeight            : QTextBlockFormat = ... # 0x3
    LineDistanceHeight       : QTextBlockFormat = ... # 0x4

    class LineHeightTypes(object):
        SingleHeight             : QTextBlockFormat.LineHeightTypes = ... # 0x0
        ProportionalHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x1
        FixedHeight              : QTextBlockFormat.LineHeightTypes = ... # 0x2
        MinimumHeight            : QTextBlockFormat.LineHeightTypes = ... # 0x3
        LineDistanceHeight       : QTextBlockFormat.LineHeightTypes = ... # 0x4

    class MarkerType(object):
        NoMarker                 : QTextBlockFormat.MarkerType = ... # 0x0
        Unchecked                : QTextBlockFormat.MarkerType = ... # 0x1
        Checked                  : QTextBlockFormat.MarkerType = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextBlockFormat:PySide2.QtGui.QTextBlockFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt:PySide2.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def bottomMargin(self) -> float: ...
    def headingLevel(self) -> int: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    @typing.overload
    def lineHeight(self) -> float: ...
    @typing.overload
    def lineHeight(self, scriptLineHeight:float, scaling:float) -> float: ...
    def lineHeightType(self) -> int: ...
    def marker(self) -> PySide2.QtGui.QTextBlockFormat.MarkerType: ...
    def nonBreakableLines(self) -> bool: ...
    def pageBreakPolicy(self) -> PySide2.QtGui.QTextFormat.PageBreakFlags: ...
    def rightMargin(self) -> float: ...
    def setAlignment(self, alignment:PySide2.QtCore.Qt.Alignment) -> None: ...
    def setBottomMargin(self, margin:float) -> None: ...
    def setHeadingLevel(self, alevel:int) -> None: ...
    def setIndent(self, indent:int) -> None: ...
    def setLeftMargin(self, margin:float) -> None: ...
    def setLineHeight(self, height:float, heightType:int) -> None: ...
    def setMarker(self, marker:PySide2.QtGui.QTextBlockFormat.MarkerType) -> None: ...
    def setNonBreakableLines(self, b:bool) -> None: ...
    def setPageBreakPolicy(self, flags:PySide2.QtGui.QTextFormat.PageBreakFlags) -> None: ...
    def setRightMargin(self, margin:float) -> None: ...
    def setTabPositions(self, tabs:typing.Sequence) -> None: ...
    def setTextIndent(self, aindent:float) -> None: ...
    def setTopMargin(self, margin:float) -> None: ...
    def tabPositions(self) -> typing.List: ...
    def textIndent(self) -> float: ...
    def topMargin(self) -> float: ...


class QTextBlockGroup(PySide2.QtGui.QTextObject):

    def __init__(self, doc:PySide2.QtGui.QTextDocument) -> None: ...

    def blockFormatChanged(self, block:PySide2.QtGui.QTextBlock) -> None: ...
    def blockInserted(self, block:PySide2.QtGui.QTextBlock) -> None: ...
    def blockList(self) -> typing.List: ...
    def blockRemoved(self, block:PySide2.QtGui.QTextBlock) -> None: ...


class QTextBlockUserData(Shiboken.Object):

    def __init__(self) -> None: ...


class QTextCharFormat(PySide2.QtGui.QTextFormat):
    AlignNormal              : QTextCharFormat = ... # 0x0
    FontPropertiesSpecifiedOnly: QTextCharFormat = ... # 0x0
    NoUnderline              : QTextCharFormat = ... # 0x0
    AlignSuperScript         : QTextCharFormat = ... # 0x1
    FontPropertiesAll        : QTextCharFormat = ... # 0x1
    SingleUnderline          : QTextCharFormat = ... # 0x1
    AlignSubScript           : QTextCharFormat = ... # 0x2
    DashUnderline            : QTextCharFormat = ... # 0x2
    AlignMiddle              : QTextCharFormat = ... # 0x3
    DotLine                  : QTextCharFormat = ... # 0x3
    AlignTop                 : QTextCharFormat = ... # 0x4
    DashDotLine              : QTextCharFormat = ... # 0x4
    AlignBottom              : QTextCharFormat = ... # 0x5
    DashDotDotLine           : QTextCharFormat = ... # 0x5
    AlignBaseline            : QTextCharFormat = ... # 0x6
    WaveUnderline            : QTextCharFormat = ... # 0x6
    SpellCheckUnderline      : QTextCharFormat = ... # 0x7

    class FontPropertiesInheritanceBehavior(object):
        FontPropertiesSpecifiedOnly: QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x0
        FontPropertiesAll        : QTextCharFormat.FontPropertiesInheritanceBehavior = ... # 0x1

    class UnderlineStyle(object):
        NoUnderline              : QTextCharFormat.UnderlineStyle = ... # 0x0
        SingleUnderline          : QTextCharFormat.UnderlineStyle = ... # 0x1
        DashUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x2
        DotLine                  : QTextCharFormat.UnderlineStyle = ... # 0x3
        DashDotLine              : QTextCharFormat.UnderlineStyle = ... # 0x4
        DashDotDotLine           : QTextCharFormat.UnderlineStyle = ... # 0x5
        WaveUnderline            : QTextCharFormat.UnderlineStyle = ... # 0x6
        SpellCheckUnderline      : QTextCharFormat.UnderlineStyle = ... # 0x7

    class VerticalAlignment(object):
        AlignNormal              : QTextCharFormat.VerticalAlignment = ... # 0x0
        AlignSuperScript         : QTextCharFormat.VerticalAlignment = ... # 0x1
        AlignSubScript           : QTextCharFormat.VerticalAlignment = ... # 0x2
        AlignMiddle              : QTextCharFormat.VerticalAlignment = ... # 0x3
        AlignTop                 : QTextCharFormat.VerticalAlignment = ... # 0x4
        AlignBottom              : QTextCharFormat.VerticalAlignment = ... # 0x5
        AlignBaseline            : QTextCharFormat.VerticalAlignment = ... # 0x6

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextCharFormat:PySide2.QtGui.QTextCharFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt:PySide2.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def anchorHref(self) -> str: ...
    def anchorName(self) -> str: ...
    def anchorNames(self) -> typing.List: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def fontCapitalization(self) -> PySide2.QtGui.QFont.Capitalization: ...
    def fontFamilies(self) -> typing.Any: ...
    def fontFamily(self) -> str: ...
    def fontFixedPitch(self) -> bool: ...
    def fontHintingPreference(self) -> PySide2.QtGui.QFont.HintingPreference: ...
    def fontItalic(self) -> bool: ...
    def fontKerning(self) -> bool: ...
    def fontLetterSpacing(self) -> float: ...
    def fontLetterSpacingType(self) -> PySide2.QtGui.QFont.SpacingType: ...
    def fontOverline(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontStretch(self) -> int: ...
    def fontStrikeOut(self) -> bool: ...
    def fontStyleHint(self) -> PySide2.QtGui.QFont.StyleHint: ...
    def fontStyleName(self) -> typing.Any: ...
    def fontStyleStrategy(self) -> PySide2.QtGui.QFont.StyleStrategy: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def fontWordSpacing(self) -> float: ...
    def isAnchor(self) -> bool: ...
    def isValid(self) -> bool: ...
    def setAnchor(self, anchor:bool) -> None: ...
    def setAnchorHref(self, value:str) -> None: ...
    def setAnchorName(self, name:str) -> None: ...
    def setAnchorNames(self, names:typing.Sequence) -> None: ...
    @typing.overload
    def setFont(self, font:PySide2.QtGui.QFont) -> None: ...
    @typing.overload
    def setFont(self, font:PySide2.QtGui.QFont, behavior:PySide2.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior) -> None: ...
    def setFontCapitalization(self, capitalization:PySide2.QtGui.QFont.Capitalization) -> None: ...
    def setFontFamilies(self, families:typing.Sequence) -> None: ...
    def setFontFamily(self, family:str) -> None: ...
    def setFontFixedPitch(self, fixedPitch:bool) -> None: ...
    def setFontHintingPreference(self, hintingPreference:PySide2.QtGui.QFont.HintingPreference) -> None: ...
    def setFontItalic(self, italic:bool) -> None: ...
    def setFontKerning(self, enable:bool) -> None: ...
    def setFontLetterSpacing(self, spacing:float) -> None: ...
    def setFontLetterSpacingType(self, letterSpacingType:PySide2.QtGui.QFont.SpacingType) -> None: ...
    def setFontOverline(self, overline:bool) -> None: ...
    def setFontPointSize(self, size:float) -> None: ...
    def setFontStretch(self, factor:int) -> None: ...
    def setFontStrikeOut(self, strikeOut:bool) -> None: ...
    def setFontStyleHint(self, hint:PySide2.QtGui.QFont.StyleHint, strategy:PySide2.QtGui.QFont.StyleStrategy=...) -> None: ...
    def setFontStyleName(self, styleName:str) -> None: ...
    def setFontStyleStrategy(self, strategy:PySide2.QtGui.QFont.StyleStrategy) -> None: ...
    def setFontUnderline(self, underline:bool) -> None: ...
    def setFontWeight(self, weight:int) -> None: ...
    def setFontWordSpacing(self, spacing:float) -> None: ...
    def setTableCellColumnSpan(self, tableCellColumnSpan:int) -> None: ...
    def setTableCellRowSpan(self, tableCellRowSpan:int) -> None: ...
    def setTextOutline(self, pen:PySide2.QtGui.QPen) -> None: ...
    def setToolTip(self, tip:str) -> None: ...
    def setUnderlineColor(self, color:PySide2.QtGui.QColor) -> None: ...
    def setUnderlineStyle(self, style:PySide2.QtGui.QTextCharFormat.UnderlineStyle) -> None: ...
    def setVerticalAlignment(self, alignment:PySide2.QtGui.QTextCharFormat.VerticalAlignment) -> None: ...
    def tableCellColumnSpan(self) -> int: ...
    def tableCellRowSpan(self) -> int: ...
    def textOutline(self) -> PySide2.QtGui.QPen: ...
    def toolTip(self) -> str: ...
    def underlineColor(self) -> PySide2.QtGui.QColor: ...
    def underlineStyle(self) -> PySide2.QtGui.QTextCharFormat.UnderlineStyle: ...
    def verticalAlignment(self) -> PySide2.QtGui.QTextCharFormat.VerticalAlignment: ...


class QTextCursor(Shiboken.Object):
    MoveAnchor               : QTextCursor = ... # 0x0
    NoMove                   : QTextCursor = ... # 0x0
    WordUnderCursor          : QTextCursor = ... # 0x0
    KeepAnchor               : QTextCursor = ... # 0x1
    LineUnderCursor          : QTextCursor = ... # 0x1
    Start                    : QTextCursor = ... # 0x1
    BlockUnderCursor         : QTextCursor = ... # 0x2
    Up                       : QTextCursor = ... # 0x2
    Document                 : QTextCursor = ... # 0x3
    StartOfLine              : QTextCursor = ... # 0x3
    StartOfBlock             : QTextCursor = ... # 0x4
    StartOfWord              : QTextCursor = ... # 0x5
    PreviousBlock            : QTextCursor = ... # 0x6
    PreviousCharacter        : QTextCursor = ... # 0x7
    PreviousWord             : QTextCursor = ... # 0x8
    Left                     : QTextCursor = ... # 0x9
    WordLeft                 : QTextCursor = ... # 0xa
    End                      : QTextCursor = ... # 0xb
    Down                     : QTextCursor = ... # 0xc
    EndOfLine                : QTextCursor = ... # 0xd
    EndOfWord                : QTextCursor = ... # 0xe
    EndOfBlock               : QTextCursor = ... # 0xf
    NextBlock                : QTextCursor = ... # 0x10
    NextCharacter            : QTextCursor = ... # 0x11
    NextWord                 : QTextCursor = ... # 0x12
    Right                    : QTextCursor = ... # 0x13
    WordRight                : QTextCursor = ... # 0x14
    NextCell                 : QTextCursor = ... # 0x15
    PreviousCell             : QTextCursor = ... # 0x16
    NextRow                  : QTextCursor = ... # 0x17
    PreviousRow              : QTextCursor = ... # 0x18

    class MoveMode(object):
        MoveAnchor               : QTextCursor.MoveMode = ... # 0x0
        KeepAnchor               : QTextCursor.MoveMode = ... # 0x1

    class MoveOperation(object):
        NoMove                   : QTextCursor.MoveOperation = ... # 0x0
        Start                    : QTextCursor.MoveOperation = ... # 0x1
        Up                       : QTextCursor.MoveOperation = ... # 0x2
        StartOfLine              : QTextCursor.MoveOperation = ... # 0x3
        StartOfBlock             : QTextCursor.MoveOperation = ... # 0x4
        StartOfWord              : QTextCursor.MoveOperation = ... # 0x5
        PreviousBlock            : QTextCursor.MoveOperation = ... # 0x6
        PreviousCharacter        : QTextCursor.MoveOperation = ... # 0x7
        PreviousWord             : QTextCursor.MoveOperation = ... # 0x8
        Left                     : QTextCursor.MoveOperation = ... # 0x9
        WordLeft                 : QTextCursor.MoveOperation = ... # 0xa
        End                      : QTextCursor.MoveOperation = ... # 0xb
        Down                     : QTextCursor.MoveOperation = ... # 0xc
        EndOfLine                : QTextCursor.MoveOperation = ... # 0xd
        EndOfWord                : QTextCursor.MoveOperation = ... # 0xe
        EndOfBlock               : QTextCursor.MoveOperation = ... # 0xf
        NextBlock                : QTextCursor.MoveOperation = ... # 0x10
        NextCharacter            : QTextCursor.MoveOperation = ... # 0x11
        NextWord                 : QTextCursor.MoveOperation = ... # 0x12
        Right                    : QTextCursor.MoveOperation = ... # 0x13
        WordRight                : QTextCursor.MoveOperation = ... # 0x14
        NextCell                 : QTextCursor.MoveOperation = ... # 0x15
        PreviousCell             : QTextCursor.MoveOperation = ... # 0x16
        NextRow                  : QTextCursor.MoveOperation = ... # 0x17
        PreviousRow              : QTextCursor.MoveOperation = ... # 0x18

    class SelectionType(object):
        WordUnderCursor          : QTextCursor.SelectionType = ... # 0x0
        LineUnderCursor          : QTextCursor.SelectionType = ... # 0x1
        BlockUnderCursor         : QTextCursor.SelectionType = ... # 0x2
        Document                 : QTextCursor.SelectionType = ... # 0x3

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, block:PySide2.QtGui.QTextBlock) -> None: ...
    @typing.overload
    def __init__(self, cursor:PySide2.QtGui.QTextCursor) -> None: ...
    @typing.overload
    def __init__(self, document:PySide2.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, frame:PySide2.QtGui.QTextFrame) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def anchor(self) -> int: ...
    def atBlockEnd(self) -> bool: ...
    def atBlockStart(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def atStart(self) -> bool: ...
    def beginEditBlock(self) -> None: ...
    def block(self) -> PySide2.QtGui.QTextBlock: ...
    def blockCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def blockFormat(self) -> PySide2.QtGui.QTextBlockFormat: ...
    def blockNumber(self) -> int: ...
    def charFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def clearSelection(self) -> None: ...
    def columnNumber(self) -> int: ...
    @typing.overload
    def createList(self, format:PySide2.QtGui.QTextListFormat) -> PySide2.QtGui.QTextList: ...
    @typing.overload
    def createList(self, style:PySide2.QtGui.QTextListFormat.Style) -> PySide2.QtGui.QTextList: ...
    def currentFrame(self) -> PySide2.QtGui.QTextFrame: ...
    def currentList(self) -> PySide2.QtGui.QTextList: ...
    def currentTable(self) -> PySide2.QtGui.QTextTable: ...
    def deleteChar(self) -> None: ...
    def deletePreviousChar(self) -> None: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def endEditBlock(self) -> None: ...
    def hasComplexSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    @typing.overload
    def insertBlock(self) -> None: ...
    @typing.overload
    def insertBlock(self, format:PySide2.QtGui.QTextBlockFormat) -> None: ...
    @typing.overload
    def insertBlock(self, format:PySide2.QtGui.QTextBlockFormat, charFormat:PySide2.QtGui.QTextCharFormat) -> None: ...
    def insertFragment(self, fragment:PySide2.QtGui.QTextDocumentFragment) -> None: ...
    def insertFrame(self, format:PySide2.QtGui.QTextFrameFormat) -> PySide2.QtGui.QTextFrame: ...
    def insertHtml(self, html:str) -> None: ...
    @typing.overload
    def insertImage(self, format:PySide2.QtGui.QTextImageFormat) -> None: ...
    @typing.overload
    def insertImage(self, format:PySide2.QtGui.QTextImageFormat, alignment:PySide2.QtGui.QTextFrameFormat.Position) -> None: ...
    @typing.overload
    def insertImage(self, image:PySide2.QtGui.QImage, name:str=...) -> None: ...
    @typing.overload
    def insertImage(self, name:str) -> None: ...
    @typing.overload
    def insertList(self, format:PySide2.QtGui.QTextListFormat) -> PySide2.QtGui.QTextList: ...
    @typing.overload
    def insertList(self, style:PySide2.QtGui.QTextListFormat.Style) -> PySide2.QtGui.QTextList: ...
    @typing.overload
    def insertTable(self, rows:int, cols:int) -> PySide2.QtGui.QTextTable: ...
    @typing.overload
    def insertTable(self, rows:int, cols:int, format:PySide2.QtGui.QTextTableFormat) -> PySide2.QtGui.QTextTable: ...
    @typing.overload
    def insertText(self, text:str) -> None: ...
    @typing.overload
    def insertText(self, text:str, format:PySide2.QtGui.QTextCharFormat) -> None: ...
    def isCopyOf(self, other:PySide2.QtGui.QTextCursor) -> bool: ...
    def isNull(self) -> bool: ...
    def joinPreviousEditBlock(self) -> None: ...
    def keepPositionOnInsert(self) -> bool: ...
    def mergeBlockCharFormat(self, modifier:PySide2.QtGui.QTextCharFormat) -> None: ...
    def mergeBlockFormat(self, modifier:PySide2.QtGui.QTextBlockFormat) -> None: ...
    def mergeCharFormat(self, modifier:PySide2.QtGui.QTextCharFormat) -> None: ...
    def movePosition(self, op:PySide2.QtGui.QTextCursor.MoveOperation, arg__2:PySide2.QtGui.QTextCursor.MoveMode=..., n:int=...) -> bool: ...
    def position(self) -> int: ...
    def positionInBlock(self) -> int: ...
    def removeSelectedText(self) -> None: ...
    def select(self, selection:PySide2.QtGui.QTextCursor.SelectionType) -> None: ...
    def selectedTableCells(self) -> typing.Tuple: ...
    def selectedText(self) -> str: ...
    def selection(self) -> PySide2.QtGui.QTextDocumentFragment: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setBlockCharFormat(self, format:PySide2.QtGui.QTextCharFormat) -> None: ...
    def setBlockFormat(self, format:PySide2.QtGui.QTextBlockFormat) -> None: ...
    def setCharFormat(self, format:PySide2.QtGui.QTextCharFormat) -> None: ...
    def setKeepPositionOnInsert(self, b:bool) -> None: ...
    def setPosition(self, pos:int, mode:PySide2.QtGui.QTextCursor.MoveMode=...) -> None: ...
    def setVerticalMovementX(self, x:int) -> None: ...
    def setVisualNavigation(self, b:bool) -> None: ...
    def swap(self, other:PySide2.QtGui.QTextCursor) -> None: ...
    def verticalMovementX(self) -> int: ...
    def visualNavigation(self) -> bool: ...


class QTextDocument(PySide2.QtCore.QObject):
    DocumentTitle            : QTextDocument = ... # 0x0
    MarkdownDialectCommonMark: QTextDocument = ... # 0x0
    UnknownResource          : QTextDocument = ... # 0x0
    DocumentUrl              : QTextDocument = ... # 0x1
    FindBackward             : QTextDocument = ... # 0x1
    HtmlResource             : QTextDocument = ... # 0x1
    UndoStack                : QTextDocument = ... # 0x1
    FindCaseSensitively      : QTextDocument = ... # 0x2
    ImageResource            : QTextDocument = ... # 0x2
    RedoStack                : QTextDocument = ... # 0x2
    StyleSheetResource       : QTextDocument = ... # 0x3
    UndoAndRedoStacks        : QTextDocument = ... # 0x3
    FindWholeWords           : QTextDocument = ... # 0x4
    MarkdownResource         : QTextDocument = ... # 0x4
    MarkdownNoHTML           : QTextDocument = ... # 0x60
    UserResource             : QTextDocument = ... # 0x64
    MarkdownDialectGitHub    : QTextDocument = ... # 0xf0c

    class FindFlag(object):
        FindBackward             : QTextDocument.FindFlag = ... # 0x1
        FindCaseSensitively      : QTextDocument.FindFlag = ... # 0x2
        FindWholeWords           : QTextDocument.FindFlag = ... # 0x4

    class FindFlags(object): ...

    class MarkdownFeature(object):
        MarkdownDialectCommonMark: QTextDocument.MarkdownFeature = ... # 0x0
        MarkdownNoHTML           : QTextDocument.MarkdownFeature = ... # 0x60
        MarkdownDialectGitHub    : QTextDocument.MarkdownFeature = ... # 0xf0c

    class MarkdownFeatures(object): ...

    class MetaInformation(object):
        DocumentTitle            : QTextDocument.MetaInformation = ... # 0x0
        DocumentUrl              : QTextDocument.MetaInformation = ... # 0x1

    class ResourceType(object):
        UnknownResource          : QTextDocument.ResourceType = ... # 0x0
        HtmlResource             : QTextDocument.ResourceType = ... # 0x1
        ImageResource            : QTextDocument.ResourceType = ... # 0x2
        StyleSheetResource       : QTextDocument.ResourceType = ... # 0x3
        MarkdownResource         : QTextDocument.ResourceType = ... # 0x4
        UserResource             : QTextDocument.ResourceType = ... # 0x64

    class Stacks(object):
        UndoStack                : QTextDocument.Stacks = ... # 0x1
        RedoStack                : QTextDocument.Stacks = ... # 0x2
        UndoAndRedoStacks        : QTextDocument.Stacks = ... # 0x3

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def addResource(self, type:int, name:PySide2.QtCore.QUrl, resource:typing.Any) -> None: ...
    def adjustSize(self) -> None: ...
    def allFormats(self) -> typing.List: ...
    def availableRedoSteps(self) -> int: ...
    def availableUndoSteps(self) -> int: ...
    def baseUrl(self) -> PySide2.QtCore.QUrl: ...
    def begin(self) -> PySide2.QtGui.QTextBlock: ...
    def blockCount(self) -> int: ...
    def characterAt(self, pos:int) -> str: ...
    def characterCount(self) -> int: ...
    def clear(self) -> None: ...
    def clearUndoRedoStacks(self, historyToClear:PySide2.QtGui.QTextDocument.Stacks=...) -> None: ...
    def clone(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> PySide2.QtGui.QTextDocument: ...
    def createObject(self, f:PySide2.QtGui.QTextFormat) -> PySide2.QtGui.QTextObject: ...
    def defaultCursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def defaultFont(self) -> PySide2.QtGui.QFont: ...
    def defaultStyleSheet(self) -> str: ...
    def defaultTextOption(self) -> PySide2.QtGui.QTextOption: ...
    def documentLayout(self) -> PySide2.QtGui.QAbstractTextDocumentLayout: ...
    def documentMargin(self) -> float: ...
    def drawContents(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF=...) -> None: ...
    def end(self) -> PySide2.QtGui.QTextBlock: ...
    @typing.overload
    def find(self, expr:PySide2.QtCore.QRegExp, cursor:PySide2.QtGui.QTextCursor, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, expr:PySide2.QtCore.QRegExp, from_:int=..., options:PySide2.QtGui.QTextDocument.FindFlags=...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, expr:PySide2.QtCore.QRegularExpression, cursor:PySide2.QtGui.QTextCursor, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, expr:PySide2.QtCore.QRegularExpression, from_:int=..., options:PySide2.QtGui.QTextDocument.FindFlags=...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, subString:str, cursor:PySide2.QtGui.QTextCursor, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def find(self, subString:str, from_:int=..., options:PySide2.QtGui.QTextDocument.FindFlags=...) -> PySide2.QtGui.QTextCursor: ...
    def findBlock(self, pos:int) -> PySide2.QtGui.QTextBlock: ...
    def findBlockByLineNumber(self, blockNumber:int) -> PySide2.QtGui.QTextBlock: ...
    def findBlockByNumber(self, blockNumber:int) -> PySide2.QtGui.QTextBlock: ...
    def firstBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def frameAt(self, pos:int) -> PySide2.QtGui.QTextFrame: ...
    def idealWidth(self) -> float: ...
    def indentWidth(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def lastBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def lineCount(self) -> int: ...
    def loadResource(self, type:int, name:PySide2.QtCore.QUrl) -> typing.Any: ...
    def markContentsDirty(self, from_:int, length:int) -> None: ...
    def maximumBlockCount(self) -> int: ...
    def metaInformation(self, info:PySide2.QtGui.QTextDocument.MetaInformation) -> str: ...
    def object(self, objectIndex:int) -> PySide2.QtGui.QTextObject: ...
    def objectForFormat(self, arg__1:PySide2.QtGui.QTextFormat) -> PySide2.QtGui.QTextObject: ...
    def pageCount(self) -> int: ...
    def pageSize(self) -> PySide2.QtCore.QSizeF: ...
    def print_(self, printer:PySide2.QtGui.QPagedPaintDevice) -> None: ...
    @typing.overload
    def redo(self) -> None: ...
    @typing.overload
    def redo(self, cursor:PySide2.QtGui.QTextCursor) -> None: ...
    def resource(self, type:int, name:PySide2.QtCore.QUrl) -> typing.Any: ...
    def revision(self) -> int: ...
    def rootFrame(self) -> PySide2.QtGui.QTextFrame: ...
    def setBaseUrl(self, url:PySide2.QtCore.QUrl) -> None: ...
    def setDefaultCursorMoveStyle(self, style:PySide2.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setDefaultFont(self, font:PySide2.QtGui.QFont) -> None: ...
    def setDefaultStyleSheet(self, sheet:str) -> None: ...
    def setDefaultTextOption(self, option:PySide2.QtGui.QTextOption) -> None: ...
    def setDocumentLayout(self, layout:PySide2.QtGui.QAbstractTextDocumentLayout) -> None: ...
    def setDocumentMargin(self, margin:float) -> None: ...
    def setHtml(self, html:str) -> None: ...
    def setIndentWidth(self, width:float) -> None: ...
    def setMarkdown(self, markdown:str, features:PySide2.QtGui.QTextDocument.MarkdownFeatures=...) -> None: ...
    def setMaximumBlockCount(self, maximum:int) -> None: ...
    def setMetaInformation(self, info:PySide2.QtGui.QTextDocument.MetaInformation, arg__2:str) -> None: ...
    def setModified(self, m:bool=...) -> None: ...
    def setPageSize(self, size:PySide2.QtCore.QSizeF) -> None: ...
    def setPlainText(self, text:str) -> None: ...
    def setTextWidth(self, width:float) -> None: ...
    def setUndoRedoEnabled(self, enable:bool) -> None: ...
    def setUseDesignMetrics(self, b:bool) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def textWidth(self) -> float: ...
    def toHtml(self, encoding:PySide2.QtCore.QByteArray=...) -> str: ...
    def toMarkdown(self, features:PySide2.QtGui.QTextDocument.MarkdownFeatures=...) -> str: ...
    def toPlainText(self) -> str: ...
    def toRawText(self) -> str: ...
    @typing.overload
    def undo(self) -> None: ...
    @typing.overload
    def undo(self, cursor:PySide2.QtGui.QTextCursor) -> None: ...
    def useDesignMetrics(self) -> bool: ...


class QTextDocumentFragment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, document:PySide2.QtGui.QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, range:PySide2.QtGui.QTextCursor) -> None: ...
    @typing.overload
    def __init__(self, rhs:PySide2.QtGui.QTextDocumentFragment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    @staticmethod
    def fromHtml(html:str) -> PySide2.QtGui.QTextDocumentFragment: ...
    @typing.overload
    @staticmethod
    def fromHtml(html:str, resourceProvider:PySide2.QtGui.QTextDocument) -> PySide2.QtGui.QTextDocumentFragment: ...
    @staticmethod
    def fromPlainText(plainText:str) -> PySide2.QtGui.QTextDocumentFragment: ...
    def isEmpty(self) -> bool: ...
    def toHtml(self, encoding:PySide2.QtCore.QByteArray=...) -> str: ...
    def toPlainText(self) -> str: ...


class QTextDocumentWriter(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device:PySide2.QtCore.QIODevice, format:PySide2.QtCore.QByteArray) -> None: ...
    @typing.overload
    def __init__(self, fileName:str, format:PySide2.QtCore.QByteArray=...) -> None: ...

    def codec(self) -> PySide2.QtCore.QTextCodec: ...
    def device(self) -> PySide2.QtCore.QIODevice: ...
    def fileName(self) -> str: ...
    def format(self) -> PySide2.QtCore.QByteArray: ...
    def setCodec(self, codec:PySide2.QtCore.QTextCodec) -> None: ...
    def setDevice(self, device:PySide2.QtCore.QIODevice) -> None: ...
    def setFileName(self, fileName:str) -> None: ...
    def setFormat(self, format:PySide2.QtCore.QByteArray) -> None: ...
    @staticmethod
    def supportedDocumentFormats() -> typing.List: ...
    @typing.overload
    def write(self, document:PySide2.QtGui.QTextDocument) -> bool: ...
    @typing.overload
    def write(self, fragment:PySide2.QtGui.QTextDocumentFragment) -> bool: ...


class QTextFormat(Shiboken.Object):
    InvalidFormat            : QTextFormat = ... # -0x1
    NoObject                 : QTextFormat = ... # 0x0
    ObjectIndex              : QTextFormat = ... # 0x0
    PageBreak_Auto           : QTextFormat = ... # 0x0
    BlockFormat              : QTextFormat = ... # 0x1
    ImageObject              : QTextFormat = ... # 0x1
    PageBreak_AlwaysBefore   : QTextFormat = ... # 0x1
    CharFormat               : QTextFormat = ... # 0x2
    TableObject              : QTextFormat = ... # 0x2
    ListFormat               : QTextFormat = ... # 0x3
    TableCellObject          : QTextFormat = ... # 0x3
    TableFormat              : QTextFormat = ... # 0x4
    FrameFormat              : QTextFormat = ... # 0x5
    PageBreak_AlwaysAfter    : QTextFormat = ... # 0x10
    UserFormat               : QTextFormat = ... # 0x64
    CssFloat                 : QTextFormat = ... # 0x800
    LayoutDirection          : QTextFormat = ... # 0x801
    OutlinePen               : QTextFormat = ... # 0x810
    BackgroundBrush          : QTextFormat = ... # 0x820
    ForegroundBrush          : QTextFormat = ... # 0x821
    BackgroundImageUrl       : QTextFormat = ... # 0x823
    UserObject               : QTextFormat = ... # 0x1000
    BlockAlignment           : QTextFormat = ... # 0x1010
    BlockTopMargin           : QTextFormat = ... # 0x1030
    BlockBottomMargin        : QTextFormat = ... # 0x1031
    BlockLeftMargin          : QTextFormat = ... # 0x1032
    BlockRightMargin         : QTextFormat = ... # 0x1033
    TextIndent               : QTextFormat = ... # 0x1034
    TabPositions             : QTextFormat = ... # 0x1035
    BlockIndent              : QTextFormat = ... # 0x1040
    LineHeight               : QTextFormat = ... # 0x1048
    LineHeightType           : QTextFormat = ... # 0x1049
    BlockNonBreakableLines   : QTextFormat = ... # 0x1050
    BlockTrailingHorizontalRulerWidth: QTextFormat = ... # 0x1060
    HeadingLevel             : QTextFormat = ... # 0x1070
    BlockQuoteLevel          : QTextFormat = ... # 0x1080
    BlockCodeLanguage        : QTextFormat = ... # 0x1090
    BlockCodeFence           : QTextFormat = ... # 0x1091
    BlockMarker              : QTextFormat = ... # 0x10a0
    FirstFontProperty        : QTextFormat = ... # 0x1fe0
    FontCapitalization       : QTextFormat = ... # 0x1fe0
    FontLetterSpacing        : QTextFormat = ... # 0x1fe1
    FontWordSpacing          : QTextFormat = ... # 0x1fe2
    FontStyleHint            : QTextFormat = ... # 0x1fe3
    FontStyleStrategy        : QTextFormat = ... # 0x1fe4
    FontKerning              : QTextFormat = ... # 0x1fe5
    FontHintingPreference    : QTextFormat = ... # 0x1fe6
    FontFamilies             : QTextFormat = ... # 0x1fe7
    FontStyleName            : QTextFormat = ... # 0x1fe8
    FontFamily               : QTextFormat = ... # 0x2000
    FontPointSize            : QTextFormat = ... # 0x2001
    FontSizeAdjustment       : QTextFormat = ... # 0x2002
    FontSizeIncrement        : QTextFormat = ... # 0x2002
    FontWeight               : QTextFormat = ... # 0x2003
    FontItalic               : QTextFormat = ... # 0x2004
    FontUnderline            : QTextFormat = ... # 0x2005
    FontOverline             : QTextFormat = ... # 0x2006
    FontStrikeOut            : QTextFormat = ... # 0x2007
    FontFixedPitch           : QTextFormat = ... # 0x2008
    FontPixelSize            : QTextFormat = ... # 0x2009
    LastFontProperty         : QTextFormat = ... # 0x2009
    TextUnderlineColor       : QTextFormat = ... # 0x2010
    TextVerticalAlignment    : QTextFormat = ... # 0x2021
    TextOutline              : QTextFormat = ... # 0x2022
    TextUnderlineStyle       : QTextFormat = ... # 0x2023
    TextToolTip              : QTextFormat = ... # 0x2024
    IsAnchor                 : QTextFormat = ... # 0x2030
    AnchorHref               : QTextFormat = ... # 0x2031
    AnchorName               : QTextFormat = ... # 0x2032
    FontLetterSpacingType    : QTextFormat = ... # 0x2033
    FontStretch              : QTextFormat = ... # 0x2034
    ObjectType               : QTextFormat = ... # 0x2f00
    ListStyle                : QTextFormat = ... # 0x3000
    ListIndent               : QTextFormat = ... # 0x3001
    ListNumberPrefix         : QTextFormat = ... # 0x3002
    ListNumberSuffix         : QTextFormat = ... # 0x3003
    FrameBorder              : QTextFormat = ... # 0x4000
    FrameMargin              : QTextFormat = ... # 0x4001
    FramePadding             : QTextFormat = ... # 0x4002
    FrameWidth               : QTextFormat = ... # 0x4003
    FrameHeight              : QTextFormat = ... # 0x4004
    FrameTopMargin           : QTextFormat = ... # 0x4005
    FrameBottomMargin        : QTextFormat = ... # 0x4006
    FrameLeftMargin          : QTextFormat = ... # 0x4007
    FrameRightMargin         : QTextFormat = ... # 0x4008
    FrameBorderBrush         : QTextFormat = ... # 0x4009
    FrameBorderStyle         : QTextFormat = ... # 0x4010
    TableColumns             : QTextFormat = ... # 0x4100
    TableColumnWidthConstraints: QTextFormat = ... # 0x4101
    TableCellSpacing         : QTextFormat = ... # 0x4102
    TableCellPadding         : QTextFormat = ... # 0x4103
    TableHeaderRowCount      : QTextFormat = ... # 0x4104
    TableBorderCollapse      : QTextFormat = ... # 0x4105
    TableCellRowSpan         : QTextFormat = ... # 0x4810
    TableCellColumnSpan      : QTextFormat = ... # 0x4811
    TableCellTopPadding      : QTextFormat = ... # 0x4812
    TableCellBottomPadding   : QTextFormat = ... # 0x4813
    TableCellLeftPadding     : QTextFormat = ... # 0x4814
    TableCellRightPadding    : QTextFormat = ... # 0x4815
    TableCellTopBorder       : QTextFormat = ... # 0x4816
    TableCellBottomBorder    : QTextFormat = ... # 0x4817
    TableCellLeftBorder      : QTextFormat = ... # 0x4818
    TableCellRightBorder     : QTextFormat = ... # 0x4819
    TableCellTopBorderStyle  : QTextFormat = ... # 0x481a
    TableCellBottomBorderStyle: QTextFormat = ... # 0x481b
    TableCellLeftBorderStyle : QTextFormat = ... # 0x481c
    TableCellRightBorderStyle: QTextFormat = ... # 0x481d
    TableCellTopBorderBrush  : QTextFormat = ... # 0x481e
    TableCellBottomBorderBrush: QTextFormat = ... # 0x481f
    TableCellLeftBorderBrush : QTextFormat = ... # 0x4820
    TableCellRightBorderBrush: QTextFormat = ... # 0x4821
    ImageName                : QTextFormat = ... # 0x5000
    ImageTitle               : QTextFormat = ... # 0x5001
    ImageAltText             : QTextFormat = ... # 0x5002
    ImageWidth               : QTextFormat = ... # 0x5010
    ImageHeight              : QTextFormat = ... # 0x5011
    ImageQuality             : QTextFormat = ... # 0x5014
    FullWidthSelection       : QTextFormat = ... # 0x6000
    PageBreakPolicy          : QTextFormat = ... # 0x7000
    UserProperty             : QTextFormat = ... # 0x100000

    class FormatType(object):
        InvalidFormat            : QTextFormat.FormatType = ... # -0x1
        BlockFormat              : QTextFormat.FormatType = ... # 0x1
        CharFormat               : QTextFormat.FormatType = ... # 0x2
        ListFormat               : QTextFormat.FormatType = ... # 0x3
        TableFormat              : QTextFormat.FormatType = ... # 0x4
        FrameFormat              : QTextFormat.FormatType = ... # 0x5
        UserFormat               : QTextFormat.FormatType = ... # 0x64

    class ObjectTypes(object):
        NoObject                 : QTextFormat.ObjectTypes = ... # 0x0
        ImageObject              : QTextFormat.ObjectTypes = ... # 0x1
        TableObject              : QTextFormat.ObjectTypes = ... # 0x2
        TableCellObject          : QTextFormat.ObjectTypes = ... # 0x3
        UserObject               : QTextFormat.ObjectTypes = ... # 0x1000

    class PageBreakFlag(object):
        PageBreak_Auto           : QTextFormat.PageBreakFlag = ... # 0x0
        PageBreak_AlwaysBefore   : QTextFormat.PageBreakFlag = ... # 0x1
        PageBreak_AlwaysAfter    : QTextFormat.PageBreakFlag = ... # 0x10

    class PageBreakFlags(object): ...

    class Property(object):
        ObjectIndex              : QTextFormat.Property = ... # 0x0
        CssFloat                 : QTextFormat.Property = ... # 0x800
        LayoutDirection          : QTextFormat.Property = ... # 0x801
        OutlinePen               : QTextFormat.Property = ... # 0x810
        BackgroundBrush          : QTextFormat.Property = ... # 0x820
        ForegroundBrush          : QTextFormat.Property = ... # 0x821
        BackgroundImageUrl       : QTextFormat.Property = ... # 0x823
        BlockAlignment           : QTextFormat.Property = ... # 0x1010
        BlockTopMargin           : QTextFormat.Property = ... # 0x1030
        BlockBottomMargin        : QTextFormat.Property = ... # 0x1031
        BlockLeftMargin          : QTextFormat.Property = ... # 0x1032
        BlockRightMargin         : QTextFormat.Property = ... # 0x1033
        TextIndent               : QTextFormat.Property = ... # 0x1034
        TabPositions             : QTextFormat.Property = ... # 0x1035
        BlockIndent              : QTextFormat.Property = ... # 0x1040
        LineHeight               : QTextFormat.Property = ... # 0x1048
        LineHeightType           : QTextFormat.Property = ... # 0x1049
        BlockNonBreakableLines   : QTextFormat.Property = ... # 0x1050
        BlockTrailingHorizontalRulerWidth: QTextFormat.Property = ... # 0x1060
        HeadingLevel             : QTextFormat.Property = ... # 0x1070
        BlockQuoteLevel          : QTextFormat.Property = ... # 0x1080
        BlockCodeLanguage        : QTextFormat.Property = ... # 0x1090
        BlockCodeFence           : QTextFormat.Property = ... # 0x1091
        BlockMarker              : QTextFormat.Property = ... # 0x10a0
        FirstFontProperty        : QTextFormat.Property = ... # 0x1fe0
        FontCapitalization       : QTextFormat.Property = ... # 0x1fe0
        FontLetterSpacing        : QTextFormat.Property = ... # 0x1fe1
        FontWordSpacing          : QTextFormat.Property = ... # 0x1fe2
        FontStyleHint            : QTextFormat.Property = ... # 0x1fe3
        FontStyleStrategy        : QTextFormat.Property = ... # 0x1fe4
        FontKerning              : QTextFormat.Property = ... # 0x1fe5
        FontHintingPreference    : QTextFormat.Property = ... # 0x1fe6
        FontFamilies             : QTextFormat.Property = ... # 0x1fe7
        FontStyleName            : QTextFormat.Property = ... # 0x1fe8
        FontFamily               : QTextFormat.Property = ... # 0x2000
        FontPointSize            : QTextFormat.Property = ... # 0x2001
        FontSizeAdjustment       : QTextFormat.Property = ... # 0x2002
        FontSizeIncrement        : QTextFormat.Property = ... # 0x2002
        FontWeight               : QTextFormat.Property = ... # 0x2003
        FontItalic               : QTextFormat.Property = ... # 0x2004
        FontUnderline            : QTextFormat.Property = ... # 0x2005
        FontOverline             : QTextFormat.Property = ... # 0x2006
        FontStrikeOut            : QTextFormat.Property = ... # 0x2007
        FontFixedPitch           : QTextFormat.Property = ... # 0x2008
        FontPixelSize            : QTextFormat.Property = ... # 0x2009
        LastFontProperty         : QTextFormat.Property = ... # 0x2009
        TextUnderlineColor       : QTextFormat.Property = ... # 0x2010
        TextVerticalAlignment    : QTextFormat.Property = ... # 0x2021
        TextOutline              : QTextFormat.Property = ... # 0x2022
        TextUnderlineStyle       : QTextFormat.Property = ... # 0x2023
        TextToolTip              : QTextFormat.Property = ... # 0x2024
        IsAnchor                 : QTextFormat.Property = ... # 0x2030
        AnchorHref               : QTextFormat.Property = ... # 0x2031
        AnchorName               : QTextFormat.Property = ... # 0x2032
        FontLetterSpacingType    : QTextFormat.Property = ... # 0x2033
        FontStretch              : QTextFormat.Property = ... # 0x2034
        ObjectType               : QTextFormat.Property = ... # 0x2f00
        ListStyle                : QTextFormat.Property = ... # 0x3000
        ListIndent               : QTextFormat.Property = ... # 0x3001
        ListNumberPrefix         : QTextFormat.Property = ... # 0x3002
        ListNumberSuffix         : QTextFormat.Property = ... # 0x3003
        FrameBorder              : QTextFormat.Property = ... # 0x4000
        FrameMargin              : QTextFormat.Property = ... # 0x4001
        FramePadding             : QTextFormat.Property = ... # 0x4002
        FrameWidth               : QTextFormat.Property = ... # 0x4003
        FrameHeight              : QTextFormat.Property = ... # 0x4004
        FrameTopMargin           : QTextFormat.Property = ... # 0x4005
        FrameBottomMargin        : QTextFormat.Property = ... # 0x4006
        FrameLeftMargin          : QTextFormat.Property = ... # 0x4007
        FrameRightMargin         : QTextFormat.Property = ... # 0x4008
        FrameBorderBrush         : QTextFormat.Property = ... # 0x4009
        FrameBorderStyle         : QTextFormat.Property = ... # 0x4010
        TableColumns             : QTextFormat.Property = ... # 0x4100
        TableColumnWidthConstraints: QTextFormat.Property = ... # 0x4101
        TableCellSpacing         : QTextFormat.Property = ... # 0x4102
        TableCellPadding         : QTextFormat.Property = ... # 0x4103
        TableHeaderRowCount      : QTextFormat.Property = ... # 0x4104
        TableBorderCollapse      : QTextFormat.Property = ... # 0x4105
        TableCellRowSpan         : QTextFormat.Property = ... # 0x4810
        TableCellColumnSpan      : QTextFormat.Property = ... # 0x4811
        TableCellTopPadding      : QTextFormat.Property = ... # 0x4812
        TableCellBottomPadding   : QTextFormat.Property = ... # 0x4813
        TableCellLeftPadding     : QTextFormat.Property = ... # 0x4814
        TableCellRightPadding    : QTextFormat.Property = ... # 0x4815
        TableCellTopBorder       : QTextFormat.Property = ... # 0x4816
        TableCellBottomBorder    : QTextFormat.Property = ... # 0x4817
        TableCellLeftBorder      : QTextFormat.Property = ... # 0x4818
        TableCellRightBorder     : QTextFormat.Property = ... # 0x4819
        TableCellTopBorderStyle  : QTextFormat.Property = ... # 0x481a
        TableCellBottomBorderStyle: QTextFormat.Property = ... # 0x481b
        TableCellLeftBorderStyle : QTextFormat.Property = ... # 0x481c
        TableCellRightBorderStyle: QTextFormat.Property = ... # 0x481d
        TableCellTopBorderBrush  : QTextFormat.Property = ... # 0x481e
        TableCellBottomBorderBrush: QTextFormat.Property = ... # 0x481f
        TableCellLeftBorderBrush : QTextFormat.Property = ... # 0x4820
        TableCellRightBorderBrush: QTextFormat.Property = ... # 0x4821
        ImageName                : QTextFormat.Property = ... # 0x5000
        ImageTitle               : QTextFormat.Property = ... # 0x5001
        ImageAltText             : QTextFormat.Property = ... # 0x5002
        ImageWidth               : QTextFormat.Property = ... # 0x5010
        ImageHeight              : QTextFormat.Property = ... # 0x5011
        ImageQuality             : QTextFormat.Property = ... # 0x5014
        FullWidthSelection       : QTextFormat.Property = ... # 0x6000
        PageBreakPolicy          : QTextFormat.Property = ... # 0x7000
        UserProperty             : QTextFormat.Property = ... # 0x100000

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, rhs:PySide2.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def __init__(self, type:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def boolProperty(self, propertyId:int) -> bool: ...
    def brushProperty(self, propertyId:int) -> PySide2.QtGui.QBrush: ...
    def clearBackground(self) -> None: ...
    def clearForeground(self) -> None: ...
    def clearProperty(self, propertyId:int) -> None: ...
    def colorProperty(self, propertyId:int) -> PySide2.QtGui.QColor: ...
    def doubleProperty(self, propertyId:int) -> float: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def hasProperty(self, propertyId:int) -> bool: ...
    def intProperty(self, propertyId:int) -> int: ...
    def isBlockFormat(self) -> bool: ...
    def isCharFormat(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isFrameFormat(self) -> bool: ...
    def isImageFormat(self) -> bool: ...
    def isListFormat(self) -> bool: ...
    def isTableCellFormat(self) -> bool: ...
    def isTableFormat(self) -> bool: ...
    def isValid(self) -> bool: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def lengthProperty(self, propertyId:int) -> PySide2.QtGui.QTextLength: ...
    def lengthVectorProperty(self, propertyId:int) -> typing.List: ...
    def merge(self, other:PySide2.QtGui.QTextFormat) -> None: ...
    def objectIndex(self) -> int: ...
    def objectType(self) -> int: ...
    def penProperty(self, propertyId:int) -> PySide2.QtGui.QPen: ...
    def properties(self) -> typing.Dict: ...
    def property(self, propertyId:int) -> typing.Any: ...
    def propertyCount(self) -> int: ...
    def setBackground(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setForeground(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setLayoutDirection(self, direction:PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setObjectIndex(self, object:int) -> None: ...
    def setObjectType(self, type:int) -> None: ...
    @typing.overload
    def setProperty(self, propertyId:int, lengths:typing.List) -> None: ...
    @typing.overload
    def setProperty(self, propertyId:int, value:typing.Any) -> None: ...
    def stringProperty(self, propertyId:int) -> str: ...
    def swap(self, other:PySide2.QtGui.QTextFormat) -> None: ...
    def toBlockFormat(self) -> PySide2.QtGui.QTextBlockFormat: ...
    def toCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def toFrameFormat(self) -> PySide2.QtGui.QTextFrameFormat: ...
    def toImageFormat(self) -> PySide2.QtGui.QTextImageFormat: ...
    def toListFormat(self) -> PySide2.QtGui.QTextListFormat: ...
    def toTableCellFormat(self) -> PySide2.QtGui.QTextTableCellFormat: ...
    def toTableFormat(self) -> PySide2.QtGui.QTextTableFormat: ...
    def type(self) -> int: ...


class QTextFragment(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o:PySide2.QtGui.QTextFragment) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def charFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def charFormatIndex(self) -> int: ...
    def contains(self, position:int) -> bool: ...
    def isValid(self) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def text(self) -> str: ...


class QTextFrame(PySide2.QtGui.QTextObject):

    class iterator(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, o:PySide2.QtGui.QTextFrame.iterator) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def __iadd__(self, arg__1:int) -> PySide2.QtGui.QTextFrame.iterator: ...
        def __isub__(self, arg__1:int) -> PySide2.QtGui.QTextFrame.iterator: ...
        def __iter__(self) -> object: ...
        def __next__(self) -> object: ...
        def atEnd(self) -> bool: ...
        def currentBlock(self) -> PySide2.QtGui.QTextBlock: ...
        def currentFrame(self) -> PySide2.QtGui.QTextFrame: ...
        def parentFrame(self) -> PySide2.QtGui.QTextFrame: ...

    def __init__(self, doc:PySide2.QtGui.QTextDocument) -> None: ...

    def __iter__(self) -> object: ...
    def begin(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def childFrames(self) -> typing.List: ...
    def end(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def frameFormat(self) -> PySide2.QtGui.QTextFrameFormat: ...
    def lastCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def parentFrame(self) -> PySide2.QtGui.QTextFrame: ...
    def setFrameFormat(self, format:PySide2.QtGui.QTextFrameFormat) -> None: ...


class QTextFrameFormat(PySide2.QtGui.QTextFormat):
    BorderStyle_None         : QTextFrameFormat = ... # 0x0
    InFlow                   : QTextFrameFormat = ... # 0x0
    BorderStyle_Dotted       : QTextFrameFormat = ... # 0x1
    FloatLeft                : QTextFrameFormat = ... # 0x1
    BorderStyle_Dashed       : QTextFrameFormat = ... # 0x2
    FloatRight               : QTextFrameFormat = ... # 0x2
    BorderStyle_Solid        : QTextFrameFormat = ... # 0x3
    BorderStyle_Double       : QTextFrameFormat = ... # 0x4
    BorderStyle_DotDash      : QTextFrameFormat = ... # 0x5
    BorderStyle_DotDotDash   : QTextFrameFormat = ... # 0x6
    BorderStyle_Groove       : QTextFrameFormat = ... # 0x7
    BorderStyle_Ridge        : QTextFrameFormat = ... # 0x8
    BorderStyle_Inset        : QTextFrameFormat = ... # 0x9
    BorderStyle_Outset       : QTextFrameFormat = ... # 0xa

    class BorderStyle(object):
        BorderStyle_None         : QTextFrameFormat.BorderStyle = ... # 0x0
        BorderStyle_Dotted       : QTextFrameFormat.BorderStyle = ... # 0x1
        BorderStyle_Dashed       : QTextFrameFormat.BorderStyle = ... # 0x2
        BorderStyle_Solid        : QTextFrameFormat.BorderStyle = ... # 0x3
        BorderStyle_Double       : QTextFrameFormat.BorderStyle = ... # 0x4
        BorderStyle_DotDash      : QTextFrameFormat.BorderStyle = ... # 0x5
        BorderStyle_DotDotDash   : QTextFrameFormat.BorderStyle = ... # 0x6
        BorderStyle_Groove       : QTextFrameFormat.BorderStyle = ... # 0x7
        BorderStyle_Ridge        : QTextFrameFormat.BorderStyle = ... # 0x8
        BorderStyle_Inset        : QTextFrameFormat.BorderStyle = ... # 0x9
        BorderStyle_Outset       : QTextFrameFormat.BorderStyle = ... # 0xa

    class Position(object):
        InFlow                   : QTextFrameFormat.Position = ... # 0x0
        FloatLeft                : QTextFrameFormat.Position = ... # 0x1
        FloatRight               : QTextFrameFormat.Position = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextFrameFormat:PySide2.QtGui.QTextFrameFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt:PySide2.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def border(self) -> float: ...
    def borderBrush(self) -> PySide2.QtGui.QBrush: ...
    def borderStyle(self) -> PySide2.QtGui.QTextFrameFormat.BorderStyle: ...
    def bottomMargin(self) -> float: ...
    def height(self) -> PySide2.QtGui.QTextLength: ...
    def isValid(self) -> bool: ...
    def leftMargin(self) -> float: ...
    def margin(self) -> float: ...
    def padding(self) -> float: ...
    def pageBreakPolicy(self) -> PySide2.QtGui.QTextFormat.PageBreakFlags: ...
    def position(self) -> PySide2.QtGui.QTextFrameFormat.Position: ...
    def rightMargin(self) -> float: ...
    def setBorder(self, border:float) -> None: ...
    def setBorderBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setBorderStyle(self, style:PySide2.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomMargin(self, margin:float) -> None: ...
    @typing.overload
    def setHeight(self, height:PySide2.QtGui.QTextLength) -> None: ...
    @typing.overload
    def setHeight(self, height:float) -> None: ...
    def setLeftMargin(self, margin:float) -> None: ...
    def setMargin(self, margin:float) -> None: ...
    def setPadding(self, padding:float) -> None: ...
    def setPageBreakPolicy(self, flags:PySide2.QtGui.QTextFormat.PageBreakFlags) -> None: ...
    def setPosition(self, f:PySide2.QtGui.QTextFrameFormat.Position) -> None: ...
    def setRightMargin(self, margin:float) -> None: ...
    def setTopMargin(self, margin:float) -> None: ...
    @typing.overload
    def setWidth(self, length:PySide2.QtGui.QTextLength) -> None: ...
    @typing.overload
    def setWidth(self, width:float) -> None: ...
    def topMargin(self) -> float: ...
    def width(self) -> PySide2.QtGui.QTextLength: ...


class QTextImageFormat(PySide2.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextImageFormat:PySide2.QtGui.QTextImageFormat) -> None: ...
    @typing.overload
    def __init__(self, format:PySide2.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def quality(self) -> int: ...
    def setHeight(self, height:float) -> None: ...
    def setName(self, name:str) -> None: ...
    def setQuality(self, quality:int=...) -> None: ...
    def setWidth(self, width:float) -> None: ...
    def width(self) -> float: ...


class QTextInlineObject(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def format(self) -> PySide2.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def height(self) -> float: ...
    def isValid(self) -> bool: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setAscent(self, a:float) -> None: ...
    def setDescent(self, d:float) -> None: ...
    def setWidth(self, w:float) -> None: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def textPosition(self) -> int: ...
    def width(self) -> float: ...


class QTextItem(Shiboken.Object):
    RightToLeft              : QTextItem = ... # 0x1
    Overline                 : QTextItem = ... # 0x10
    Underline                : QTextItem = ... # 0x20
    StrikeOut                : QTextItem = ... # 0x40
    Dummy                    : QTextItem = ... # -0x1

    class RenderFlag(object):
        RightToLeft              : QTextItem.RenderFlag = ... # 0x1
        Overline                 : QTextItem.RenderFlag = ... # 0x10
        Underline                : QTextItem.RenderFlag = ... # 0x20
        StrikeOut                : QTextItem.RenderFlag = ... # 0x40
        Dummy                    : QTextItem.RenderFlag = ... # -0x1

    class RenderFlags(object): ...

    def __init__(self) -> None: ...

    def ascent(self) -> float: ...
    def descent(self) -> float: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def renderFlags(self) -> PySide2.QtGui.QTextItem.RenderFlags: ...
    def text(self) -> str: ...
    def width(self) -> float: ...


class QTextLayout(Shiboken.Object):
    SkipCharacters           : QTextLayout = ... # 0x0
    SkipWords                : QTextLayout = ... # 0x1

    class CursorMode(object):
        SkipCharacters           : QTextLayout.CursorMode = ... # 0x0
        SkipWords                : QTextLayout.CursorMode = ... # 0x1

    class FormatRange(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, FormatRange:PySide2.QtGui.QTextLayout.FormatRange) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, b:PySide2.QtGui.QTextBlock) -> None: ...
    @typing.overload
    def __init__(self, text:str) -> None: ...
    @typing.overload
    def __init__(self, text:str, font:PySide2.QtGui.QFont, paintdevice:typing.Optional[PySide2.QtGui.QPaintDevice]=...) -> None: ...

    def additionalFormats(self) -> typing.List: ...
    def beginLayout(self) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def cacheEnabled(self) -> bool: ...
    def clearAdditionalFormats(self) -> None: ...
    def clearFormats(self) -> None: ...
    def clearLayout(self) -> None: ...
    def createLine(self) -> PySide2.QtGui.QTextLine: ...
    def cursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def draw(self, p:PySide2.QtGui.QPainter, pos:PySide2.QtCore.QPointF, selections:typing.List=..., clip:PySide2.QtCore.QRectF=...) -> None: ...
    @typing.overload
    def drawCursor(self, p:PySide2.QtGui.QPainter, pos:PySide2.QtCore.QPointF, cursorPosition:int) -> None: ...
    @typing.overload
    def drawCursor(self, p:PySide2.QtGui.QPainter, pos:PySide2.QtCore.QPointF, cursorPosition:int, width:int) -> None: ...
    def endLayout(self) -> None: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def formats(self) -> typing.List: ...
    def isValidCursorPosition(self, pos:int) -> bool: ...
    def leftCursorPosition(self, oldPos:int) -> int: ...
    def lineAt(self, i:int) -> PySide2.QtGui.QTextLine: ...
    def lineCount(self) -> int: ...
    def lineForTextPosition(self, pos:int) -> PySide2.QtGui.QTextLine: ...
    def maximumWidth(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def nextCursorPosition(self, oldPos:int, mode:PySide2.QtGui.QTextLayout.CursorMode=...) -> int: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def preeditAreaPosition(self) -> int: ...
    def preeditAreaText(self) -> str: ...
    def previousCursorPosition(self, oldPos:int, mode:PySide2.QtGui.QTextLayout.CursorMode=...) -> int: ...
    def rightCursorPosition(self, oldPos:int) -> int: ...
    def setAdditionalFormats(self, overrides:typing.Sequence) -> None: ...
    def setCacheEnabled(self, enable:bool) -> None: ...
    def setCursorMoveStyle(self, style:PySide2.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setFlags(self, flags:int) -> None: ...
    def setFont(self, f:PySide2.QtGui.QFont) -> None: ...
    def setFormats(self, overrides:typing.List) -> None: ...
    def setPosition(self, p:PySide2.QtCore.QPointF) -> None: ...
    def setPreeditArea(self, position:int, text:str) -> None: ...
    def setRawFont(self, rawFont:PySide2.QtGui.QRawFont) -> None: ...
    def setText(self, string:str) -> None: ...
    def setTextOption(self, option:PySide2.QtGui.QTextOption) -> None: ...
    def text(self) -> str: ...
    def textOption(self) -> PySide2.QtGui.QTextOption: ...


class QTextLength(Shiboken.Object):
    VariableLength           : QTextLength = ... # 0x0
    FixedLength              : QTextLength = ... # 0x1
    PercentageLength         : QTextLength = ... # 0x2

    class Type(object):
        VariableLength           : QTextLength.Type = ... # 0x0
        FixedLength              : QTextLength.Type = ... # 0x1
        PercentageLength         : QTextLength.Type = ... # 0x2

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextLength:PySide2.QtGui.QTextLength) -> None: ...
    @typing.overload
    def __init__(self, type:PySide2.QtGui.QTextLength.Type, value:float) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def rawValue(self) -> float: ...
    def type(self) -> PySide2.QtGui.QTextLength.Type: ...
    def value(self, maximumLength:float) -> float: ...


class QTextLine(Shiboken.Object):
    CursorBetweenCharacters  : QTextLine = ... # 0x0
    Leading                  : QTextLine = ... # 0x0
    CursorOnCharacter        : QTextLine = ... # 0x1
    Trailing                 : QTextLine = ... # 0x1

    class CursorPosition(object):
        CursorBetweenCharacters  : QTextLine.CursorPosition = ... # 0x0
        CursorOnCharacter        : QTextLine.CursorPosition = ... # 0x1

    class Edge(object):
        Leading                  : QTextLine.Edge = ... # 0x0
        Trailing                 : QTextLine.Edge = ... # 0x1

    def __init__(self) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def ascent(self) -> float: ...
    def cursorToX(self, cursorPos:int, edge:PySide2.QtGui.QTextLine.Edge=...) -> float: ...
    def descent(self) -> float: ...
    def draw(self, p:PySide2.QtGui.QPainter, point:PySide2.QtCore.QPointF, selection:typing.Optional[PySide2.QtGui.QTextLayout.FormatRange]=...) -> None: ...
    def height(self) -> float: ...
    def horizontalAdvance(self) -> float: ...
    def isValid(self) -> bool: ...
    def leading(self) -> float: ...
    def leadingIncluded(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def naturalTextRect(self) -> PySide2.QtCore.QRectF: ...
    def naturalTextWidth(self) -> float: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def setLeadingIncluded(self, included:bool) -> None: ...
    def setLineWidth(self, width:float) -> None: ...
    @typing.overload
    def setNumColumns(self, columns:int) -> None: ...
    @typing.overload
    def setNumColumns(self, columns:int, alignmentWidth:float) -> None: ...
    def setPosition(self, pos:PySide2.QtCore.QPointF) -> None: ...
    def textLength(self) -> int: ...
    def textStart(self) -> int: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def xToCursor(self, x:float, edge:PySide2.QtGui.QTextLine.CursorPosition=...) -> int: ...
    def y(self) -> float: ...


class QTextList(PySide2.QtGui.QTextBlockGroup):

    def __init__(self, doc:PySide2.QtGui.QTextDocument) -> None: ...

    def add(self, block:PySide2.QtGui.QTextBlock) -> None: ...
    def count(self) -> int: ...
    def format(self) -> PySide2.QtGui.QTextListFormat: ...
    def item(self, i:int) -> PySide2.QtGui.QTextBlock: ...
    def itemNumber(self, arg__1:PySide2.QtGui.QTextBlock) -> int: ...
    def itemText(self, arg__1:PySide2.QtGui.QTextBlock) -> str: ...
    def remove(self, arg__1:PySide2.QtGui.QTextBlock) -> None: ...
    def removeItem(self, i:int) -> None: ...
    @typing.overload
    def setFormat(self, format:PySide2.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def setFormat(self, format:PySide2.QtGui.QTextListFormat) -> None: ...


class QTextListFormat(PySide2.QtGui.QTextFormat):
    ListUpperRoman           : QTextListFormat = ... # -0x8
    ListLowerRoman           : QTextListFormat = ... # -0x7
    ListUpperAlpha           : QTextListFormat = ... # -0x6
    ListLowerAlpha           : QTextListFormat = ... # -0x5
    ListDecimal              : QTextListFormat = ... # -0x4
    ListSquare               : QTextListFormat = ... # -0x3
    ListCircle               : QTextListFormat = ... # -0x2
    ListDisc                 : QTextListFormat = ... # -0x1
    ListStyleUndefined       : QTextListFormat = ... # 0x0

    class Style(object):
        ListUpperRoman           : QTextListFormat.Style = ... # -0x8
        ListLowerRoman           : QTextListFormat.Style = ... # -0x7
        ListUpperAlpha           : QTextListFormat.Style = ... # -0x6
        ListLowerAlpha           : QTextListFormat.Style = ... # -0x5
        ListDecimal              : QTextListFormat.Style = ... # -0x4
        ListSquare               : QTextListFormat.Style = ... # -0x3
        ListCircle               : QTextListFormat.Style = ... # -0x2
        ListDisc                 : QTextListFormat.Style = ... # -0x1
        ListStyleUndefined       : QTextListFormat.Style = ... # 0x0

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextListFormat:PySide2.QtGui.QTextListFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt:PySide2.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def indent(self) -> int: ...
    def isValid(self) -> bool: ...
    def numberPrefix(self) -> str: ...
    def numberSuffix(self) -> str: ...
    def setIndent(self, indent:int) -> None: ...
    def setNumberPrefix(self, numberPrefix:str) -> None: ...
    def setNumberSuffix(self, numberSuffix:str) -> None: ...
    def setStyle(self, style:PySide2.QtGui.QTextListFormat.Style) -> None: ...
    def style(self) -> PySide2.QtGui.QTextListFormat.Style: ...


class QTextObject(PySide2.QtCore.QObject):

    def __init__(self, doc:PySide2.QtGui.QTextDocument) -> None: ...

    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def format(self) -> PySide2.QtGui.QTextFormat: ...
    def formatIndex(self) -> int: ...
    def objectIndex(self) -> int: ...
    def setFormat(self, format:PySide2.QtGui.QTextFormat) -> None: ...


class QTextObjectInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def drawObject(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF, doc:PySide2.QtGui.QTextDocument, posInDocument:int, format:PySide2.QtGui.QTextFormat) -> None: ...
    def intrinsicSize(self, doc:PySide2.QtGui.QTextDocument, posInDocument:int, format:PySide2.QtGui.QTextFormat) -> PySide2.QtCore.QSizeF: ...


class QTextOption(Shiboken.Object):
    LeftTab                  : QTextOption = ... # 0x0
    NoWrap                   : QTextOption = ... # 0x0
    RightTab                 : QTextOption = ... # 0x1
    ShowTabsAndSpaces        : QTextOption = ... # 0x1
    WordWrap                 : QTextOption = ... # 0x1
    CenterTab                : QTextOption = ... # 0x2
    ManualWrap               : QTextOption = ... # 0x2
    ShowLineAndParagraphSeparators: QTextOption = ... # 0x2
    DelimiterTab             : QTextOption = ... # 0x3
    WrapAnywhere             : QTextOption = ... # 0x3
    AddSpaceForLineAndParagraphSeparators: QTextOption = ... # 0x4
    WrapAtWordBoundaryOrAnywhere: QTextOption = ... # 0x4
    SuppressColors           : QTextOption = ... # 0x8
    ShowDocumentTerminator   : QTextOption = ... # 0x10
    IncludeTrailingSpaces    : QTextOption = ... # -0x80000000

    class Flag(object):
        ShowTabsAndSpaces        : QTextOption.Flag = ... # 0x1
        ShowLineAndParagraphSeparators: QTextOption.Flag = ... # 0x2
        AddSpaceForLineAndParagraphSeparators: QTextOption.Flag = ... # 0x4
        SuppressColors           : QTextOption.Flag = ... # 0x8
        ShowDocumentTerminator   : QTextOption.Flag = ... # 0x10
        IncludeTrailingSpaces    : QTextOption.Flag = ... # -0x80000000

    class Flags(object): ...

    class Tab(Shiboken.Object):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, Tab:PySide2.QtGui.QTextOption.Tab) -> None: ...
        @typing.overload
        def __init__(self, pos:float, tabType:PySide2.QtGui.QTextOption.TabType, delim:str=...) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class TabType(object):
        LeftTab                  : QTextOption.TabType = ... # 0x0
        RightTab                 : QTextOption.TabType = ... # 0x1
        CenterTab                : QTextOption.TabType = ... # 0x2
        DelimiterTab             : QTextOption.TabType = ... # 0x3

    class WrapMode(object):
        NoWrap                   : QTextOption.WrapMode = ... # 0x0
        WordWrap                 : QTextOption.WrapMode = ... # 0x1
        ManualWrap               : QTextOption.WrapMode = ... # 0x2
        WrapAnywhere             : QTextOption.WrapMode = ... # 0x3
        WrapAtWordBoundaryOrAnywhere: QTextOption.WrapMode = ... # 0x4

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, alignment:PySide2.QtCore.Qt.Alignment) -> None: ...
    @typing.overload
    def __init__(self, o:PySide2.QtGui.QTextOption) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def flags(self) -> PySide2.QtGui.QTextOption.Flags: ...
    def setAlignment(self, alignment:PySide2.QtCore.Qt.Alignment) -> None: ...
    def setFlags(self, flags:PySide2.QtGui.QTextOption.Flags) -> None: ...
    def setTabArray(self, tabStops:typing.Sequence) -> None: ...
    def setTabStop(self, tabStop:float) -> None: ...
    def setTabStopDistance(self, tabStopDistance:float) -> None: ...
    def setTabs(self, tabStops:typing.Sequence) -> None: ...
    def setTextDirection(self, aDirection:PySide2.QtCore.Qt.LayoutDirection) -> None: ...
    def setUseDesignMetrics(self, b:bool) -> None: ...
    def setWrapMode(self, wrap:PySide2.QtGui.QTextOption.WrapMode) -> None: ...
    def tabArray(self) -> typing.List: ...
    def tabStop(self) -> float: ...
    def tabStopDistance(self) -> float: ...
    def tabs(self) -> typing.List: ...
    def textDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def useDesignMetrics(self) -> bool: ...
    def wrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...


class QTextTable(PySide2.QtGui.QTextFrame):

    def __init__(self, doc:PySide2.QtGui.QTextDocument) -> None: ...

    def appendColumns(self, count:int) -> None: ...
    def appendRows(self, count:int) -> None: ...
    @typing.overload
    def cellAt(self, c:PySide2.QtGui.QTextCursor) -> PySide2.QtGui.QTextTableCell: ...
    @typing.overload
    def cellAt(self, position:int) -> PySide2.QtGui.QTextTableCell: ...
    @typing.overload
    def cellAt(self, row:int, col:int) -> PySide2.QtGui.QTextTableCell: ...
    def columns(self) -> int: ...
    def format(self) -> PySide2.QtGui.QTextTableFormat: ...
    def insertColumns(self, pos:int, num:int) -> None: ...
    def insertRows(self, pos:int, num:int) -> None: ...
    @typing.overload
    def mergeCells(self, cursor:PySide2.QtGui.QTextCursor) -> None: ...
    @typing.overload
    def mergeCells(self, row:int, col:int, numRows:int, numCols:int) -> None: ...
    def removeColumns(self, pos:int, num:int) -> None: ...
    def removeRows(self, pos:int, num:int) -> None: ...
    def resize(self, rows:int, cols:int) -> None: ...
    def rowEnd(self, c:PySide2.QtGui.QTextCursor) -> PySide2.QtGui.QTextCursor: ...
    def rowStart(self, c:PySide2.QtGui.QTextCursor) -> PySide2.QtGui.QTextCursor: ...
    def rows(self) -> int: ...
    @typing.overload
    def setFormat(self, format:PySide2.QtGui.QTextFormat) -> None: ...
    @typing.overload
    def setFormat(self, format:PySide2.QtGui.QTextTableFormat) -> None: ...
    def splitCell(self, row:int, col:int, numRows:int, numCols:int) -> None: ...


class QTextTableCell(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o:PySide2.QtGui.QTextTableCell) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def begin(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def column(self) -> int: ...
    def columnSpan(self) -> int: ...
    def end(self) -> PySide2.QtGui.QTextFrame.iterator: ...
    def firstCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def firstPosition(self) -> int: ...
    def format(self) -> PySide2.QtGui.QTextCharFormat: ...
    def isValid(self) -> bool: ...
    def lastCursorPosition(self) -> PySide2.QtGui.QTextCursor: ...
    def lastPosition(self) -> int: ...
    def row(self) -> int: ...
    def rowSpan(self) -> int: ...
    def setFormat(self, format:PySide2.QtGui.QTextCharFormat) -> None: ...
    def tableCellFormatIndex(self) -> int: ...


class QTextTableCellFormat(PySide2.QtGui.QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextTableCellFormat:PySide2.QtGui.QTextTableCellFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt:PySide2.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bottomBorder(self) -> float: ...
    def bottomBorderBrush(self) -> PySide2.QtGui.QBrush: ...
    def bottomBorderStyle(self) -> PySide2.QtGui.QTextFrameFormat.BorderStyle: ...
    def bottomPadding(self) -> float: ...
    def isValid(self) -> bool: ...
    def leftBorder(self) -> float: ...
    def leftBorderBrush(self) -> PySide2.QtGui.QBrush: ...
    def leftBorderStyle(self) -> PySide2.QtGui.QTextFrameFormat.BorderStyle: ...
    def leftPadding(self) -> float: ...
    def rightBorder(self) -> float: ...
    def rightBorderBrush(self) -> PySide2.QtGui.QBrush: ...
    def rightBorderStyle(self) -> PySide2.QtGui.QTextFrameFormat.BorderStyle: ...
    def rightPadding(self) -> float: ...
    def setBorder(self, width:float) -> None: ...
    def setBorderBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setBorderStyle(self, style:PySide2.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomBorder(self, width:float) -> None: ...
    def setBottomBorderBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setBottomBorderStyle(self, style:PySide2.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setBottomPadding(self, padding:float) -> None: ...
    def setLeftBorder(self, width:float) -> None: ...
    def setLeftBorderBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setLeftBorderStyle(self, style:PySide2.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setLeftPadding(self, padding:float) -> None: ...
    def setPadding(self, padding:float) -> None: ...
    def setRightBorder(self, width:float) -> None: ...
    def setRightBorderBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setRightBorderStyle(self, style:PySide2.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setRightPadding(self, padding:float) -> None: ...
    def setTopBorder(self, width:float) -> None: ...
    def setTopBorderBrush(self, brush:PySide2.QtGui.QBrush) -> None: ...
    def setTopBorderStyle(self, style:PySide2.QtGui.QTextFrameFormat.BorderStyle) -> None: ...
    def setTopPadding(self, padding:float) -> None: ...
    def topBorder(self) -> float: ...
    def topBorderBrush(self) -> PySide2.QtGui.QBrush: ...
    def topBorderStyle(self) -> PySide2.QtGui.QTextFrameFormat.BorderStyle: ...
    def topPadding(self) -> float: ...


class QTextTableFormat(PySide2.QtGui.QTextFrameFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, QTextTableFormat:PySide2.QtGui.QTextTableFormat) -> None: ...
    @typing.overload
    def __init__(self, fmt:PySide2.QtGui.QTextFormat) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def borderCollapse(self) -> bool: ...
    def cellPadding(self) -> float: ...
    def cellSpacing(self) -> float: ...
    def clearColumnWidthConstraints(self) -> None: ...
    def columnWidthConstraints(self) -> typing.List: ...
    def columns(self) -> int: ...
    def headerRowCount(self) -> int: ...
    def isValid(self) -> bool: ...
    def setAlignment(self, alignment:PySide2.QtCore.Qt.Alignment) -> None: ...
    def setBorderCollapse(self, borderCollapse:bool) -> None: ...
    def setCellPadding(self, padding:float) -> None: ...
    def setCellSpacing(self, spacing:float) -> None: ...
    def setColumnWidthConstraints(self, constraints:typing.List) -> None: ...
    def setColumns(self, columns:int) -> None: ...
    def setHeaderRowCount(self, count:int) -> None: ...


class QToolBarChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, t:bool) -> None: ...

    def toggle(self) -> bool: ...


class QTouchDevice(Shiboken.Object):
    TouchScreen              : QTouchDevice = ... # 0x0
    Position                 : QTouchDevice = ... # 0x1
    TouchPad                 : QTouchDevice = ... # 0x1
    Area                     : QTouchDevice = ... # 0x2
    Pressure                 : QTouchDevice = ... # 0x4
    Velocity                 : QTouchDevice = ... # 0x8
    RawPositions             : QTouchDevice = ... # 0x10
    NormalizedPosition       : QTouchDevice = ... # 0x20
    MouseEmulation           : QTouchDevice = ... # 0x40

    class Capabilities(object): ...

    class CapabilityFlag(object):
        Position                 : QTouchDevice.CapabilityFlag = ... # 0x1
        Area                     : QTouchDevice.CapabilityFlag = ... # 0x2
        Pressure                 : QTouchDevice.CapabilityFlag = ... # 0x4
        Velocity                 : QTouchDevice.CapabilityFlag = ... # 0x8
        RawPositions             : QTouchDevice.CapabilityFlag = ... # 0x10
        NormalizedPosition       : QTouchDevice.CapabilityFlag = ... # 0x20
        MouseEmulation           : QTouchDevice.CapabilityFlag = ... # 0x40

    class DeviceType(object):
        TouchScreen              : QTouchDevice.DeviceType = ... # 0x0
        TouchPad                 : QTouchDevice.DeviceType = ... # 0x1

    def __init__(self) -> None: ...

    def capabilities(self) -> PySide2.QtGui.QTouchDevice.Capabilities: ...
    @staticmethod
    def devices() -> typing.List: ...
    def maximumTouchPoints(self) -> int: ...
    def name(self) -> str: ...
    def setCapabilities(self, caps:PySide2.QtGui.QTouchDevice.Capabilities) -> None: ...
    def setMaximumTouchPoints(self, max:int) -> None: ...
    def setName(self, name:str) -> None: ...
    def setType(self, devType:PySide2.QtGui.QTouchDevice.DeviceType) -> None: ...
    def type(self) -> PySide2.QtGui.QTouchDevice.DeviceType: ...


class QTouchEvent(PySide2.QtGui.QInputEvent):

    class TouchPoint(Shiboken.Object):
        Pen                      : QTouchEvent.TouchPoint = ... # 0x1
        Token                    : QTouchEvent.TouchPoint = ... # 0x2

        class InfoFlag(object):
            Pen                      : QTouchEvent.TouchPoint.InfoFlag = ... # 0x1
            Token                    : QTouchEvent.TouchPoint.InfoFlag = ... # 0x2

        class InfoFlags(object): ...

        @typing.overload
        def __init__(self, id:int=...) -> None: ...
        @typing.overload
        def __init__(self, other:PySide2.QtGui.QTouchEvent.TouchPoint) -> None: ...

        @staticmethod
        def __copy__() -> None: ...
        def ellipseDiameters(self) -> PySide2.QtCore.QSizeF: ...
        def flags(self) -> PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags: ...
        def id(self) -> int: ...
        def lastNormalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def lastPos(self) -> PySide2.QtCore.QPointF: ...
        def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
        def lastScreenPos(self) -> PySide2.QtCore.QPointF: ...
        def normalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def pos(self) -> PySide2.QtCore.QPointF: ...
        def pressure(self) -> float: ...
        def rawScreenPositions(self) -> typing.List: ...
        def rect(self) -> PySide2.QtCore.QRectF: ...
        def rotation(self) -> float: ...
        def scenePos(self) -> PySide2.QtCore.QPointF: ...
        def sceneRect(self) -> PySide2.QtCore.QRectF: ...
        def screenPos(self) -> PySide2.QtCore.QPointF: ...
        def screenRect(self) -> PySide2.QtCore.QRectF: ...
        def setEllipseDiameters(self, dia:PySide2.QtCore.QSizeF) -> None: ...
        def setFlags(self, flags:PySide2.QtGui.QTouchEvent.TouchPoint.InfoFlags) -> None: ...
        def setId(self, id:int) -> None: ...
        def setLastNormalizedPos(self, lastNormalizedPos:PySide2.QtCore.QPointF) -> None: ...
        def setLastPos(self, lastPos:PySide2.QtCore.QPointF) -> None: ...
        def setLastScenePos(self, lastScenePos:PySide2.QtCore.QPointF) -> None: ...
        def setLastScreenPos(self, lastScreenPos:PySide2.QtCore.QPointF) -> None: ...
        def setNormalizedPos(self, normalizedPos:PySide2.QtCore.QPointF) -> None: ...
        def setPos(self, pos:PySide2.QtCore.QPointF) -> None: ...
        def setPressure(self, pressure:float) -> None: ...
        def setRawScreenPositions(self, positions:typing.List) -> None: ...
        def setRect(self, rect:PySide2.QtCore.QRectF) -> None: ...
        def setRotation(self, angle:float) -> None: ...
        def setScenePos(self, scenePos:PySide2.QtCore.QPointF) -> None: ...
        def setSceneRect(self, sceneRect:PySide2.QtCore.QRectF) -> None: ...
        def setScreenPos(self, screenPos:PySide2.QtCore.QPointF) -> None: ...
        def setScreenRect(self, screenRect:PySide2.QtCore.QRectF) -> None: ...
        def setStartNormalizedPos(self, startNormalizedPos:PySide2.QtCore.QPointF) -> None: ...
        def setStartPos(self, startPos:PySide2.QtCore.QPointF) -> None: ...
        def setStartScenePos(self, startScenePos:PySide2.QtCore.QPointF) -> None: ...
        def setStartScreenPos(self, startScreenPos:PySide2.QtCore.QPointF) -> None: ...
        def setState(self, state:PySide2.QtCore.Qt.TouchPointStates) -> None: ...
        def setUniqueId(self, uid:int) -> None: ...
        def setVelocity(self, v:PySide2.QtGui.QVector2D) -> None: ...
        def startNormalizedPos(self) -> PySide2.QtCore.QPointF: ...
        def startPos(self) -> PySide2.QtCore.QPointF: ...
        def startScenePos(self) -> PySide2.QtCore.QPointF: ...
        def startScreenPos(self) -> PySide2.QtCore.QPointF: ...
        def state(self) -> PySide2.QtCore.Qt.TouchPointState: ...
        def swap(self, other:PySide2.QtGui.QTouchEvent.TouchPoint) -> None: ...
        def uniqueId(self) -> PySide2.QtGui.QPointingDeviceUniqueId: ...
        def velocity(self) -> PySide2.QtGui.QVector2D: ...

    def __init__(self, eventType:PySide2.QtCore.QEvent.Type, device:typing.Optional[PySide2.QtGui.QTouchDevice]=..., modifiers:PySide2.QtCore.Qt.KeyboardModifiers=..., touchPointStates:PySide2.QtCore.Qt.TouchPointStates=..., touchPoints:typing.Sequence=...) -> None: ...

    def device(self) -> PySide2.QtGui.QTouchDevice: ...
    def setDevice(self, adevice:PySide2.QtGui.QTouchDevice) -> None: ...
    def setTarget(self, atarget:PySide2.QtCore.QObject) -> None: ...
    def setTouchPointStates(self, aTouchPointStates:PySide2.QtCore.Qt.TouchPointStates) -> None: ...
    def setTouchPoints(self, atouchPoints:typing.Sequence) -> None: ...
    def setWindow(self, awindow:PySide2.QtGui.QWindow) -> None: ...
    def target(self) -> PySide2.QtCore.QObject: ...
    def touchPointStates(self) -> PySide2.QtCore.Qt.TouchPointStates: ...
    def touchPoints(self) -> typing.List: ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QTransform(Shiboken.Object):
    TxNone                   : QTransform = ... # 0x0
    TxTranslate              : QTransform = ... # 0x1
    TxScale                  : QTransform = ... # 0x2
    TxRotate                 : QTransform = ... # 0x4
    TxShear                  : QTransform = ... # 0x8
    TxProject                : QTransform = ... # 0x10

    class TransformationType(object):
        TxNone                   : QTransform.TransformationType = ... # 0x0
        TxTranslate              : QTransform.TransformationType = ... # 0x1
        TxScale                  : QTransform.TransformationType = ... # 0x2
        TxRotate                 : QTransform.TransformationType = ... # 0x4
        TxShear                  : QTransform.TransformationType = ... # 0x8
        TxProject                : QTransform.TransformationType = ... # 0x10

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, h11:float, h12:float, h13:float, h21:float, h22:float, h23:float, h31:float, h32:float, h33:float=...) -> None: ...
    @typing.overload
    def __init__(self, h11:float, h12:float, h21:float, h22:float, dx:float, dy:float) -> None: ...
    @typing.overload
    def __init__(self, mtx:PySide2.QtGui.QMatrix) -> None: ...
    @typing.overload
    def __init__(self, other:PySide2.QtGui.QTransform) -> None: ...

    def __add__(self, n:float) -> PySide2.QtGui.QTransform: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, div:float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __imul__(self, arg__1:PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __imul__(self, div:float) -> PySide2.QtGui.QTransform: ...
    def __isub__(self, div:float) -> PySide2.QtGui.QTransform: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, l:PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def __mul__(self, l:PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def __mul__(self, n:float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __mul__(self, o:PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    def __mul__(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, p:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, n:float) -> PySide2.QtGui.QTransform: ...
    def adjoint(self) -> PySide2.QtGui.QTransform: ...
    def det(self) -> float: ...
    def determinant(self) -> float: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @staticmethod
    def fromScale(dx:float, dy:float) -> PySide2.QtGui.QTransform: ...
    @staticmethod
    def fromTranslate(dx:float, dy:float) -> PySide2.QtGui.QTransform: ...
    def inverted(self) -> typing.Tuple: ...
    def isAffine(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def isRotating(self) -> bool: ...
    def isScaling(self) -> bool: ...
    def isTranslating(self) -> bool: ...
    def m11(self) -> float: ...
    def m12(self) -> float: ...
    def m13(self) -> float: ...
    def m21(self) -> float: ...
    def m22(self) -> float: ...
    def m23(self) -> float: ...
    def m31(self) -> float: ...
    def m32(self) -> float: ...
    def m33(self) -> float: ...
    @typing.overload
    def map(self, a:PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def map(self, a:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def map(self, l:PySide2.QtCore.QLine) -> PySide2.QtCore.QLine: ...
    @typing.overload
    def map(self, l:PySide2.QtCore.QLineF) -> PySide2.QtCore.QLineF: ...
    @typing.overload
    def map(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def map(self, p:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def map(self, p:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def map(self, r:PySide2.QtGui.QRegion) -> PySide2.QtGui.QRegion: ...
    @typing.overload
    def map(self, x:float, y:float) -> typing.Tuple: ...
    @typing.overload
    def mapRect(self, arg__1:PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def mapRect(self, arg__1:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def mapToPolygon(self, r:PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    @staticmethod
    def quadToQuad(arg__1:PySide2.QtGui.QPolygonF, arg__2:PySide2.QtGui.QPolygonF) -> object: ...
    @typing.overload
    @staticmethod
    def quadToQuad(one:PySide2.QtGui.QPolygonF, two:PySide2.QtGui.QPolygonF, result:PySide2.QtGui.QTransform) -> bool: ...
    @typing.overload
    @staticmethod
    def quadToSquare(arg__1:PySide2.QtGui.QPolygonF) -> object: ...
    @typing.overload
    @staticmethod
    def quadToSquare(quad:PySide2.QtGui.QPolygonF, result:PySide2.QtGui.QTransform) -> bool: ...
    def reset(self) -> None: ...
    def rotate(self, a:float, axis:PySide2.QtCore.Qt.Axis=...) -> PySide2.QtGui.QTransform: ...
    def rotateRadians(self, a:float, axis:PySide2.QtCore.Qt.Axis=...) -> PySide2.QtGui.QTransform: ...
    def scale(self, sx:float, sy:float) -> PySide2.QtGui.QTransform: ...
    def setMatrix(self, m11:float, m12:float, m13:float, m21:float, m22:float, m23:float, m31:float, m32:float, m33:float) -> None: ...
    def shear(self, sh:float, sv:float) -> PySide2.QtGui.QTransform: ...
    @typing.overload
    @staticmethod
    def squareToQuad(arg__1:PySide2.QtGui.QPolygonF) -> object: ...
    @typing.overload
    @staticmethod
    def squareToQuad(square:PySide2.QtGui.QPolygonF, result:PySide2.QtGui.QTransform) -> bool: ...
    def toAffine(self) -> PySide2.QtGui.QMatrix: ...
    def translate(self, dx:float, dy:float) -> PySide2.QtGui.QTransform: ...
    def transposed(self) -> PySide2.QtGui.QTransform: ...
    def type(self) -> PySide2.QtGui.QTransform.TransformationType: ...


class QValidator(PySide2.QtCore.QObject):
    Invalid                  : QValidator = ... # 0x0
    Intermediate             : QValidator = ... # 0x1
    Acceptable               : QValidator = ... # 0x2

    class State(object):
        Invalid                  : QValidator.State = ... # 0x0
        Intermediate             : QValidator.State = ... # 0x1
        Acceptable               : QValidator.State = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def fixup(self, arg__1:str) -> None: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale) -> None: ...
    def validate(self, arg__1:str, arg__2:int) -> PySide2.QtGui.QValidator.State: ...


class QVector2D(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def __init__(self, xpos:float, ypos:float) -> None: ...

    def __add__(self, v2:PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector:PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    @typing.overload
    def __imul__(self, factor:float) -> PySide2.QtGui.QVector2D: ...
    @typing.overload
    def __imul__(self, vector:PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def __isub__(self, vector:PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide2.QtGui.QVector2D: ...
    @typing.overload
    def __mul__(self, v2:PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def __neg__(self) -> PySide2.QtGui.QVector2D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, v2:PySide2.QtGui.QVector2D) -> PySide2.QtGui.QVector2D: ...
    def distanceToLine(self, point:PySide2.QtGui.QVector2D, direction:PySide2.QtGui.QVector2D) -> float: ...
    def distanceToPoint(self, point:PySide2.QtGui.QVector2D) -> float: ...
    @staticmethod
    def dotProduct(v1:PySide2.QtGui.QVector2D, v2:PySide2.QtGui.QVector2D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide2.QtGui.QVector2D: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector3D(self) -> PySide2.QtGui.QVector3D: ...
    def toVector4D(self) -> PySide2.QtGui.QVector4D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...


class QVector3D(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector2D, zpos:float) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector4D) -> None: ...
    @typing.overload
    def __init__(self, xpos:float, ypos:float, zpos:float) -> None: ...

    def __add__(self, v2:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __imul__(self, factor:float) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __imul__(self, vector:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def __isub__(self, vector:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, matrix:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, quaternion:PySide2.QtGui.QQuaternion) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    def __mul__(self, v2:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def __neg__(self) -> PySide2.QtGui.QVector3D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, v2:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @staticmethod
    def crossProduct(v1:PySide2.QtGui.QVector3D, v2:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def distanceToLine(self, point:PySide2.QtGui.QVector3D, direction:PySide2.QtGui.QVector3D) -> float: ...
    @typing.overload
    def distanceToPlane(self, plane1:PySide2.QtGui.QVector3D, plane2:PySide2.QtGui.QVector3D, plane3:PySide2.QtGui.QVector3D) -> float: ...
    @typing.overload
    def distanceToPlane(self, plane:PySide2.QtGui.QVector3D, normal:PySide2.QtGui.QVector3D) -> float: ...
    def distanceToPoint(self, point:PySide2.QtGui.QVector3D) -> float: ...
    @staticmethod
    def dotProduct(v1:PySide2.QtGui.QVector3D, v2:PySide2.QtGui.QVector3D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    @typing.overload
    @staticmethod
    def normal(v1:PySide2.QtGui.QVector3D, v2:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    @typing.overload
    @staticmethod
    def normal(v1:PySide2.QtGui.QVector3D, v2:PySide2.QtGui.QVector3D, v3:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QVector3D: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide2.QtGui.QVector3D: ...
    def project(self, modelView:PySide2.QtGui.QMatrix4x4, projection:PySide2.QtGui.QMatrix4x4, viewport:PySide2.QtCore.QRect) -> PySide2.QtGui.QVector3D: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def setZ(self, z:float) -> None: ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide2.QtGui.QVector2D: ...
    def toVector4D(self) -> PySide2.QtGui.QVector4D: ...
    def unproject(self, modelView:PySide2.QtGui.QMatrix4x4, projection:PySide2.QtGui.QMatrix4x4, viewport:PySide2.QtCore.QRect) -> PySide2.QtGui.QVector3D: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QVector4D(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point:PySide2.QtCore.QPointF) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector2D) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector2D, zpos:float, wpos:float) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, vector:PySide2.QtGui.QVector3D, wpos:float) -> None: ...
    @typing.overload
    def __init__(self, xpos:float, ypos:float, zpos:float, wpos:float) -> None: ...

    def __add__(self, v2:PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, vector:PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __imul__(self, factor:float) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __imul__(self, vector:PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    def __isub__(self, vector:PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    @typing.overload
    def __mul__(self, factor:float) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __mul__(self, matrix:PySide2.QtGui.QMatrix4x4) -> PySide2.QtGui.QVector4D: ...
    @typing.overload
    def __mul__(self, v2:PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    def __neg__(self) -> PySide2.QtGui.QVector4D: ...
    def __reduce__(self) -> object: ...
    def __repr__(self) -> object: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __sub__(self, v2:PySide2.QtGui.QVector4D) -> PySide2.QtGui.QVector4D: ...
    @staticmethod
    def dotProduct(v1:PySide2.QtGui.QVector4D, v2:PySide2.QtGui.QVector4D) -> float: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> PySide2.QtGui.QVector4D: ...
    def setW(self, w:float) -> None: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def setZ(self, z:float) -> None: ...
    def toPoint(self) -> PySide2.QtCore.QPoint: ...
    def toPointF(self) -> PySide2.QtCore.QPointF: ...
    def toTuple(self) -> object: ...
    def toVector2D(self) -> PySide2.QtGui.QVector2D: ...
    def toVector2DAffine(self) -> PySide2.QtGui.QVector2D: ...
    def toVector3D(self) -> PySide2.QtGui.QVector3D: ...
    def toVector3DAffine(self) -> PySide2.QtGui.QVector3D: ...
    def w(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QWhatsThisClickedEvent(PySide2.QtCore.QEvent):

    def __init__(self, href:str) -> None: ...

    def href(self) -> str: ...


class QWheelEvent(PySide2.QtGui.QInputEvent):

    @typing.overload
    def __init__(self, pos:PySide2.QtCore.QPointF, delta:int, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, orient:PySide2.QtCore.Qt.Orientation=...) -> None: ...
    @typing.overload
    def __init__(self, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, delta:int, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, orient:PySide2.QtCore.Qt.Orientation=...) -> None: ...
    @typing.overload
    def __init__(self, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, pixelDelta:PySide2.QtCore.QPoint, angleDelta:PySide2.QtCore.QPoint, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, phase:PySide2.QtCore.Qt.ScrollPhase, inverted:bool, source:PySide2.QtCore.Qt.MouseEventSource=...) -> None: ...
    @typing.overload
    def __init__(self, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, pixelDelta:PySide2.QtCore.QPoint, angleDelta:PySide2.QtCore.QPoint, qt4Delta:int, qt4Orientation:PySide2.QtCore.Qt.Orientation, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> None: ...
    @typing.overload
    def __init__(self, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, pixelDelta:PySide2.QtCore.QPoint, angleDelta:PySide2.QtCore.QPoint, qt4Delta:int, qt4Orientation:PySide2.QtCore.Qt.Orientation, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, phase:PySide2.QtCore.Qt.ScrollPhase) -> None: ...
    @typing.overload
    def __init__(self, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, pixelDelta:PySide2.QtCore.QPoint, angleDelta:PySide2.QtCore.QPoint, qt4Delta:int, qt4Orientation:PySide2.QtCore.Qt.Orientation, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, phase:PySide2.QtCore.Qt.ScrollPhase, source:PySide2.QtCore.Qt.MouseEventSource) -> None: ...
    @typing.overload
    def __init__(self, pos:PySide2.QtCore.QPointF, globalPos:PySide2.QtCore.QPointF, pixelDelta:PySide2.QtCore.QPoint, angleDelta:PySide2.QtCore.QPoint, qt4Delta:int, qt4Orientation:PySide2.QtCore.Qt.Orientation, buttons:PySide2.QtCore.Qt.MouseButtons, modifiers:PySide2.QtCore.Qt.KeyboardModifiers, phase:PySide2.QtCore.Qt.ScrollPhase, source:PySide2.QtCore.Qt.MouseEventSource, inverted:bool) -> None: ...

    def angleDelta(self) -> PySide2.QtCore.QPoint: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def delta(self) -> int: ...
    def globalPos(self) -> PySide2.QtCore.QPoint: ...
    def globalPosF(self) -> PySide2.QtCore.QPointF: ...
    def globalPosition(self) -> PySide2.QtCore.QPointF: ...
    def globalX(self) -> int: ...
    def globalY(self) -> int: ...
    def inverted(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def phase(self) -> PySide2.QtCore.Qt.ScrollPhase: ...
    def pixelDelta(self) -> PySide2.QtCore.QPoint: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def posF(self) -> PySide2.QtCore.QPointF: ...
    def position(self) -> PySide2.QtCore.QPointF: ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWindow(PySide2.QtCore.QObject, PySide2.QtGui.QSurface):
    ExcludeTransients        : QWindow = ... # 0x0
    Hidden                   : QWindow = ... # 0x0
    AutomaticVisibility      : QWindow = ... # 0x1
    IncludeTransients        : QWindow = ... # 0x1
    Windowed                 : QWindow = ... # 0x2
    Minimized                : QWindow = ... # 0x3
    Maximized                : QWindow = ... # 0x4
    FullScreen               : QWindow = ... # 0x5

    class AncestorMode(object):
        ExcludeTransients        : QWindow.AncestorMode = ... # 0x0
        IncludeTransients        : QWindow.AncestorMode = ... # 0x1

    class Visibility(object):
        Hidden                   : QWindow.Visibility = ... # 0x0
        AutomaticVisibility      : QWindow.Visibility = ... # 0x1
        Windowed                 : QWindow.Visibility = ... # 0x2
        Minimized                : QWindow.Visibility = ... # 0x3
        Maximized                : QWindow.Visibility = ... # 0x4
        FullScreen               : QWindow.Visibility = ... # 0x5

    @typing.overload
    def __init__(self, parent:PySide2.QtGui.QWindow) -> None: ...
    @typing.overload
    def __init__(self, screen:typing.Optional[PySide2.QtGui.QScreen]=...) -> None: ...

    def accessibleRoot(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def alert(self, msec:int) -> None: ...
    def baseSize(self) -> PySide2.QtCore.QSize: ...
    def close(self) -> bool: ...
    def contentOrientation(self) -> PySide2.QtCore.Qt.ScreenOrientation: ...
    def create(self) -> None: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def destroy(self) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def exposeEvent(self, arg__1:PySide2.QtGui.QExposeEvent) -> None: ...
    def filePath(self) -> str: ...
    def flags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def focusInEvent(self, arg__1:PySide2.QtGui.QFocusEvent) -> None: ...
    def focusObject(self) -> PySide2.QtCore.QObject: ...
    def focusOutEvent(self, arg__1:PySide2.QtGui.QFocusEvent) -> None: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def frameGeometry(self) -> PySide2.QtCore.QRect: ...
    def frameMargins(self) -> PySide2.QtCore.QMargins: ...
    def framePosition(self) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def fromWinId(id:int) -> PySide2.QtGui.QWindow: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def height(self) -> int: ...
    def hide(self) -> None: ...
    def hideEvent(self, arg__1:PySide2.QtGui.QHideEvent) -> None: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child:PySide2.QtGui.QWindow, mode:PySide2.QtGui.QWindow.AncestorMode=...) -> bool: ...
    def isExposed(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1:PySide2.QtGui.QKeyEvent) -> None: ...
    def lower(self) -> None: ...
    def mapFromGlobal(self, pos:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToGlobal(self, pos:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> PySide2.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def modality(self) -> PySide2.QtCore.Qt.WindowModality: ...
    def mouseDoubleClickEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, arg__1:PySide2.QtGui.QMoveEvent) -> None: ...
    def nativeEvent(self, eventType:PySide2.QtCore.QByteArray, message:int) -> typing.Tuple: ...
    def opacity(self) -> float: ...
    @typing.overload
    def parent(self) -> PySide2.QtGui.QWindow: ...
    @typing.overload
    def parent(self, mode:PySide2.QtGui.QWindow.AncestorMode) -> PySide2.QtGui.QWindow: ...
    def position(self) -> PySide2.QtCore.QPoint: ...
    def raise_(self) -> None: ...
    def reportContentOrientationChange(self, orientation:PySide2.QtCore.Qt.ScreenOrientation) -> None: ...
    def requestActivate(self) -> None: ...
    def requestUpdate(self) -> None: ...
    def requestedFormat(self) -> PySide2.QtGui.QSurfaceFormat: ...
    @typing.overload
    def resize(self, newSize:PySide2.QtCore.QSize) -> None: ...
    @typing.overload
    def resize(self, w:int, h:int) -> None: ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent) -> None: ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    def setBaseSize(self, size:PySide2.QtCore.QSize) -> None: ...
    def setCursor(self, arg__1:PySide2.QtGui.QCursor) -> None: ...
    def setFilePath(self, filePath:str) -> None: ...
    def setFlag(self, arg__1:PySide2.QtCore.Qt.WindowType, on:bool=...) -> None: ...
    def setFlags(self, flags:PySide2.QtCore.Qt.WindowFlags) -> None: ...
    def setFormat(self, format:PySide2.QtGui.QSurfaceFormat) -> None: ...
    def setFramePosition(self, point:PySide2.QtCore.QPoint) -> None: ...
    @typing.overload
    def setGeometry(self, posx:int, posy:int, w:int, h:int) -> None: ...
    @typing.overload
    def setGeometry(self, rect:PySide2.QtCore.QRect) -> None: ...
    def setHeight(self, arg:int) -> None: ...
    def setIcon(self, icon:PySide2.QtGui.QIcon) -> None: ...
    def setKeyboardGrabEnabled(self, grab:bool) -> bool: ...
    def setMask(self, region:PySide2.QtGui.QRegion) -> None: ...
    def setMaximumHeight(self, h:int) -> None: ...
    def setMaximumSize(self, size:PySide2.QtCore.QSize) -> None: ...
    def setMaximumWidth(self, w:int) -> None: ...
    def setMinimumHeight(self, h:int) -> None: ...
    def setMinimumSize(self, size:PySide2.QtCore.QSize) -> None: ...
    def setMinimumWidth(self, w:int) -> None: ...
    def setModality(self, modality:PySide2.QtCore.Qt.WindowModality) -> None: ...
    def setMouseGrabEnabled(self, grab:bool) -> bool: ...
    def setOpacity(self, level:float) -> None: ...
    @typing.overload
    def setParent(self, parent:PySide2.QtCore.QObject) -> None: ...
    @typing.overload
    def setParent(self, parent:PySide2.QtGui.QWindow) -> None: ...
    @typing.overload
    def setPosition(self, posx:int, posy:int) -> None: ...
    @typing.overload
    def setPosition(self, pt:PySide2.QtCore.QPoint) -> None: ...
    def setScreen(self, screen:PySide2.QtGui.QScreen) -> None: ...
    def setSizeIncrement(self, size:PySide2.QtCore.QSize) -> None: ...
    def setSurfaceType(self, surfaceType:PySide2.QtGui.QSurface.SurfaceType) -> None: ...
    def setTitle(self, arg__1:str) -> None: ...
    def setTransientParent(self, parent:PySide2.QtGui.QWindow) -> None: ...
    def setVisibility(self, v:PySide2.QtGui.QWindow.Visibility) -> None: ...
    def setVisible(self, visible:bool) -> None: ...
    def setWidth(self, arg:int) -> None: ...
    def setWindowState(self, state:PySide2.QtCore.Qt.WindowState) -> None: ...
    def setWindowStates(self, states:PySide2.QtCore.Qt.WindowStates) -> None: ...
    def setX(self, arg:int) -> None: ...
    def setY(self, arg:int) -> None: ...
    def show(self) -> None: ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def showNormal(self) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide2.QtCore.QSize: ...
    def startSystemMove(self) -> bool: ...
    def startSystemResize(self, edges:PySide2.QtCore.Qt.Edges) -> bool: ...
    def surfaceHandle(self) -> int: ...
    def surfaceType(self) -> PySide2.QtGui.QSurface.SurfaceType: ...
    def tabletEvent(self, arg__1:PySide2.QtGui.QTabletEvent) -> None: ...
    def title(self) -> str: ...
    def touchEvent(self, arg__1:PySide2.QtGui.QTouchEvent) -> None: ...
    def transientParent(self) -> PySide2.QtGui.QWindow: ...
    def type(self) -> PySide2.QtCore.Qt.WindowType: ...
    def unsetCursor(self) -> None: ...
    def visibility(self) -> PySide2.QtGui.QWindow.Visibility: ...
    def wheelEvent(self, arg__1:PySide2.QtGui.QWheelEvent) -> None: ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def windowState(self) -> PySide2.QtCore.Qt.WindowState: ...
    def windowStates(self) -> PySide2.QtCore.Qt.WindowStates: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWindowStateChangeEvent(PySide2.QtCore.QEvent):

    def __init__(self, aOldState:PySide2.QtCore.Qt.WindowStates, isOverride:bool=...) -> None: ...

    def isOverride(self) -> bool: ...
    def oldState(self) -> PySide2.QtCore.Qt.WindowStates: ...


class Qt(PySide2.QtCore.Qt):
    @staticmethod
    def codecForHtml(ba:PySide2.QtCore.QByteArray) -> PySide2.QtCore.QTextCodec: ...
    @staticmethod
    def convertFromPlainText(plain:str, mode:PySide2.QtCore.Qt.WhiteSpaceMode=...) -> str: ...
    @staticmethod
    def mightBeRichText(arg__1:str) -> bool: ...
@staticmethod
def qAlpha(rgb:int) -> int: ...
@staticmethod
def qBlue(rgb:int) -> int: ...
@typing.overload
@staticmethod
def qGray(r:int, g:int, b:int) -> int: ...
@typing.overload
@staticmethod
def qGray(rgb:int) -> int: ...
@staticmethod
def qGreen(rgb:int) -> int: ...
@staticmethod
def qIsGray(rgb:int) -> bool: ...
@staticmethod
def qRed(rgb:int) -> int: ...
@staticmethod
def qRgb(r:int, g:int, b:int) -> int: ...
@staticmethod
def qRgba(r:int, g:int, b:int, a:int) -> int: ...

# eof
