/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class ProceduralStructureStart
extends StructureStart {
    public List<StructureComponent> queuedComponents = new ArrayList<StructureComponent>();
    protected List<Weight> componentWeightList;
    protected int sizeLimit = 50;
    protected int distanceLimit = 64;

    public ProceduralStructureStart() {
    }

    public ProceduralStructureStart(int chunkX, int chunkZ) {
        super(chunkX, chunkZ);
    }

    public ProceduralStructureStart buildStart(World world, Random rand, StructureComponent starter, Weight ... weights) {
        this.prepareWeights(weights);
        this.field_75075_a.add(starter);
        this.queuedComponents.add(starter);
        while (!this.queuedComponents.isEmpty()) {
            int i = rand.nextInt(this.queuedComponents.size());
            StructureComponent component = this.queuedComponents.remove(i);
            if (!(component instanceof ProceduralComponent)) continue;
            ((ProceduralComponent)component).buildComponent(this, rand);
        }
        this.func_75072_c();
        return this;
    }

    public void prepareWeights(Weight ... weights) {
        this.componentWeightList = new ArrayList<Weight>(weights.length);
        for (int i = 0; i < weights.length; ++i) {
            weights[i].instancesSpawned = 0;
            this.componentWeightList.add(weights[i]);
        }
    }

    public void func_143017_b(NBTTagCompound nbt) {
    }

    public void func_143022_a(NBTTagCompound nbt) {
    }

    protected int getTotalWeight() {
        boolean flag = false;
        int totalWeight = 0;
        for (Weight weight : this.componentWeightList) {
            if (weight.instanceLimit >= 0 && weight.instancesSpawned < weight.instanceLimit) {
                flag = true;
            }
            totalWeight += weight.weight;
        }
        return flag ? totalWeight : -1;
    }

    protected StructureComponent getWeightedComponent(StructureComponent last, Random rand, int minX, int minY, int minZ, int coordMode, int componentType) {
        int totalWeight = this.getTotalWeight();
        if (totalWeight < 0) {
            return null;
        }
        block0: for (int i = 0; i < 5; ++i) {
            int value = rand.nextInt(totalWeight);
            for (Weight weight : this.componentWeightList) {
                if ((value -= weight.weight) >= 0) continue;
                if (!weight.canSpawnStructure(componentType, coordMode, last)) continue block0;
                StructureComponent component = weight.lambda.findValidPlacement(this.field_75075_a, rand, minX, minY, minZ, coordMode, componentType);
                if (component == null) continue;
                ++weight.instancesSpawned;
                if (!weight.canSpawnMoreStructures()) {
                    this.componentWeightList.remove(weight);
                }
                return component;
            }
        }
        return null;
    }

    protected StructureComponent getNextValidComponent(StructureComponent last, Random rand, int minX, int minY, int minZ, int coordMode, int componentType) {
        if (this.field_75075_a.size() > this.sizeLimit) {
            return null;
        }
        if (Math.abs(minX - (this.func_143019_e() * 16 + 8)) <= this.distanceLimit && Math.abs(minZ - (this.func_143018_f() * 16 + 8)) <= this.distanceLimit) {
            StructureComponent structure = this.getWeightedComponent(last, rand, minX, minY, minZ, coordMode, componentType + 1);
            if (structure != null) {
                this.field_75075_a.add(structure);
                this.queuedComponents.add(structure);
            }
            return structure;
        }
        return null;
    }

    public static StructureBoundingBox getComponentToAddBoundingBox(int posX, int posY, int posZ, int offsetX, int offsetY, int offsetZ, int maxX, int maxY, int maxZ, int coordMode) {
        switch (coordMode) {
            default: {
                return new StructureBoundingBox(posX + offsetX, posY + offsetY, posZ + offsetZ, posX + maxX - 1 + offsetX, posY + maxY - 1 + offsetY, posZ + maxZ - 1 + offsetZ);
            }
            case 1: {
                return new StructureBoundingBox(posX - maxZ + 1 - offsetZ, posY + offsetY, posZ + offsetX, posX - offsetZ, posY + maxY - 1 + offsetY, posZ + maxX - 1 + offsetX);
            }
            case 2: {
                return new StructureBoundingBox(posX - maxX + 1 - offsetX, posY + offsetY, posZ - maxZ + 1 - offsetZ, posX - offsetX, posY + maxY - 1 + offsetY, posZ + offsetZ);
            }
            case 3: 
        }
        return new StructureBoundingBox(posX + offsetZ, posY + offsetY, posZ - maxX + 1 - offsetX, posX + maxZ - 1 + offsetZ, posY + maxY - 1 + offsetY, posZ - offsetX);
    }

    protected static class Weight {
        public final instantiateStructure lambda;
        public final int weight;
        public int instancesSpawned;
        public int instanceLimit;

        public Weight(int weight, int limit, instantiateStructure lambda) {
            this.weight = weight;
            this.instanceLimit = limit;
            this.lambda = lambda;
        }

        public boolean canSpawnStructure(int componentAmount, int coordMode, StructureComponent component) {
            return this.instanceLimit < 0 || this.instancesSpawned < this.instanceLimit;
        }

        public boolean canSpawnMoreStructures() {
            return this.instanceLimit < 0 || this.instancesSpawned < this.instanceLimit;
        }
    }

    @FunctionalInterface
    protected static interface instantiateStructure {
        public StructureComponent findValidPlacement(List var1, Random var2, int var3, int var4, int var5, int var6, int var7);
    }

    public static interface ProceduralComponent {
        default public void buildComponent(ProceduralStructureStart start, Random rand) {
        }

        default public StructureComponent getNextComponentNormal(ProceduralStructureStart start, StructureComponent caller, int coordMode, Random rand, int offset, int offsetY) {
            StructureBoundingBox box = caller.func_74874_b();
            switch (coordMode) {
                case 0: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a + offset, box.field_78895_b + offsetY, box.field_78892_f + 1, coordMode, caller.func_74877_c());
                }
                case 1: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a - 1, box.field_78895_b + offsetY, box.field_78896_c + offset, coordMode, caller.func_74877_c());
                }
                case 2: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d - offset, box.field_78895_b + offsetY, box.field_78896_c - 1, coordMode, caller.func_74877_c());
                }
                case 3: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d + 1, box.field_78895_b + offsetY, box.field_78892_f - offset, coordMode, caller.func_74877_c());
                }
            }
            return null;
        }

        default public StructureComponent getNextComponentAntiNormal(ProceduralStructureStart start, StructureComponent caller, int coordMode, Random rand, int offset, int offsetY) {
            StructureBoundingBox box = caller.func_74874_b();
            switch (coordMode) {
                case 0: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d - offset, box.field_78895_b + offsetY, box.field_78896_c - 1, 2, caller.func_74877_c());
                }
                case 1: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d + 1, box.field_78895_b + offsetY, box.field_78892_f - offset, 3, caller.func_74877_c());
                }
                case 2: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a + offset, box.field_78895_b + offsetY, box.field_78892_f + 1, 0, caller.func_74877_c());
                }
                case 3: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a - 1, box.field_78895_b + offsetY, box.field_78896_c + offset, 1, caller.func_74877_c());
                }
            }
            return null;
        }

        default public StructureComponent getNextComponentWest(ProceduralStructureStart start, StructureComponent caller, int coordMode, Random rand, int offset, int offsetY) {
            StructureBoundingBox box = caller.func_74874_b();
            switch (coordMode) {
                case 0: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a - 1, box.field_78895_b + offsetY, box.field_78896_c + offset, 1, caller.func_74877_c());
                }
                case 1: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d - offset, box.field_78895_b + offsetY, box.field_78896_c - 1, 2, caller.func_74877_c());
                }
                case 2: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d + 1, box.field_78895_b + offsetY, box.field_78892_f - offset, 3, caller.func_74877_c());
                }
                case 3: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a + offset, box.field_78895_b + offsetY, box.field_78892_f + 1, 0, caller.func_74877_c());
                }
            }
            return null;
        }

        default public StructureComponent getNextComponentEast(ProceduralStructureStart start, StructureComponent caller, int coordMode, Random rand, int offset, int offsetY) {
            StructureBoundingBox box = caller.func_74874_b();
            switch (coordMode) {
                case 0: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d + 1, box.field_78895_b + offsetY, box.field_78892_f - offset, 3, caller.func_74877_c());
                }
                case 1: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a + offset, box.field_78895_b + offsetY, box.field_78892_f + 1, 0, caller.func_74877_c());
                }
                case 2: {
                    return start.getNextValidComponent(caller, rand, box.field_78897_a - 1, box.field_78895_b + offsetY, box.field_78896_c + offset, 1, caller.func_74877_c());
                }
                case 3: {
                    return start.getNextValidComponent(caller, rand, box.field_78893_d - offset, box.field_78895_b + offsetY, box.field_78896_c - 1, 2, caller.func_74877_c());
                }
            }
            return null;
        }
    }
}

