/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBedrockOreTE;
import com.hbm.config.WorldConfig;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBedrockOre;
import com.hbm.util.WeightedRandomGeneric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BedrockOre {
    public static List<WeightedRandomGeneric<BedrockOreDefinition>> weightedOres = new ArrayList<WeightedRandomGeneric<BedrockOreDefinition>>();
    public static List<WeightedRandomGeneric<BedrockOreDefinition>> weightedOresNether = new ArrayList<WeightedRandomGeneric<BedrockOreDefinition>>();
    public static HashMap<String, BedrockOreDefinition> replacements = new HashMap();

    public static void init() {
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.IRON, 1), WorldConfig.bedrockIronSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.COPPER, 1), WorldConfig.bedrockCopperSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.BORAX, 3, new FluidStack(Fluids.SULFURIC_ACID, 500)), WorldConfig.bedrockBoraxSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.CHLOROCALCITE, 3, new FluidStack(Fluids.SULFURIC_ACID, 500)), WorldConfig.bedrockChlorocalciteSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.ASBESTOS, 2), WorldConfig.bedrockAsbestosSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.NIOBIUM, 2, new FluidStack(Fluids.PEROXIDE, 500)), WorldConfig.bedrockNiobiumSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.NEODYMIUM, 3, new FluidStack(Fluids.PEROXIDE, 500)), WorldConfig.bedrockNeodymiumSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.TITANIUM, 2, new FluidStack(Fluids.SULFURIC_ACID, 500)), WorldConfig.bedrockTitaniumSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.TUNGSTEN, 2, new FluidStack(Fluids.PEROXIDE, 500)), WorldConfig.bedrockTungstenSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.GOLD, 1), WorldConfig.bedrockGoldSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.URANIUM, 4, new FluidStack(Fluids.SULFURIC_ACID, 500)), WorldConfig.bedrockUraniumSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.THORIUM, 4, new FluidStack(Fluids.SULFURIC_ACID, 500)), WorldConfig.bedrockThoriumSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.FLUORITE, 1), WorldConfig.bedrockFluoriteSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(new ItemStack(Items.field_151044_h, 8), 1, 0x202020), WorldConfig.bedrockCoalSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(new ItemStack(ModItems.niter, 4), 2, 0x808080, new FluidStack(Fluids.PEROXIDE, 500)), WorldConfig.bedrockNiterSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(new ItemStack(Items.field_151137_ax, 4), 1, 0xD01010), WorldConfig.bedrockRedstoneSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(new ItemStack(Items.field_151166_bC, 4), 1, 4185477), WorldConfig.bedrockEmeraldSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.RARE), 2, 0x8F9999, new FluidStack(Fluids.PEROXIDE, 500)), WorldConfig.bedrockRareEarthSpawn);
        BedrockOre.registerBedrockOre(weightedOres, new BedrockOreDefinition(OreDictManager.DictFrame.fromOne(ModBlocks.stone_resource, (Enum)BlockEnums.EnumStoneType.BAUXITE, 2), 1, 15692307), WorldConfig.bedrockBauxiteSpawn);
        BedrockOre.registerBedrockOre(weightedOresNether, new BedrockOreDefinition(new ItemStack(Items.field_151114_aO, 4), 1, 16383821), WorldConfig.bedrockGlowstoneSpawn);
        BedrockOre.registerBedrockOre(weightedOresNether, new BedrockOreDefinition(new ItemStack(ModItems.powder_fire, 4), 1, 14103583), WorldConfig.bedrockPhosphorusSpawn);
        BedrockOre.registerBedrockOre(weightedOresNether, new BedrockOreDefinition(new ItemStack(Items.field_151128_bU, 4), 1, 15790045), WorldConfig.bedrockQuartzSpawn);
        replacements.put("ore" + ItemBedrockOre.EnumBedrockOre.IRON.oreName, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.HEMATITE, 1));
        replacements.put("ore" + ItemBedrockOre.EnumBedrockOre.COPPER.oreName, new BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre.MALACHITE, 1));
    }

    public static void registerBedrockOre(List list, BedrockOreDefinition def, int weight) {
        WeightedRandomGeneric<BedrockOreDefinition> weighted = new WeightedRandomGeneric<BedrockOreDefinition>(def, weight);
        list.add(weighted);
    }

    public static void generate(World world, int x, int z, ItemStack stack, FluidStack acid, int color, int tier) {
        BedrockOre.generate(world, x, z, stack, acid, color, tier, ModBlocks.stone_depth);
    }

    public static void generate(World world, int x, int z, ItemStack stack, FluidStack acid, int color, int tier, Block depthRock) {
        int iz;
        int ix;
        for (ix = x - 1; ix <= x + 1; ++ix) {
            for (iz = z - 1; iz <= z + 1; ++iz) {
                Block b = world.func_147439_a(ix, 0, iz);
                if (!b.isReplaceableOreGen(world, ix, 0, iz, Blocks.field_150357_h) || (ix != x || iz != z) && !world.field_73012_v.nextBoolean()) continue;
                world.func_147449_b(ix, 0, iz, ModBlocks.ore_bedrock);
                BlockBedrockOreTE.TileEntityBedrockOre ore = (BlockBedrockOreTE.TileEntityBedrockOre)world.func_147438_o(ix, 0, iz);
                ore.resource = stack;
                ore.color = color;
                ore.shape = world.field_73012_v.nextInt(10);
                ore.acidRequirement = acid;
                ore.tier = tier;
                world.func_147471_g(ix, 0, iz);
                world.func_147476_b(ix, 0, iz, (TileEntity)ore);
            }
        }
        for (ix = x - 3; ix <= x + 3; ++ix) {
            for (iz = z - 3; iz <= z + 3; ++iz) {
                for (int iy = 1; iy < 7; ++iy) {
                    Block b;
                    if (iy >= 3 && world.func_147439_a(ix, iy, iz) != Blocks.field_150357_h || !(b = world.func_147439_a(ix, iy, iz)).isReplaceableOreGen(world, ix, iy, iz, Blocks.field_150348_b) && !b.isReplaceableOreGen(world, ix, iy, iz, Blocks.field_150357_h)) continue;
                    world.func_147449_b(ix, iy, iz, depthRock);
                }
            }
        }
    }

    public static class BedrockOreDefinition {
        public ItemStack stack;
        public FluidStack acid;
        public String id;
        public int tier;
        public int color;

        public BedrockOreDefinition(ItemStack stack, int tier, int color) {
            this(stack, tier, color, null);
        }

        public BedrockOreDefinition(ItemStack stack, int tier, int color, FluidStack acid) {
            this.stack = stack;
            this.id = stack.toString();
            this.tier = tier;
            this.color = color;
            this.acid = acid;
        }

        public BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre type, int tier) {
            this(type, tier, null);
        }

        public BedrockOreDefinition(ItemBedrockOre.EnumBedrockOre type, int tier, FluidStack acid) {
            this.stack = OreDictManager.DictFrame.fromOne(ModItems.ore_bedrock, (Enum)type);
            this.id = "ore" + type.oreName;
            this.color = type.color;
            this.tier = tier;
            this.acid = acid;
        }
    }
}

