/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj;

import com.hbm.util.BobMathUtil;
import com.hbm.wiaj.JarScene;
import com.hbm.wiaj.WorldInAJar;
import com.hbm.wiaj.actors.ISpecialActor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.MathHelper;

public class JarScript {
    public WorldInAJar world;
    public List<JarScene> scenes = new ArrayList<JarScene>();
    public HashMap<Integer, ISpecialActor> actors = new HashMap();
    public JarScene currentScene;
    public int sceneNumber = 0;
    public double lastRotationYaw = -45.0;
    public double rotationYaw = -45.0;
    public double lastRotationPitch = -30.0;
    public double rotationPitch = -30.0;
    public double lastOffsetX = 0.0;
    public double offsetX = 0.0;
    public double lastOffsetY = 0.0;
    public double offsetY = 0.0;
    public double lastOffsetZ = 0.0;
    public double offsetZ = 0.0;
    public double lastZoom = 1.0;
    public double zoom = 1.0;
    public float interp = 0.0f;
    public long lastTick = 0L;
    public int ticksElapsed = 0;
    private boolean isPaused = false;
    private long pauseDelta;
    public static int ffwTarget = 0;
    public static boolean freeRun = false;

    public JarScript(WorldInAJar world) {
        this.world = world;
    }

    public JarScript addScene(JarScene scene) {
        if (this.currentScene == null) {
            this.currentScene = scene;
        }
        this.scenes.add(scene);
        return this;
    }

    public void run() {
        if (this.isPaused && !freeRun) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean nextTick = false;
        if (this.lastTick == 0L) {
            this.lastTick = now;
            nextTick = true;
        }
        if (this.lastTick + 50L < now || freeRun) {
            this.lastTick = now;
            ++this.ticksElapsed;
            nextTick = true;
        }
        this.interp = this.currentScene != null ? MathHelper.func_76131_a((float)((float)(now - this.lastTick) / 50.0f), (float)0.0f, (float)1.0f) : 0.0f;
        if (nextTick) {
            this.lastRotationPitch = this.rotationPitch;
            this.lastRotationYaw = this.rotationYaw;
            this.lastOffsetX = this.offsetX;
            this.lastOffsetY = this.offsetY;
            this.lastOffsetZ = this.offsetZ;
            this.lastZoom = this.zoom;
            if (this.currentScene != null) {
                for (Map.Entry<Integer, ISpecialActor> actor : this.actors.entrySet()) {
                    actor.getValue().updateActor(this.currentScene);
                }
                this.tickScene();
            }
        }
    }

    public void tickScene() {
        this.currentScene.tick();
        if (this.currentScene.currentAction == null) {
            ++this.sceneNumber;
            if (this.sceneNumber < this.scenes.size()) {
                this.currentScene = this.scenes.get(this.sceneNumber);
                this.currentScene.reset();
            } else {
                this.currentScene = null;
            }
        }
    }

    public void pause() {
        this.isPaused = true;
        this.pauseDelta = System.currentTimeMillis() - this.lastTick;
    }

    public void unpause() {
        this.isPaused = false;
        this.lastTick = System.currentTimeMillis() - this.pauseDelta;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    private void ffw() {
        int i;
        this.reset();
        freeRun = true;
        for (i = 0; this.sceneNumber < ffwTarget && this.currentScene != null && i < 10000; ++i) {
            this.run();
        }
        if (i > 0) {
            this.run();
        }
        freeRun = false;
    }

    public void reset() {
        this.actors.clear();
        this.world.nuke();
        this.currentScene = this.scenes.get(0);
        this.sceneNumber = 0;
        this.ticksElapsed = 0;
        this.lastTick = 0L;
        this.offsetX = 0.0;
        this.lastOffsetX = 0.0;
        this.offsetY = 0.0;
        this.lastOffsetY = 0.0;
        this.offsetZ = 0.0;
        this.lastOffsetZ = 0.0;
        this.zoom = 1.0;
        this.lastZoom = 1.0;
        this.rotationYaw = -45.0;
        this.lastRotationYaw = -45.0;
        this.rotationPitch = -30.0;
        this.lastRotationPitch = -30.0;
        for (JarScene scene : this.scenes) {
            scene.reset();
        }
    }

    public void rewindOne() {
        ffwTarget = this.sceneNumber > 0 ? this.sceneNumber - 1 : 0;
        this.ffw();
    }

    public void forwardOne() {
        ffwTarget = this.sceneNumber < this.scenes.size() ? this.sceneNumber + 1 : this.scenes.size();
        this.ffw();
    }

    public double yaw() {
        return BobMathUtil.interp(this.lastRotationYaw, this.rotationYaw, this.interp);
    }

    public double pitch() {
        return BobMathUtil.interp(this.lastRotationPitch, this.rotationPitch, this.interp);
    }

    public double offsetX() {
        return BobMathUtil.interp(this.lastOffsetX, this.offsetX, this.interp);
    }

    public double offsetY() {
        return BobMathUtil.interp(this.lastOffsetY, this.offsetY, this.interp);
    }

    public double offsetZ() {
        return BobMathUtil.interp(this.lastOffsetZ, this.offsetZ, this.interp);
    }

    public double zoom() {
        return BobMathUtil.interp(this.lastZoom, this.zoom, this.interp);
    }
}

