/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.entity.projectile.EntityArtilleryShell;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.container.ContainerTurretBase;
import com.hbm.inventory.gui.GUITurretArty;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemAmmoArty;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.turret.TileEntityTurretBaseArtillery;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityTurretArty
extends TileEntityTurretBaseArtillery
implements IGUIProvider {
    public short mode = 0;
    public static final short MODE_ARTILLERY = 0;
    public static final short MODE_CANNON = 1;
    public static final short MODE_MANUAL = 2;
    private boolean didJustShoot = false;
    private boolean retracting = false;
    public double barrelPos = 0.0;
    public double lastBarrelPos = 0.0;
    int timer;
    protected static CasingEjector ejector = new CasingEjector().setMotion(0.0, 0.6, -1.0).setAngleRange(0.1f, 0.1f);

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAmmoTypesForDisplay() {
        if (this.ammoStacks != null) {
            return this.ammoStacks;
        }
        this.ammoStacks = new ArrayList();
        ArrayList list = new ArrayList();
        ModItems.ammo_arty.func_150895_a(ModItems.ammo_arty, MainRegistry.weaponTab, list);
        this.ammoStacks.addAll(list);
        return this.ammoStacks;
    }

    @Override
    protected List<Integer> getAmmoList() {
        return new ArrayList<Integer>();
    }

    @Override
    public String getName() {
        return "container.turretArty";
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public double getBarrelLength() {
        return 9.0;
    }

    @Override
    public double getAcceptableInaccuracy() {
        return 0.0;
    }

    @Override
    public double getHeightOffset() {
        return 3.0;
    }

    @Override
    public double getDecetorRange() {
        return this.mode == 1 ? 250.0 : 3000.0;
    }

    @Override
    public double getDecetorGrace() {
        return this.mode == 1 ? 32.0 : 250.0;
    }

    @Override
    public double getTurretYawSpeed() {
        return 1.0;
    }

    @Override
    public double getTurretPitchSpeed() {
        return 0.5;
    }

    @Override
    public double getTurretDepression() {
        return 30.0;
    }

    @Override
    public double getTurretElevation() {
        return 90.0;
    }

    @Override
    public int getDecetorInterval() {
        return this.mode == 1 ? 20 : 200;
    }

    @Override
    public boolean doLOSCheck() {
        return this.mode == 1;
    }

    @Override
    protected void alignTurret() {
        Vec3 pos = this.getTurretPos();
        Vec3 barrel = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
        barrel.func_72446_c((float)(-this.rotationPitch));
        barrel.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        pos.field_72450_a += barrel.field_72450_a;
        pos.field_72448_b += barrel.field_72448_b;
        pos.field_72449_c += barrel.field_72449_c;
        Vec3 delta = Vec3.func_72443_a((double)(this.tPos.field_72450_a - pos.field_72450_a), (double)(this.tPos.field_72448_b - pos.field_72448_b), (double)(this.tPos.field_72449_c - pos.field_72449_c));
        double targetYaw = -Math.atan2(delta.field_72450_a, delta.field_72449_c);
        double x = Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c);
        double y = delta.field_72448_b;
        double v0 = this.getV0();
        double v02 = v0 * v0;
        double g = 0.49050000000000005;
        double upperLower = this.mode == 1 ? -1.0 : 1.0;
        double targetPitch = Math.atan((v02 + Math.sqrt(v02 * v02 - g * (g * x * x + 2.0 * y * v02)) * upperLower) / (g * x));
        this.turnTowardsAngle(targetPitch, targetYaw);
    }

    public double getV0() {
        return this.mode == 1 ? 20.0 : 50.0;
    }

    public ItemStack getShellLoaded() {
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.ammo_arty) continue;
            return this.slots[i];
        }
        return null;
    }

    public void conusmeAmmo(Item ammo) {
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ammo) continue;
            this.func_70298_a(i, 1);
            return;
        }
        this.func_70296_d();
    }

    public void spawnShell(ItemStack type) {
        NBTTagCompound cargo;
        Vec3 pos = this.getTurretPos();
        Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
        vec.func_72446_c((float)(-this.rotationPitch));
        vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityArtilleryShell proj = new EntityArtilleryShell(this.field_145850_b);
        proj.func_70080_a(pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c, 0.0f, 0.0f);
        proj.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (float)this.getV0(), 0.0f);
        proj.setTarget((int)this.tPos.field_72450_a, (int)this.tPos.field_72448_b, (int)this.tPos.field_72449_c);
        proj.setType(type.func_77960_j());
        if (type.func_77960_j() == 8 && type.func_77942_o() && (cargo = type.field_77990_d.func_74775_l("cargo")) != null) {
            proj.setCargo(ItemStack.func_77949_a((NBTTagCompound)cargo));
        }
        if (this.mode != 1) {
            proj.setWhistle(true);
        }
        this.field_145850_b.func_72838_d((Entity)proj);
        this.casingDelay = this.casingDelay();
    }

    @Override
    public int casingDelay() {
        return 7;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.lastBarrelPos = this.barrelPos;
            if (this.retracting) {
                this.barrelPos += 0.5;
                if (this.barrelPos >= 1.0) {
                    this.retracting = false;
                }
            } else {
                this.barrelPos -= 0.05;
                if (this.barrelPos < 0.0) {
                    this.barrelPos = 0.0;
                }
            }
            this.lastRotationPitch = this.rotationPitch;
            this.lastRotationYaw = this.rotationYaw;
            this.rotationPitch = this.syncRotationPitch;
            this.rotationYaw = this.syncRotationYaw;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.mode == 2) {
                if (!this.targetQueue.isEmpty()) {
                    this.tPos = (Vec3)this.targetQueue.get(0);
                }
            } else {
                this.targetQueue.clear();
            }
            this.aligned = false;
            this.updateConnections();
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                ++this.stattrak;
            }
            if (this.target != null) {
                if (this.mode != 2 && !this.entityInLOS(this.target)) {
                    this.target = null;
                }
            }
            if (this.target != null) {
                this.tPos = this.getEntityPos(this.target);
            } else if (this.mode != 2) {
                this.tPos = null;
            }
            if (this.isOn() && this.hasPower()) {
                if (this.tPos != null) {
                    this.alignTurret();
                }
            } else {
                this.target = null;
                this.tPos = null;
            }
            if (!this.isOn()) {
                this.targetQueue.clear();
            }
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                this.tPos = null;
                ++this.stattrak;
            }
            if (this.isOn() && this.hasPower()) {
                --this.searchTimer;
                this.setPower(this.getPower() - this.getConsumption());
                if (this.searchTimer <= 0) {
                    this.searchTimer = this.getDecetorInterval();
                    if (this.target == null) {
                        if (this.mode != 2) {
                            this.seekNewTarget();
                        }
                    }
                }
            } else {
                this.searchTimer = 0;
            }
            if (this.aligned) {
                this.updateFiringTick();
            }
            this.power = Library.chargeTEFromItems(this.slots, 10, this.power, this.getMaxPower());
            this.networkPackNT(250);
            this.didJustShoot = false;
            if (this.casingDelay > 0) {
                --this.casingDelay;
            } else {
                this.spawnCasing();
            }
        } else if (Math.abs(this.lastRotationYaw - this.rotationYaw) > Math.PI) {
            this.lastRotationYaw = this.lastRotationYaw < this.rotationYaw ? (this.lastRotationYaw += Math.PI * 2) : (this.lastRotationYaw -= Math.PI * 2);
        }
    }

    @Override
    public void updateFiringTick() {
        int delay;
        ++this.timer;
        int n = delay = this.mode == 0 ? 300 : 40;
        if (this.timer % delay == 0) {
            ItemStack conf = this.getShellLoaded();
            if (conf != null) {
                this.cachedCasingConfig = ItemAmmoArty.itemTypes[conf.func_77960_j()].casing;
                this.spawnShell(conf);
                this.conusmeAmmo(ModItems.ammo_arty);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:turret.jeremy_fire", 25.0f, 1.0f);
                Vec3 pos = this.getTurretPos();
                Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
                vec.func_72446_c((float)(-this.rotationPitch));
                vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
                this.didJustShoot = true;
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaExt");
                data.func_74778_a("mode", "largeexplode");
                data.func_74776_a("size", 0.0f);
                data.func_74774_a("count", (byte)5);
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            }
            if (this.mode == 2 && !this.targetQueue.isEmpty()) {
                this.targetQueue.remove(0);
                this.tPos = null;
            }
        }
    }

    @Override
    protected CasingEjector getEjector() {
        return ejector;
    }

    @Override
    protected Vec3 getCasingSpawnPos() {
        return this.getTurretPos();
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 5) {
            this.mode = (short)(this.mode + 1);
            if (this.mode > 2) {
                this.mode = 0;
            }
            this.tPos = null;
            this.targetQueue.clear();
        } else {
            super.handleButtonPacket(value, meta);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeShort((int)this.mode);
        buf.writeBoolean(this.didJustShoot);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.mode = buf.readShort();
        this.retracting = buf.readBoolean();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74765_d("mode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", this.mode);
    }

    @Override
    protected void spawnCasing() {
        if (this.cachedCasingConfig == null) {
            return;
        }
        CasingEjector ej = this.getEjector();
        Vec3 spawn = this.getCasingSpawnPos();
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "casing");
        data.func_74776_a("pitch", 0.0f);
        data.func_74776_a("yaw", (float)this.rotationYaw);
        data.func_74757_a("crouched", false);
        data.func_74778_a("name", this.cachedCasingConfig.getName());
        if (ej != null) {
            data.func_74768_a("ej", ej.getId());
        }
        PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, spawn.field_72450_a, spawn.field_72448_b, spawn.field_72449_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        this.cachedCasingConfig = null;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTurretBase(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITurretArty(player.field_71071_by, this);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] addCoords(Context context, Arguments args) {
        this.mode = (short)2;
        if (Math.sqrt(Math.pow((double)this.field_145851_c - args.checkDouble(0), 2.0) + Math.pow((double)this.field_145848_d - args.checkDouble(1), 2.0) + Math.pow((double)this.field_145849_e - args.checkDouble(2), 2.0)) >= this.getDecetorRange()) {
            return new Object[]{false};
        }
        this.targetQueue.add(Vec3.func_72443_a((double)args.checkDouble(0), (double)args.checkDouble(1), (double)args.checkDouble(2)));
        return new Object[]{true};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"setActive", "isActive", "getEnergyInfo", "getWhitelisted", "addWhitelist", "removeWhitelist", "setTargeting", "getTargeting", "hasTarget", "getAngle", "isAligned", "getCurrentTarget", "getTargetDistance", "addCoords"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "setActive": {
                return this.setActive(context, args);
            }
            case "isActive": {
                return this.isActive(context, args);
            }
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "getWhitelisted": {
                return this.getWhitelisted(context, args);
            }
            case "addWhitelist": {
                return this.addWhitelist(context, args);
            }
            case "removeWhitelist": {
                return this.removeWhitelist(context, args);
            }
            case "setTargeting": {
                return this.setTargeting(context, args);
            }
            case "getTargeting": {
                return this.getTargeting(context, args);
            }
            case "hasTarget": {
                return this.hasTarget(context, args);
            }
            case "getAngle": {
                return this.getAngle(context, args);
            }
            case "isAligned": {
                return this.isAligned(context, args);
            }
            case "getCurrentTarget": {
                return this.getCurrentTarget(context, args);
            }
            case "getTargetDistance": {
                return this.getTargetDistance(context, args);
            }
            case "addCoords": {
                return this.addCoords(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

