/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.entity.item.EntityDeliveryDrone;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerDroneCrate;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIDroneCrate;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.network.IDroneLinkable;
import com.hbm.util.BufferUtil;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityDroneCrate
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
IDroneLinkable,
IFluidStandardTransceiver,
IFluidCopiable {
    public FluidTank tank = new FluidTank(Fluids.NONE, 64000);
    public int nextX = -1;
    public int nextY = -1;
    public int nextZ = -1;
    public boolean sendingMode = false;
    public boolean itemType = true;

    public TileEntityDroneCrate() {
        super(19);
    }

    @Override
    public String getName() {
        return "container.droneCrate";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            BlockPos pos = this.getCoord();
            this.tank.setType(18, this.slots);
            if (this.sendingMode && !this.itemType && this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.subscribeToAllAround(this.tank.getTankType(), this);
            }
            if (!this.sendingMode && !this.itemType && this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.sendFluidToAll(this.tank, this);
            }
            if (this.nextY != -1) {
                List drones = this.field_145850_b.func_72872_a(EntityDeliveryDrone.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
                for (EntityDeliveryDrone drone : drones) {
                    if (!(Vec3.func_72443_a((double)drone.field_70159_w, (double)drone.field_70181_x, (double)drone.field_70179_y).func_72433_c() < 0.05)) continue;
                    drone.setTarget((double)this.nextX + 0.5, this.nextY, (double)this.nextZ + 0.5);
                    if (this.sendingMode && this.itemType) {
                        this.loadItems(drone);
                    }
                    if (!this.sendingMode && this.itemType) {
                        this.unloadItems(drone);
                    }
                    if (this.sendingMode && !this.itemType) {
                        this.loadFluid(drone);
                    }
                    if (this.sendingMode || this.itemType) continue;
                    this.unloadFluid(drone);
                }
                ParticleUtil.spawnDroneLine(this.field_145850_b, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.nextX - pos.getX(), this.nextY - pos.getY(), this.nextZ - pos.getZ(), 65535);
            }
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        BufferUtil.writeIntArray(buf, new int[]{this.nextX, this.nextY, this.nextZ});
        buf.writeBoolean(this.sendingMode);
        buf.writeBoolean(this.itemType);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int[] pos = BufferUtil.readIntArray(buf);
        this.nextX = pos[0];
        this.nextY = pos[1];
        this.nextZ = pos[2];
        this.sendingMode = buf.readBoolean();
        this.itemType = buf.readBoolean();
        this.tank.deserialize(buf);
    }

    protected void loadItems(EntityDeliveryDrone drone) {
        if (drone.getAppearance() != 0) {
            return;
        }
        boolean loaded = false;
        for (int i = 0; i < 18; ++i) {
            if (this.slots[i] == null) continue;
            loaded = true;
            drone.func_70299_a(i, this.slots[i].func_77946_l());
            this.slots[i] = null;
        }
        if (loaded) {
            this.func_70296_d();
            drone.setAppearance(1);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.unpack", 0.5f, 0.75f);
        }
    }

    protected void unloadItems(EntityDeliveryDrone drone) {
        if (drone.getAppearance() != 1) {
            return;
        }
        boolean emptied = true;
        for (int i = 0; i < 18; ++i) {
            ItemStack droneSlot = drone.func_70301_a(i);
            if (this.slots[i] == null && droneSlot != null) {
                this.slots[i] = droneSlot.func_77946_l();
                drone.func_70299_a(i, null);
                continue;
            }
            if (this.slots[i] == null || droneSlot == null) continue;
            emptied = false;
        }
        this.func_70296_d();
        if (emptied) {
            drone.setAppearance(0);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.unpack", 0.5f, 0.75f);
        }
    }

    protected void loadFluid(EntityDeliveryDrone drone) {
        if (drone.getAppearance() != 0) {
            return;
        }
        if (this.tank.getFill() > 0) {
            drone.fluid = new FluidStack(this.tank.getTankType(), this.tank.getFill());
            this.tank.setFill(0);
            drone.setAppearance(2);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.unpack", 0.5f, 0.75f);
            this.func_70296_d();
        }
    }

    protected void unloadFluid(EntityDeliveryDrone drone) {
        if (drone.getAppearance() != 2) {
            return;
        }
        if (drone.fluid != null && drone.fluid.type == this.tank.getTankType()) {
            if (drone.fluid.fill + this.tank.getFill() <= this.tank.getMaxFill()) {
                this.tank.setFill(this.tank.getFill() + drone.fluid.fill);
                drone.fluid = null;
                drone.setAppearance(0);
            } else {
                int overshoot = drone.fluid.fill + this.tank.getFill() - this.tank.getMaxFill();
                this.tank.setFill(this.tank.getMaxFill());
                drone.fluid.fill = overshoot;
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.unpack", 0.5f, 0.75f);
            this.func_70296_d();
        }
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    @Override
    public BlockPos getPoint() {
        return new BlockPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public void setNextTarget(int x, int y, int z) {
        this.nextX = x;
        this.nextY = y;
        this.nextZ = z;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] pos = nbt.func_74759_k("pos");
        this.nextX = pos[0];
        this.nextY = pos[1];
        this.nextZ = pos[2];
        this.sendingMode = nbt.func_74767_n("mode");
        this.itemType = nbt.func_74767_n("type");
        this.tank.readFromNBT(nbt, "t");
    }

    public BlockPos getCoord() {
        return new BlockPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74783_a("pos", new int[]{this.nextX, this.nextY, this.nextZ});
        nbt.func_74757_a("mode", this.sendingMode);
        nbt.func_74757_a("type", this.itemType);
        this.tank.writeToNBT(nbt, "t");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerDroneCrate(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIDroneCrate(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("mode")) {
            this.sendingMode = !this.sendingMode;
            this.markChanged();
        }
        if (data.func_74764_b("type")) {
            this.itemType = !this.itemType;
            this.markChanged();
        }
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        FluidTank[] fluidTankArray;
        if (!this.sendingMode && !this.itemType) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        FluidTank[] fluidTankArray;
        if (this.sendingMode && !this.itemType) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }
}

