/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.inventory.container.ContainerCraneRouter;
import com.hbm.inventory.gui.GUICraneRouter;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.IControlReceiverFilter;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityCraneRouter
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiverFilter {
    public ModulePatternMatcher[] patterns = new ModulePatternMatcher[6];
    public int[] modes = new int[6];
    public static final int MODE_NONE = 0;
    public static final int MODE_WHITELIST = 1;
    public static final int MODE_BLACKLIST = 2;
    public static final int MODE_WILDCARD = 3;

    public TileEntityCraneRouter() {
        super(30);
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = new ModulePatternMatcher(5);
        }
    }

    @Override
    public String getName() {
        return "container.craneRouter";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.networkPackNT(15);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        for (ModulePatternMatcher pattern : this.patterns) {
            pattern.serialize(buf);
        }
        BufferUtil.writeIntArray(buf, this.modes);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        for (ModulePatternMatcher pattern : this.patterns) {
            pattern.deserialize(buf);
        }
        this.modes = BufferUtil.readIntArray(buf);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneRouter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneRouter(player.field_71071_by, this);
    }

    @Override
    public void nextMode(int index) {
        int matcher = index / 5;
        int mIndex = index % 5;
        this.patterns[matcher].nextMode(this.field_145850_b, this.slots[index], mIndex);
    }

    public void initPattern(ItemStack stack, int index) {
        int matcher = index / 5;
        int mIndex = index % 5;
        this.patterns[matcher].initPatternSmart(this.field_145850_b, stack, mIndex);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = nbt.func_74775_l("pattern" + i);
            this.patterns[i].readFromNBT(compound);
        }
        this.modes = nbt.func_74759_k("modes");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            this.patterns[i].writeToNBT(compound);
            nbt.func_74782_a("pattern" + i, (NBTBase)compound);
        }
        nbt.func_74783_a("modes", this.modes);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public int[] getFilterSlots() {
        return new int[]{0, this.slots.length};
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            int i;
            int n = i = data.func_74762_e("toggle");
            this.modes[n] = this.modes[n] + 1;
            if (this.modes[i] > 3) {
                this.modes[i] = 0;
            }
        }
        if (data.func_74764_b("slot")) {
            this.setFilterContents(data);
        }
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        TileEntityCraneRouter inv = this;
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList tags = new NBTTagList();
        int count = 0;
        for (int i = this.getFilterSlots()[0]; i < this.getFilterSlots()[1]; ++i) {
            NBTTagCompound slotNBT = new NBTTagCompound();
            if (inv.func_70301_a(i) != null) {
                slotNBT.func_74774_a("slot", (byte)count);
                inv.func_70301_a(i).func_77955_b(slotNBT);
                tags.func_74742_a((NBTBase)slotNBT);
            }
            ++count;
        }
        nbt.func_74782_a("items", (NBTBase)tags);
        nbt.func_74783_a("modes", this.modes);
        return nbt;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        NBTTagList items = nbt.func_150295_c("items", 10);
        int listSize = items.func_74745_c();
        if (listSize > 0 && nbt.func_74764_b("modes")) {
            for (int i = 0; i < listSize; ++i) {
                NBTTagCompound slotNBT = items.func_150305_b(i);
                byte slot = slotNBT.func_74771_c("slot");
                ItemStack loadedStack = ItemStack.func_77949_a((NBTTagCompound)slotNBT);
                if (loadedStack == null || slot <= index * 5 || slot >= Math.min(index * 5 + 5, 30)) continue;
                this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)slotNBT));
                this.nextMode(slot);
                this.func_145831_w().func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            }
            this.modes = nbt.func_74759_k("modes");
        } else {
            IControlReceiverFilter.super.pasteSettings(nbt, index, world, player, x, y, z);
        }
    }

    @Override
    public String[] infoForDisplay(World world, int x, int y, int z) {
        String[] options = new String[this.patterns.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = "copytool.pattern" + i;
        }
        return options;
    }
}

