/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.interfaces.ICopiable;
import com.hbm.tileentity.IControlReceiverFilter;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityCraneBase
extends TileEntityMachineBase
implements ICopiable {
    private ForgeDirection outputOverride = ForgeDirection.UNKNOWN;
    private ForgeDirection cachedOutputOverride = ForgeDirection.UNKNOWN;

    public TileEntityCraneBase(int scount) {
        super(scount);
    }

    @Override
    public void func_145845_h() {
        if (this.func_145830_o() && this.field_145850_b.field_72995_K && this.cachedOutputOverride != this.outputOverride) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.cachedOutputOverride = this.outputOverride;
        }
    }

    public ForgeDirection getInputSide() {
        return ForgeDirection.getOrientation((int)this.func_145832_p());
    }

    public ForgeDirection getOutputSide() {
        ForgeDirection override = this.getOutputOverride();
        return override != ForgeDirection.UNKNOWN ? override : ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
    }

    public ForgeDirection getOutputOverride() {
        return this.outputOverride;
    }

    public void setOutputOverride(ForgeDirection direction) {
        ForgeDirection oldSide = this.getOutputSide();
        if (oldSide == direction) {
            direction = direction.getOpposite();
        }
        this.outputOverride = direction;
        if (direction == this.getInputSide()) {
            this.setInput(oldSide);
        } else {
            this.onBlockChanged();
        }
    }

    public void setInput(ForgeDirection direction) {
        this.outputOverride = this.getOutputSide();
        ForgeDirection oldSide = this.getInputSide();
        if (oldSide == direction) {
            direction = direction.getOpposite();
        }
        boolean needSwapOutput = direction == this.getOutputSide();
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, direction.ordinal(), needSwapOutput ? 4 : 3);
        if (needSwapOutput) {
            this.setOutputOverride(oldSide);
        }
    }

    protected void onBlockChanged() {
        if (!this.func_145830_o()) {
            return;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.func_70296_d();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("CraneOutputOverride", 1)) {
            this.outputOverride = ForgeDirection.getOrientation((int)nbt.func_74771_c("CraneOutputOverride"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("CraneOutputOverride", (byte)this.outputOverride.ordinal());
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("inputSide", this.getInputSide().ordinal());
        nbt.func_74768_a("outputSide", this.getOutputSide().ordinal());
        if (this instanceof IControlReceiverFilter) {
            IControlReceiverFilter filter = (IControlReceiverFilter)((Object)this);
            TileEntityCraneBase inv = this;
            NBTTagList tags = new NBTTagList();
            int count = 0;
            for (int i = filter.getFilterSlots()[0]; i < filter.getFilterSlots()[1]; ++i) {
                NBTTagCompound slotNBT = new NBTTagCompound();
                if (inv.func_70301_a(i) != null) {
                    slotNBT.func_74774_a("slot", (byte)count);
                    inv.func_70301_a(i).func_77955_b(slotNBT);
                    tags.func_74742_a((NBTBase)slotNBT);
                }
                ++count;
            }
            nbt.func_74782_a("items", (NBTBase)tags);
        }
        return nbt;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        if (index == 1) {
            if (nbt.func_74764_b("outputSide")) {
                this.outputOverride = ForgeDirection.getOrientation((int)nbt.func_74762_e("outputSide"));
                this.onBlockChanged();
            }
            if (nbt.func_74764_b("inputSide")) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, nbt.func_74762_e("inputSide"), 3);
            }
        } else if (this instanceof IControlReceiverFilter) {
            IControlReceiverFilter filter = (IControlReceiverFilter)((Object)this);
            TileEntityCraneBase inv = this;
            NBTTagList items = nbt.func_150295_c("items", 10);
            int listSize = items.func_74745_c();
            if (listSize > 0) {
                int count = 0;
                for (int i = filter.getFilterSlots()[0]; i < filter.getFilterSlots()[1]; ++i) {
                    if (i < listSize) {
                        boolean router;
                        NBTTagCompound slotNBT = items.func_150305_b(count);
                        byte slot = slotNBT.func_74771_c("slot");
                        ItemStack loadedStack = ItemStack.func_77949_a((NBTTagCompound)slotNBT);
                        boolean bl = router = nbt.func_74764_b("modes") && slot > index * 5 && slot < index * 5;
                        if (loadedStack != null && (slot < filter.getFilterSlots()[1] || router)) {
                            inv.func_70299_a(slot + filter.getFilterSlots()[0], ItemStack.func_77949_a((NBTTagCompound)slotNBT));
                            filter.nextMode(slot);
                            this.func_145831_w().func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                        }
                    }
                    ++count;
                }
            }
        }
    }

    @Override
    public String[] infoForDisplay(World world, int x, int y, int z) {
        return new String[]{"copytool.filter", "copytool.orientation"};
    }
}

