/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.inventory.RecipesCommon;
import com.hbm.util.HashedSet;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class RequestNetwork {
    private static int timer = 0;
    public static HashMap<World, HashMap<ChunkCoordIntPair, HashedSet<PathNode>>> activeWaypoints = new HashMap();
    public static final int maxAge = 2000;

    public static void updateEntries() {
        if (timer < 0) {
            --timer;
            return;
        }
        timer = 20;
        Iterator<Map.Entry<World, HashMap<ChunkCoordIntPair, HashedSet<PathNode>>>> worldIt = activeWaypoints.entrySet().iterator();
        while (worldIt.hasNext()) {
            Map.Entry<World, HashMap<ChunkCoordIntPair, HashedSet<PathNode>>> worldEntry = worldIt.next();
            Iterator<Map.Entry<ChunkCoordIntPair, HashedSet<PathNode>>> chunkIt = worldEntry.getValue().entrySet().iterator();
            while (chunkIt.hasNext()) {
                Map.Entry<ChunkCoordIntPair, HashedSet<PathNode>> chunkEntry = chunkIt.next();
                Iterator pathIt = chunkEntry.getValue().iterator();
                while (pathIt.hasNext()) {
                    PathNode node = (PathNode)pathIt.next();
                    if (node.lease >= System.currentTimeMillis() - 2000L) continue;
                    node.reachableNodes.clear();
                    pathIt.remove();
                }
                if (chunkEntry.getValue().size() != 0) continue;
                chunkIt.remove();
            }
            if (worldEntry.getValue().size() != 0) continue;
            worldIt.remove();
        }
    }

    public static class RequestNode
    extends PathNode {
        public List<RecipesCommon.AStack> request;

        public RequestNode(BlockPos pos, HashedSet<PathNode> reachableNodes, List<RecipesCommon.AStack> request) {
            super(pos, reachableNodes);
            this.request = request;
        }
    }

    public static class OfferNode
    extends PathNode {
        public List<ItemStack> offer;

        public OfferNode(BlockPos pos, HashedSet<PathNode> reachableNodes, List<ItemStack> offer) {
            super(pos, reachableNodes);
            this.offer = offer;
        }
    }

    public static class PathNode {
        public BlockPos pos;
        public long lease;
        public boolean active = true;
        public HashedSet<PathNode> reachableNodes;

        public PathNode(BlockPos pos, HashedSet<PathNode> reachableNodes) {
            this.pos = pos;
            this.reachableNodes = new HashedSet(reachableNodes);
            this.lease = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object toCompare) {
            if (this == toCompare) {
                return true;
            }
            if (!(toCompare instanceof PathNode)) {
                return false;
            }
            PathNode node = (PathNode)toCompare;
            if (this.pos.getX() != node.pos.getX()) {
                return false;
            }
            if (this.pos.getY() != node.pos.getY()) {
                return false;
            }
            return this.pos.getZ() == node.pos.getZ();
        }
    }
}

