/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.entity.IRadarDetectable;
import api.hbm.entity.IRadarDetectableNT;
import api.hbm.entity.RadarEntry;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerMachineRadarNT;
import com.hbm.inventory.gui.GUIMachineRadarNT;
import com.hbm.inventory.gui.GUIMachineRadarNTSlots;
import com.hbm.items.ISatChip;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemCoordinateBase;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.saveddata.satellites.SatelliteHorizons;
import com.hbm.saveddata.satellites.SatelliteLaser;
import com.hbm.saveddata.satellites.SatelliteResonator;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IRadarCommandReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityMachineRadarScreen;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.world.WorldUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineRadarNT
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider,
IConfigurableMachine,
IControlReceiver,
SimpleComponent,
CompatHandler.OCComponent {
    public boolean scanMissiles = true;
    public boolean scanShells = true;
    public boolean scanPlayers = true;
    public boolean smartMode = true;
    public boolean redMode = true;
    public boolean showMap = false;
    public boolean jammed = false;
    public float prevRotation;
    public float rotation;
    public long power = 0L;
    protected int pingTimer = 0;
    protected int lastPower;
    protected static final int maxTimer = 80;
    public static int maxPower = 100000;
    public static int consumption = 500;
    public static int radarRange = 1000;
    public static int radarBuffer = 30;
    public static int radarAltitude = 55;
    public static int chunkLoadCap = 10;
    public static boolean generateChunks = false;
    public byte[] map = new byte[40000];
    public boolean clearFlag = false;
    public List<RadarEntry> entries = new ArrayList<RadarEntry>();
    AxisAlignedBB bb = null;
    public static List<Function<Tuple.Triplet<Entity, Object, IRadarDetectableNT.RadarScanParams>, RadarEntry>> converters = new ArrayList<Function<Tuple.Triplet<Entity, Object, IRadarDetectableNT.RadarScanParams>, RadarEntry>>();
    public static List<Class> classes = new ArrayList<Class>();
    public static List<Entity> matchingEntities = new ArrayList<Entity>();

    @Override
    public String getConfigName() {
        return "radar";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:powerCap", maxPower);
        consumption = IConfigurableMachine.grab(obj, "L:consumption", consumption);
        radarRange = IConfigurableMachine.grab(obj, "I:radarRange", radarRange);
        radarBuffer = IConfigurableMachine.grab(obj, "I:radarBuffer", radarBuffer);
        radarAltitude = IConfigurableMachine.grab(obj, "I:radarAltitude", radarAltitude);
        chunkLoadCap = IConfigurableMachine.grab(obj, "I:chunkLoadCap", chunkLoadCap);
        generateChunks = IConfigurableMachine.grab(obj, "B:generateChunks", generateChunks);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:powerCap").value((long)maxPower);
        writer.name("L:consumption").value((long)consumption);
        writer.name("I:radarRange").value((long)radarRange);
        writer.name("I:radarBuffer").value((long)radarBuffer);
        writer.name("I:radarAltitude").value((long)radarAltitude);
        writer.name("B:generateChunks").value(generateChunks);
    }

    public TileEntityMachineRadarNT() {
        super(10);
    }

    @Override
    public String getName() {
        return "container.radar";
    }

    public int getRange() {
        return radarRange;
    }

    @Override
    public void func_145845_h() {
        if (this.map == null || this.map.length != 40000) {
            this.map = new byte[40000];
        }
        if (!this.field_145850_b.field_72995_K) {
            TileEntity tile;
            BlockPos pos;
            this.power = Library.chargeTEFromItems(this.slots, 9, this.power, maxPower);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos2 : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos2.getX(), pos2.getY(), pos2.getZ(), pos2.getDir());
                }
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, maxPower);
            this.jammed = false;
            this.allocateTargets();
            if (this.lastPower != this.getRedPower()) {
                this.markChanged();
                for (DirPos pos2 : this.getConPos()) {
                    this.updateRedstoneConnection(pos2);
                }
            }
            this.lastPower = this.getRedPower();
            if (!this.muffled) {
                ++this.pingTimer;
                if (this.power > 0L && this.pingTimer >= 80) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.sonarPing", 5.0f, 1.0f);
                    this.pingTimer = 0;
                }
            }
            if (this.showMap) {
                int chunkLoads = 0;
                for (int i = 0; i < 100; ++i) {
                    int index = (int)(this.field_145850_b.func_82737_E() % 400L) * 100 + i;
                    int iX = index % 200 * this.getRange() * 2 / 200;
                    int iZ = index / 200 * this.getRange() * 2 / 200;
                    int x = this.field_145851_c - this.getRange() + iX;
                    int z = this.field_145849_e - this.getRange() + iZ;
                    if (this.field_145850_b.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
                        this.map[index] = (byte)MathHelper.func_76125_a((int)this.field_145850_b.func_72976_f(x, z), (int)50, (int)128);
                        continue;
                    }
                    if (this.map[index] != 0 || chunkLoads >= chunkLoadCap) continue;
                    if (generateChunks) {
                        this.field_145850_b.func_72964_e(x >> 4, z >> 4);
                        this.map[index] = (byte)MathHelper.func_76125_a((int)this.field_145850_b.func_72976_f(x, z), (int)50, (int)128);
                        ++chunkLoads;
                        continue;
                    }
                    WorldUtil.provideChunk((WorldServer)this.field_145850_b, x >> 4, z >> 4);
                    this.map[index] = (byte)MathHelper.func_76125_a((int)this.field_145850_b.func_72976_f(x, z), (int)50, (int)128);
                    if (!this.field_145850_b.func_72863_F().func_73149_a(x >> 4, z >> 4)) continue;
                    ++chunkLoads;
                }
            }
            if (this.slots[8] != null && this.slots[8].func_77973_b() == ModItems.radar_linker && (pos = ItemCoordinateBase.getPosition(this.slots[8])) != null && (tile = this.field_145850_b.func_147438_o(pos.getX(), pos.getY(), pos.getZ())) instanceof TileEntityMachineRadarScreen) {
                TileEntityMachineRadarScreen screen = (TileEntityMachineRadarScreen)tile;
                screen.entries.clear();
                screen.entries.addAll(this.entries);
                screen.refX = this.field_145851_c;
                screen.refY = this.field_145848_d;
                screen.refZ = this.field_145849_e;
                screen.range = this.getRange();
                screen.linked = true;
                screen.networkPackNT(25);
            }
            this.networkPackNT(50);
            if (this.clearFlag) {
                this.map = new byte[40000];
                this.clearFlag = false;
            }
        } else {
            this.prevRotation = this.rotation;
            if (this.power > 0L) {
                this.rotation += 5.0f;
            }
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeBoolean(this.scanMissiles);
        buf.writeBoolean(this.scanShells);
        buf.writeBoolean(this.scanPlayers);
        buf.writeBoolean(this.smartMode);
        buf.writeBoolean(this.redMode);
        buf.writeBoolean(this.showMap);
        buf.writeBoolean(this.jammed);
        buf.writeInt(this.entries.size());
        for (RadarEntry entry : this.entries) {
            entry.toBytes(buf);
        }
        if (this.clearFlag) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
            if (this.showMap) {
                buf.writeBoolean(true);
                short index = (short)(this.field_145850_b.func_82737_E() % 400L);
                buf.writeShort((int)index);
                for (int i = index * 100; i < (index + 1) * 100; ++i) {
                    buf.writeByte((int)this.map[i]);
                }
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.scanMissiles = buf.readBoolean();
        this.scanShells = buf.readBoolean();
        this.scanPlayers = buf.readBoolean();
        this.smartMode = buf.readBoolean();
        this.redMode = buf.readBoolean();
        this.showMap = buf.readBoolean();
        this.jammed = buf.readBoolean();
        int count = buf.readInt();
        this.entries.clear();
        for (int i = 0; i < count; ++i) {
            RadarEntry entry = new RadarEntry();
            entry.fromBytes(buf);
            this.entries.add(entry);
        }
        if (buf.readBoolean()) {
            this.map = new byte[40000];
        } else if (buf.readBoolean()) {
            short index = buf.readShort();
            for (int i = index * 100; i < (index + 1) * 100; ++i) {
                this.map[i] = buf.readByte();
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.scanMissiles = nbt.func_74767_n("scanMissiles");
        this.scanShells = nbt.func_74767_n("scanShells");
        this.scanPlayers = nbt.func_74767_n("scanPlayers");
        this.smartMode = nbt.func_74767_n("smartMode");
        this.redMode = nbt.func_74767_n("redMode");
        this.showMap = nbt.func_74767_n("showMap");
        if (nbt.func_74764_b("map")) {
            this.map = nbt.func_74770_j("map");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("scanMissiles", this.scanMissiles);
        nbt.func_74757_a("scanShells", this.scanShells);
        nbt.func_74757_a("scanPlayers", this.scanPlayers);
        nbt.func_74757_a("smartMode", this.smartMode);
        nbt.func_74757_a("redMode", this.redMode);
        nbt.func_74757_a("showMap", this.showMap);
        nbt.func_74773_a("map", this.map);
    }

    protected void allocateTargets() {
        this.entries.clear();
        if (this.field_145848_d < radarAltitude) {
            return;
        }
        if (this.power < (long)consumption) {
            this.power = 0L;
            return;
        }
        this.power -= (long)consumption;
        int scan = this.getRange();
        IRadarDetectableNT.RadarScanParams params = new IRadarDetectableNT.RadarScanParams(this.scanMissiles, this.scanShells, this.scanPlayers, this.smartMode);
        block0: for (Entity e : matchingEntities) {
            if (e.field_71093_bK != this.field_145850_b.field_73011_w.field_76574_g || !(Math.abs(e.field_70165_t - ((double)this.field_145851_c + 0.5)) <= (double)scan) || !(Math.abs(e.field_70161_v - ((double)this.field_145849_e + 0.5)) <= (double)scan) || !(e.field_70163_u - (double)this.field_145848_d > (double)radarBuffer)) continue;
            if (e instanceof EntityLivingBase && (double)HbmLivingProps.getDigamma((EntityLivingBase)e) > 0.001) {
                this.jammed = true;
                this.entries.clear();
                return;
            }
            for (Function<Tuple.Triplet<Entity, Object, IRadarDetectableNT.RadarScanParams>, RadarEntry> converter : converters) {
                RadarEntry entry = converter.apply(new Tuple.Triplet<Entity, TileEntityMachineRadarNT, IRadarDetectableNT.RadarScanParams>(e, this, params));
                if (entry == null) continue;
                this.entries.add(entry);
                continue block0;
            }
        }
    }

    public int getRedPower() {
        if (!this.entries.isEmpty()) {
            if (this.redMode) {
                double maxRange = (double)this.getRange() * Math.sqrt(2.0);
                int power = 0;
                for (int i = 0; i < this.entries.size(); ++i) {
                    double dist;
                    int p;
                    RadarEntry e = this.entries.get(i);
                    if (!e.redstone || (p = 15 - (int)Math.floor((dist = Math.sqrt(Math.pow(e.posX - this.field_145851_c, 2.0) + Math.pow(e.posZ - this.field_145849_e, 2.0))) / maxRange * 15.0)) <= power) continue;
                    power = p;
                }
                return power;
            }
            int power = 0;
            for (int i = 0; i < this.entries.size(); ++i) {
                RadarEntry e = this.entries.get(i);
                if (!e.redstone || e.blipLevel + 1 <= power) continue;
                power = e.blipLevel + 1;
            }
            return power;
        }
        return 0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
    }

    @Override
    public void receiveControl(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74764_b("missiles")) {
            boolean bl = this.scanMissiles = !this.scanMissiles;
        }
        if (data.func_74764_b("shells")) {
            boolean bl = this.scanShells = !this.scanShells;
        }
        if (data.func_74764_b("players")) {
            boolean bl = this.scanPlayers = !this.scanPlayers;
        }
        if (data.func_74764_b("smart")) {
            boolean bl = this.smartMode = !this.smartMode;
        }
        if (data.func_74764_b("red")) {
            boolean bl = this.redMode = !this.redMode;
        }
        if (data.func_74764_b("map")) {
            boolean bl = this.showMap = !this.showMap;
        }
        if (data.func_74764_b("clear")) {
            this.clearFlag = true;
        }
        if (data.func_74764_b("gui1")) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)1, (World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
        if (data.func_74764_b("link")) {
            TileEntity tile;
            BlockPos pos;
            int id = data.func_74762_e("link");
            ItemStack link = this.slots[id];
            if (link != null && link.func_77973_b() == ModItems.sat_relay) {
                int y;
                int z;
                int x;
                World world = player.func_130014_f_();
                Satellite sat = SatelliteSavedData.getData(world).getSatFromFreq(ISatChip.getFreqS(link));
                if (sat instanceof SatelliteLaser && data.func_74764_b("launchPosX")) {
                    x = data.func_74762_e("launchPosX");
                    z = data.func_74762_e("launchPosZ");
                    this.field_145850_b.func_72956_a((Entity)player, "hbm:item.techBleep", 1.0f, 1.0f);
                    sat.onClick(world, x, z);
                }
                if (sat instanceof SatelliteHorizons && data.func_74764_b("launchPosX")) {
                    x = data.func_74762_e("launchPosX");
                    z = data.func_74762_e("launchPosZ");
                    y = 60;
                    this.field_145850_b.func_72956_a((Entity)player, "hbm:item.techBleep", 1.0f, 1.0f);
                    sat.onCoordAction(world, player, x, y, z);
                }
                if (sat instanceof SatelliteResonator && data.func_74764_b("launchPosX")) {
                    x = data.func_74762_e("launchPosX");
                    z = data.func_74762_e("launchPosZ");
                    y = world.func_72825_h(x, z);
                    this.field_145850_b.func_72956_a((Entity)player, "hbm:item.techBleep", 1.0f, 1.0f);
                    sat.onCoordAction(world, player, x, y, z);
                }
            }
            if (link != null && link.func_77973_b() == ModItems.radar_linker && (pos = ItemCoordinateBase.getPosition(link)) != null && (tile = this.field_145850_b.func_147438_o(pos.getX(), pos.getY(), pos.getZ())) instanceof IRadarCommandReceiver) {
                int z;
                int x;
                IRadarCommandReceiver rec = (IRadarCommandReceiver)tile;
                if (data.func_74764_b("launchEntity")) {
                    Entity entity = this.field_145850_b.func_73045_a(data.func_74762_e("launchEntity"));
                    if (entity != null && rec.sendCommandEntity(entity)) {
                        this.field_145850_b.func_72956_a((Entity)player, "hbm:item.techBleep", 1.0f, 1.0f);
                    }
                } else if (data.func_74764_b("launchPosX") && rec.sendCommandPosition(x = data.func_74762_e("launchPosX"), this.field_145848_d, z = data.func_74762_e("launchPosZ"))) {
                    this.field_145850_b.func_72956_a((Entity)player, "hbm:item.techBleep", 1.0f, 1.0f);
                }
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 1) {
            return new ContainerMachineRadarNT(player.field_71071_by, this);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 0) {
            return new GUIMachineRadarNT(this);
        }
        if (ID == 1) {
            return new GUIMachineRadarNTSlots(player.field_71071_by, this);
        }
        return null;
    }

    public static void updateSystem() {
        matchingEntities.clear();
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            block1: for (Object entity : world.field_72996_f) {
                for (Class clazz : classes) {
                    if (!clazz.isAssignableFrom(entity.getClass())) continue;
                    matchingEntities.add((Entity)entity);
                    continue block1;
                }
            }
        }
    }

    public static void registerEntityClasses() {
        classes.add(IRadarDetectableNT.class);
        classes.add(IRadarDetectable.class);
        classes.add(EntityPlayer.class);
    }

    public static void registerConverters() {
        converters.add(x -> {
            IRadarDetectableNT detectable;
            Entity e = (Entity)x.getX();
            if (e instanceof IRadarDetectableNT && (detectable = (IRadarDetectableNT)e).canBeSeenBy(x.getY()) && detectable.paramsApplicable((IRadarDetectableNT.RadarScanParams)x.getZ())) {
                return new RadarEntry(detectable, e, detectable.suppliesRedstone((IRadarDetectableNT.RadarScanParams)x.getZ()));
            }
            return null;
        });
        converters.add(x -> {
            Entity e = (Entity)x.getX();
            IRadarDetectableNT.RadarScanParams params = (IRadarDetectableNT.RadarScanParams)x.getZ();
            if (e instanceof IRadarDetectable && params.scanMissiles) {
                return new RadarEntry((IRadarDetectable)e, e);
            }
            return null;
        });
        converters.add(x -> {
            if (x.getX() instanceof EntityPlayer && ((IRadarDetectableNT.RadarScanParams)x.getZ()).scanPlayers) {
                return new RadarEntry((EntityPlayer)x.getX());
            }
            return null;
        });
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_radar";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSettings(Context context, Arguments args) {
        return new Object[]{this.scanMissiles, this.scanShells, this.scanPlayers, this.smartMode};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getRange(Context context, Arguments args) {
        return new Object[]{this.getRange()};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setSettings(Context context, Arguments args) {
        this.scanMissiles = args.checkBoolean(0);
        this.scanShells = args.checkBoolean(1);
        this.scanPlayers = args.checkBoolean(2);
        this.smartMode = args.checkBoolean(3);
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isJammed(Context context, Arguments args) {
        return new Object[]{this.jammed};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getAmount(Context context, Arguments args) {
        return new Object[]{this.entries.size()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isIndexPlayer(Context context, Arguments args) {
        int index = args.checkInteger(0) - 1;
        if (index > this.entries.size() || index < 0) {
            return new Object[]{null, "No entity exists at that index."};
        }
        RadarEntry e = this.entries.get(index);
        return new Object[]{e.blipLevel == 11};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getIndexType(Context context, Arguments args) {
        int index = args.checkInteger(0) - 1;
        if (index > this.entries.size() || index < 0) {
            return new Object[]{null, "No entity exists at that index."};
        }
        RadarEntry e = this.entries.get(index);
        return new Object[]{e.blipLevel};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEntityAtIndex(Context context, Arguments args) {
        int index = args.checkInteger(0) - 1;
        if (index > this.entries.size() || index < 0) {
            return new Object[]{null, "No entity exists at that index."};
        }
        RadarEntry e = this.entries.get(index);
        int type = e.blipLevel;
        if (e.blipLevel == 11) {
            return new Object[]{true, e.posX, e.posY, e.posZ, type, e.unlocalizedName};
        }
        return new Object[]{false, e.posX, e.posY, e.posZ, type};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPos(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getSettings", "getRange", "setSettings", "getEnergyInfo", "isJammed", "getAmount", "isIndexPlayer", "getIndexType", "getEntityAtIndex", "getPos"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getSettings": {
                return this.getSettings(context, args);
            }
            case "getRange": {
                return this.getRange(context, args);
            }
            case "setSettings": {
                return this.setSettings(context, args);
            }
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "isJammed": {
                return this.isJammed(context, args);
            }
            case "getAmount": {
                return this.getAmount(context, args);
            }
            case "isIndexPlayer": {
                return this.isIndexPlayer(context, args);
            }
            case "getIndexType": {
                return this.getIndexType(context, args);
            }
            case "getEntityAtIndex": {
                return this.getEntityAtIndex(context, args);
            }
            case "getPos": {
                return this.getPos(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

