/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerOreSlopper;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIOreSlopper;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.items.special.ItemBedrockOreBase;
import com.hbm.items.special.ItemBedrockOreNew;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineOreSlopper
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IGUIProvider,
IUpgradeInfoProvider,
IFluidCopiable {
    public long power;
    public static final long maxPower = 100000L;
    public static final int waterUsedBase = 1000;
    public int waterUsed = 1000;
    public static final long consumptionBase = 200L;
    public long consumption = 200L;
    public float progress;
    public boolean processing;
    public SlopperAnimation animation = SlopperAnimation.LOWERING;
    public float slider;
    public float prevSlider;
    public float bucket;
    public float prevBucket;
    public float blades;
    public float prevBlades;
    public float fan;
    public float prevFan;
    public int delay;
    public FluidTank[] tanks;
    public double[] ores = new double[ItemBedrockOreNew.BedrockOreType.values().length];
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    private static final int[] slot_access = new int[]{2, 3, 4, 5, 6, 7, 8};
    AxisAlignedBB bb = null;

    public TileEntityMachineOreSlopper() {
        super(11);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.WATER, 16000);
        this.tanks[1] = new FluidTank(Fluids.SLOP, 16000);
    }

    @Override
    public String getName() {
        return "container.machineOreSlopper";
    }

    @Override
    public void func_145845_h() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            this.tanks[0].setType(1, this.slots);
            FluidType conversion = this.getFluidOutput(this.tanks[0].getTankType());
            if (conversion != null) {
                this.tanks[1].setTankType(conversion);
            }
            for (DirPos dirPos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, dirPos.getX(), dirPos.getY(), dirPos.getZ(), dirPos.getDir());
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, dirPos.getX(), dirPos.getY(), dirPos.getZ(), dirPos.getDir());
                if (this.tanks[1].getFill() <= 0) continue;
                this.sendFluid(this.tanks[1], this.field_145850_b, dirPos.getX(), dirPos.getY(), dirPos.getZ(), dirPos.getDir());
            }
            this.processing = false;
            this.upgradeManager.checkSlots(this, this.slots, 9, 10);
            int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int efficiency = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT);
            this.consumption = 200L + 200L * (long)speed / 2L + 200L * (long)efficiency;
            if (this.canSlop()) {
                this.power -= this.consumption;
                this.progress += 1.0f / (float)(600 - speed * 150);
                this.processing = true;
                boolean markDirty = false;
                while (this.progress >= 1.0f && this.canSlop()) {
                    this.progress -= 1.0f;
                    for (ItemBedrockOreNew.BedrockOreType type : ItemBedrockOreNew.BedrockOreType.values()) {
                        int n = type.ordinal();
                        this.ores[n] = this.ores[n] + ItemBedrockOreBase.getOreAmount(this.slots[2], type) * (1.0 + (double)efficiency * 0.1);
                    }
                    this.func_70298_a(2, 1);
                    this.tanks[0].setFill(this.tanks[0].getFill() - this.waterUsed);
                    this.tanks[1].setFill(this.tanks[1].getFill() + this.waterUsed);
                    markDirty = true;
                }
                if (markDirty) {
                    this.func_70296_d();
                }
                List list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 3), (double)((double)this.field_145849_e + 1.5)).func_72317_d((double)dir.offsetX, 0.0, (double)dir.offsetZ));
                for (Entity e : list) {
                    e.func_70097_a(ModDamageSource.turbofan, 1000.0f);
                    if (e.func_70089_S() || !(e instanceof EntityLivingBase)) continue;
                    NBTTagCompound vdat = new NBTTagCompound();
                    vdat.func_74778_a("type", "giblets");
                    vdat.func_74768_a("ent", e.func_145782_y());
                    vdat.func_74768_a("cDiv", 5);
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(vdat, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5, e.field_70161_v), new NetworkRegistry.TargetPoint(e.field_71093_bK, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5, e.field_70161_v, 150.0));
                    this.field_145850_b.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, "mob.zombie.woodbreak", 2.0f, 0.95f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                }
            } else {
                this.progress = 0.0f;
            }
            for (ItemBedrockOreNew.BedrockOreType type : ItemBedrockOreNew.BedrockOreType.values()) {
                ItemStack output = ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE, type);
                block12: while (this.ores[type.ordinal()] >= 1.0) {
                    int i;
                    for (i = 3; i <= 8; ++i) {
                        if (this.slots[i] == null || this.slots[i].func_77973_b() != output.func_77973_b() || this.slots[i].func_77960_j() != output.func_77960_j() || this.slots[i].field_77994_a >= output.func_77976_d()) continue;
                        ++this.slots[i].field_77994_a;
                        int n = type.ordinal();
                        this.ores[n] = this.ores[n] - 1.0;
                        continue block12;
                    }
                    for (i = 3; i <= 8; ++i) {
                        if (this.slots[i] != null) continue;
                        this.slots[i] = output;
                        int n = type.ordinal();
                        this.ores[n] = this.ores[n] - 1.0;
                        continue block12;
                    }
                }
            }
            this.networkPackNT(150);
        } else {
            this.prevSlider = this.slider;
            this.prevBucket = this.bucket;
            this.prevBlades = this.blades;
            this.prevFan = this.fan;
            if (this.processing) {
                this.blades += 15.0f;
                this.fan += 35.0f;
                if (this.blades >= 360.0f) {
                    this.blades -= 360.0f;
                    this.prevBlades -= 360.0f;
                }
                if (this.fan >= 360.0f) {
                    this.fan -= 360.0f;
                    this.prevFan -= 360.0f;
                }
                if (this.animation == SlopperAnimation.DUMPING && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 4), (double)this.field_145849_e + 0.5) <= 50.0) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150339_S));
                    data.func_74780_a("posX", (double)this.field_145851_c + 0.5 + (double)dir.offsetX + this.field_145850_b.field_73012_v.nextGaussian() * 0.25);
                    data.func_74780_a("posY", (double)this.field_145848_d + 4.25);
                    data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + (double)dir.offsetZ + this.field_145850_b.field_73012_v.nextGaussian() * 0.25);
                    data.func_74780_a("mY", -0.2);
                    MainRegistry.proxy.effectNT(data);
                }
                if (this.delay > 0) {
                    --this.delay;
                    return;
                }
                switch (this.animation) {
                    case LOWERING: {
                        this.bucket += 0.025f;
                        if (!(this.bucket >= 1.0f)) break;
                        this.bucket = 1.0f;
                        this.animation = SlopperAnimation.LIFTING;
                        this.delay = 20;
                        break;
                    }
                    case LIFTING: {
                        this.bucket -= 0.025f;
                        if (!(this.bucket <= 0.0f)) break;
                        this.bucket = 0.0f;
                        this.animation = SlopperAnimation.MOVE_SHREDDER;
                        this.delay = 10;
                        break;
                    }
                    case MOVE_SHREDDER: {
                        this.slider += 0.02f;
                        if (!(this.slider >= 1.0f)) break;
                        this.slider = 1.0f;
                        this.animation = SlopperAnimation.DUMPING;
                        this.delay = 60;
                        break;
                    }
                    case DUMPING: {
                        this.animation = SlopperAnimation.MOVE_BUCKET;
                        break;
                    }
                    case MOVE_BUCKET: {
                        this.slider -= 0.02f;
                        if (!(this.slider <= 0.0f)) break;
                        this.animation = SlopperAnimation.LOWERING;
                        this.delay = 10;
                    }
                }
            }
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4, dir), new DirPos(this.field_145851_c - dir.offsetX * 4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 4, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 2, rot.getOpposite())};
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 2 && stack.func_77973_b() == ModItems.bedrock_ore_base;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        return i >= 3 && i <= 8;
    }

    @Override
    public int[] func_94128_d(int side) {
        return slot_access;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.consumption);
        buf.writeFloat(this.progress);
        buf.writeBoolean(this.processing);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.consumption = buf.readLong();
        this.progress = buf.readFloat();
        this.processing = buf.readBoolean();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74760_g("progress");
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "slop");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74776_a("progress", this.progress);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "slop");
    }

    public boolean canSlop() {
        if (this.getFluidOutput(this.tanks[0].getTankType()) == null) {
            return false;
        }
        if (this.tanks[0].getFill() < this.waterUsed) {
            return false;
        }
        if (this.tanks[1].getFill() + this.waterUsed > this.tanks[1].getMaxFill()) {
            return false;
        }
        if (this.power < this.consumption) {
            return false;
        }
        return this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.bedrock_ore_base;
    }

    public FluidType getFluidOutput(FluidType input) {
        if (input == Fluids.WATER) {
            return Fluids.SLOP;
        }
        return null;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 7), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerOreSlopper(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIOreSlopper(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.EFFECT;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_ore_slopper));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.EFFECT) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.efficiency", "+" + level * 10 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.EFFECT, 3);
        return upgrades;
    }

    public static enum SlopperAnimation {
        LOWERING,
        LIFTING,
        MOVE_SHREDDER,
        DUMPING,
        MOVE_BUCKET;

    }
}

