/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.inventory.container.ContainerIGenerator;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineIGenerator
extends TileEntityMachineBase
implements IFluidStandardReceiver,
IGUIProvider,
IInfoProviderEC {
    public long power;
    public int spin;
    public int[] burn = new int[4];
    public boolean hasRTG = false;
    public int[] RTGSlots = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    @SideOnly(value=Side.CLIENT)
    public float rotation;
    @SideOnly(value=Side.CLIENT)
    public float prevRotation;
    public FluidTank[] tanks = new FluidTank[3];
    public int age = 0;
    public static final int coalConRate = 75;
    public static long maxPower = 1000000L;
    public static int waterCap = 16000;
    public static int oilCap = 16000;
    public static int lubeCap = 4000;
    public static int coalGenRate = 100;
    public static double rtgHeatMult = 0.15;
    public static int waterRate = 10;
    public static int lubeRate = 1;
    public static long fluidHeatDiv = 1000L;
    protected long output;

    public TileEntityMachineIGenerator() {
        super(21);
        this.tanks[0] = new FluidTank(Fluids.WATER, waterCap);
        this.tanks[1] = new FluidTank(Fluids.HEATINGOIL, oilCap);
        this.tanks[2] = new FluidTank(Fluids.LUBRICANT, lubeCap);
    }

    @Override
    public String getName() {
        return "container.iGenerator";
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * -4, this.field_145848_d, this.field_145849_e + dir.offsetZ * -4, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * -2, this.field_145848_d - 1, this.field_145849_e + dir.offsetZ * -2, ForgeDirection.DOWN), new DirPos(this.field_145851_c + dir.offsetX * -1, this.field_145848_d - 1, this.field_145849_e + dir.offsetZ * -1, ForgeDirection.DOWN), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, ForgeDirection.DOWN), new DirPos(this.field_145851_c + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3, dir)};
    }

    @Override
    public void func_145845_h() {
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i >= 3 && i <= 6 && TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 5, 6};
    }

    public int getPowerFromFuel(boolean con) {
        FluidType type = this.tanks[1].getTankType();
        return type.hasTrait(FT_Flammable.class) ? (int)(type.getTrait(FT_Flammable.class).getHeatEnergy() / (con ? 5000L : fluidHeatDiv)) : 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].readFromNBT(nbt, "tank_" + i);
        }
        this.power = nbt.func_74763_f("power");
        this.burn = nbt.func_74759_k("burn");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].writeToNBT(nbt, "tank_" + i);
        }
        nbt.func_74772_a("power", this.power);
        nbt.func_74783_a("burn", this.burn);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerIGenerator(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.output > 0L);
        data.func_74780_a("output", (double)this.output);
    }
}

