/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.container.ContainerICF;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.inventory.gui.GUIICF;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemICFPellet;
import com.hbm.lib.Library;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityICF
extends TileEntityMachineBase
implements IGUIProvider,
IFluidStandardTransceiver,
IInfoProviderEC,
SimpleComponent,
CompatHandler.OCComponent,
IFluidCopiable {
    public long laser;
    public long maxLaser;
    public long heat;
    public static final long maxHeat = 1000000000000L;
    public long heatup;
    public int consumption;
    public int output;
    public FluidTank[] tanks = new FluidTank[3];
    public static final int[] io = new int[]{0, 1, 2, 3, 4, 6, 7, 8, 9, 10};
    AxisAlignedBB bb = null;

    public TileEntityICF() {
        super(12);
        this.tanks[0] = new FluidTank(Fluids.SODIUM, 512000);
        this.tanks[1] = new FluidTank(Fluids.SODIUM_HOT, 512000);
        this.tanks[2] = new FluidTank(Fluids.STELLAR_FLUX, 24000);
    }

    @Override
    public String getName() {
        return "container.machineICF";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            this.tanks[0].setType(11, this.slots);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            boolean markDirty = false;
            if (this.slots[5] != null && this.slots[5].func_77973_b() == ModItems.icf_pellet_depleted) {
                for (i = 6; i < 11; ++i) {
                    if (this.slots[i] != null) continue;
                    this.slots[i] = this.slots[5].func_77946_l();
                    this.slots[5] = null;
                    markDirty = true;
                    break;
                }
            }
            if (this.slots[5] == null) {
                for (i = 0; i < 5; ++i) {
                    if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.icf_pellet) continue;
                    this.slots[5] = this.slots[i].func_77946_l();
                    this.slots[i] = null;
                    markDirty = true;
                    break;
                }
            }
            this.heatup = 0L;
            if (this.slots[5] != null && this.slots[5].func_77973_b() == ModItems.icf_pellet && ItemICFPellet.getFusingDifficulty(this.slots[5]) <= this.laser) {
                this.heatup = ItemICFPellet.react(this.slots[5], this.laser);
                this.heat += this.heatup;
                if (ItemICFPellet.getDepletion(this.slots[5]) >= ItemICFPellet.getMaxDepletion(this.slots[5])) {
                    this.slots[5] = new ItemStack(ModItems.icf_pellet_depleted);
                    markDirty = true;
                }
                this.tanks[2].setFill(this.tanks[2].getFill() + (int)Math.ceil((double)this.heat * 2.5 / 1.0E12));
                if (this.tanks[2].getFill() > this.tanks[2].getMaxFill()) {
                    this.tanks[2].setFill(this.tanks[2].getMaxFill());
                }
                NBTTagCompound dPart = new NBTTagCompound();
                dPart.func_74778_a("type", "hadron");
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(dPart, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 3.5, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 25.0));
            }
            if (this.heatup == 0L) {
                this.heat = (long)((double)this.heat + (double)this.laser * 0.25);
            }
            this.consumption = 0;
            this.output = 0;
            if (this.tanks[0].getTankType().hasTrait(FT_Heatable.class)) {
                FT_Heatable trait = this.tanks[0].getTankType().getTrait(FT_Heatable.class);
                FT_Heatable.HeatingStep step = trait.getFirstStep();
                this.tanks[1].setTankType(step.typeProduced);
                int coolingCycles = this.tanks[0].getFill() / step.amountReq;
                int heatingCycles = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / step.amountProduced;
                int heatCycles = (int)Math.min((double)this.heat / 4.0 / (double)step.heatReq * trait.getEfficiency(FT_Heatable.HeatingType.ICF), (double)(this.heat / (long)step.heatReq));
                int cycles = Math.min(coolingCycles, Math.min(heatingCycles, heatCycles));
                this.tanks[0].setFill(this.tanks[0].getFill() - step.amountReq * cycles);
                this.tanks[1].setFill(this.tanks[1].getFill() + step.amountProduced * cycles);
                this.heat -= (long)(step.heatReq * cycles);
                this.consumption = step.amountReq * cycles;
                this.output = step.amountProduced * cycles;
            }
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.heat = (long)((double)this.heat * 0.999);
            if (this.heat > 1000000000000L) {
                this.heat = 1000000000000L;
            }
            if (markDirty) {
                this.func_70296_d();
            }
            this.networkPackNT(150);
            this.laser = 0L;
            this.maxLaser = 0L;
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + 6, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + dir.offsetX * 3 + rot.offsetX * 6, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 3 + rot.offsetZ * 6, dir), new DirPos(this.field_145851_c + dir.offsetX * 3 - rot.offsetX * 6, this.field_145848_d + 3, this.field_145849_e + dir.offsetZ * 3 - rot.offsetZ * 6, dir), new DirPos(this.field_145851_c - dir.offsetX * 3 + rot.offsetX * 6, this.field_145848_d + 3, this.field_145849_e - dir.offsetZ * 3 + rot.offsetZ * 6, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 3 - rot.offsetX * 6, this.field_145848_d + 3, this.field_145849_e - dir.offsetZ * 3 - rot.offsetZ * 6, dir.getOpposite())};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.laser);
        buf.writeLong(this.maxLaser);
        buf.writeLong(this.heat);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.laser = buf.readLong();
        this.maxLaser = buf.readLong();
        this.heat = buf.readLong();
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot < 5 && stack.func_77973_b() == ModItems.icf_pellet;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot > 5;
    }

    @Override
    public int[] func_94128_d(int side) {
        return io;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
        this.heat = nbt.func_74763_f("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
        nbt.func_74772_a("heat", this.heat);
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 256.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - 8.0), (double)this.field_145848_d, (double)((double)this.field_145849_e + 0.5 - 8.0), (double)((double)this.field_145851_c + 0.5 + 9.0), (double)((double)this.field_145848_d + 0.5 + 5.0), (double)((double)this.field_145849_e + 0.5 + 9.0));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerICF(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIICF(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.heatup > 0L);
        data.func_74772_a("capacityTU", 1000000000000L);
        data.func_74772_a("energyTU", this.heat);
        data.func_74780_a("consumption", (double)this.consumption);
        data.func_74780_a("outputmb", (double)this.output);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_icf_reactor";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeatingRate(Context context, Arguments args) {
        return new Object[]{this.heatup};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getMaxHeat(Context context, Arguments args) {
        return new Object[]{1000000000000L};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.laser};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[0].getTankType().getUnlocalizedName(), this.tanks[1].getFill(), this.tanks[1].getMaxFill(), this.tanks[1].getTankType().getUnlocalizedName(), this.tanks[2].getFill(), this.tanks[2].getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPelletStats(Context context, Arguments args) {
        return new Object[]{ItemICFPellet.getDepletion(this.slots[5]), ItemICFPellet.getMaxDepletion(this.slots[5]), ItemICFPellet.getFusingDifficulty(this.slots[5]), ItemICFPellet.getType(this.slots[5], true).name(), ItemICFPellet.getType(this.slots[5], false).name()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getHeat", "getHeatingRate", "getMaxHeat", "getPower", "getFluid", "getPelletStats"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getHeat": {
                return this.getHeat(context, args);
            }
            case "getHeatingRate": {
                return this.getHeatingRate(context, args);
            }
            case "getMaxHeat": {
                return this.getMaxHeat(context, args);
            }
            case "getPower": {
                return this.getPower(context, args);
            }
            case "getFluid": {
                return this.getFluid(context, args);
            }
            case "getPelletStats": {
                return this.getPelletStats(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

