/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.container.ContainerFurnaceSteel;
import com.hbm.inventory.gui.GUIFurnaceSteel;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceSteel
extends TileEntityMachineBase
implements IGUIProvider {
    public int[] progress = new int[3];
    public int[] bonus = new int[3];
    public static final int processTime = 40000;
    public int heat;
    public static final int maxHeat = 100000;
    public static final double diffusion = 0.05;
    private ItemStack[] lastItems = new ItemStack[3];
    public boolean wasOn = false;
    AxisAlignedBB bb = null;

    public TileEntityFurnaceSteel() {
        super(6);
    }

    @Override
    public String getName() {
        return "container.furnaceSteel";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tryPullHeat();
            this.wasOn = false;
            int burn = (this.heat - 100000 / 3) / 10;
            for (int i = 0; i < 3; ++i) {
                if (this.slots[i] == null || this.lastItems[i] == null || !this.slots[i].func_77969_a(this.lastItems[i])) {
                    this.progress[i] = 0;
                    this.bonus[i] = 0;
                }
                if (this.canSmelt(i)) {
                    int n = i;
                    this.progress[n] = this.progress[n] + burn;
                    this.heat -= burn;
                    this.wasOn = true;
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.08f);
                    }
                }
                this.lastItems[i] = this.slots[i];
                if (this.progress[i] < 40000) continue;
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[i]);
                if (this.slots[i + 3] == null) {
                    this.slots[i + 3] = result.func_77946_l();
                } else {
                    this.slots[i + 3].field_77994_a += result.field_77994_a;
                }
                this.addBonus(this.slots[i], i);
                while (this.bonus[i] >= 100) {
                    this.slots[i + 3].field_77994_a = Math.min(this.slots[i + 3].func_77976_d(), this.slots[i + 3].field_77994_a + result.field_77994_a);
                    int n = i;
                    this.bonus[n] = this.bonus[n] - 100;
                }
                this.func_70298_a(i, 1);
                this.progress[i] = 0;
            }
            this.networkPackNT(50);
        } else if (this.wasOn) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 - (double)dir.offsetX * 1.125 - (double)rot.offsetX * 0.75, (double)this.field_145848_d + 2.625, (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * 1.125 - (double)rot.offsetZ * 0.75, 0.0, 0.05, 0.0);
            if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 0.75, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 0.75, 0.0, 0.05, 0.0);
            }
            if (this.field_145850_b.field_73012_v.nextInt(15) == 0) {
                this.field_145850_b.func_72869_a("lava", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 1.5 + (double)rot.offsetX * (this.field_145850_b.field_73012_v.nextDouble() - 0.5), (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 1.5 + (double)rot.offsetZ * (this.field_145850_b.field_73012_v.nextDouble() - 0.5), (double)dir.offsetX * 0.5, 0.05, (double)dir.offsetZ * 0.5);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        BufferUtil.writeIntArray(buf, this.progress);
        BufferUtil.writeIntArray(buf, this.bonus);
        buf.writeInt(this.heat);
        buf.writeBoolean(this.wasOn);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.progress = BufferUtil.readIntArray(buf);
        this.bonus = BufferUtil.readIntArray(buf);
        this.heat = buf.readInt();
        this.wasOn = buf.readBoolean();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74759_k("progress");
        this.bonus = nbt.func_74759_k("bonus");
        this.heat = nbt.func_74762_e("heat");
        NBTTagList list = nbt.func_150295_c("lastItems", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("lastItem");
            if (b0 < 0 || b0 >= this.lastItems.length) continue;
            this.lastItems[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74783_a("progress", this.progress);
        nbt.func_74783_a("bonus", this.bonus);
        nbt.func_74768_a("heat", this.heat);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.lastItems.length; ++i) {
            if (this.lastItems[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("lastItem", (byte)i);
            this.lastItems[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("lastItems", (NBTBase)list);
    }

    protected void addBonus(ItemStack stack, int index) {
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        for (String name : names) {
            if (name.startsWith("ore")) {
                int n = index;
                this.bonus[n] = this.bonus[n] + 25;
                return;
            }
            if (name.startsWith("log")) {
                int n = index;
                this.bonus[n] = this.bonus[n] + 50;
                return;
            }
            if (!name.equals("anyTar")) continue;
            int n = index;
            this.bonus[n] = this.bonus[n] + 50;
            return;
        }
    }

    protected void tryPullHeat() {
        if (this.heat >= 100000) {
            return;
        }
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * 0.05);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > 100000) {
                    this.heat = 100000;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    public boolean canSmelt(int index) {
        if (this.heat < 100000 / 3) {
            return false;
        }
        if (this.slots[index] == null) {
            return false;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[index]);
        if (result == null) {
            return false;
        }
        if (this.slots[index + 3] == null) {
            return true;
        }
        if (!result.func_77969_a(this.slots[index + 3])) {
            return false;
        }
        return result.field_77994_a + this.slots[index + 3].field_77994_a <= this.slots[index + 3].func_77976_d();
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i < 3) {
            return FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i > 2;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFurnaceSteel(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFurnaceSteel(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

