/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardSender;
import api.hbm.tile.IHeatSource;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerFurnaceCombo;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIFurnaceCombo;
import com.hbm.inventory.recipes.CombinationRecipes;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.Tuple;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceCombination
extends TileEntityMachinePolluting
implements IFluidStandardSender,
IGUIProvider,
IFluidCopiable {
    public boolean wasOn;
    public int progress;
    public static int processTime = 20000;
    public int heat;
    public static int maxHeat = 100000;
    public static double diffusion = 0.25;
    public FluidTank tank = new FluidTank(Fluids.NONE, 24000);
    AxisAlignedBB bb = null;

    public TileEntityFurnaceCombination() {
        super(4, 50);
    }

    @Override
    public String getName() {
        return "container.furnaceCombination";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tryPullHeat();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (int i = 2; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                    ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                    for (int y = this.field_145848_d; y <= this.field_145848_d + 1; ++y) {
                        for (int j = -1; j <= 1; ++j) {
                            if (this.tank.getFill() > 0) {
                                this.sendFluid(this.tank, this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * j, y, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * j, dir);
                            }
                            this.sendSmoke(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * j, y, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * j, dir);
                        }
                    }
                }
                for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
                    for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                        if (this.tank.getFill() > 0) {
                            this.sendFluid(this.tank, this.field_145850_b, x, this.field_145848_d + 2, z, ForgeDirection.UP);
                        }
                        this.sendSmoke(x, this.field_145848_d + 2, z, ForgeDirection.UP);
                    }
                }
            }
            this.wasOn = false;
            this.tank.unloadTank(2, 3, this.slots);
            if (this.canSmelt()) {
                int burn = this.heat / 100;
                if (burn > 0) {
                    this.wasOn = true;
                    this.progress += burn;
                    this.heat -= burn;
                    if (this.progress >= processTime) {
                        this.markChanged();
                        this.progress -= processTime;
                        Tuple.Pair<ItemStack, FluidStack> pair = CombinationRecipes.getOutput(this.slots[0]);
                        ItemStack out = pair.getKey();
                        FluidStack fluid = pair.getValue();
                        if (out != null) {
                            if (this.slots[1] == null) {
                                this.slots[1] = out.func_77946_l();
                            } else {
                                this.slots[1].field_77994_a += out.field_77994_a;
                            }
                        }
                        if (fluid != null) {
                            if (this.tank.getTankType() != fluid.type) {
                                this.tank.setTankType(fluid.type);
                            }
                            this.tank.setFill(this.tank.getFill() + fluid.fill);
                        }
                        this.func_70298_a(0, 1);
                    }
                    List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)(this.field_145848_d + 2), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 4), (double)((double)this.field_145849_e + 1.5)));
                    for (Entity e : entities) {
                        e.func_70015_d(5);
                    }
                    if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, "hbm:weapon.flamethrowerShoot", 0.25f, 0.5f);
                    }
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        this.pollute(PollutionHandler.PollutionType.SOOT, 0.12f);
                    }
                }
            } else {
                this.progress = 0;
            }
            this.networkPackNT(50);
        } else if (this.wasOn && this.field_145850_b.field_73012_v.nextInt(15) == 0) {
            this.field_145850_b.func_72869_a("lava", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.wasOn);
        buf.writeInt(this.heat);
        buf.writeInt(this.progress);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.wasOn = buf.readBoolean();
        this.heat = buf.readInt();
        this.progress = buf.readInt();
        this.tank.deserialize(buf);
    }

    public boolean canSmelt() {
        if (this.slots[0] == null) {
            return false;
        }
        Tuple.Pair<ItemStack, FluidStack> pair = CombinationRecipes.getOutput(this.slots[0]);
        if (pair == null) {
            return false;
        }
        ItemStack out = pair.getKey();
        FluidStack fluid = pair.getValue();
        if (out != null && this.slots[1] != null) {
            if (!out.func_77969_a(this.slots[1])) {
                return false;
            }
            if (out.field_77994_a + this.slots[1].field_77994_a > this.slots[1].func_77976_d()) {
                return false;
            }
        }
        if (fluid != null) {
            if (this.tank.getTankType() != fluid.type && this.tank.getFill() > 0) {
                return false;
            }
            if (this.tank.getTankType() == fluid.type && this.tank.getFill() + fluid.fill > this.tank.getMaxFill()) {
                return false;
            }
        }
        return true;
    }

    protected void tryPullHeat() {
        if (this.heat >= maxHeat) {
            return;
        }
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * diffusion);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > maxHeat) {
                    this.heat = maxHeat;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0 && CombinationRecipes.getOutput(itemStack) != null;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "tank");
        this.progress = nbt.func_74762_e("prog");
        this.heat = nbt.func_74762_e("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74768_a("prog", this.progress);
        nbt.func_74768_a("heat", this.heat);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFurnaceCombo(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFurnaceCombo(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)((double)this.field_145848_d + 2.125), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tank, this.smoke, this.smoke_leaded, this.smoke_poison};
    }
}

