/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.google.common.annotations.Beta;
import com.hbm.config.VersatileConfig;
import com.hbm.interfaces.Untested;
import com.hbm.tileentity.IRadioisotopeFuel;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface IRTGUser {
    public int getHeat();

    public Class<? extends IRadioisotopeFuel> getDesiredClass();

    default public boolean isItemValid(Item itemIn) {
        return itemIn instanceof IRadioisotopeFuel && this.getDesiredClass().isAssignableFrom(itemIn.getClass());
    }

    public static short getPower(IRadioisotopeFuel fuel, ItemStack stack) {
        return VersatileConfig.scaleRTGPower() ? IRadioisotopeFuel.getScaledPower(fuel, stack) : fuel.getHeat();
    }

    default public int updateRTGs(ItemStack[] inventory, int[] rtgIn) {
        int newHeat = 0;
        for (int slot : rtgIn) {
            if (inventory[slot] == null || !this.isItemValid(inventory[slot].func_77973_b())) continue;
            IRadioisotopeFuel pellet = (IRadioisotopeFuel)inventory[slot].func_77973_b();
            newHeat += IRTGUser.getPower(pellet, inventory[slot]);
            inventory[slot] = IRadioisotopeFuel.handleDecay(inventory[slot], pellet);
        }
        return newHeat;
    }

    default public int updateRTGs(ItemStack[] inventory) {
        int newHeat = 0;
        for (int slot = 0; slot < inventory.length; ++slot) {
            if (inventory[slot] == null || !this.isItemValid(inventory[slot].func_77973_b())) continue;
            IRadioisotopeFuel pellet = (IRadioisotopeFuel)inventory[slot].func_77973_b();
            newHeat += IRTGUser.getPower(pellet, inventory[slot]);
            inventory[slot] = IRadioisotopeFuel.handleDecay(inventory[slot], pellet);
        }
        return newHeat;
    }

    @Untested
    @Beta
    default public int updateRTGs(ArrayList<ItemStack> rtgList) {
        int newHeat = 0;
        for (ItemStack pellet : rtgList) {
            IRadioisotopeFuel fuel = (IRadioisotopeFuel)pellet.func_77973_b();
            newHeat += IRTGUser.getPower(fuel, pellet);
            if (!fuel.getDoesDecay()) continue;
            if (fuel.getLifespan(pellet) <= 0L) {
                rtgList.remove(pellet);
                continue;
            }
            fuel.decay(pellet);
        }
        return newHeat;
    }

    @Untested
    @Beta
    default public int updateRTGs(ArrayList<ItemStack> rtgList, ArrayList<ItemStack> deplList) {
        int newHeat = 0;
        for (ItemStack pellet : rtgList) {
            int i;
            IRadioisotopeFuel fuel = (IRadioisotopeFuel)pellet.func_77973_b();
            newHeat += IRTGUser.getPower(fuel, pellet);
            if (!fuel.getDoesDecay() || fuel.getLifespan(pellet) > 0L) continue;
            rtgList.remove(pellet);
            boolean alreadyExists = false;
            ItemStack decayItem = fuel.getDecayItem();
            for (i = 0; i < deplList.size(); ++i) {
                if (deplList.get(i).func_77973_b() == decayItem.func_77973_b() && deplList.get(i).func_77960_j() == decayItem.func_77960_j() && deplList.get((int)i).field_77994_a + decayItem.field_77994_a <= decayItem.func_77976_d()) {
                    alreadyExists = true;
                } else if (deplList.get((int)i).field_77994_a + decayItem.field_77994_a > decayItem.func_77976_d()) continue;
                if (alreadyExists) break;
            }
            if (alreadyExists) {
                for (i = 0; i < deplList.size(); ++i) {
                    if (deplList.get(i).func_77973_b() != decayItem.func_77973_b() || deplList.get(i).func_77960_j() != decayItem.func_77960_j() || deplList.get((int)i).field_77994_a + decayItem.field_77994_a > decayItem.func_77976_d()) continue;
                    deplList.get((int)i).field_77994_a += decayItem.field_77994_a;
                }
                continue;
            }
            deplList.add(fuel.getDecayItem());
        }
        return newHeat;
    }

    @Untested
    @Beta
    default public int updateRTGs(ItemStack[] inventory, HashMap<Item, IRadioisotopeFuel> fuelMap) {
        int newHeat = 0;
        for (int slot = 0; slot < inventory.length; ++slot) {
            if (inventory[slot] == null || IRadioisotopeFuel.getInstance(inventory[slot]) == null || !fuelMap.containsKey(inventory[slot].func_77973_b())) continue;
            IRadioisotopeFuel fuel = IRadioisotopeFuel.getInstance(inventory[slot]);
            newHeat += IRTGUser.getPower(fuel, inventory[slot]);
            inventory[slot] = IRadioisotopeFuel.handleDecay(inventory[slot], fuel);
        }
        return newHeat;
    }
}

