/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.block.ct;

import com.hbm.render.block.ct.IBlockCT;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class CTContext {
    public static CTFace[] faces;
    public static int[][][] access;

    private static int[][] lcfs(ForgeDirection up, ForgeDirection left) {
        ForgeDirection down = up.getOpposite();
        ForgeDirection right = left.getOpposite();
        int[][] lexicalCoordinates = new int[][]{CTContext.cfs(up, left), CTContext.cfs(up), CTContext.cfs(up, right), CTContext.cfs(left), CTContext.cfs(right), CTContext.cfs(down, left), CTContext.cfs(down), CTContext.cfs(down, right)};
        return lexicalCoordinates;
    }

    private static int[] cfs(ForgeDirection ... dirs) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (ForgeDirection dir : dirs) {
            x += dir.offsetX;
            y += dir.offsetY;
            z += dir.offsetZ;
        }
        return new int[]{x, y, z};
    }

    public static void loadContext(IBlockAccess world, int x, int y, int z, Block block) {
        faces = new CTFace[6];
        for (int i = 0; i < 6; ++i) {
            boolean[] cons = new boolean[8];
            int[][] dirs = access[i];
            for (int j = 0; j < 8; ++j) {
                int[] coord = dirs[j];
                Block neighbor = world.func_147439_a(x + coord[0], y + coord[1], z + coord[2]);
                if (!((IBlockCT)block).canConnect(world, x + coord[0], y + coord[1], z + coord[2], neighbor)) continue;
                cons[j] = true;
            }
            int itl = 0 | CTContext.cornerType(cons[3], cons[0], cons[1]);
            int itr = 1 | CTContext.cornerType(cons[4], cons[2], cons[1]);
            int ibl = 2 | CTContext.cornerType(cons[3], cons[5], cons[6]);
            int ibr = 3 | CTContext.cornerType(cons[4], cons[7], cons[6]);
            CTContext.faces[i] = new CTFace(world, x, y, z, (IBlockCT)block, itl, itr, ibl, ibr);
        }
    }

    public static int cornerType(boolean hor, boolean corner, boolean vert) {
        if (vert && hor && corner) {
            return 4;
        }
        if (vert && hor) {
            return 8;
        }
        if (vert) {
            return 16;
        }
        if (hor) {
            return 12;
        }
        return 0;
    }

    public static boolean isContextLoaded() {
        return faces != null;
    }

    public static void dropContext() {
        faces = null;
    }

    static {
        access = new int[][][]{CTContext.lcfs(ForgeDirection.SOUTH, ForgeDirection.WEST), CTContext.lcfs(ForgeDirection.NORTH, ForgeDirection.WEST), CTContext.lcfs(ForgeDirection.UP, ForgeDirection.EAST), CTContext.lcfs(ForgeDirection.UP, ForgeDirection.WEST), CTContext.lcfs(ForgeDirection.UP, ForgeDirection.NORTH), CTContext.lcfs(ForgeDirection.UP, ForgeDirection.SOUTH)};
    }

    public static class CTFace {
        IBlockAccess world;
        int x;
        int y;
        int z;
        IBlockCT ct;
        int index_tl;
        int index_tr;
        int index_bl;
        int index_br;

        public CTFace() {
        }

        public CTFace(IBlockAccess world, int x, int y, int z, IBlockCT block, int i, int j, int k, int l) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.ct = block;
            this.index_tl = i;
            this.index_tr = j;
            this.index_bl = k;
            this.index_br = l;
        }

        public IIcon getTopLeft() {
            return this.ct.getFragments(this.world, this.x, this.y, this.z)[this.index_tl];
        }

        public IIcon getTopRight() {
            return this.ct.getFragments(this.world, this.x, this.y, this.z)[this.index_tr];
        }

        public IIcon getBottomLeft() {
            return this.ct.getFragments(this.world, this.x, this.y, this.z)[this.index_bl];
        }

        public IIcon getBottomRight() {
            return this.ct.getFragments(this.world, this.x, this.y, this.z)[this.index_br];
        }
    }
}

