/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet.toclient;

import com.hbm.world.WorldUtil;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.chunk.Chunk;

public class BiomeSyncPacket
implements IMessage {
    int chunkX;
    int chunkZ;
    byte blockX;
    byte blockZ;
    short biome;
    short[] biomeArray;

    public BiomeSyncPacket() {
    }

    public BiomeSyncPacket(int chunkX, int chunkZ, byte[] biomeArray) {
        this(chunkX, chunkZ, BiomeSyncPacket.bytesToShorts(biomeArray));
    }

    public BiomeSyncPacket(int blockX, int blockZ, byte biome) {
        this(blockX, blockZ, (short)biome);
    }

    public BiomeSyncPacket(int chunkX, int chunkZ, short[] biomeArray) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.biomeArray = biomeArray;
    }

    public BiomeSyncPacket(int blockX, int blockZ, short biome) {
        this.chunkX = blockX >> 4;
        this.chunkZ = blockZ >> 4;
        this.blockX = (byte)(blockX & 0xF);
        this.blockZ = (byte)(blockZ & 0xF);
        this.biome = biome;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        if (this.biomeArray == null) {
            buf.writeBoolean(false);
            buf.writeShort((int)this.biome);
            buf.writeByte((int)this.blockX);
            buf.writeByte((int)this.blockZ);
        } else {
            buf.writeBoolean(true);
            for (int i = 0; i < 256; ++i) {
                buf.writeShort((int)this.biomeArray[i]);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        if (!buf.readBoolean()) {
            this.biome = buf.readShort();
            this.blockX = buf.readByte();
            this.blockZ = buf.readByte();
        } else {
            this.biomeArray = new short[256];
            for (int i = 0; i < 256; ++i) {
                this.biomeArray[i] = buf.readShort();
            }
        }
    }

    private static final short[] bytesToShorts(byte[] byteArray) {
        int size = byteArray.length;
        short[] shortArray = new short[size];
        for (int index = 0; index < size; ++index) {
            shortArray[index] = byteArray[index];
        }
        return shortArray;
    }

    public static class Handler
    implements IMessageHandler<BiomeSyncPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(BiomeSyncPacket m, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (!world.func_72863_F().func_73149_a(m.chunkX, m.chunkZ)) {
                return null;
            }
            Chunk chunk = world.func_72964_e(m.chunkX, m.chunkZ);
            chunk.field_76643_l = true;
            if (Loader.isModLoaded((String)"endlessids")) {
                short[] target = WorldUtil.getBiomeShortArray(chunk);
                if (m.biomeArray == null) {
                    target[(m.blockZ & 0xF) << 4 | m.blockX & 0xF] = m.biome;
                    world.func_147458_c(m.chunkX << 4, 0, m.chunkZ << 4, m.chunkX << 4, 255, m.chunkZ << 4);
                } else {
                    for (int i = 0; i < 255; ++i) {
                        target[i] = m.biomeArray[i];
                        world.func_147458_c(m.chunkX << 4, 0, m.chunkZ << 4, (m.chunkX << 4) + 15, 255, (m.chunkZ << 4) + 15);
                    }
                }
            } else {
                byte[] target = chunk.func_76605_m();
                if (m.biomeArray == null) {
                    target[(m.blockZ & 0xF) << 4 | m.blockX & 0xF] = (byte)m.biome;
                    world.func_147458_c(m.chunkX << 4, 0, m.chunkZ << 4, m.chunkX << 4, 255, m.chunkZ << 4);
                } else {
                    for (int i = 0; i < 256; ++i) {
                        target[i] = (byte)m.biomeArray[i];
                        world.func_147458_c(m.chunkX << 4, 0, m.chunkZ << 4, (m.chunkX << 4) + 15, 255, (m.chunkZ << 4) + 15);
                    }
                }
            }
            return null;
        }
    }
}

