/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.items.ItemCustomLore;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemMissile
extends ItemCustomLore {
    public final MissileFormFactor formFactor;
    public final MissileTier tier;
    public final MissileFuel fuel;
    public int fuelCap;
    public boolean launchable = true;

    public ItemMissile(MissileFormFactor form, MissileTier tier) {
        this(form, tier, form.defaultFuel);
    }

    public ItemMissile(MissileFormFactor form, MissileTier tier, MissileFuel fuel) {
        this.formFactor = form;
        this.tier = tier;
        this.fuel = fuel;
        this.setFuelCap(this.fuel.defaultCap);
    }

    public ItemMissile notLaunchable() {
        this.launchable = false;
        return this;
    }

    public ItemMissile setFuelCap(int fuelCap) {
        this.fuelCap = fuelCap;
        return this;
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        String tierKey = "item.missile.tier." + this.tier.name().toLowerCase();
        list.add(EnumChatFormatting.ITALIC + I18nUtil.resolveKey(tierKey, new Object[0]));
        if (!this.launchable) {
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("item.missile.desc.notLaunchable", new Object[0]));
        } else {
            list.add(I18nUtil.resolveKey("item.missile.desc.fuel", new Object[0]) + ": " + this.fuel.getDisplay());
            if (this.fuelCap > 0) {
                list.add(I18nUtil.resolveKey("item.missile.desc.fuelCapacity", new Object[0]) + ": " + this.fuelCap + "mB");
            }
            super.func_77624_a(itemstack, player, list, bool);
        }
    }

    public static enum MissileFuel {
        SOLID("item.missile.fuel.solid.prefueled", EnumChatFormatting.GOLD, 0),
        ETHANOL_PEROXIDE("item.missile.fuel.ethanol_peroxide", EnumChatFormatting.AQUA, 4000),
        KEROSENE_PEROXIDE("item.missile.fuel.kerosene_peroxide", EnumChatFormatting.BLUE, 8000),
        KEROSENE_LOXY("item.missile.fuel.kerosene_loxy", EnumChatFormatting.LIGHT_PURPLE, 12000),
        JETFUEL_LOXY("item.missile.fuel.jetfuel_loxy", EnumChatFormatting.RED, 16000);

        private final String key;
        public final EnumChatFormatting color;
        public final int defaultCap;

        private MissileFuel(String key, EnumChatFormatting color, int defaultCap) {
            this.key = key;
            this.color = color;
            this.defaultCap = defaultCap;
        }

        public String getDisplay() {
            return this.color + I18nUtil.resolveKey(this.key, new Object[0]);
        }
    }

    public static enum MissileTier {
        TIER0("Tier 0"),
        TIER1("Tier 1"),
        TIER2("Tier 2"),
        TIER3("Tier 3"),
        TIER4("Tier 4");

        public String display;

        private MissileTier(String display) {
            this.display = display;
        }
    }

    public static enum MissileFormFactor {
        ABM(MissileFuel.SOLID),
        MICRO(MissileFuel.SOLID),
        V2(MissileFuel.ETHANOL_PEROXIDE),
        STRONG(MissileFuel.KEROSENE_PEROXIDE),
        HUGE(MissileFuel.KEROSENE_LOXY),
        ATLAS(MissileFuel.JETFUEL_LOXY),
        OTHER(MissileFuel.KEROSENE_PEROXIDE);

        protected MissileFuel defaultFuel;

        private MissileFormFactor(MissileFuel defaultFuel) {
            this.defaultFuel = defaultFuel;
        }
    }
}

