/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.fluidmk2.IFillableItem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemPipette
extends Item
implements IFillableItem {
    @SideOnly(value=Side.CLIENT)
    protected IIcon overlayIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon emptyIcon;

    public ItemPipette() {
        this.canRepair = false;
        this.func_77656_e(1);
    }

    public short getMaxFill() {
        if (this == ModItems.pipette_laboratory) {
            return 50;
        }
        return 1000;
    }

    public void initNBT(ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        this.setFill(stack, Fluids.NONE, (short)0);
        stack.field_77990_d.func_74777_a("capacity", this.getMaxFill());
    }

    public FluidType getType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        return Fluids.fromID(stack.field_77990_d.func_74765_d("type"));
    }

    public short getCapacity(ItemStack stack) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        return stack.field_77990_d.func_74765_d("capacity");
    }

    public void setFill(ItemStack stack, FluidType type, short fill) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        stack.field_77990_d.func_74777_a("type", (short)type.getID());
        stack.field_77990_d.func_74777_a("fill", fill);
    }

    @Override
    public int getFill(ItemStack stack) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        return stack.field_77990_d.func_74765_d("fill");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        if (!world.field_72995_K) {
            if (this.getFill(stack) == 0) {
                int a = this == ModItems.pipette_laboratory ? (!player.func_70093_af() ? Math.min(this.getCapacity(stack) + 1, 50) : Math.max(this.getCapacity(stack) - 1, 1)) : (!player.func_70093_af() ? Math.min(this.getCapacity(stack) + 50, 1000) : Math.max(this.getCapacity(stack) - 50, 50));
                stack.field_77990_d.func_74777_a("capacity", (short)a);
                player.func_145747_a((IChatComponent)new ChatComponentText(a + "/" + this.getMaxFill() + "mB"));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("desc.item.pipette.noEmpty", new Object[0]));
            }
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (this == ModItems.pipette_laboratory) {
            list.add(I18nUtil.resolveKey("desc.item.pipette.corrosive", new Object[0]));
            list.add(I18nUtil.resolveKey("desc.item.pipette.laboratory", new Object[0]));
        }
        if (this == ModItems.pipette_boron) {
            list.add(I18nUtil.resolveKey("desc.item.pipette.corrosive", new Object[0]));
        }
        if (this == ModItems.pipette) {
            list.add(I18nUtil.resolveKey("desc.item.pipette.noCorrosive", new Object[0]));
        }
        list.add("Fluid: " + this.getType(stack).getLocalizedName());
        list.add("Amount: " + this.getFill(stack) + "/" + this.getCapacity(stack) + "mB (" + this.getMaxFill() + "mB)");
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        return (type == this.getType(stack) || this.getFill(stack) == 0) && !type.isAntimatter();
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        if (this.getFill(stack) == 0) {
            this.setFill(stack, type, (short)0);
        }
        int req = this.getCapacity(stack) - this.getFill(stack);
        int toFill = Math.min(req, amount);
        this.setFill(stack, type, (short)(this.getFill(stack) + toFill));
        if (this.getFill(stack) > 0 && this.willFizzle(type)) {
            stack.field_77994_a = 0;
        }
        return amount - toFill;
    }

    public boolean willFizzle(FluidType type) {
        if (this != ModItems.pipette) {
            return false;
        }
        return type.isCorrosive() && type != Fluids.PEROXIDE;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return this.getType(stack) == type;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        if (this.providesFluid(type, stack)) {
            int toUnload = Math.min(amount, this.getFill(stack));
            this.setFill(stack, type, (short)(this.getFill(stack) - toUnload));
            if (this.getFill(stack) == 0) {
                this.setFill(stack, Fluids.NONE, (short)0);
            }
            return toUnload;
        }
        return amount;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        super.func_94581_a(icon);
        this.overlayIcon = this == ModItems.pipette_laboratory ? icon.func_94245_a("hbm:pipette_laboratory_overlay") : icon.func_94245_a("hbm:pipette_overlay");
        this.emptyIcon = icon.func_94245_a("hbm:pipette_empty");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (this.getFill(stack) == 0 && pass == 1) {
            return this.emptyIcon;
        }
        return pass == 1 ? this.overlayIcon : this.func_77618_c(stack.func_77960_j(), pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass == 0) {
            return 0xFFFFFF;
        }
        int j = this.getType(stack).getColor();
        if (j < 0) {
            j = 0xFFFFFF;
        }
        return j;
    }

    @Override
    public FluidType getFirstFluidType(ItemStack stack) {
        return this.getType(stack);
    }
}

