/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.config.VersatileConfig;
import com.hbm.items.ItemCustomLore;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.potion.HbmPotion;
import com.hbm.util.EnchantmentUtil;
import com.hbm.util.Tuple;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class ItemSimpleConsumable
extends ItemCustomLore {
    private BiConsumer<ItemStack, EntityPlayer> useAction;
    private BiConsumer<ItemStack, EntityPlayer> useActionServer;
    private BiConsumer<ItemStack, Tuple.Pair<EntityLivingBase, EntityLivingBase>> hitAction;
    private BiConsumer<ItemStack, Tuple.Pair<EntityLivingBase, EntityLivingBase>> hitActionServer;

    public ItemSimpleConsumable() {
        this.func_77637_a(MainRegistry.consumableTab);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.useAction != null) {
            this.useAction.accept(stack, player);
        }
        if (!world.field_72995_K && this.useActionServer != null) {
            this.useActionServer.accept(stack, player);
        }
        return stack;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase entityPlayer) {
        if (this.hitAction != null) {
            this.hitAction.accept(stack, new Tuple.Pair<EntityLivingBase, EntityLivingBase>(entity, entityPlayer));
        }
        if (!entity.field_70170_p.field_72995_K && this.hitActionServer != null) {
            this.hitActionServer.accept(stack, new Tuple.Pair<EntityLivingBase, EntityLivingBase>(entity, entityPlayer));
        }
        return false;
    }

    public static void giveSoundAndDecrement(ItemStack stack, EntityLivingBase entity, String sound, ItemStack container) {
        --stack.field_77994_a;
        entity.field_70170_p.func_72956_a((Entity)entity, sound, 1.0f, 1.0f);
        ItemSimpleConsumable.tryAddItem(entity, container);
    }

    public static void addPotionEffect(EntityLivingBase entity, Potion effect, int duration, int level) {
        if (!entity.func_70644_a(effect)) {
            entity.func_70690_d(new PotionEffect(effect.field_76415_H, duration, level));
        } else {
            int d = entity.func_70660_b(effect).func_76459_b() + duration;
            entity.func_70690_d(new PotionEffect(effect.field_76415_H, d, level));
        }
    }

    public static void tryAddItem(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71071_by.func_70441_a(stack)) {
                player.func_71019_a(stack, false);
            }
        }
    }

    public static void doRadaway(ItemStack stack, EntityPlayer user, int duration) {
        ItemSimpleConsumable.giveSoundAndDecrement(stack, (EntityLivingBase)user, "hbm:item.radaway", new ItemStack(ModItems.iv_empty));
        ItemSimpleConsumable.addPotionEffect((EntityLivingBase)user, HbmPotion.radaway, duration, 0);
    }

    public ItemSimpleConsumable setUseAction(BiConsumer<ItemStack, EntityPlayer> delegate) {
        this.useAction = delegate;
        return this;
    }

    public ItemSimpleConsumable setUseActionServer(BiConsumer<ItemStack, EntityPlayer> delegate) {
        this.useActionServer = delegate;
        return this;
    }

    public ItemSimpleConsumable setHitAction(BiConsumer<ItemStack, Tuple.Pair<EntityLivingBase, EntityLivingBase>> delegate) {
        this.hitAction = delegate;
        return this;
    }

    public ItemSimpleConsumable setHitActionServer(BiConsumer<ItemStack, Tuple.Pair<EntityLivingBase, EntityLivingBase>> delegate) {
        this.hitActionServer = delegate;
        return this;
    }

    public static void init() {
        ModItems.syringe_antidote = new ItemSimpleConsumable().setUseActionServer((stack, user) -> ItemSimpleConsumable.effectAntidote(stack, (EntityLivingBase)user, (EntityLivingBase)user)).setHitActionServer((stack, pair) -> ItemSimpleConsumable.effectAntidote(stack, (EntityLivingBase)pair.key, (EntityLivingBase)pair.value)).func_77655_b("syringe_antidote").func_77664_n().func_111206_d("hbm:syringe_antidote");
        ModItems.syringe_poison = new ItemSimpleConsumable().setUseActionServer((stack, user) -> ItemSimpleConsumable.effectPoison(stack, (EntityLivingBase)user, (EntityLivingBase)user)).setHitActionServer((stack, pair) -> ItemSimpleConsumable.effectPoison(stack, (EntityLivingBase)pair.key, (EntityLivingBase)pair.value)).func_77655_b("syringe_poison").func_77664_n().func_111206_d("hbm:syringe_poison");
        ModItems.syringe_awesome = new ItemSimpleConsumable().setUseActionServer((stack, user) -> ItemSimpleConsumable.effectAwesome(stack, (EntityLivingBase)user, (EntityLivingBase)user)).setHitActionServer((stack, pair) -> ItemSimpleConsumable.effectAwesome(stack, (EntityLivingBase)pair.key, (EntityLivingBase)pair.value)).setRarity(EnumRarity.uncommon).setEffect().func_77655_b("syringe_awesome").func_77664_n().func_111206_d("hbm:syringe_awesome");
        ModItems.iv_empty = new ItemSimpleConsumable().setUseActionServer((stack, user) -> {
            ItemSimpleConsumable.giveSoundAndDecrement(stack, (EntityLivingBase)user, "hbm:item.syringe", new ItemStack(ModItems.iv_blood));
            user.func_70606_j(Math.max(user.func_110143_aJ() - 5.0f, 0.0f));
            if (user.func_110143_aJ() <= 0.0f) {
                user.func_70645_a(DamageSource.field_76376_m);
            }
        }).func_77655_b("iv_empty").func_111206_d("hbm:iv_empty");
        ModItems.iv_blood = new ItemSimpleConsumable().setUseActionServer((stack, user) -> {
            ItemSimpleConsumable.giveSoundAndDecrement(stack, (EntityLivingBase)user, "hbm:item.radaway", new ItemStack(ModItems.iv_empty));
            user.func_70691_i(5.0f);
        }).func_77655_b("iv_blood").func_111206_d("hbm:iv_blood");
        ModItems.iv_xp_empty = new ItemSimpleConsumable().setUseActionServer((stack, user) -> {
            if (EnchantmentUtil.getTotalExperience(user) >= 100) {
                ItemSimpleConsumable.giveSoundAndDecrement(stack, (EntityLivingBase)user, "hbm:item.syringe", new ItemStack(ModItems.iv_xp));
                EnchantmentUtil.setExperience(user, EnchantmentUtil.getTotalExperience(user) - 100);
            }
        }).func_77655_b("iv_xp_empty").func_111206_d("hbm:iv_xp_empty");
        ModItems.iv_xp = new ItemSimpleConsumable().setUseActionServer((stack, user) -> {
            ItemSimpleConsumable.giveSoundAndDecrement(stack, (EntityLivingBase)user, "random.orb", new ItemStack(ModItems.iv_xp_empty));
            EnchantmentUtil.addExperience(user, 100, false);
        }).func_77655_b("iv_xp").func_111206_d("hbm:iv_xp");
        ModItems.radaway = new ItemSimpleConsumable().setUseActionServer((stack, user) -> ItemSimpleConsumable.doRadaway(stack, user, 140)).func_77655_b("radaway").func_111206_d("hbm:radaway");
        ModItems.radaway_strong = new ItemSimpleConsumable().setUseActionServer((stack, user) -> ItemSimpleConsumable.doRadaway(stack, user, 350)).func_77655_b("radaway_strong").func_111206_d("hbm:radaway_strong");
        ModItems.radaway_flush = new ItemSimpleConsumable().setUseActionServer((stack, user) -> ItemSimpleConsumable.doRadaway(stack, user, 500)).func_77655_b("radaway_flush").func_111206_d("hbm:radaway_flush");
    }

    public static void effectAntidote(ItemStack stack, EntityLivingBase affected, EntityLivingBase source) {
        if (VersatileConfig.hasPotionSickness(affected)) {
            return;
        }
        affected.func_70674_bp();
        ItemSimpleConsumable.giveSoundAndDecrement(stack, source, "hbm:item.syringe", new ItemStack(ModItems.syringe_empty));
        VersatileConfig.applyPotionSickness(affected, 5);
    }

    public static void effectPoison(ItemStack stack, EntityLivingBase affected, EntityLivingBase source) {
        if (affected == source) {
            affected.func_70097_a(affected.func_70681_au().nextBoolean() ? ModDamageSource.euthanizedSelf : ModDamageSource.euthanizedSelf2, 30.0f);
        } else {
            affected.func_70097_a(ModDamageSource.euthanized((Entity)source, (Entity)source), 30.0f);
        }
        ItemSimpleConsumable.giveSoundAndDecrement(stack, source, "hbm:item.syringe", new ItemStack(ModItems.syringe_empty));
    }

    public static void effectAwesome(ItemStack stack, EntityLivingBase affected, EntityLivingBase source) {
        if (VersatileConfig.hasPotionSickness(affected)) {
            return;
        }
        ItemSimpleConsumable.giveSoundAndDecrement(stack, source, "hbm:item.syringe", new ItemStack(ModItems.syringe_empty));
        affected.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 1000, 9));
        affected.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 1000, 9));
        affected.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 1000, 0));
        affected.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 1000, 24));
        affected.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 1000, 9));
        affected.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 1000, 6));
        affected.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 1000, 9));
        affected.func_70690_d(new PotionEffect(Potion.field_76434_w.field_76415_H, 1000, 9));
        affected.func_70690_d(new PotionEffect(Potion.field_76444_x.field_76415_H, 1000, 4));
        affected.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 4));
        affected.func_70690_d(new PotionEffect(HbmPotion.radx.field_76415_H, 1000, 9));
        VersatileConfig.applyPotionSickness(affected, 5);
    }
}

