/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemAutogen;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;

public class ItemScraps
extends ItemAutogen {
    @SideOnly(value=Side.CLIENT)
    public IIcon liquidIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon addiviceIcon;

    public ItemScraps() {
        super(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.liquidIcon = reg.func_94245_a("hbm:scraps_liquid");
        this.addiviceIcon = reg.func_94245_a("hbm:scraps_additive");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (NTMMaterial mat : Mats.orderedList) {
            if (mat.smeltable != NTMMaterial.SmeltingBehavior.SMELTABLE && mat.smeltable != NTMMaterial.SmeltingBehavior.ADDITIVE) continue;
            list.add(new ItemStack(item, 1, mat.id));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int layer) {
        NTMMaterial mat;
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("liquid") && (mat = Mats.matById.get(stack.func_77960_j())) != null) {
            return mat.moltenColor;
        }
        return super.func_82790_a(stack, layer);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        NTMMaterial mat;
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("liquid") && (mat = Mats.matById.get(stack.func_77960_j())) != null) {
            NTMMaterial.SmeltingBehavior cfr_ignored_0 = mat.smeltable;
            if (mat.smeltable == NTMMaterial.SmeltingBehavior.SMELTABLE) {
                return this.liquidIcon;
            }
            NTMMaterial.SmeltingBehavior cfr_ignored_1 = mat.smeltable;
            if (mat.smeltable == NTMMaterial.SmeltingBehavior.ADDITIVE) {
                return this.addiviceIcon;
            }
        }
        return this.func_77617_a(stack.func_77960_j());
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        Mats.MaterialStack contents;
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("liquid") && (contents = ItemScraps.getMats(stack)) != null) {
            return I18nUtil.resolveKey(contents.material.getUnlocalizedName(), new Object[0]);
        }
        return ("" + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        Mats.MaterialStack contents = ItemScraps.getMats(stack);
        if (contents != null) {
            if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("liquid")) {
                list.add(Mats.formatAmount(contents.amount, Keyboard.isKeyDown((int)42)));
                NTMMaterial.SmeltingBehavior cfr_ignored_0 = contents.material.smeltable;
                if (contents.material.smeltable == NTMMaterial.SmeltingBehavior.ADDITIVE) {
                    list.add(EnumChatFormatting.DARK_RED + "Additive, not castable!");
                }
            } else {
                list.add(I18nUtil.resolveKey(contents.material.getUnlocalizedName(), new Object[0]) + ", " + Mats.formatAmount(contents.amount, Keyboard.isKeyDown((int)42)));
            }
        }
    }

    public static Mats.MaterialStack getMats(ItemStack stack) {
        if (stack.func_77973_b() != ModItems.scraps) {
            return null;
        }
        NTMMaterial mat = Mats.matById.get(stack.func_77960_j());
        if (mat == null) {
            return null;
        }
        int amount = MaterialShapes.INGOT.q(1);
        if (stack.func_77942_o()) {
            amount = stack.func_77978_p().func_74762_e("amount");
        }
        return new Mats.MaterialStack(mat, amount);
    }

    public static ItemStack create(Mats.MaterialStack stack) {
        return ItemScraps.create(stack, false);
    }

    public static ItemStack create(Mats.MaterialStack stack, boolean liquid) {
        if (stack.material == null) {
            return new ItemStack(ModItems.nothing);
        }
        ItemStack scrap = new ItemStack(ModItems.scraps, 1, stack.material.id);
        scrap.field_77990_d = new NBTTagCompound();
        scrap.field_77990_d.func_74768_a("amount", stack.amount);
        if (liquid) {
            scrap.field_77990_d.func_74757_a("liquid", true);
        }
        return scrap;
    }
}

