/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.machine.ItemFuelRod;
import com.hbm.util.BobMathUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemPlateFuel
extends ItemFuelRod {
    public int reactivity;
    public FunctionEnum function;

    public ItemPlateFuel(int life) {
        super(life);
        this.canRepair = false;
    }

    public ItemPlateFuel setFunction(FunctionEnum function, int reactivity) {
        this.function = function;
        this.reactivity = reactivity;
        return this;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.YELLOW + "[Research Reactor Plate Fuel]");
        list.add(EnumChatFormatting.DARK_AQUA + "   " + this.getFunctionDesc());
        list.add(EnumChatFormatting.DARK_AQUA + "   Yield of " + BobMathUtil.getShortNumber(this.lifeTime) + " events");
        super.func_77624_a(itemstack, player, list, bool);
    }

    public String getFunctionDesc() {
        switch (this.function) {
            case LOGARITHM: {
                return "f(x) = log10(x + 1) * 0.5 * " + this.reactivity;
            }
            case SQUARE_ROOT: {
                return "f(x) = sqrt(x) * " + this.reactivity + " / 10";
            }
            case NEGATIVE_QUADRATIC: {
                return "f(x) = [x - (x\u00b2 / 10000)] / 100 * " + this.reactivity;
            }
            case LINEAR: {
                return "f(x) = x / 100 * " + this.reactivity;
            }
            case PASSIVE: {
                return "f(x) = " + this.reactivity;
            }
        }
        return "x";
    }

    public int react(World world, ItemStack stack, int flux) {
        if (this.function != FunctionEnum.PASSIVE) {
            ItemPlateFuel.setLifeTime(stack, ItemPlateFuel.getLifeTime(stack) + flux);
        }
        switch (this.function) {
            case LOGARITHM: {
                return (int)(Math.log10(flux + 1) * 0.5 * (double)this.reactivity);
            }
            case SQUARE_ROOT: {
                return (int)(Math.sqrt(flux) * (double)this.reactivity / 10.0);
            }
            case NEGATIVE_QUADRATIC: {
                return (int)Math.max(((double)flux - (double)(flux * flux) / 10000.0) / 100.0 * (double)this.reactivity, 0.0);
            }
            case LINEAR: {
                return (int)((double)flux / 100.0 * (double)this.reactivity);
            }
            case PASSIVE: {
                ItemPlateFuel.setLifeTime(stack, ItemPlateFuel.getLifeTime(stack) + this.reactivity);
                return this.reactivity;
            }
        }
        return 0;
    }

    public static enum FunctionEnum {
        LOGARITHM,
        SQUARE_ROOT,
        NEGATIVE_QUADRATIC,
        LINEAR,
        PASSIVE;

    }
}

