/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.armor.ArmorFSBFueled;
import com.hbm.main.ResourceManager;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.model.ModelArmorDiesel;
import com.hbm.render.tileentity.IItemRendererProvider;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ArmorDiesel
extends ArmorFSBFueled
implements IItemRendererProvider {
    @SideOnly(value=Side.CLIENT)
    ModelArmorDiesel[] models;

    public ArmorDiesel(ItemArmor.ArmorMaterial material, int slot, String texture, FluidType fuelType, int maxFuel, int fillRate, int consumption, int drain) {
        super(material, slot, texture, fuelType, maxFuel, fillRate, consumption, drain);
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ArmorModHandler.fixedUUIDs[this.field_77881_a], "Armor modifier", 0.25, 1));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.models == null) {
            this.models = new ModelArmorDiesel[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorDiesel(i);
            }
        }
        return this.models[armorSlot];
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (!world.field_72995_K && this == ModItems.dieselsuit_legs) {
            if (ArmorDiesel.hasFSBArmor(player) && world.func_82737_E() % 3L == 0L) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "bnuuy");
                data.func_74768_a("player", player.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, player.field_70165_t, player.field_70163_u, player.field_70161_v), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
            }
        }
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        return type == Fluids.DIESEL || type == Fluids.DIESEL_CRACK;
    }

    @Override
    public Item getItemForRenderer() {
        return this;
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                ArmorFSB.setupRenderInv();
            }

            @Override
            public void renderNonInv() {
                ArmorFSB.setupRenderNonInv();
            }

            @Override
            public void renderCommon() {
                if (ArmorDiesel.this.field_77881_a == 0) {
                    GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
                    GL11.glScaled((double)0.875, (double)0.875, (double)0.875);
                }
                ArmorFSB.renderStandard(ResourceManager.armor_dieselsuit, ArmorDiesel.this.field_77881_a, ResourceManager.dieselsuit_helmet, ResourceManager.dieselsuit_chest, ResourceManager.dieselsuit_arm, ResourceManager.dieselsuit_leg, "Head", "Body", "LeftArm", "RightArm", "LeftLeg", "RightLeg", "LeftBoot", "RightBoot");
            }
        };
    }
}

