/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hbm.handler.ArmorModHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.armor.ArmorFSBFueled;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.model.ModelArmorDesh;
import com.hbm.render.tileentity.IItemRendererProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class ArmorDesh
extends ArmorFSBFueled
implements IItemRendererProvider {
    @SideOnly(value=Side.CLIENT)
    ModelArmorDesh[] models;

    public ArmorDesh(ItemArmor.ArmorMaterial material, int slot, String texture, FluidType fuelType, int maxFuel, int fillRate, int consumption, int drain) {
        super(material, slot, texture, fuelType, maxFuel, fillRate, consumption, drain);
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ArmorModHandler.fixedUUIDs[this.field_77881_a], "Armor modifier", -0.025, 1));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.models == null) {
            this.models = new ModelArmorDesh[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorDesh(i);
            }
        }
        return this.models[armorSlot];
    }

    @Override
    public Item getItemForRenderer() {
        return this;
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                ArmorFSB.setupRenderInv();
            }

            @Override
            public void renderNonInv() {
                ArmorFSB.setupRenderNonInv();
            }

            @Override
            public void renderCommon() {
                ArmorFSB.renderStandard(ResourceManager.armor_steamsuit, ArmorDesh.this.field_77881_a, ResourceManager.steamsuit_helmet, ResourceManager.steamsuit_chest, ResourceManager.steamsuit_arm, ResourceManager.steamsuit_leg, "Head", "Body", "LeftArm", "RightArm", "LeftLeg", "RightLeg", "LeftBoot", "RightBoot");
            }
        };
    }
}

