/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.Multimap;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.armor.ArmorFSBPowered;
import com.hbm.main.ResourceManager;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.model.ModelArmorDNT;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.util.ArmorUtil;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.lwjgl.opengl.GL11;

public class ArmorDNT
extends ArmorFSBPowered
implements IItemRendererProvider {
    @SideOnly(value=Side.CLIENT)
    ModelArmorDNT[] models;
    private static final UUID speed = UUID.fromString("6ab858ba-d712-485c-bae9-e5e765fc555a");

    public ArmorDNT(ItemArmor.ArmorMaterial material, int slot, String texture, long maxPower, long chargeRate, long consumption, long drain) {
        super(material, slot, texture, maxPower, chargeRate, consumption, drain);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.models == null) {
            this.models = new ModelArmorDNT[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorDNT(i);
            }
        }
        return this.models[armorSlot];
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this != ModItems.dns_plate) {
            return;
        }
        HbmPlayerProps props = HbmPlayerProps.getData(player);
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speed, "DNT SPEED", 0.25, 0));
        player.func_110140_aT().func_111148_a(multimap);
        if (player.func_70051_ag()) {
            player.func_110140_aT().func_111147_b(multimap);
        }
        if (!world.field_72995_K) {
            if (ArmorDNT.hasFSBArmor(player) && (props.isJetpackActive() || !player.field_70122_E && !player.func_70093_af() && props.enableBackpack)) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "jetpack_dns");
                data.func_74768_a("player", player.func_145782_y());
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, player.field_70165_t, player.field_70163_u, player.field_70161_v), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
            }
        }
        if (ArmorDNT.hasFSBArmor(player)) {
            ArmorUtil.resetFlightTime(player);
            if (props.isJetpackActive()) {
                if (player.field_70181_x < 0.6) {
                    player.field_70181_x += 0.2;
                }
                player.field_70143_R = 0.0f;
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hbm:weapon.immolatorShoot", 0.125f, 1.5f);
            } else if (!player.func_70093_af() && !player.field_70122_E && props.enableBackpack) {
                player.field_70143_R = 0.0f;
                if (player.field_70181_x < -1.0) {
                    player.field_70181_x += 0.4;
                } else if (player.field_70181_x < -0.1) {
                    player.field_70181_x += 0.2;
                } else if (player.field_70181_x < 0.0) {
                    player.field_70181_x = 0.0;
                }
                player.field_70159_w *= 1.05;
                player.field_70179_y *= 1.05;
                if (player.field_70701_bs != 0.0f) {
                    player.field_70159_w += player.func_70040_Z().field_72450_a * 0.25 * (double)player.field_70701_bs;
                    player.field_70179_y += player.func_70040_Z().field_72449_c * 0.25 * (double)player.field_70701_bs;
                }
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "hbm:weapon.immolatorShoot", 0.125f, 1.5f);
            }
            if (player.func_70093_af() && !player.field_70122_E) {
                player.field_70181_x -= 0.1;
            }
        }
    }

    @Override
    public void handleAttack(LivingAttackEvent event) {
        EntityPlayer player;
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor(player = (EntityPlayer)e)) {
            if (event.source.func_94541_c()) {
                return;
            }
            HbmPlayerProps.plink(player, "random.break", 0.5f, 1.0f + e.func_70681_au().nextFloat() * 0.5f);
            event.setCanceled(true);
        }
    }

    @Override
    public void handleHurt(LivingHurtEvent event) {
        EntityPlayer player;
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor(player = (EntityPlayer)e)) {
            if (event.source.func_94541_c()) {
                event.ammount *= 0.001f;
                return;
            }
            event.ammount = 0.0f;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add("Charge: " + BobMathUtil.getShortNumber(this.getCharge(stack)) + " / " + BobMathUtil.getShortNumber(this.getMaxCharge(stack)));
        list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("armor.fullSetBonus", new Object[0]));
        if (!this.effects.isEmpty()) {
            for (PotionEffect effect : this.effects) {
                list.add(EnumChatFormatting.AQUA + "  " + I18nUtil.format(Potion.field_76425_a[effect.func_76456_a()].func_76393_a(), new Object[0]));
            }
        }
        list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.vats", new Object[0]));
        list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.thermal", new Object[0]));
        list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.hardLanding", new Object[0]));
        list.add(EnumChatFormatting.AQUA + "  " + I18nUtil.resolveKey("armor.rocketBoots", new Object[0]));
        list.add(EnumChatFormatting.AQUA + "  " + I18nUtil.resolveKey("armor.fastFall", new Object[0]));
        list.add(EnumChatFormatting.AQUA + "  " + I18nUtil.resolveKey("armor.sprintBoost", new Object[0]));
    }

    @Override
    public Item getItemForRenderer() {
        return this;
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                if (ArmorDNT.this.field_77881_a == 0) {
                    GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                }
                ArmorFSB.setupRenderInv();
            }

            @Override
            public void renderNonInv() {
                ArmorFSB.setupRenderNonInv();
            }

            @Override
            public void renderCommon() {
                ArmorFSB.renderStandard(ResourceManager.armor_dnt, ArmorDNT.this.field_77881_a, ResourceManager.dnt_helmet, ResourceManager.dnt_chest, ResourceManager.dnt_arm, ResourceManager.dnt_leg, "Head", "Body", "LeftArm", "RightArm", "LeftLeg", "RightLeg", "LeftBoot", "RightBoot");
            }
        };
    }
}

