/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.special.ItemBedrockOreNew;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PyroOvenRecipes
extends SerializableRecipe {
    public static List<PyroOvenRecipe> recipes = new ArrayList<PyroOvenRecipe>();

    @Override
    public void registerDefaults() {
        PyroOvenRecipes.registerSFAuto(Fluids.SMEAR);
        PyroOvenRecipes.registerSFAuto(Fluids.HEATINGOIL);
        PyroOvenRecipes.registerSFAuto(Fluids.HEATINGOIL_VACUUM);
        PyroOvenRecipes.registerSFAuto(Fluids.RECLAIMED);
        PyroOvenRecipes.registerSFAuto(Fluids.PETROIL);
        PyroOvenRecipes.registerSFAuto(Fluids.NAPHTHA);
        PyroOvenRecipes.registerSFAuto(Fluids.NAPHTHA_CRACK);
        PyroOvenRecipes.registerSFAuto(Fluids.DIESEL);
        PyroOvenRecipes.registerSFAuto(Fluids.DIESEL_REFORM);
        PyroOvenRecipes.registerSFAuto(Fluids.DIESEL_CRACK);
        PyroOvenRecipes.registerSFAuto(Fluids.DIESEL_CRACK_REFORM);
        PyroOvenRecipes.registerSFAuto(Fluids.LIGHTOIL);
        PyroOvenRecipes.registerSFAuto(Fluids.LIGHTOIL_CRACK);
        PyroOvenRecipes.registerSFAuto(Fluids.LIGHTOIL_VACUUM);
        PyroOvenRecipes.registerSFAuto(Fluids.KEROSENE);
        PyroOvenRecipes.registerSFAuto(Fluids.KEROSENE_REFORM);
        PyroOvenRecipes.registerSFAuto(Fluids.SOURGAS);
        PyroOvenRecipes.registerSFAuto(Fluids.REFORMGAS);
        PyroOvenRecipes.registerSFAuto(Fluids.SYNGAS);
        PyroOvenRecipes.registerSFAuto(Fluids.PETROLEUM);
        PyroOvenRecipes.registerSFAuto(Fluids.LPG);
        PyroOvenRecipes.registerSFAuto(Fluids.BIOFUEL);
        PyroOvenRecipes.registerSFAuto(Fluids.AROMATICS);
        PyroOvenRecipes.registerSFAuto(Fluids.UNSATURATEDS);
        PyroOvenRecipes.registerSFAuto(Fluids.REFORMATE);
        PyroOvenRecipes.registerSFAuto(Fluids.XYLENE);
        PyroOvenRecipes.registerSFAuto(Fluids.BALEFIRE, 24000000L, ModItems.solid_fuel_bf);
        for (ItemBedrockOreNew.BedrockOreType type : ItemBedrockOreNew.BedrockOreType.values()) {
            recipes.add(new PyroOvenRecipe(10).in(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE, type))).out(new FluidStack(Fluids.VITRIOL, 50)).out(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE_ROASTED, type)));
            recipes.add(new PyroOvenRecipe(10).in(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type))).out(new FluidStack(Fluids.VITRIOL, 50)).out(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type)));
            recipes.add(new PyroOvenRecipe(10).in(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_BYPRODUCT, type))).out(new FluidStack(Fluids.VITRIOL, 50)).out(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_ROASTED, type)));
            recipes.add(new PyroOvenRecipe(10).in(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_BYPRODUCT, type))).out(new FluidStack(Fluids.VITRIOL, 50)).out(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_ROASTED, type)));
            recipes.add(new PyroOvenRecipe(10).in(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_BYPRODUCT, type))).out(new FluidStack(Fluids.VITRIOL, 50)).out(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_ROASTED, type)));
        }
        recipes.add(new PyroOvenRecipe(100).in(new FluidStack(Fluids.STEAM, 500)).in(new RecipesCommon.OreDictStack(OreDictManager.COAL.gem())).out(new FluidStack(Fluids.SYNGAS, 1000)));
        recipes.add(new PyroOvenRecipe(100).in(new FluidStack(Fluids.STEAM, 500)).in(new RecipesCommon.OreDictStack(OreDictManager.COAL.dust())).out(new FluidStack(Fluids.SYNGAS, 1000)));
        recipes.add(new PyroOvenRecipe(100).in(new FluidStack(Fluids.STEAM, 250)).in(new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem())).out(new FluidStack(Fluids.SYNGAS, 1000)));
        recipes.add(new PyroOvenRecipe(100).in(new RecipesCommon.ComparableStack(ModItems.biomass, 4)).out(new FluidStack(Fluids.SYNGAS, 1000)).out(new ItemStack(Items.field_151044_h, 1, 1)));
        recipes.add(new PyroOvenRecipe(40).out(new FluidStack(Fluids.HYDROGEN, 250)).in(new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any(), 4)).out(new FluidStack(Fluids.CARBONDIOXIDE, 1000)).out(OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)ItemEnums.EnumAshType.SOOT)));
        recipes.add(new PyroOvenRecipe(100).in(new FluidStack(Fluids.HYDROGEN, 500)).in(new RecipesCommon.OreDictStack(OreDictManager.COAL.gem())).out(new FluidStack(Fluids.HEAVYOIL, 1000)));
        recipes.add(new PyroOvenRecipe(100).in(new FluidStack(Fluids.HYDROGEN, 500)).in(new RecipesCommon.OreDictStack(OreDictManager.COAL.dust())).out(new FluidStack(Fluids.HEAVYOIL, 1000)));
        recipes.add(new PyroOvenRecipe(50).in(new FluidStack(Fluids.HEAVYOIL, 500)).in(new RecipesCommon.OreDictStack(OreDictManager.COAL.gem())).out(new FluidStack(Fluids.COALGAS, 1000)));
        recipes.add(new PyroOvenRecipe(50).in(new FluidStack(Fluids.HEAVYOIL, 500)).in(new RecipesCommon.OreDictStack(OreDictManager.COAL.dust())).out(new FluidStack(Fluids.COALGAS, 1000)));
        recipes.add(new PyroOvenRecipe(50).in(new FluidStack(Fluids.HEAVYOIL, 500)).in(new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem())).out(new FluidStack(Fluids.COALGAS, 1000)));
        recipes.add(new PyroOvenRecipe(60).in(new FluidStack(Fluids.GAS_COKER, 4000)).out(new FluidStack(Fluids.REFORMGAS, 100)));
        recipes.add(new PyroOvenRecipe(60).in(new FluidStack(Fluids.GAS, 12000)).out(new FluidStack(Fluids.HYDROGEN, 8000)).out(new ItemStack(ModItems.ingot_graphite, 1)));
    }

    public static void registerSFAuto(FluidType fluid) {
        PyroOvenRecipes.registerSFAuto(fluid, 1440000L, ModItems.solid_fuel);
    }

    private static void registerSFAuto(FluidType fluid, long tuPerSF, Item fuel) {
        double bonus = 0.5;
        long tuPerBucket = fluid.getTrait(FT_Flammable.class).getHeatEnergy();
        int mB = (int)((double)(tuPerSF * 1000L) * bonus / (double)tuPerBucket);
        if (mB > 10000) {
            mB -= mB % 1000;
        } else if (mB > 1000) {
            mB -= mB % 100;
        } else if (mB > 100) {
            mB -= mB % 10;
        }
        mB = Math.max(mB, 1);
        PyroOvenRecipes.registerRecipe(fluid, mB, fuel);
    }

    private static void registerRecipe(FluidType type, int quantity, Item output) {
        PyroOvenRecipes.registerRecipe(type, quantity, new ItemStack(output));
    }

    private static void registerRecipe(FluidType type, int quantity, ItemStack output) {
        recipes.add(new PyroOvenRecipe(60).in(new FluidStack(type, quantity)).out(output));
    }

    public static HashMap getRecipes() {
        HashMap<Object[], Object[]> map = new HashMap<Object[], Object[]>();
        for (PyroOvenRecipe rec : recipes) {
            Object[] in = null;
            Object[] out = null;
            if (rec.inputFluid != null && rec.inputItem != null) {
                in = new Object[]{ItemFluidIcon.make(rec.inputFluid), rec.inputItem};
            }
            if (rec.inputFluid != null && rec.inputItem == null) {
                in = new Object[]{ItemFluidIcon.make(rec.inputFluid)};
            }
            if (rec.inputFluid == null && rec.inputItem != null) {
                in = new Object[]{rec.inputItem};
            }
            if (rec.outputFluid != null && rec.outputItem != null) {
                out = new Object[]{rec.outputItem, ItemFluidIcon.make(rec.outputFluid)};
            }
            if (rec.outputFluid != null && rec.outputItem == null) {
                out = new Object[]{ItemFluidIcon.make(rec.outputFluid)};
            }
            if (rec.outputFluid == null && rec.outputItem != null) {
                out = new Object[]{rec.outputItem};
            }
            if (in == null || out == null) continue;
            map.put(in, out);
        }
        return map;
    }

    @Override
    public String getFileName() {
        return "hbmPyrolysis.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        ItemStack outputItem;
        FluidStack inputFluid;
        RecipesCommon.AStack inputItem;
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack aStack = obj.has("inputItem") ? PyroOvenRecipes.readAStack(obj.get("inputItem").getAsJsonArray()) : (inputItem = null);
        FluidStack fluidStack = obj.has("inputFluid") ? PyroOvenRecipes.readFluidStack(obj.get("inputFluid").getAsJsonArray()) : (inputFluid = null);
        ItemStack itemStack = obj.has("outputItem") ? PyroOvenRecipes.readItemStack(obj.get("outputItem").getAsJsonArray()) : (outputItem = null);
        FluidStack outputFluid = obj.has("outputFluid") ? PyroOvenRecipes.readFluidStack(obj.get("outputFluid").getAsJsonArray()) : null;
        int duration = obj.get("duration").getAsInt();
        recipes.add(new PyroOvenRecipe(duration).in(inputFluid).in(inputItem).out(outputFluid).out(outputItem));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        PyroOvenRecipe rec = (PyroOvenRecipe)recipe;
        if (rec.inputFluid != null) {
            writer.name("inputFluid");
            PyroOvenRecipes.writeFluidStack(rec.inputFluid, writer);
        }
        if (rec.inputItem != null) {
            writer.name("inputItem");
            PyroOvenRecipes.writeAStack(rec.inputItem, writer);
        }
        if (rec.outputFluid != null) {
            writer.name("outputFluid");
            PyroOvenRecipes.writeFluidStack(rec.outputFluid, writer);
        }
        if (rec.outputItem != null) {
            writer.name("outputItem");
            PyroOvenRecipes.writeItemStack(rec.outputItem, writer);
        }
        writer.name("duration").value((long)rec.duration);
    }

    public static class PyroOvenRecipe {
        public FluidStack inputFluid;
        public RecipesCommon.AStack inputItem;
        public FluidStack outputFluid;
        public ItemStack outputItem;
        public int duration;

        public PyroOvenRecipe(int duration) {
            this.duration = duration;
        }

        public PyroOvenRecipe in(FluidStack stack) {
            this.inputFluid = stack;
            return this;
        }

        public PyroOvenRecipe in(RecipesCommon.AStack stack) {
            this.inputItem = stack;
            return this;
        }

        public PyroOvenRecipe out(FluidStack stack) {
            this.outputFluid = stack;
            return this;
        }

        public PyroOvenRecipe out(ItemStack stack) {
            this.outputItem = stack;
            return this;
        }
    }
}

