/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CustomMachineRecipes
extends SerializableRecipe {
    public static HashMap<String, List<CustomMachineRecipe>> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        recipes.put("paperPress", new ArrayList(){
            {
                CustomMachineRecipe recipe = new CustomMachineRecipe();
                recipe.inputFluids = new FluidStack[]{new FluidStack(Fluids.WATER, 250)};
                recipe.inputItems = new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.powder_sawdust)};
                recipe.outputFluids = new FluidStack[0];
                recipe.outputItems = new Tuple.Pair[]{new Tuple.Pair<ItemStack, Float>(new ItemStack(Items.field_151121_aF, 3), Float.valueOf(1.0f))};
                recipe.duration = 60;
                recipe.consumptionPerTick = 10;
                recipe.pollutionType = "SOOT";
                recipe.pollutionAmount = 0.03f;
                recipe.radiationAmount = 0.0f;
                recipe.flux = 0;
                recipe.heat = 0;
                this.add(recipe);
            }
        });
    }

    @Override
    public String getFileName() {
        return "hbmCustomMachines.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = recipe.getAsJsonObject();
        String name = obj.get("recipeKey").getAsString();
        ArrayList<CustomMachineRecipe> list = new ArrayList<CustomMachineRecipe>();
        JsonArray array = obj.get("recipes").getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject rec = array.get(i).getAsJsonObject();
            CustomMachineRecipe recipeInstance = new CustomMachineRecipe();
            recipeInstance.inputFluids = CustomMachineRecipes.readFluidArray(rec.get("inputFluids").getAsJsonArray());
            recipeInstance.inputItems = CustomMachineRecipes.readAStackArray(rec.get("inputItems").getAsJsonArray());
            recipeInstance.outputFluids = CustomMachineRecipes.readFluidArray(rec.get("outputFluids").getAsJsonArray());
            recipeInstance.outputItems = CustomMachineRecipes.readItemStackArrayChance(rec.get("outputItems").getAsJsonArray());
            recipeInstance.duration = rec.get("duration").getAsInt();
            recipeInstance.consumptionPerTick = rec.get("consumptionPerTick").getAsInt();
            if (rec.has("pollutionType") && rec.has("pollutionAmount")) {
                recipeInstance.pollutionType = rec.get("pollutionType").getAsString();
                recipeInstance.pollutionAmount = rec.get("pollutionAmount").getAsFloat();
            } else {
                recipeInstance.pollutionType = "";
            }
            if (rec.has("radiationAmount")) {
                recipeInstance.radiationAmount = rec.get("radiationAmount").getAsFloat();
            }
            if (rec.has("flux")) {
                recipeInstance.flux = rec.get("flux").getAsInt();
            }
            if (rec.has("heat")) {
                recipeInstance.heat = rec.get("heat").getAsInt();
            }
            list.add(recipeInstance);
        }
        recipes.put(name, list);
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry entry = (Map.Entry)recipe;
        writer.name("recipeKey").value((String)entry.getKey());
        writer.name("recipes").beginArray();
        for (CustomMachineRecipe recipeInstance : (List)entry.getValue()) {
            writer.beginObject();
            writer.name("inputFluids").beginArray();
            for (FluidStack fluidStack : recipeInstance.inputFluids) {
                CustomMachineRecipes.writeFluidStack(fluidStack, writer);
            }
            writer.endArray();
            writer.name("inputItems").beginArray();
            for (RecipesCommon.AStack aStack : recipeInstance.inputItems) {
                CustomMachineRecipes.writeAStack(aStack, writer);
            }
            writer.endArray();
            writer.name("outputFluids").beginArray();
            for (FluidStack fluidStack : recipeInstance.outputFluids) {
                CustomMachineRecipes.writeFluidStack(fluidStack, writer);
            }
            writer.endArray();
            writer.name("outputItems").beginArray();
            for (Tuple.Pair<ItemStack, Float> pair : recipeInstance.outputItems) {
                CustomMachineRecipes.writeItemStackChance(pair, writer);
            }
            writer.endArray();
            writer.name("duration").value((long)recipeInstance.duration);
            writer.name("consumptionPerTick").value((long)recipeInstance.consumptionPerTick);
            writer.name("pollutionType").value(recipeInstance.pollutionType);
            writer.name("pollutionAmount").value((double)recipeInstance.pollutionAmount);
            writer.name("radiationAmount").value((double)recipeInstance.radiationAmount);
            writer.name("flux").value((long)recipeInstance.flux);
            writer.name("heat").value((long)recipeInstance.heat);
            writer.endObject();
        }
        writer.endArray();
    }

    public static class CustomMachineRecipe {
        public FluidStack[] inputFluids;
        public RecipesCommon.AStack[] inputItems;
        public FluidStack[] outputFluids;
        public Tuple.Pair<ItemStack, Float>[] outputItems;
        public int duration;
        public int consumptionPerTick;
        public String pollutionType;
        public float pollutionAmount;
        public float radiationAmount;
        public int flux;
        public int heat;
    }
}

