/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CokerRecipes
extends SerializableRecipe {
    public static HashMap<FluidType, Tuple.Triplet<Integer, ItemStack, FluidStack>> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        CokerRecipes.registerAuto(Fluids.HEAVYOIL, Fluids.OIL_COKER);
        CokerRecipes.registerAuto(Fluids.HEAVYOIL_VACUUM, Fluids.REFORMATE);
        CokerRecipes.registerAuto(Fluids.COALCREOSOTE, Fluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(Fluids.SMEAR, Fluids.OIL_COKER);
        CokerRecipes.registerAuto(Fluids.HEATINGOIL, Fluids.OIL_COKER);
        CokerRecipes.registerAuto(Fluids.HEATINGOIL_VACUUM, Fluids.OIL_COKER);
        CokerRecipes.registerAuto(Fluids.RECLAIMED, Fluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(Fluids.NAPHTHA, Fluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(Fluids.NAPHTHA_DS, Fluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(Fluids.NAPHTHA_CRACK, Fluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(Fluids.DIESEL, Fluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(Fluids.DIESEL_REFORM, Fluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(Fluids.DIESEL_CRACK, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.DIESEL_CRACK_REFORM, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.LIGHTOIL, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.LIGHTOIL_DS, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.LIGHTOIL_CRACK, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.LIGHTOIL_VACUUM, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.BIOFUEL, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.AROMATICS, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.REFORMATE, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.XYLENE, Fluids.GAS_COKER);
        CokerRecipes.registerAuto(Fluids.FISHOIL, Fluids.MERCURY);
        CokerRecipes.registerAuto(Fluids.SUNFLOWEROIL, Fluids.GAS_COKER);
        CokerRecipes.registerSFAuto(Fluids.WOODOIL, 340000L, new ItemStack(Items.field_151044_h, 1, 1), Fluids.GAS_COKER);
        CokerRecipes.registerRecipe(Fluids.WATZ, 4000, new ItemStack(ModItems.ingot_mud, 4), null);
        CokerRecipes.registerRecipe(Fluids.REDMUD, 450, new ItemStack(Items.field_151042_j, 1), new FluidStack(Fluids.MERCURY, 50));
        CokerRecipes.registerRecipe(Fluids.BITUMEN, 16000, OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), new FluidStack(Fluids.OIL_COKER, 1600));
        CokerRecipes.registerRecipe(Fluids.LUBRICANT, 12000, OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), new FluidStack(Fluids.OIL_COKER, 1200));
        CokerRecipes.registerRecipe(Fluids.CALCIUM_SOLUTION, 125, new ItemStack(ModItems.powder_calcium), new FluidStack(Fluids.SPENTSTEAM, 100));
        CokerRecipes.registerRecipe(Fluids.SOURGAS, 1000, new ItemStack(ModItems.sulfur), new FluidStack(Fluids.GAS_COKER, 150));
        CokerRecipes.registerRecipe(Fluids.SLOP, 1000, new ItemStack(ModItems.powder_limestone), new FluidStack(Fluids.COLLOID, 250));
        CokerRecipes.registerRecipe(Fluids.VITRIOL, 4000, new ItemStack(ModItems.powder_iron), new FluidStack(Fluids.SULFURIC_ACID, 500));
    }

    public static void registerAuto(FluidType fluid, FluidType type) {
        CokerRecipes.registerSFAuto(fluid, 820000L, OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), type);
    }

    private static void registerSFAuto(FluidType fluid, long tuPerSF, ItemStack fuel, FluidType type) {
        long tuCombustible;
        double penalty = 1.0;
        long tuFlammable = fluid.hasTrait(FT_Flammable.class) ? fluid.getTrait(FT_Flammable.class).getHeatEnergy() : 0L;
        long tuPerBucket = Math.max(tuFlammable, tuCombustible = fluid.hasTrait(FT_Combustible.class) ? fluid.getTrait(FT_Combustible.class).getCombustionEnergy() : 0L);
        int mB = (int)((double)(tuPerSF * 1000L) * penalty / (double)tuPerBucket);
        if (mB > 10000) {
            mB -= mB % 1000;
        } else if (mB > 1000) {
            mB -= mB % 100;
        } else if (mB > 100) {
            mB -= mB % 10;
        }
        FluidStack byproduct = type == null ? null : new FluidStack(type, Math.max(10, mB / 10));
        CokerRecipes.registerRecipe(fluid, mB, fuel, byproduct);
    }

    private static void registerRecipe(FluidType type, int quantity, ItemStack output, FluidStack byproduct) {
        recipes.put(type, new Tuple.Triplet<Integer, ItemStack, FluidStack>(quantity, output, byproduct));
    }

    public static Tuple.Triplet<Integer, ItemStack, FluidStack> getOutput(FluidType type) {
        return recipes.get(type);
    }

    public static HashMap<ItemStack, ItemStack[]> getRecipes() {
        HashMap<ItemStack, ItemStack[]> recipes = new HashMap<ItemStack, ItemStack[]>();
        for (Map.Entry<FluidType, Tuple.Triplet<Integer, ItemStack, FluidStack>> entry : CokerRecipes.recipes.entrySet()) {
            FluidType type = entry.getKey();
            int amount = entry.getValue().getX();
            ItemStack out = entry.getValue().getY().func_77946_l();
            FluidStack byproduct = entry.getValue().getZ();
            if (out != null && byproduct != null) {
                recipes.put(ItemFluidIcon.make(type, amount), new ItemStack[]{out, ItemFluidIcon.make(byproduct)});
            }
            if (out != null && byproduct == null) {
                recipes.put(ItemFluidIcon.make(type, amount), new ItemStack[]{out});
            }
            if (out != null || byproduct == null) continue;
            recipes.put(ItemFluidIcon.make(type, amount), new ItemStack[]{ItemFluidIcon.make(byproduct)});
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmCoker.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        ItemStack out;
        JsonObject obj = (JsonObject)recipe;
        FluidStack in = CokerRecipes.readFluidStack(obj.get("input").getAsJsonArray());
        ItemStack itemStack = obj.has("output") ? CokerRecipes.readItemStack(obj.get("output").getAsJsonArray()) : (out = null);
        FluidStack byproduct = obj.has("byproduct") ? CokerRecipes.readFluidStack(obj.get("byproduct").getAsJsonArray()) : null;
        recipes.put(in.type, new Tuple.Triplet<Integer, ItemStack, FluidStack>(in.fill, out, byproduct));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        FluidStack in = new FluidStack((FluidType)rec.getKey(), (Integer)((Tuple.Triplet)rec.getValue()).getX());
        writer.name("input");
        CokerRecipes.writeFluidStack(in, writer);
        if (((Tuple.Triplet)rec.getValue()).getY() != null) {
            writer.name("output");
            CokerRecipes.writeItemStack((ItemStack)((Tuple.Triplet)rec.getValue()).getY(), writer);
        }
        if (((Tuple.Triplet)rec.getValue()).getZ() != null) {
            writer.name("byproduct");
            CokerRecipes.writeFluidStack((FluidStack)((Tuple.Triplet)rec.getValue()).getZ(), writer);
        }
    }
}

